/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringBufferInputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import lsedit.AttributeValueItem;
import lsedit.ColorChooser;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeObject;
import lsedit.LandscapeTokenStream;
import lsedit.LandscapeViewerCore;
import lsedit.RelationClass;
import lsedit.Util;

public class EditAttribute
extends JDialog {
    protected EditAttribute(JFrame jFrame, LandscapeObject landscapeObject) {
        super(jFrame, "Edit Attributes of " + landscapeObject.getLabel(), true);
        this.resize(438, 369);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setForeground(new Color(0, 0, 0));
        this.setBackground(new Color(192, 192, 192));
        this.setFont(new Font("Dialog", 0, 12));
        AttributeTableModel attributeTableModel = new AttributeTableModel(landscapeObject);
        MyJTable myJTable = new MyJTable(jFrame, attributeTableModel, landscapeObject);
        attributeTableModel.setJTable(myJTable);
        myJTable.setVisible(true);
        JScrollPane jScrollPane = new JScrollPane(myJTable);
        jScrollPane.setVisible(true);
        container.add((Component)jScrollPane, "Center");
        this.repaint();
        this.setVisible(true);
    }

    private static JFrame findFrame(LandscapeViewerCore landscapeViewerCore) {
        Container container = landscapeViewerCore;
        while (!((container = container.getParent()) instanceof JFrame)) {
        }
        return (JFrame)container;
    }

    private static boolean sameColors(Color color, Color color2) {
        if (color == color2) {
            return true;
        }
        if (color == null || color2 == null) {
            return false;
        }
        return color.equals(color2);
    }

    public static void Create(LandscapeViewerCore landscapeViewerCore, EntityInstance entityInstance) {
        new EditAttribute(EditAttribute.findFrame(landscapeViewerCore), entityInstance);
        landscapeViewerCore.repaint();
    }

    public static void Create(LandscapeViewerCore landscapeViewerCore, EntityClass entityClass) {
        boolean bl;
        Color color = entityClass.getObjectColorWhenOpen();
        Color color2 = entityClass.getObjectColor();
        Color color3 = entityClass.getLabelColor();
        int n = entityClass.style;
        new EditAttribute(EditAttribute.findFrame(landscapeViewerCore), entityClass);
        Color color4 = entityClass.getObjectColorWhenOpen();
        Color color5 = entityClass.getObjectColor();
        Color color6 = entityClass.getLabelColor();
        int n2 = entityClass.style;
        boolean bl2 = EditAttribute.sameColors(color, color4);
        boolean bl3 = EditAttribute.sameColors(color2, color5);
        boolean bl4 = EditAttribute.sameColors(color3, color6);
        boolean bl5 = bl = n == n2;
        if (!(bl2 && bl3 && bl4 && bl)) {
            if (!bl2) {
                landscapeViewerCore.setEntitiesColorWhenOpen(entityClass, color4);
            }
            if (!bl3) {
                landscapeViewerCore.setEntitiesColor(entityClass, color5);
            }
            if (!bl4) {
                landscapeViewerCore.setEntitiesLabelColor(entityClass, color6);
            }
            if (!bl) {
                landscapeViewerCore.setEntitiesStyle(entityClass, n2);
            }
            landscapeViewerCore.repaint();
        } else {
            landscapeViewerCore.repaintTabs();
        }
    }

    public static void Create(LandscapeViewerCore landscapeViewerCore, RelationClass relationClass) {
        int n = relationClass.style;
        Color color = relationClass.getObjectColor();
        new EditAttribute(EditAttribute.findFrame(landscapeViewerCore), relationClass);
        Color color2 = relationClass.getObjectColor();
        int n2 = relationClass.style;
        if (!color.equals(color2) || n != n2) {
            if (!color.equals(color2)) {
                landscapeViewerCore.setRelationColor(relationClass, color2);
            }
            if (n != n2) {
                landscapeViewerCore.setRelationStyle(relationClass, n2);
            }
            landscapeViewerCore.repaint();
        } else {
            landscapeViewerCore.repaintTabs();
        }
    }

    protected class MyJTable
    extends JTable {
        JFrame m_frame;
        LandscapeObject m_object;

        public MyJTable(JFrame jFrame, AbstractTableModel abstractTableModel, LandscapeObject landscapeObject) {
            super(abstractTableModel);
            this.m_frame = jFrame;
            this.m_object = landscapeObject;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            TableCellRenderer tableCellRenderer = null;
            String string = null;
            if (this.convertColumnIndexToModel(n2) == 1) {
                Object object = this.dataModel.getValueAt(n, n2);
                int n3 = this.m_object.getAttributeTypeAt(n);
                switch (n3) {
                    case 3: {
                        if (n != 0) {
                            string = "Click to change string";
                            break;
                        }
                        string = "This value is fixed";
                        break;
                    }
                    case 2: {
                        string = "Click to change double";
                        break;
                    }
                    case 1: {
                        string = "Click to change integer";
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (object != null) {
                            tableCellRenderer = new ColorRenderer();
                        }
                        string = "Click to change color";
                        break;
                    }
                    case 12: {
                        if (object != null) {
                            tableCellRenderer = new TextRenderer();
                        }
                        string = "Click to change text";
                        break;
                    }
                    case 13: {
                        if (object != null) {
                            tableCellRenderer = new StyleRenderer();
                        }
                        string = "Click to change entity style";
                        break;
                    }
                    case 14: {
                        if (object != null) {
                            tableCellRenderer = new RelStyleRenderer();
                        }
                        string = "Click to change relation style";
                        break;
                    }
                    case 11: {
                        string = "Click to change attribute value";
                        break;
                    }
                    case 0: {
                        string = "First enter name to create new attribute";
                    }
                }
                if (tableCellRenderer == null) {
                    tableCellRenderer = super.getCellRenderer(n, n2);
                    ((JLabel)((Object)tableCellRenderer)).setForeground(Color.black);
                }
            } else {
                Color color;
                tableCellRenderer = super.getCellRenderer(n, n2);
                if (n < this.m_object.getPrimaryAttributeCount()) {
                    color = Color.blue;
                    string = "This attribute name is fixed";
                } else {
                    color = Color.red;
                    string = n == this.m_object.getAttributeCount() - 1 ? "Click to add new attribute name" : "Click to change/delete attribute name";
                }
                ((JLabel)((Object)tableCellRenderer)).setForeground(color);
            }
            if (tableCellRenderer != null) {
                ((JComponent)((Object)tableCellRenderer)).setToolTipText(string);
            }
            return tableCellRenderer;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (this.convertColumnIndexToModel(n2) == 1) {
                int n3 = this.m_object.getAttributeTypeAt(n);
                switch (n3) {
                    case 7: {
                        return new ColorEditor(this.m_frame, false);
                    }
                    case 8: {
                        return new ColorEditor(this.m_frame, true);
                    }
                    case 12: {
                        return new TextEditor(this.m_frame);
                    }
                    case 2: {
                        return new DoubleEditor();
                    }
                    case 1: {
                        return new IntegerEditor();
                    }
                    case 13: {
                        return new StyleEditor();
                    }
                    case 14: {
                        return new RelStyleEditor();
                    }
                    case 11: {
                        return new AviTextEditor(this.m_frame);
                    }
                }
            }
            return super.getCellEditor(n, n2);
        }

        class RelStyleEditor
        extends DefaultCellEditor {
            Integer m_current;
            JComboBox m_comboBox;

            public RelStyleEditor() {
                super(new JCheckBox());
                this.m_comboBox = new JComboBox();
                for (int i = 0; i < Util.lineStyleName.length; ++i) {
                    this.m_comboBox.addItem(Util.lineStyleName[i]);
                }
                this.editorComponent = this.m_comboBox;
                this.setClickCountToStart(1);
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RelStyleEditor.this.fireEditingStopped();
                    }
                });
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = RelStyleEditor.this.m_comboBox.getSelectedIndex();
                        if (n >= 0) {
                            RelStyleEditor.this.m_current = new Integer(n);
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.m_current = (Integer)object;
                int n3 = this.m_current;
                if (n3 >= 0 && n3 < this.m_comboBox.getItemCount()) {
                    this.m_comboBox.setSelectedIndex(this.m_current);
                }
                return this.editorComponent;
            }
        }

        protected class RelStyleRenderer
        extends JTextField
        implements TableCellRenderer {
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                int n3 = (Integer)object;
                String string = n3 < 0 || n3 >= Util.lineStyleName.length ? "" : Util.lineStyleName[n3];
                this.setText(string);
                return this;
            }
        }

        class StyleEditor
        extends DefaultCellEditor {
            Integer m_current;
            JComboBox m_comboBox;

            public StyleEditor() {
                super(new JCheckBox());
                this.m_comboBox = new JComboBox();
                for (int i = 0; i < EntityClass.styleName.length; ++i) {
                    this.m_comboBox.addItem(EntityClass.styleName[i]);
                }
                this.editorComponent = this.m_comboBox;
                this.setClickCountToStart(1);
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        StyleEditor.this.fireEditingStopped();
                    }
                });
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = StyleEditor.this.m_comboBox.getSelectedIndex();
                        if (n >= 0) {
                            StyleEditor.this.m_current = new Integer(n);
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.m_current = (Integer)object;
                int n3 = this.m_current;
                if (n3 >= 0 && n3 < this.m_comboBox.getItemCount()) {
                    this.m_comboBox.setSelectedIndex(this.m_current);
                }
                return this.editorComponent;
            }
        }

        protected class StyleRenderer
        extends JTextField
        implements TableCellRenderer {
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                int n3 = (Integer)object;
                String string = n3 < 0 || n3 >= EntityClass.styleName.length ? "" : EntityClass.styleName[n3];
                this.setText(string);
                return this;
            }
        }

        class IntegerEditor
        extends DefaultCellEditor {
            Integer m_current;
            JTextField m_textField;

            public IntegerEditor() {
                super(new JCheckBox());
                this.m_textField = new JTextField();
                this.editorComponent = this.m_textField;
                this.setClickCountToStart(1);
                this.m_textField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        IntegerEditor.this.fireEditingStopped();
                    }
                });
                this.m_textField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            Integer n;
                            IntegerEditor.this.m_current = n = new Integer(IntegerEditor.this.m_textField.getText());
                        }
                        catch (Exception exception) {
                            System.out.println("\"" + IntegerEditor.this.m_textField.getText() + "\" is not an integer");
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.m_current = (Integer)object;
                this.m_textField.setText(this.m_current.toString());
                return this.editorComponent;
            }
        }

        class DoubleEditor
        extends DefaultCellEditor {
            Double m_current;
            JTextField m_textField;

            public DoubleEditor() {
                super(new JCheckBox());
                this.m_textField = new JTextField();
                this.editorComponent = this.m_textField;
                this.setClickCountToStart(1);
                this.m_textField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DoubleEditor.this.fireEditingStopped();
                    }
                });
                this.m_textField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            Double d;
                            DoubleEditor.this.m_current = d = new Double(DoubleEditor.this.m_textField.getText());
                        }
                        catch (Exception exception) {
                            System.out.println("\"" + DoubleEditor.this.m_textField.getText() + "\" is not a double");
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.m_current = (Double)object;
                this.m_textField.setText(this.m_current.toString());
                return this.editorComponent;
            }
        }

        class AviTextEditor
        extends TextEditor {
            AttributeValueItem m_avi;
            String m_oldText;

            public AviTextEditor(JFrame jFrame) {
                super(jFrame);
            }

            public Object getCellEditorValue() {
                if (!this.m_oldText.equals(this.m_currentText)) {
                    int n;
                    for (n = this.m_currentText.length() - 1; n >= 0 && Character.isWhitespace(this.m_currentText.charAt(n)); --n) {
                    }
                    if (n < 0) {
                        this.m_avi = null;
                    } else {
                        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(this.m_currentText);
                        LandscapeTokenStream landscapeTokenStream = new LandscapeTokenStream(stringBufferInputStream, "Attribute Editor");
                        try {
                            AttributeValueItem attributeValueItem = landscapeTokenStream.parseAttributeValueItem();
                            if (attributeValueItem != null) {
                                this.m_avi = attributeValueItem;
                            } else {
                                System.out.println("Can't parse '" + this.m_currentText + "' as attribute value");
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("Can't parse '" + this.m_currentText + "' as attribute value - exception thrown");
                        }
                    }
                }
                return this.m_avi;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.m_avi = (AttributeValueItem)object;
                this.m_currentText = object == null ? "" : object.toString();
                this.m_oldText = this.m_currentText;
                return this.editorComponent;
            }
        }

        class TextEditor
        extends DefaultCellEditor {
            JFrame m_frame;
            String m_currentText;
            JButton m_button;
            JTextArea m_textArea;
            JDialog m_dialog;

            public TextEditor(JFrame jFrame) {
                super(new JCheckBox());
                this.m_frame = jFrame;
                this.m_button = new JButton();
                this.m_button.setBackground(Color.white);
                this.m_button.setBorderPainted(false);
                this.m_button.setMargin(new Insets(0, 0, 0, 0));
                this.editorComponent = this.m_button;
                this.setClickCountToStart(1);
                this.m_button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TextEditor.this.fireEditingStopped();
                    }
                });
                this.m_button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Button button = new Button("OK");
                        Button button2 = new Button("Cancel");
                        TextEditor.this.m_textArea = new JTextArea(TextEditor.this.m_currentText);
                        ActionListener actionListener = new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                TextEditor.this.m_currentText = TextEditor.this.m_textArea.getText();
                                TextEditor.this.m_dialog.setVisible(false);
                            }
                        };
                        TextEditor.this.m_dialog = new JDialog(TextEditor.this.m_frame, "Change Text", true);
                        TextEditor.this.m_dialog.resize(438, 369);
                        Container container = TextEditor.this.m_dialog.getContentPane();
                        container.setLayout(null);
                        TextEditor.this.m_dialog.setForeground(new Color(0, 0, 0));
                        TextEditor.this.m_dialog.setBackground(new Color(192, 192, 192));
                        TextEditor.this.m_dialog.setFont(new Font("Dialog", 0, 12));
                        JScrollPane jScrollPane = new JScrollPane(TextEditor.this.m_textArea);
                        jScrollPane.setVisible(true);
                        jScrollPane.reshape(5, 5, 423, 300);
                        container.add(jScrollPane);
                        button = new Button("OK");
                        button.reshape(5, 310, 40, 20);
                        container.add(button);
                        button.addActionListener(actionListener);
                        TextEditor.this.m_dialog.setVisible(true);
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_currentText;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.m_currentText = (String)object;
                return this.editorComponent;
            }
        }

        protected class TextRenderer
        extends JTextField
        implements TableCellRenderer {
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setText((String)object);
                return this;
            }
        }

        class ColorEditor
        extends DefaultCellEditor {
            JFrame m_frame;
            Color m_currentColor;
            boolean m_allowNull;
            JButton m_button;

            public ColorEditor(JFrame jFrame, boolean bl) {
                super(new JCheckBox());
                this.m_frame = jFrame;
                this.m_allowNull = bl;
                this.m_button = new JButton(){

                    public void setText(String string) {
                    }
                };
                this.m_button.setBackground(Color.white);
                this.m_button.setBorderPainted(false);
                this.m_button.setMargin(new Insets(0, 0, 0, 0));
                this.editorComponent = this.m_button;
                this.setClickCountToStart(1);
                this.m_button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ColorEditor.this.fireEditingStopped();
                    }
                });
                this.m_button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ColorEditor.this.m_button.setBackground(ColorEditor.this.m_currentColor);
                        ColorEditor.this.m_currentColor = ColorChooser.create(ColorEditor.this.m_frame, "Pick a color", ColorEditor.this.m_currentColor, true, ColorEditor.this.m_allowNull);
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_currentColor;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.m_currentColor = (Color)object;
                return this.editorComponent;
            }
        }

        protected class ColorRenderer
        extends JLabel
        implements TableCellRenderer {
            Border unselectedBorder = null;
            Border selectedBorder = null;

            public ColorRenderer() {
                this.setOpaque(true);
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setBackground((Color)object);
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
                return this;
            }
        }
    }

    protected class AttributeTableModel
    extends AbstractTableModel {
        LandscapeObject m_object;
        JTable m_table;

        public AttributeTableModel(LandscapeObject landscapeObject) {
            this.m_object = landscapeObject;
        }

        public void setJTable(JTable jTable) {
            this.m_table = jTable;
        }

        public int getRowCount() {
            return this.m_object.getAttributeCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Name";
            }
            return "Value";
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.m_object.getAttributeNameAt(n);
            }
            return this.m_object.getAttributeValueAt(n);
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return this.getValueAt(0, n).getClass();
            }
            Object object = new Object();
            return object.getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return this.m_object.canEditName(n);
            }
            return this.m_object.canEditAttribute(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (this.m_object.setAttributeNameAt(n, object)) {
                    this.m_table.revalidate();
                    this.m_table.repaint();
                }
            } else {
                this.m_object.setAttributeValueAt(n, object);
            }
        }
    }
}

