/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Event;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Bend;
import lsedit.CommandList;
import lsedit.EdgePoint;
import lsedit.EditAttribute;
import lsedit.EntityInstance;
import lsedit.Layout;
import lsedit.ScrollableDiagram;
import lsedit.TextBox;
import lsedit.ViewModeHandler;

public class EditModeHandler
extends ViewModeHandler {
    protected static final String[] rootMenu = new String[]{"Add new entity (e)", "-", "Edit attributes (a)", "Edit class attributes (A)", "-", "Decrease label font size (t)", "Increase label font size (T)", "-", "Select all children (^A)", "Fit children to container (F)", "-", "Scale smaller in X dim (x)", "Scale larger in X dim (X)", "Scale smaller in Y dim (y)", "Scale larger in Y dim (Y)", "Scale smaller (z)", "Scale larger (Z)"};
    protected static final int[] rootKeys = new int[]{101, 0, 97, 65, 0, 116, 84, 0, 1, 70, 0, 120, 88, 121, 89, 122, 90};
    protected static final String[] entityMenu = new String[]{"Forward query (f)", "Backtrace query (b)", "Contain query result (^C)", "-", "Hide/show user edge (u)", "Hide/show user inside edges (U)", "Hide/show supplier edge (s)", "Hide/show supplier inside edge (S)", "Hide/show internal edges (I)", "Hide/show contents (c)", "-", "Draw new entity (e)", "Draw new source edge (E)", "Delete entity (DEL)", "Delete container (k)", "-", "Edit attributes (a)", "Edit class attributes (A)", "-", "Decrease label text size (t)", "Increase label text size (T)", "-", "Select all children (^A)", "Fit children to container (F)", "-", "Scale smaller in X dim (x)", "Scale larger in X dim (X)", "Scale smaller in Y dim (y)", "Scale larger in Y dim (Y)", "Scale smaller (z)", "Scale larger (Z)"};
    protected static final int[] entityKeys = new int[]{102, 98, 3, 0, 117, 85, 115, 83, 73, 99, 0, 101, 69, 127, 107, 0, 97, 65, 0, 116, 84, 0, 1, 70, 0, 120, 88, 121, 89, 122, 90};
    protected static final String[] edgeMenu = new String[]{"Open edge destination", "Open edge source", "Close edge destination", "Close edge source", "Navigate to destination", "Navigate to source", "New bend point (b)", "Delete edge (DEL)"};
    protected static final int[] edgeKeys = new int[]{2001, 2002, 2004, 2005, 2007, 2006, 98, 127};
    protected static final String[] bendMenu = new String[]{"Delete bend (DEL)"};
    protected static final int[] bendKeys = new int[]{127};
    protected static final String[] edgePointMenu = new String[]{"Reset edge point (DEL)"};
    protected static final int[] edgePointKeys = new int[]{127};

    protected void containQuery() {
        EntityInstance entityInstance = this.dg.getKeyEntity();
        if (!entityInstance.isOpen()) {
            this.ls.error("Key entity doesn't seem likely destination");
            return;
        }
        Vector vector = this.dg.getHighlightGroup();
        if (vector == null) {
            this.ls.error("No query result active.");
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            entityInstance2.moveEntityContainment(entityInstance);
        }
        this.dg.rescale();
        this.dg.fitTo(entityInstance);
    }

    protected void deltaFont(int n) {
        Vector vector = this.dg.getGroup();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.deltaFont(n);
        }
    }

    protected boolean handleRelnCommands(int n, int n2) {
        if (super.handleRelnCommands(n, n2)) {
            return true;
        }
        switch (n) {
            case 127: {
                this.dg.saveForUndo();
                if (this.bend != null) {
                    this.dg.deleteBend(this.bend);
                    break;
                }
                this.dg.deleteEdge(this.ri);
                break;
            }
            default: {
                return false;
            }
        }
        this.e = null;
        this.ri = null;
        this.bend = null;
        this.dg.setDrawEdges(true);
        this.ls.redrawDg();
        return true;
    }

    protected boolean isRootCommand(int n) {
        for (int i = 0; i < rootKeys.length; ++i) {
            if (n != rootKeys[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean handleEntityCommands(int n, int n2) {
        if (super.handleEntityCommands(n, n2)) {
            return true;
        }
        if (this.e == null) {
            this.e = this.dg.getKeyEntity();
            if (this.e == null) {
                this.e = this.dg.getRoot();
            }
        }
        if (this.e == this.dg.getRoot() && !this.isRootCommand(n)) {
            return false;
        }
        switch (n) {
            case 101: {
                String string;
                Layout layout = this.e.getLayout();
                Layout layout2 = new Layout(this.curX, this.curY, layout.width / 10.0, layout.height / 10.0);
                int n3 = 0;
                do {
                    string = "Entity#" + n3;
                    ++n3;
                } while (this.dg.entityExists(string));
                this.e = this.dg.addEntity(string, layout2, this.e);
                break;
            }
            case 97: {
                EditAttribute.Create(this.ls, this.e);
                break;
            }
            case 65: {
                EditAttribute.Create(this.ls, this.e.getEntityClass());
                break;
            }
            case 3: {
                this.dg.saveForUndo();
                this.containQuery();
                break;
            }
            case 107: {
                this.dg.saveForUndo();
                this.e.delete();
                this.ls.doFeedback("Entity " + this.e.getLabel() + " has been deleted.");
                break;
            }
            case 127: {
                this.dg.saveForUndo();
                this.e.deleteAll(true);
                this.ls.doFeedback("Entity " + this.e.getLabel() + " and its contents have been deleted.");
                break;
            }
            case 84: {
                this.deltaFont(1);
                break;
            }
            case 116: {
                this.deltaFont(-1);
                break;
            }
            default: {
                this.e = null;
                this.ri = null;
                this.bend = null;
                return false;
            }
        }
        this.ri = null;
        this.bend = null;
        if (this.e != null) {
            this.ls.redrawDg();
        }
        return true;
    }

    protected void popupMenu(Event event, int n, int n2) {
        this.e = this.dg.mouseOverEx(n, n2);
        this.ri = this.dg.mouseOverEdge(this.e, n, n2);
        this.bend = this.dg.mouseOverBend(n, n2);
        this.ept = this.dg.mouseOverIO(this.e, n, n2);
        if (this.ri != null) {
            this.popup.set("Relation options", new CommandList(edgeMenu, edgeKeys), null, this.dg.getRoot(), this.ls, event.x, event.y);
        } else if (this.bend != null) {
            this.popup.set("Bend options", new CommandList(bendMenu, bendKeys), null, this.dg.getRoot(), this.ls, event.x, event.y);
        } else if (this.ept != null) {
            this.popup.set("Side point options", new CommandList(edgePointMenu, edgePointKeys), null, this.dg.getRoot(), this.ls, event.x, event.y);
        } else if (this.e == this.dg.getRoot()) {
            this.popup.set("Root options", new CommandList(rootMenu, rootKeys), null, this.dg.getRoot(), this.ls, event.x, event.y);
        } else {
            this.popup.set("Entity options", new CommandList(entityMenu, entityKeys), null, this.dg.getRoot(), this.ls, event.x, event.y);
        }
    }

    public void select(ScrollableDiagram scrollableDiagram) {
        super.select(scrollableDiagram);
        scrollableDiagram.setDrawBends(true);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.e = this.dg.mouseOverEx(n, n2);
        if (this.e == null) {
            return false;
        }
        this.bend = this.dg.mouseOverBend(n, n2);
        this.ri = this.bend != null ? this.bend.getFirstEdge() : this.dg.mouseOverEdge(this.e, n, n2);
        return super.mouseDown(event, n, n2);
    }

    public void mouseMotion(EntityInstance entityInstance, int n, int n2) {
        EdgePoint edgePoint = this.dg.mouseOverIO(entityInstance, n, n2);
        Bend bend = this.dg.mouseOverBend(n, n2);
        if (edgePoint != null || bend != null) {
            this.ls.setCursor(1);
        } else {
            super.mouseMotion(entityInstance, n, n2);
        }
    }

    public void setHelp(TextBox textBox) {
    }
}

