/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import lsedit.BaseEntity;
import lsedit.Box2D;
import lsedit.Box3D;
import lsedit.ClassEntity;
import lsedit.Diagram;
import lsedit.DiskEntity;
import lsedit.EntityInstance;
import lsedit.FileEntity;
import lsedit.FolderEntity;
import lsedit.GroupEntity;
import lsedit.LabelledGroupEntity;
import lsedit.LandscapeClassObject;
import lsedit.SourceObjectEntity;

public class EntityClass
extends LandscapeClassObject {
    public static final String ENTITY_BASE_CLASS_ID = "$ENTITY";
    public static final int ENTITY_STYLE_3DBOX = 0;
    public static final int ENTITY_STYLE_2DBOX = 1;
    public static final int ENTITY_STYLE_FILE = 2;
    public static final int ENTITY_STYLE_DISK = 3;
    public static final int ENTITY_STYLE_FOLDER = 4;
    public static final int ENTITY_STYLE_SOURCEOBJ = 5;
    public static final int ENTITY_STYLE_CLASS = 6;
    public static final int ENTITY_STYLE_GROUP = 7;
    public static final int ENTITY_STYLE_LABELLED_GROUP = 8;
    public static final String[] styleName = new String[]{"3D Box", "2D Box", "File", "Disk", "Folder", "Source Object", "Class", "Group", "Labelled Group"};
    protected double avg;

    public EntityClass(String string, int n, EntityClass entityClass, Diagram diagram) {
        this.id = string;
        this.setNid(n);
        this.label = string;
        this.dg = diagram;
        this.style = 0;
        this.addParentClass(entityClass);
        this.setObjectColor(Color.blue);
        this.setLabelColor(Color.cyan);
    }

    public boolean hasId(String string) {
        return this.id.equals(string);
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        if (this.attributes.size() > 0) {
            printStream.print(this.qt(this.id) + " {\n");
            super.writeAttributes(printStream);
            printStream.print("}\n\n");
        }
    }

    public EntityInstance newEntity(String string, Diagram diagram) {
        BaseEntity baseEntity;
        switch (this.style) {
            case 0: {
                baseEntity = new Box3D(this, string, diagram);
                break;
            }
            case 1: {
                baseEntity = new Box2D(this, string, diagram);
                break;
            }
            case 2: {
                baseEntity = new FileEntity(this, string, diagram);
                break;
            }
            case 3: {
                baseEntity = new DiskEntity(this, string, diagram);
                break;
            }
            case 4: {
                baseEntity = new FolderEntity(this, string, diagram);
                break;
            }
            case 5: {
                baseEntity = new SourceObjectEntity(this, string, diagram);
                break;
            }
            case 6: {
                baseEntity = new ClassEntity(this, string, diagram);
                break;
            }
            case 7: {
                baseEntity = new GroupEntity(this, string, diagram);
                break;
            }
            case 8: {
                baseEntity = new LabelledGroupEntity(this, string, diagram);
                break;
            }
            default: {
                System.out.println("Internal error: Unknown EntityClass style " + this.style);
                return null;
            }
        }
        this.makeInstanceOfUs(baseEntity);
        return baseEntity;
    }

    public String addParentClass(EntityClass entityClass) {
        return this.addParentClass(entityClass, ENTITY_BASE_CLASS_ID);
    }

    public void setAverage(double d) {
        this.avg = d;
    }

    public double getAverage() {
        return this.avg;
    }

    public int getPrimaryAttributeCount() {
        return 7;
    }

    public String getAttributeNameAt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "id";
                break;
            }
            case 1: {
                string = "class_label";
                break;
            }
            case 2: {
                string = "class_description";
                break;
            }
            case 3: {
                string = "class_style";
                break;
            }
            case 4: {
                string = "color";
                break;
            }
            case 5: {
                string = "labelcolor";
                break;
            }
            case 6: {
                string = "opencolor";
                break;
            }
            default: {
                string = super.getAttributeNameAt(n);
            }
        }
        return string;
    }

    public Object getAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                object = this.label;
                break;
            }
            case 2: {
                object = this.description;
                break;
            }
            case 3: {
                object = new Integer(this.style);
                break;
            }
            case 4: {
                object = this.getObjectColor();
                break;
            }
            case 5: {
                object = this.getLabelColor();
                break;
            }
            case 6: {
                object = this.getObjectColorWhenOpen();
                break;
            }
            default: {
                object = super.getAttributeValueAt(n);
            }
        }
        return object;
    }

    public void setAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.label = (String)object;
                break;
            }
            case 2: {
                this.description = (String)object;
                break;
            }
            case 3: {
                this.style = (Integer)object;
                break;
            }
            case 4: {
                this.setObjectColor((Color)object);
                break;
            }
            case 5: {
                this.setLabelColor((Color)object);
                break;
            }
            case 6: {
                this.setObjectColorWhenOpen((Color)object);
                break;
            }
            default: {
                super.setAttributeValueAt(n, object);
            }
        }
    }

    public int getAttributeTypeAt(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 13;
                break;
            }
            case 4: 
            case 5: {
                n2 = 7;
                break;
            }
            case 6: {
                n2 = 8;
                break;
            }
            default: {
                n2 = super.getAttributeTypeAt(n);
            }
        }
        return n2;
    }
}

