/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Bend;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityClass;
import lsedit.LandscapeObject;
import lsedit.Layout;
import lsedit.MsgOut;
import lsedit.PSGr;
import lsedit.RealPoint;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ScreenPoint;
import lsedit.SugiyamaLayout;
import lsedit.Util;

public abstract class EntityInstance
extends LandscapeObject {
    public static final int SMALL_FONT = 0;
    public static final int REG_FONT = 1;
    public static final int NOT_USED = -1;
    public static final int CLOSED = 0;
    public static final int OPEN = 1;
    public static final String LABEL_ID = "label";
    public static final String XPOSITION_ID = "x";
    public static final String YPOSITION_ID = "y";
    public static final String WIDTH_ID = "width";
    public static final String HEIGHT_ID = "height";
    public static final String IN_ELISION_ID = "elision";
    public static final String OUT_ELISION_ID = "outelision";
    public static final String CLIENT_ELISION_ID = "clientelision";
    public static final String SUPPLIER_ELISION_ID = "supplierelision";
    public static final String INTERNAL_ELISION_ID = "internalelision";
    public static final String AGG_ELISION_ID = "aggelision";
    public static final String LINK_ID = "navlink";
    public static final String INPOINT_ID = "inpoints";
    public static final String OUTPOINT_ID = "outpoints";
    public static final String LEFTPOINT_ID = "leftpoints";
    public static final String RIGHTPOINT_ID = "rightpoints";
    public static final String DESC_ID = "description";
    public static final String TITLE_ID = "title";
    public static final String FONTDELTA_ID = "fontdelta";
    protected static final int RSZ_NONE = -1;
    protected static final int RSZ_NW = 0;
    protected static final int RSZ_N = 1;
    protected static final int RSZ_NE = 2;
    protected static final int RSZ_E = 3;
    protected static final int RSZ_SE = 4;
    protected static final int RSZ_S = 5;
    protected static final int RSZ_SW = 6;
    protected static final int RSZ_W = 7;
    protected static final int DEF_CONT_CAP = 35;
    protected static final int ROOT_CONT_CAP = 1000;
    protected EntityClass parentClass;
    protected int mark = 0;
    protected static final double TAB_HEIGHT = 16.0;
    protected static final int MOUSE_NEAR_EDGE_THRESHOLD = 4;
    protected static final int SEP_THRESHOLD = 8;
    protected static final int MARGIN = 5;
    protected static final int MIN_HEIGHT = 10;
    protected static final int MIN_WIDTH = 30;
    protected static final int CONTENTS_FLAG_DIM = 8;
    protected static final String OPEN_FAMILY = "Helvetica";
    protected static final int OPEN_FONT_SIZE = 12;
    protected static final Font openFont = new Font("Helvetica", 0, 12);
    protected static final String CLOSED_FAMILY = "Helvetica";
    protected static final int CLOSED_FONT_MIN_SIZE = 6;
    protected static final int CLOSED_FONT_SMALL_SIZE = 10;
    protected static final int NUM_FONTS = 25;
    protected static final int START_FONT_NUM = 6;
    protected static Font[] closedFont = new Font[25];
    protected static final Font smallFont = new Font("Helvetica", 0, 10);
    protected static boolean mungeIdToLabel = true;
    protected static final Color CARD_FORE_COLOUR = new Color(1.0f, 1.0f, 0.85f);
    protected Vector inElision = new Vector();
    protected Vector outElision = new Vector();
    protected Vector clientElision = new Vector();
    protected Vector supplierElision = new Vector();
    protected Vector internalElision = new Vector();
    protected EdgePoint[] topPoints;
    protected EdgePoint[] bottomPoints;
    protected EdgePoint[] leftPoints;
    protected EdgePoint[] rightPoints;
    protected double xLocal = 0.0;
    protected double yLocal = 0.0;
    protected double widthLocal = 300.0;
    protected double heightLocal = 100.0;
    private double m_x;
    private double m_y;
    private double m_width;
    private double m_height;
    protected int fontDelta = 0;
    private boolean m_groupFlag = false;
    private boolean m_groupKeyFlag = false;
    protected boolean highlightFlag = false;
    protected int tmpOpen = -1;
    protected boolean fullLabel = true;
    protected boolean drewClientFlag = true;
    protected boolean drewSupplierFlag = true;
    protected EntityInstance visibleEntityCache = null;
    protected EntityInstance containedBy;
    protected Hashtable containsList;
    protected Vector srcRelList = new Vector();
    protected Vector dstRelList = new Vector();
    protected int[] dstCardinals;
    protected Vector bends = new Vector();
    Layout tempLyt;
    protected int dstCount;
    protected Object m_ancilliary;
    protected static Hashtable est = new Hashtable();
    protected String[] endSet = new String[]{".ss", ".dup", "__funcdef", "__funcdcl", "__vardef", "__vardcl", "__macro", "__struct", "__union", "__enum", "__type"};

    protected void setFont(Graphics graphics, int n) {
        switch (n) {
            case 0: {
                graphics.setFont(smallFont);
                return;
            }
        }
        graphics.setFont(closedFont[6 + this.fontDelta]);
    }

    protected void setFontDelta(int n) {
        this.fontDelta = Math.max(-6, Math.min(n, 18));
    }

    protected void doSaveForUndo(EntityInstance entityInstance) {
        int n;
        entityInstance.srcRelList = (Vector)this.srcRelList.clone();
        entityInstance.dstRelList = (Vector)this.dstRelList.clone();
        entityInstance.containsList = (Hashtable)this.containsList.clone();
        entityInstance.containedBy = this.containedBy;
        entityInstance.label = this.label;
        entityInstance.description = this.description;
        entityInstance.setObjectColor(this.getObjectColor());
        entityInstance.inElision = (Vector)this.inElision.clone();
        entityInstance.outElision = (Vector)this.outElision.clone();
        entityInstance.clientElision = (Vector)this.clientElision.clone();
        entityInstance.supplierElision = (Vector)this.supplierElision.clone();
        entityInstance.internalElision = (Vector)this.internalElision.clone();
        entityInstance.xLocal = this.xLocal;
        entityInstance.yLocal = this.yLocal;
        entityInstance.widthLocal = this.widthLocal;
        entityInstance.heightLocal = this.heightLocal;
        entityInstance.setX(this.x());
        entityInstance.setY(this.y());
        entityInstance.setWidth(this.width());
        entityInstance.setHeight(this.height());
        int n2 = this.dg.numRelationClasses;
        if (this.topPoints != null) {
            entityInstance.topPoints = new EdgePoint[n2];
            for (n = 0; n < n2; ++n) {
                if (this.topPoints[n] == null) continue;
                entityInstance.topPoints[n] = (EdgePoint)this.topPoints[n].clone();
            }
        }
        if (this.bottomPoints != null) {
            entityInstance.bottomPoints = new EdgePoint[n2];
            for (n = 0; n < n2; ++n) {
                if (this.bottomPoints[n] == null) continue;
                entityInstance.bottomPoints[n] = (EdgePoint)this.bottomPoints[n].clone();
            }
        }
        if (this.leftPoints != null) {
            entityInstance.leftPoints = new EdgePoint[n2];
            for (n = 0; n < n2; ++n) {
                if (this.leftPoints[n] == null) continue;
                entityInstance.leftPoints[n] = (EdgePoint)this.leftPoints[n].clone();
            }
        }
        if (this.rightPoints != null) {
            entityInstance.rightPoints = new EdgePoint[n2];
            for (n = 0; n < n2; ++n) {
                if (this.rightPoints[n] == null) continue;
                entityInstance.rightPoints[n] = (EdgePoint)this.rightPoints[n].clone();
            }
        }
        super.saveForUndo(entityInstance);
    }

    protected void saveForUndo(EntityInstance entityInstance) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            entityInstance2.saveForUndo();
        }
        this.doSaveForUndo(entityInstance);
    }

    protected void undo(EntityInstance entityInstance) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            entityInstance2.undo();
        }
        this.srcRelList = entityInstance.srcRelList;
        this.dstRelList = entityInstance.dstRelList;
        this.containsList = entityInstance.containsList;
        this.containedBy = entityInstance.containedBy;
        this.label = entityInstance.label;
        this.description = entityInstance.description;
        this.setObjectColor(entityInstance.getObjectColor());
        this.inElision = entityInstance.inElision;
        this.outElision = entityInstance.outElision;
        this.clientElision = entityInstance.clientElision;
        this.supplierElision = entityInstance.supplierElision;
        this.internalElision = entityInstance.internalElision;
        this.xLocal = entityInstance.xLocal;
        this.yLocal = entityInstance.yLocal;
        this.widthLocal = entityInstance.widthLocal;
        this.heightLocal = entityInstance.heightLocal;
        this.setX(entityInstance.x());
        this.setY(entityInstance.y());
        this.setWidth(entityInstance.width());
        this.setHeight(entityInstance.height());
        this.topPoints = entityInstance.topPoints;
        this.bottomPoints = entityInstance.bottomPoints;
        this.leftPoints = entityInstance.leftPoints;
        this.rightPoints = entityInstance.rightPoints;
        super.undo(entityInstance);
    }

    protected double tabHeight() {
        return this.height() / 3.0 - 2.0;
    }

    protected void drawIOpoint(Graphics graphics, RelationClass relationClass, EdgePoint edgePoint, boolean bl) {
    }

    protected void setGraphicsColor(Graphics graphics) {
        graphics.setColor(this.getObjectColor());
    }

    public Color getLabelColour() {
        if (this.highlightFlag && !this.isOpen()) {
            return Color.yellow;
        }
        return this.getLabelColor();
    }

    protected void parsePoints(EdgePoint[] edgePointArray, Attribute attribute) {
        AttributeValueItem attributeValueItem = attribute.avi;
        while (attributeValueItem != null) {
            RelationClass relationClass = this.dg.nameToRelationClass(attributeValueItem.value);
            if (relationClass == null) continue;
            int n = relationClass.getNid();
            double d = Util.parseReal(attributeValueItem.next.value);
            double d2 = Util.parseReal(attributeValueItem.next.next.value);
            if (edgePointArray[n] == null) {
                edgePointArray[n] = new EdgePoint(this, relationClass, d, d2);
            } else {
                if (relationClass != edgePointArray[n].getRc()) {
                    MsgOut.println("Class nid mismatch");
                }
                edgePointArray[n].wf = d;
                edgePointArray[n].hf = d2;
            }
            edgePointArray[n].isDefault = false;
            attributeValueItem = attributeValueItem.nextList;
        }
    }

    protected void processElision(Attribute attribute, Vector vector) {
        AttributeValueItem attributeValueItem = attribute.avi;
        while (attributeValueItem != null) {
            String string = (String)est.get(attributeValueItem.value);
            if (string == null) {
                string = attributeValueItem.value;
                est.put(string, string);
            }
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            attributeValueItem = attributeValueItem.next;
        }
    }

    protected void processRawElision(String[] stringArray, Vector vector) {
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
    }

    protected boolean processFirstOrderAttributes(Attribute attribute) {
        boolean bl;
        boolean bl2 = bl = attribute.avi != null;
        if (attribute.hasId(XPOSITION_ID)) {
            if (bl) {
                this.xLocal = attribute.parseReal();
            }
            return true;
        }
        if (attribute.hasId(YPOSITION_ID)) {
            if (bl) {
                this.yLocal = attribute.parseReal();
            }
            return true;
        }
        if (attribute.hasId(WIDTH_ID)) {
            if (bl) {
                this.widthLocal = attribute.parseReal();
            }
            return true;
        }
        if (attribute.hasId(HEIGHT_ID)) {
            if (bl) {
                this.heightLocal = attribute.parseReal();
            }
            return true;
        }
        if (attribute.hasId(LABEL_ID)) {
            if (bl) {
                this.label = attribute.parseString();
            }
            return true;
        }
        if (attribute.hasId(DESC_ID)) {
            if (bl) {
                this.description = attribute.parseString();
            }
            return true;
        }
        if (attribute.hasId(TITLE_ID)) {
            if (bl) {
                this.title = attribute.parseString();
            }
            return true;
        }
        if (attribute.hasId(FONTDELTA_ID)) {
            if (bl) {
                this.setFontDelta(attribute.parseInt());
            }
            return true;
        }
        if (attribute.hasId("color")) {
            if (bl) {
                this.setObjectColor(attribute.parseColour());
            }
            return true;
        }
        if (attribute.hasId("opencolor")) {
            if (bl) {
                this.setObjectColorWhenOpen(attribute.parseColour());
            }
            return true;
        }
        if (attribute.hasId("labelcolor")) {
            if (bl) {
                this.setLabelColor(attribute.parseColour());
            }
            return true;
        }
        if (attribute.hasId(IN_ELISION_ID)) {
            if (bl) {
                this.processElision(attribute, this.inElision);
            }
            return true;
        }
        if (attribute.hasId(OUT_ELISION_ID)) {
            if (bl) {
                this.processElision(attribute, this.outElision);
            }
            return true;
        }
        if (attribute.hasId(CLIENT_ELISION_ID)) {
            if (bl) {
                this.processElision(attribute, this.clientElision);
            }
            return true;
        }
        if (attribute.hasId(SUPPLIER_ELISION_ID)) {
            if (bl) {
                this.processElision(attribute, this.supplierElision);
            }
            return true;
        }
        if (attribute.hasId(INTERNAL_ELISION_ID)) {
            if (bl) {
                this.processElision(attribute, this.internalElision);
            }
            return true;
        }
        if (attribute.hasId(INPOINT_ID)) {
            if (bl) {
                if (this.topPoints == null) {
                    this.topPoints = new EdgePoint[this.dg.numRelationClasses];
                }
                this.parsePoints(this.topPoints, attribute);
            }
            return true;
        }
        if (attribute.hasId(OUTPOINT_ID)) {
            if (bl) {
                if (this.bottomPoints == null) {
                    this.bottomPoints = new EdgePoint[this.dg.numRelationClasses];
                }
                this.parsePoints(this.bottomPoints, attribute);
            }
            return true;
        }
        if (attribute.hasId(LEFTPOINT_ID)) {
            if (bl) {
                if (this.leftPoints == null) {
                    this.leftPoints = new EdgePoint[this.dg.numRelationClasses];
                }
                this.parsePoints(this.leftPoints, attribute);
            }
            return true;
        }
        if (attribute.hasId(RIGHTPOINT_ID)) {
            if (bl) {
                if (this.rightPoints == null) {
                    this.rightPoints = new EdgePoint[this.dg.numRelationClasses];
                }
                this.parsePoints(this.rightPoints, attribute);
            }
            return true;
        }
        return false;
    }

    protected boolean hasRelation(RelationClass relationClass, boolean bl) {
        Object object;
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = bl ? this.srcRelList.elements() : this.dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            object = (RelationInstance)enumeration.nextElement();
            if (!((RelationInstance)object).parentClass.id.equals(relationClass.id)) continue;
            return true;
        }
        object = this.getChildren();
        while (object.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)object.nextElement();
            if (!entityInstance.hasRelation(relationClass, bl)) continue;
            return true;
        }
        return false;
    }

    protected void doEntityDelete() {
        RelationInstance relationInstance;
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.getDst().removeDstRelation(relationInstance);
        }
        enumeration = this.dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.getSrc().removeSrcRelation(relationInstance);
        }
        this.containedBy.removeContainment(this);
    }

    public Layout getLocalContentBoundingBox() {
        if (this.containsList.size() == 0) {
            MsgOut.dprintln("No children");
            return null;
        }
        Enumeration enumeration = this.getChildren();
        double d = this.xLocal + this.widthLocal;
        double d2 = this.yLocal + this.heightLocal;
        double d3 = 0.0;
        double d4 = 0.0;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.xLocal < d) {
                d = entityInstance.xLocal;
            }
            if (entityInstance.yLocal < d2) {
                d2 = entityInstance.yLocal;
            }
            if (entityInstance.xLocal + entityInstance.widthLocal > d3) {
                d3 = entityInstance.xLocal + entityInstance.widthLocal;
            }
            if (!(entityInstance.yLocal + entityInstance.heightLocal > d4)) continue;
            d4 = entityInstance.yLocal + entityInstance.heightLocal;
        }
        enumeration = this.bends.elements();
        int n = 3;
        while (enumeration.hasMoreElements()) {
            Bend bend = (Bend)enumeration.nextElement();
            if (bend.xLocal - (double)n < d) {
                d = bend.xLocal - (double)n;
            }
            if (bend.yLocal - (double)n < d2) {
                d2 = bend.yLocal - (double)n;
            }
            if (bend.xLocal + (double)n > d3) {
                d3 = bend.xLocal + (double)n;
            }
            if (!(bend.yLocal + (double)n > d4)) continue;
            d4 = bend.yLocal + (double)n;
        }
        return new Layout(d, d2, d3 - d, d4 - d2);
    }

    public String mungeId(String string) {
        if (mungeIdToLabel && string.length() > 0) {
            int n;
            for (n = 0; n < this.endSet.length; ++n) {
                if (!string.endsWith(this.endSet[n])) continue;
                string = string.substring(0, string.length() - this.endSet[n].length());
                break;
            }
            if (string.charAt(0) != '<') {
                n = string.lastIndexOf(47);
                if (n < 0) {
                    n = string.lastIndexOf(92);
                }
                if (n >= 0 && string.length() != n + 1) {
                    return string.substring(n + 1);
                }
            }
        }
        return string;
    }

    public static void generateFonts() {
        for (int i = 0; i < 25; ++i) {
            EntityInstance.closedFont[i] = new Font("Helvetica", 0, 6 + i);
        }
    }

    public static void setLabelMungeFlag(boolean bl) {
        mungeIdToLabel = bl;
    }

    public abstract void saveForUndo();

    public abstract void undo();

    public abstract void draw(Graphics var1);

    public abstract RealPoint calculateIntercept(RealPoint var1, RealPoint var2);

    public abstract boolean isPointOver(int var1, int var2);

    public abstract boolean isPointOverIO(EdgePoint var1, int var2, int var3);

    public abstract boolean containsLayout(Layout var1);

    public abstract boolean intersectsLayout(Layout var1);

    public abstract int overResizeTab(int var1, int var2);

    public abstract void drawHighlight(Graphics var1);

    public abstract void undrawHighlight(Graphics var1);

    public abstract void drawOutline(Graphics var1, Layout var2);

    public abstract EdgePoint getPoint(RelationClass var1, int var2);

    public abstract EdgePoint getOutPoint(RelationInstance var1, int var2, Layout var3, Layout var4);

    public abstract EdgePoint getMouseOverIO(int var1, int var2);

    public abstract void writeIOpoints(PrintStream var1);

    protected EntityInstance() {
    }

    protected String extendedLabel(boolean bl) {
        EntityInstance entityInstance;
        if (bl && (entityInstance = this.getEnterableParent()) != null) {
            return entityInstance.getLabel() + " .\n" + this.label;
        }
        return this.label;
    }

    public void setup(EntityClass entityClass, String string, Diagram diagram) {
        this.dg = diagram;
        this.id = string;
        this.parentClass = entityClass;
        this.label = this.mungeId(string);
        this.setX(10.0);
        this.setY(10.0);
        this.setWidth(20.0);
        this.setHeight(10.0);
        this.containsList = new Hashtable(string.equals("$ROOT") ? 1000 : 35);
        if (entityClass != null) {
            this.setObjectColor(entityClass.getObjectColor());
            this.setLabelColor(entityClass.getLabelColor());
        }
    }

    public EntityInstance(EntityClass entityClass, String string, Diagram diagram) {
        this.setup(entityClass, string, diagram);
    }

    public void clearCache() {
        this.visibleEntityCache = null;
        this.leftPoints = null;
        this.rightPoints = null;
        this.bottomPoints = null;
        this.topPoints = null;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearCache();
        }
    }

    public void drawAll(Graphics graphics) {
        this.drewClientFlag = false;
        this.drewSupplierFlag = false;
        this.dstCount = 0;
        this.draw(graphics);
        if (!this.isOpen()) {
            if (this.hasChildren()) {
                this.drawContentsFlag(graphics);
            }
        } else {
            this.drawChildren(graphics);
        }
    }

    public void drawChildren(Graphics graphics) {
        if (!this.isOpen()) {
            return;
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.drawAll(graphics);
        }
    }

    public void delete() {
        double d = this.dg.getScaleX();
        double d2 = this.dg.getScaleY();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Layout layout = entityInstance.getLayout();
            this.containedBy.addContainment(entityInstance);
            entityInstance.setLayout(layout);
        }
        this.doEntityDelete();
    }

    public void deleteAll(boolean bl) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.deleteAll(true);
        }
        if (bl) {
            this.doEntityDelete();
        }
    }

    public void addContainment(EntityInstance entityInstance) {
        if (this.containsList.put(entityInstance.id, entityInstance) != null) {
            MsgOut.println("Entity " + this.id + " already contains " + entityInstance.id);
        } else {
            entityInstance.containedBy = this;
        }
    }

    public boolean removeContainment(EntityInstance entityInstance) {
        if (this.containsList.containsKey(entityInstance.id)) {
            this.containsList.remove(entityInstance.id);
            return true;
        }
        MsgOut.println("Entity " + this.id + " doesn't contain " + entityInstance.id);
        return false;
    }

    public void moveEntityContainment(EntityInstance entityInstance) {
        if (entityInstance != this.containedBy) {
            this.containedBy.removeContainment(this);
            entityInstance.addContainment(this);
        }
    }

    public void addRelation(RelationInstance relationInstance, EntityInstance entityInstance) {
        this.addSrcRelation(relationInstance);
        entityInstance.addDestRelation(relationInstance);
    }

    public RelationInstance getRelation(RelationClass relationClass, EntityInstance entityInstance) {
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass || relationInstance.getDst() != entityInstance) continue;
            return relationInstance;
        }
        return null;
    }

    public void addSrcRelation(RelationInstance relationInstance) {
        this.srcRelList.addElement(relationInstance);
    }

    public void removeSrcRelation(RelationInstance relationInstance) {
        this.srcRelList.removeElement(relationInstance);
    }

    public void addDestRelation(RelationInstance relationInstance) {
        this.dstRelList.addElement(relationInstance);
    }

    public void removeDstRelation(RelationInstance relationInstance) {
        this.dstRelList.removeElement(relationInstance);
    }

    public boolean isRelationPresent(RelationClass relationClass, EntityInstance entityInstance) {
        String string = entityInstance.getId();
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            if (!relationInstance.isSameRelation(relationClass, this, entityInstance)) continue;
            return true;
        }
        return false;
    }

    public void addAttribute(Attribute attribute) {
        if (this.processFirstOrderAttributes(attribute)) {
            return;
        }
        super.addAttribute(attribute);
    }

    public boolean addRawAttribute(String string, int n) {
        if (string.equals(FONTDELTA_ID)) {
            this.setFontDelta(n);
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String string, double d) {
        if (string.equals(XPOSITION_ID)) {
            this.xLocal = d;
            return true;
        }
        if (string.equals(YPOSITION_ID)) {
            this.yLocal = d;
            return true;
        }
        if (string.equals(WIDTH_ID)) {
            this.widthLocal = d;
            return true;
        }
        if (string.equals(HEIGHT_ID)) {
            this.heightLocal = d;
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String string, String string2) {
        if (string.equals(LABEL_ID)) {
            this.label = string2;
            return true;
        }
        if (string.equals(DESC_ID)) {
            this.description = string2;
            return true;
        }
        if (string.equals(TITLE_ID)) {
            this.title = string2;
            return true;
        }
        return super.addRawAttribute(string, string2);
    }

    public boolean addRawAttribute(String string, int[] nArray) {
        return false;
    }

    public boolean addRawAttribute(String string, double[] dArray) {
        if (string.equals("color")) {
            this.setObjectColor(new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]));
            return true;
        }
        if (string.equals("labelcolor")) {
            this.setLabelColor(new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]));
            return true;
        }
        if (string.equals("opencolor")) {
            this.setObjectColorWhenOpen(new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]));
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String string, String[] stringArray) {
        if (string.equals(IN_ELISION_ID)) {
            this.processRawElision(stringArray, this.inElision);
            return true;
        }
        if (string.equals(OUT_ELISION_ID)) {
            this.processRawElision(stringArray, this.outElision);
            return true;
        }
        if (string.equals(CLIENT_ELISION_ID)) {
            this.processRawElision(stringArray, this.clientElision);
            return true;
        }
        if (string.equals(SUPPLIER_ELISION_ID)) {
            this.processRawElision(stringArray, this.supplierElision);
            return true;
        }
        if (string.equals(INTERNAL_ELISION_ID)) {
            this.processRawElision(stringArray, this.internalElision);
            return true;
        }
        return super.addRawAttribute(string, stringArray);
    }

    public void assignAttributes(Attribute attribute) {
        while (attribute != null) {
            if (attribute.avi == null) {
                MsgOut.println("Null attribute assignment");
            } else if (!this.processFirstOrderAttributes(attribute)) {
                Attribute attribute2 = this.getAttribute(attribute.id);
                if (attribute2 == null) {
                    MsgOut.println("Missing attribute '" + attribute.toString() + "'");
                } else {
                    if (attribute2.cloneOnAssign) {
                        attribute2 = (Attribute)attribute2.clone();
                        attribute2.cloneOnAssign = false;
                        this.replaceAttribute(attribute2);
                    }
                    attribute2.avi = attribute.avi;
                }
            }
            attribute = attribute.next;
        }
    }

    public void assignRelnAttributes(RelationClass relationClass, EntityInstance entityInstance, Attribute attribute) {
        System.out.println("Asgn: " + relationClass.getId() + " " + this.id + " " + entityInstance.getId());
    }

    protected void rescale(EdgePoint[] edgePointArray) {
        if (edgePointArray != null) {
            for (int i = 0; i < edgePointArray.length; ++i) {
                if (edgePointArray[i] == null) continue;
                edgePointArray[i].clearRc();
            }
        }
    }

    public void rescale(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.setX(d * d5 + d7);
        this.setY(d2 * d6 + d8);
        this.setWidth(d3 * d5);
        this.setHeight(d4 * d6);
        Enumeration enumeration = this.bends.elements();
        while (enumeration.hasMoreElements()) {
            Bend bend = (Bend)enumeration.nextElement();
            bend.x = bend.xLocal * d5 + this.x();
            bend.y = bend.yLocal * d6 + this.y();
            MsgOut.dprintln(this.id + " " + bend.x + " " + bend.y);
        }
        this.rescale(this.topPoints);
        this.rescale(this.bottomPoints);
        this.rescale(this.leftPoints);
        this.rescale(this.rightPoints);
        enumeration = this.getChildren();
        double d9 = d7 + d * d5;
        double d10 = d8 + d2 * d6;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.rescale(d5, d6, d9, d10);
        }
    }

    public void rescale(double d, double d2, double d3, double d4) {
        this.rescale(this.xLocal, this.yLocal, this.widthLocal, this.heightLocal, d, d2, d3, d4);
    }

    public void rescaleChildren(double d, double d2, double d3, double d4) {
        this.rescale(this.topPoints);
        this.rescale(this.bottomPoints);
        this.rescale(this.leftPoints);
        this.rescale(this.rightPoints);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.rescale(d, d2, d3, d4);
        }
    }

    protected void scale(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        if (bl) {
            this.widthLocal *= d;
            this.heightLocal *= d2;
            if (bl2) {
                this.xLocal = (this.xLocal - d3) * d;
                this.yLocal = (this.yLocal - d4) * d2;
            }
        } else if (this.containsList.size() > 0) {
            object2 = this.getLocalContentBoundingBox();
            ((Layout)object2).width *= d;
            ((Layout)object2).height *= d2;
            if (bl2) {
                ((Layout)object2).x = (((Layout)object2).x - d3) * d;
                ((Layout)object2).y = (((Layout)object2).y - d4) * d2;
            }
            if (((Layout)object2).x + ((Layout)object2).width >= this.widthLocal || ((Layout)object2).y + ((Layout)object2).height >= this.heightLocal) {
                return;
            }
        }
        object2 = this.bends.elements();
        while (object2.hasMoreElements()) {
            object = (Bend)object2.nextElement();
            ((Bend)object).xLocal = (((Bend)object).xLocal - d3) * d;
            ((Bend)object).yLocal = (((Bend)object).yLocal - d4) * d2;
        }
        object2 = this.getChildren();
        while (object2.hasMoreElements()) {
            object = (EntityInstance)object2.nextElement();
            ((EntityInstance)object).scale(d, d2, d3, d4, true, true);
        }
    }

    public void scale(double d, boolean bl, boolean bl2) {
        this.scale(d, d, 0.0, 0.0, bl, bl2);
    }

    public void scale(double d, boolean bl) {
        this.scale(d, d, 0.0, 0.0, bl, false);
    }

    public void scale(double d) {
        this.scale(d, d, 0.0, 0.0, true, false);
    }

    public void scaleX(double d, boolean bl, boolean bl2) {
        this.scale(d, 1.0, 0.0, 0.0, bl, bl2);
    }

    public void scaleX(double d, boolean bl) {
        this.scale(d, 1.0, 0.0, 0.0, bl, false);
    }

    public void scaleX(double d) {
        this.scale(d, 1.0, 0.0, 0.0, true, false);
    }

    public void scaleY(double d, boolean bl, boolean bl2) {
        this.scale(1.0, d, 0.0, 0.0, bl, bl2);
    }

    public void scaleY(double d, boolean bl) {
        this.scale(1.0, d, 0.0, 0.0, bl, false);
    }

    public void scaleY(double d) {
        this.scale(1.0, d, 0.0, 0.0, true, false);
    }

    protected void doFitScale(double d, double d2, double d3, double d4) {
        Object object;
        this.widthLocal *= d;
        this.heightLocal *= d2;
        this.xLocal = this.xLocal * d - d3;
        this.yLocal = this.yLocal * d2 - d4;
        Enumeration enumeration = this.bends.elements();
        while (enumeration.hasMoreElements()) {
            object = (Bend)enumeration.nextElement();
            ((Bend)object).xLocal = (((Bend)object).xLocal - d3) * d;
            ((Bend)object).yLocal = (((Bend)object).yLocal - d4) * d2;
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            object = (EntityInstance)enumeration.nextElement();
            ((EntityInstance)object).doFitScale(d, d2, 0.0, 0.0);
        }
    }

    public boolean fitTo(boolean bl) {
        Object object;
        double d = this.dg.getScaleX();
        double d2 = this.dg.getScaleY();
        MsgOut.dprintln("Fit to: " + this.id + " (" + this.widthLocal + " " + this.heightLocal + ")");
        if (this.widthLocal == 0.0 || this.heightLocal == 0.0) {
            this.containsList = new Hashtable();
        }
        if (this.containsList.size() == 0) {
            MsgOut.dprintln("No children");
            return true;
        }
        Enumeration enumeration = this.getChildren();
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MAX_VALUE;
        double d6 = Double.MIN_VALUE;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.x() < d3) {
                d3 = entityInstance.x();
            }
            if (entityInstance.y() < d5) {
                d5 = entityInstance.y();
            }
            if (entityInstance.x() + entityInstance.width() > d4) {
                d4 = entityInstance.x() + entityInstance.width();
            }
            if (!(entityInstance.y() + entityInstance.height() > d6)) continue;
            d6 = entityInstance.y() + entityInstance.height();
        }
        enumeration = this.bends.elements();
        int n = 3;
        while (enumeration.hasMoreElements()) {
            object = (Bend)enumeration.nextElement();
            if (((Bend)object).x - (double)n < d3) {
                d3 = ((Bend)object).x - (double)n;
            }
            if (((Bend)object).y - (double)n < d5) {
                d5 = ((Bend)object).y - (double)n;
            }
            if (((Bend)object).x + (double)n > d4) {
                d4 = ((Bend)object).x + (double)n;
            }
            if (!(((Bend)object).y + (double)n > d6)) continue;
            d6 = ((Bend)object).y + (double)n;
        }
        if (d4 - d3 <= 1.0E-4) {
            return false;
        }
        if (d6 - d5 <= 1.0E-4) {
            return false;
        }
        if (!bl && this.containsLayout((Layout)(object = new Layout(d3, d5, d4 - d3, d6 - d5)))) {
            return true;
        }
        MsgOut.dprintln("(" + d3 + "," + d5 + ") (" + d4 + "," + d6 + ")");
        double d7 = (this.width() - this.width() / 15.0) / (d4 - d3);
        double d8 = (this.height() - this.height() / 15.0) / (d6 - d5);
        double d9 = (d4 - d3) / d * d7;
        double d10 = (d6 - d5) / d2 * d8;
        double d11 = (d3 - this.x()) / d * d7 - (this.widthLocal - d9) / 2.0;
        double d12 = (d5 - this.y()) / d2 * d8 - (this.heightLocal - d10) / 2.0;
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.doFitScale(d7, d8, d11, d12);
        }
        MsgOut.dprintln("Fit: " + d7 + " " + d8);
        return true;
    }

    public boolean verifyFit() {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.verifyFit()) continue;
            this.containsList = new Hashtable();
            this.setObjectColor(Color.black);
            this.setLabelColor(Color.white);
            this.setLabel("LSedit depth limit!!!");
            MsgOut.dprintln("Hit LSedit depth limit: see [irbull]");
            break;
        }
        return this.fitTo(false);
    }

    public void deltaFont(int n) {
        this.setFontDelta(this.fontDelta + n);
    }

    protected void drawTopLeftLabel(Graphics graphics) {
        graphics.setFont(smallFont);
        graphics.setColor(Color.black);
        Util.drawStringClipped(graphics, this.label, this.x() + 5.0, this.y() + 5.0, this.width() - 10.0, this.height() - 10.0);
    }

    public boolean doDrawLabel(Graphics graphics, double d, double d2, double d3, double d4, boolean bl) {
        return Util.drawStringWrapped(graphics, this.extendedLabel(bl), d + 5.0, d2 + 5.0, d3 - 10.0, d4 - 10.0, true, false);
    }

    public void drawLabel(Graphics graphics, int n, boolean bl) {
        if (this.getParent() == null) {
            return;
        }
        if (this.isLabelDrawable()) {
            if (this.isOpen()) {
                this.drawTopLeftLabel(graphics);
            } else {
                graphics.setColor(this.getLabelColour());
                this.setFont(graphics, n);
                this.fullLabel = this.doDrawLabel(graphics, this.x(), this.y(), this.width(), this.height(), bl);
            }
        } else {
            this.fullLabel = false;
        }
    }

    public void drawLabel(Graphics graphics) {
        this.drawLabel(graphics, 1, false);
    }

    public void drawLabels(Graphics graphics) {
        if (this.width() < 30.0 || this.height() < 10.0) {
            this.fullLabel = false;
            return;
        }
        if (this.isOpen()) {
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.drawLabels(graphics);
            }
        }
        this.drawLabel(graphics);
    }

    public Dimension getLabelDim(Graphics graphics, int n, boolean bl) {
        int n2;
        this.setFont(graphics, n);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = Util.fontHeight(fontMetrics);
        if (bl) {
            EntityInstance entityInstance = this.getEnterableParent();
            if (entityInstance != null) {
                n2 = Math.max(fontMetrics.stringWidth(entityInstance.getLabel() + " | "), fontMetrics.stringWidth(this.label));
                n3 += n3 / 2;
            } else {
                n2 = fontMetrics.stringWidth(this.label);
            }
        } else {
            n2 = fontMetrics.stringWidth(this.label);
        }
        return new Dimension(n2, n3);
    }

    public Dimension getLabelDim(Graphics graphics, int n) {
        return this.getLabelDim(graphics, n, false);
    }

    public Dimension getFitDim(Graphics graphics, int n, boolean bl) {
        Dimension dimension = this.getLabelDim(graphics, n, bl);
        if (this.hasChildren() && !this.isOpen()) {
            dimension.width += 8;
        }
        dimension.width += 15;
        dimension.height += 7;
        return dimension;
    }

    public Dimension getFitDim(Graphics graphics, int n) {
        return this.getFitDim(graphics, n, false);
    }

    public void drawClientFlag(Graphics graphics) {
        if (this.drewClientFlag) {
            return;
        }
        RealPoint realPoint = new RealPoint(this.x() + this.width() - 5.0, this.y() + 10.0);
        RealPoint realPoint2 = new RealPoint(this.x() + this.width() - 20.0 - 5.0, this.y() + 10.0);
        Util.drawArrow(graphics, realPoint, realPoint2);
        this.drewClientFlag = true;
    }

    public void drawSupplierFlag(Graphics graphics) {
        if (this.drewSupplierFlag) {
            return;
        }
        RealPoint realPoint = new RealPoint(this.x() + this.width() - 20.0 - 5.0, this.y() + 10.0);
        RealPoint realPoint2 = new RealPoint(this.x() + this.width() - 5.0, this.y() + 10.0);
        Util.drawArrow(graphics, realPoint, realPoint2);
        this.drewSupplierFlag = true;
    }

    public void drawContentsFlag(Graphics graphics) {
        if (this.width() < 16.0 || this.height() < 16.0) {
            return;
        }
        graphics.setColor(this.getObjectColor().darker());
        int n = (int)this.x();
        int n2 = (int)this.y();
        graphics.drawRect(n + 3, n2 + 3, 8, 8);
        graphics.drawLine(n + 5, n2 + 7, n + 9, n2 + 7);
        graphics.drawLine(n + 7, n2 + 5, n + 7, n2 + 9);
    }

    public void drawEdges(Graphics graphics) {
        EntityInstance entityInstance;
        RelationInstance relationInstance;
        EntityInstance entityInstance2;
        EntityInstance entityInstance3 = this.getVisibleEntity();
        EntityInstance entityInstance4 = entityInstance3 == null ? null : entityInstance3.getParent();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            entityInstance2.drawEdges(graphics);
        }
        if (entityInstance4 == null) {
            return;
        }
        entityInstance2 = this.dg.getRoot();
        enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getSrc() != this) {
                System.out.println("Error!!!!!");
            }
            if (!relationInstance.draw(graphics, true) || entityInstance2.descendent(entityInstance = relationInstance.getDst()) || !entityInstance4.isSupplierRelationElided(relationInstance.getRelationClass())) continue;
            entityInstance3.drawSupplierFlag(graphics);
        }
        enumeration = this.dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance = relationInstance.getSrc();
            if (entityInstance2.descendent(entityInstance) || !relationInstance.draw(graphics, true) || !entityInstance4.isClientRelationElided(relationInstance.getRelationClass())) continue;
            entityInstance3.drawClientFlag(graphics);
        }
    }

    public void drawHighlightedEdges(Graphics graphics) {
        LandscapeObject landscapeObject;
        EntityInstance entityInstance = this.dg.getRoot();
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            if (!((RelationInstance)landscapeObject).getHighlightFlag() || !((RelationInstance)landscapeObject).getRelationClass().isActive()) continue;
            ((RelationInstance)landscapeObject).draw(graphics, false);
        }
        enumeration = this.dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = ((RelationInstance)landscapeObject).getSrc();
            if (entityInstance.descendent(entityInstance2) || !((RelationInstance)landscapeObject).getHighlightFlag() || !((RelationInstance)landscapeObject).getRelationClass().isActive()) continue;
            ((RelationInstance)landscapeObject).draw(graphics, false);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            ((EntityInstance)landscapeObject).drawHighlightedEdges(graphics);
        }
    }

    protected void doDrawCardinals(Graphics graphics, FontMetrics fontMetrics, int n) {
        LandscapeObject landscapeObject;
        for (int i = 0; i < this.dstCardinals.length; ++i) {
            landscapeObject = this.dg.numToRelationClass(i);
            if (this.dstCardinals[i] <= 0 || this.dg.allowElision() && !((RelationClass)landscapeObject).isVisible()) continue;
            String string = "" + this.dstCardinals[i];
            int n2 = fontMetrics.stringWidth(string);
            double d = ((RelationClass)landscapeObject).getIOfactor();
            ScreenPoint screenPoint = new ScreenPoint(this.x() + this.width() * d - (double)(n2 / 2), this.y() + this.height() + 5.0 + (double)n);
            graphics.setColor(landscapeObject.getObjectColor());
            if (graphics instanceof PSGr) {
                graphics.fillOval(screenPoint.x - 5, screenPoint.y - n + 3, Math.max(n, n2 + 10), n);
            } else {
                graphics.fillOval(screenPoint.x - 5, screenPoint.y - n + 3, Math.max(n, n2 + 10) + 1, n + 1);
            }
            graphics.setColor(Color.black);
            graphics.drawOval(screenPoint.x - 5, screenPoint.y - n + 3, Math.max(n, n2 + 10), n);
            graphics.setColor(CARD_FORE_COLOUR);
            graphics.drawString(string, screenPoint.x, screenPoint.y);
        }
        if (!this.isOpen()) {
            return;
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            ((EntityInstance)landscapeObject).doDrawCardinals(graphics, fontMetrics, n);
        }
    }

    public void drawCardinals(Graphics graphics) {
        graphics.setFont(smallFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.doDrawCardinals(graphics, fontMetrics, Util.fontHeight(fontMetrics));
    }

    public void getHighlightedEdges(Vector vector) {
        LandscapeObject landscapeObject;
        LandscapeObject landscapeObject2;
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject2 = (RelationInstance)enumeration.nextElement();
            if (!((RelationInstance)landscapeObject2).getHighlightFlag() || !((RelationInstance)landscapeObject2).getRelationClass().isActive()) continue;
            vector.addElement(landscapeObject2);
        }
        enumeration = this.dstRelList.elements();
        landscapeObject2 = this.dg.getRoot();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance = ((RelationInstance)landscapeObject).getSrc();
            if (((EntityInstance)landscapeObject2).descendent(entityInstance) || !((RelationInstance)landscapeObject).getHighlightFlag() || !((RelationInstance)landscapeObject).getRelationClass().isActive()) continue;
            vector.addElement(landscapeObject);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            ((EntityInstance)landscapeObject).getHighlightedEdges(vector);
        }
    }

    public void drawSegment(Graphics graphics, int n, int n2) {
        int n3 = (int)Math.round(this.x() + this.width() / 2.0);
        int n4 = (int)Math.round(this.y() + this.height() / 2.0);
        graphics.setColor(Color.black);
        graphics.drawLine(n3, n4, n, n2);
    }

    public void getInstancesRaw(Vector vector, Hashtable hashtable) {
        Object object;
        if (this.parentClass != null) {
            object = new Integer[]{(Integer)hashtable.get(this.id), (Integer)hashtable.get(this.parentClass.getId())};
            vector.addElement(object);
        }
        object = this.getChildren();
        while (object.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)object.nextElement();
            entityInstance.getInstancesRaw(vector, hashtable);
        }
    }

    public void getRelationsRaw(Vector vector, Hashtable hashtable, Integer n) {
        Integer[] integerArray;
        LandscapeObject landscapeObject;
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            integerArray = new Integer[3];
            RelationClass relationClass = ((RelationInstance)landscapeObject).getRelationClass();
            EntityInstance entityInstance = ((RelationInstance)landscapeObject).getSrc();
            EntityInstance entityInstance2 = ((RelationInstance)landscapeObject).getDst();
            integerArray[0] = (Integer)hashtable.get(relationClass.getId());
            integerArray[1] = (Integer)hashtable.get(entityInstance.getId());
            integerArray[2] = (Integer)hashtable.get(entityInstance2.getId());
            vector.addElement(integerArray);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            if (this.parentClass != null) {
                integerArray = new Integer[]{n, (Integer)hashtable.get(this.id), (Integer)hashtable.get(((EntityInstance)landscapeObject).id)};
                vector.addElement(integerArray);
            }
            ((EntityInstance)landscapeObject).getRelationsRaw(vector, hashtable, n);
        }
    }

    public void writeInstances(PrintStream printStream) throws IOException {
        if (this.parentClass != null) {
            printStream.print("$INSTANCE " + this.qt(this.id) + " " + this.qt(this.parentClass.getId()) + "\n");
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeInstances(printStream);
        }
    }

    public void writeRelations(PrintStream printStream) throws IOException {
        LandscapeObject landscapeObject;
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            ((RelationInstance)landscapeObject).writeRelation(printStream);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            if (this.parentClass != null) {
                printStream.print("contain " + this.qt(this.id) + " " + this.qt(((EntityInstance)landscapeObject).id) + "\n");
            }
            ((EntityInstance)landscapeObject).writeRelations(printStream);
        }
    }

    protected void writeLayout(PrintStream printStream) throws IOException {
        printStream.print("\t x = " + this.xLocal + "\n");
        printStream.print("\t y = " + this.yLocal + "\n");
        printStream.print("\t width = " + this.widthLocal + "\n");
        printStream.print("\t height = " + this.heightLocal + "\n");
    }

    public void writeLayoutAttributes(PrintStream printStream) throws IOException {
        printStream.print(this.qt(this.id) + " {\n");
        this.writeLayout(printStream);
        printStream.print("}\n\n");
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeLayoutAttributes(printStream);
        }
    }

    protected void writeElision(PrintStream printStream, Vector vector, String string) {
        if (vector.size() > 0) {
            printStream.print("\t " + string + " = (");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (enumeration.hasMoreElements()) {
                    printStream.print(string2 + " ");
                    continue;
                }
                printStream.print(string2);
            }
            printStream.print(")\n");
        }
    }

    protected void regRawElision(Vector vector, Hashtable hashtable, Vector vector2, String string) {
        if (vector2.size() > 0) {
            int n = vector2.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)vector2.elementAt(i);
            }
            this.regRawAttribute(vector, hashtable, string, stringArray);
        }
    }

    public void writeAttributes(PrintStream printStream, boolean bl) throws IOException {
        Object object;
        Object object2;
        printStream.print(this.qt(this.id) + " {\n");
        if (bl) {
            this.writeLayout(printStream);
        }
        if (this.label != null && !this.label.equals(this.mungeId(this.id))) {
            printStream.print("\t label = " + this.qt(this.label) + "\n");
        }
        if (this.description != null) {
            printStream.print("\t description = \"" + this.description + "\"\n");
        }
        if (this.parentClass != null) {
            int n;
            int n2;
            int n3;
            object2 = this.parentClass.getObjectColor();
            object = this.getObjectColor();
            if (!((Color)object).equals(object2)) {
                n3 = ((Color)object).getRed();
                n2 = ((Color)object).getGreen();
                n = ((Color)object).getBlue();
                printStream.print("\t color = (" + (double)n3 / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n / 255.0 + ")\n");
            }
            if ((object = this.getObjectColorWhenOpen()) != null) {
                n3 = ((Color)object).getRed();
                n2 = ((Color)object).getGreen();
                n = ((Color)object).getBlue();
                printStream.print("\t opencolor = (" + (double)n3 / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n / 255.0 + ")\n");
            }
            this.writeElision(printStream, this.inElision, IN_ELISION_ID);
            this.writeElision(printStream, this.outElision, OUT_ELISION_ID);
            this.writeElision(printStream, this.clientElision, CLIENT_ELISION_ID);
            this.writeElision(printStream, this.supplierElision, SUPPLIER_ELISION_ID);
            this.writeElision(printStream, this.internalElision, INTERNAL_ELISION_ID);
            this.writeIOpoints(printStream);
            if (this.fontDelta != 0) {
                printStream.print("\t fontdelta = ");
                printStream.print(this.fontDelta + "\n");
            }
        }
        if (this.attributes.size() > 0) {
            super.writeAttributes(printStream, false);
        }
        printStream.print("}\n\n");
        object2 = this.srcRelList.elements();
        while (object2.hasMoreElements()) {
            object = (RelationInstance)object2.nextElement();
            ((RelationInstance)object).writeAttributes(printStream);
        }
        object2 = this.getChildren();
        while (object2.hasMoreElements()) {
            object = (EntityInstance)object2.nextElement();
            ((EntityInstance)object).writeAttributes(printStream, bl);
        }
    }

    public void getAttributesRaw(Vector vector, Hashtable hashtable) {
        Object object;
        Object object2;
        Object object3;
        Vector vector2 = new Vector();
        this.regRawAttribute(vector2, hashtable, XPOSITION_ID, this.x());
        this.regRawAttribute(vector2, hashtable, YPOSITION_ID, this.y());
        this.regRawAttribute(vector2, hashtable, WIDTH_ID, this.width());
        this.regRawAttribute(vector2, hashtable, HEIGHT_ID, this.height());
        if (this.label != null && !this.label.equals(this.mungeId(this.id))) {
            this.regRawAttribute(vector2, hashtable, LABEL_ID, this.label);
        }
        if (this.description != null) {
            this.regRawAttribute(vector2, hashtable, DESC_ID, this.description);
        }
        if (this.parentClass != null) {
            object3 = this.parentClass.getObjectColor();
            object2 = this.getObjectColor();
            if (!((Color)object2).equals(object3)) {
                this.regRawAttribute(vector2, hashtable, "color", (Color)object2);
            }
            object3 = this.parentClass.getLabelColor();
            object = this.getLabelColor();
            if (!((Color)object).equals(object3)) {
                this.regRawAttribute(vector2, hashtable, "labelcolor", (Color)object);
            }
            if ((object2 = this.getObjectColorWhenOpen()) != null) {
                this.regRawAttribute(vector2, hashtable, "opencolor", (Color)object);
            }
            this.regRawElision(vector2, hashtable, this.inElision, IN_ELISION_ID);
            this.regRawElision(vector2, hashtable, this.clientElision, OUT_ELISION_ID);
            this.regRawElision(vector2, hashtable, this.supplierElision, SUPPLIER_ELISION_ID);
            this.regRawElision(vector2, hashtable, this.internalElision, INTERNAL_ELISION_ID);
            if (this.fontDelta != 0) {
                this.regRawAttribute(vector2, hashtable, FONTDELTA_ID, this.fontDelta);
            }
        }
        if (this.attributes.size() > 0) {
            super.getAttributesRaw(vector2, hashtable, false);
        }
        object3 = new Object[]{hashtable.get(this.id), vector2};
        vector.addElement(object3);
        object2 = this.getChildren();
        while (object2.hasMoreElements()) {
            object = (EntityInstance)object2.nextElement();
            ((EntityInstance)object).getAttributesRaw(vector, hashtable);
        }
    }

    public boolean canOpen() {
        return !this.containsList.isEmpty();
    }

    public boolean isOpen() {
        if (this.tmpOpen != -1) {
            return this.tmpOpen == 1;
        }
        return this.dg.getRoot() == this || !this.isInRelationElided("contain") && this.canOpen();
    }

    public boolean isOpenElided() {
        return !this.isInRelationElided("contain");
    }

    public EntityInstance getParent() {
        return this.containedBy;
    }

    public EntityInstance getEnterableParent() {
        if (this.containedBy == null || this.containedBy.isEnterable()) {
            return this.containedBy;
        }
        return this.containedBy.getEnterableParent();
    }

    public EntityClass getEntityClass() {
        return this.parentClass;
    }

    public boolean isRoot() {
        return this.containedBy == null;
    }

    public boolean hasChildren() {
        return !this.containsList.isEmpty();
    }

    public int numChildren() {
        return this.containsList.size();
    }

    public Enumeration getChildren() {
        return this.containsList.elements();
    }

    public void resetCardinals(int n) {
        this.dstCardinals = new int[n];
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.resetCardinals(n);
        }
    }

    public void incCardinal(int n) {
        int n2 = n;
        this.dstCardinals[n2] = this.dstCardinals[n2] + 1;
    }

    public void calcEdgeCardinals(boolean bl) {
        LandscapeObject landscapeObject;
        Enumeration enumeration = this.srcRelList.elements();
        EntityInstance entityInstance = this.getVisibleEntity();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            int n = ((RelationInstance)landscapeObject).getRelationClass().getNid();
            EntityInstance entityInstance2 = ((RelationInstance)landscapeObject).getDst().getVisibleEntity();
            if (entityInstance2 == null || entityInstance2 == entityInstance || bl && !((RelationInstance)landscapeObject).getHighlightFlag()) continue;
            entityInstance2.incCardinal(n);
        }
        landscapeObject = this.dg.getRoot();
        enumeration = this.dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            if (((EntityInstance)landscapeObject).descendent(relationInstance.getSrc())) continue;
            int n = relationInstance.getRelationClass().getNid();
            if (bl && !relationInstance.getHighlightFlag()) continue;
            entityInstance.incCardinal(n);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
            entityInstance3.calcEdgeCardinals(bl);
        }
    }

    public void getClients(Vector vector, EntityInstance entityInstance) {
        LandscapeObject landscapeObject;
        Enumeration<Object> enumeration = this.dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = ((RelationInstance)landscapeObject).getSrc();
            if (this != this.getVisibleEntity(entityInstance) && this.getParent().isInRelationElided(AGG_ELISION_ID) || entityInstance.descendent(entityInstance2) || vector.contains(entityInstance2)) continue;
            vector.addElement(entityInstance2);
        }
        enumeration = this.containsList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            ((EntityInstance)landscapeObject).getClients(vector, entityInstance);
        }
    }

    public void getSuppliers(Vector vector, EntityInstance entityInstance) {
        LandscapeObject landscapeObject;
        Enumeration<Object> enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = ((RelationInstance)landscapeObject).getDst();
            EntityInstance entityInstance3 = this.getVisibleEntity(entityInstance);
            if (this != entityInstance3 && this.getParent().isInRelationElided(AGG_ELISION_ID) || entityInstance.descendent(entityInstance2) || vector.contains(entityInstance2)) continue;
            vector.addElement(entityInstance2);
        }
        enumeration = this.containsList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            ((EntityInstance)landscapeObject).getSuppliers(vector, entityInstance);
        }
    }

    public String toString() {
        return this.label;
    }

    public Diagram getDiagram() {
        return this.dg;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return "";
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Layout getLayout() {
        return new Layout(this.x(), this.y(), this.width(), this.height());
    }

    public Layout getLocalLayout() {
        return new Layout(this.xLocal, this.yLocal, this.widthLocal, this.heightLocal);
    }

    public void setGlobalLayout(Layout layout) {
        this.setX(layout.x);
        this.setY(layout.y);
        this.setWidth(layout.width);
        this.setHeight(layout.height);
    }

    public void setLayout(Layout layout) {
        double d = this.dg.getScaleX();
        double d2 = this.dg.getScaleY();
        if (this.parentClass != null && this.containedBy != null) {
            Layout layout2 = this.containedBy.getLayout();
            this.xLocal = (layout.x - layout2.x) / d;
            this.yLocal = (layout.y - layout2.y) / d2;
        }
        this.widthLocal = layout.width / d;
        this.heightLocal = layout.height / d2;
        this.setGlobalLayout(layout);
    }

    public void setAbsoluteLayout(Layout layout) {
        this.xLocal = layout.x;
        this.yLocal = layout.y;
        this.widthLocal = layout.width;
        this.heightLocal = layout.height;
        this.setGlobalLayout(layout);
    }

    public void saveLayout() {
        this.tempLyt = new Layout(this.x(), this.y(), this.width(), this.height());
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.saveLayout();
        }
    }

    public void restoreLayout() {
        if (this.tempLyt == null) {
            System.out.println("Layout: restore without save " + this.label);
            return;
        }
        this.setGlobalLayout(this.tempLyt);
        this.tempLyt = null;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.restoreLayout();
        }
    }

    public void moveBend(Bend bend, double d, double d2) {
        bend.xLocal = (bend.x - this.x()) / d;
        bend.yLocal = (bend.y - this.y()) / d2;
    }

    public void addBend(Bend bend, double d, double d2) {
        this.moveBend(bend, d, d2);
        if (!this.bends.contains(bend)) {
            this.bends.addElement(bend);
        }
    }

    public void addBend(Bend bend) {
        if (!this.bends.contains(bend)) {
            this.bends.addElement(bend);
        }
    }

    public void deleteBend(Bend bend) {
        this.bends.removeElement(bend);
    }

    public Layout getChildBoundingBoxLocal() {
        if (this.containsList.isEmpty()) {
            return null;
        }
        Enumeration enumeration = this.getChildren();
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.xLocal < d) {
                d = entityInstance.xLocal;
            }
            if (entityInstance.yLocal < d3) {
                d3 = entityInstance.yLocal;
            }
            if (entityInstance.xLocal + entityInstance.widthLocal > d2) {
                d2 = entityInstance.xLocal + entityInstance.widthLocal;
            }
            if (!(entityInstance.yLocal + entityInstance.heightLocal > d4)) continue;
            d4 = entityInstance.yLocal + entityInstance.heightLocal;
        }
        return new Layout(d, d3, d2 - d, d4 - d3);
    }

    public Layout getChildBoundingBox() {
        if (this.containsList.isEmpty()) {
            return null;
        }
        Enumeration enumeration = this.getChildren();
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.x() < d) {
                d = entityInstance.x();
            }
            if (entityInstance.y() < d3) {
                d3 = entityInstance.y();
            }
            if (entityInstance.x() + entityInstance.width() > d2) {
                d2 = entityInstance.x() + entityInstance.width();
            }
            if (!(entityInstance.y() + entityInstance.height() > d4)) continue;
            d4 = entityInstance.y() + entityInstance.height();
        }
        return new Layout(d, d3, d2 - d, d4 - d3);
    }

    public void translateChildrenLocal(double d, double d2) {
        Object object;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            object = (EntityInstance)enumeration.nextElement();
            ((EntityInstance)object).xLocal += d;
            ((EntityInstance)object).yLocal += d2;
        }
        enumeration = this.bends.elements();
        while (enumeration.hasMoreElements()) {
            object = (Bend)enumeration.nextElement();
            ((Bend)object).xLocal += d;
            ((Bend)object).yLocal += d2;
        }
    }

    public Color getBackgroundWhenOpen() {
        Color color = this.getObjectColorWhenOpen();
        if (color == null) {
            EntityInstance entityInstance;
            float f = 0.7f;
            EntityInstance entityInstance2 = this;
            if (this.isTransparent()) {
                entityInstance2 = entityInstance2.containedBy;
            }
            if (!(entityInstance = this.dg.getRoot()).descendent(this)) {
                entityInstance = entityInstance.common(this);
            }
            while (entityInstance2 != entityInstance) {
                f -= 0.05f;
                entityInstance2 = entityInstance2.containedBy;
            }
            color = new Color(f, f, f);
            if (Util.isBlack(color)) {
                color = Color.lightGray;
            }
        }
        return color;
    }

    public Color getBackground() {
        Color color = this.isOpen() ? this.getBackgroundWhenOpen() : this.getObjectColor();
        return color;
    }

    public boolean isRelationElided(Vector vector, String string) {
        return vector.contains(string);
    }

    protected boolean toggleElision(Vector vector, String string) {
        if (this.isRelationElided(vector, string)) {
            if (!vector.removeElement(string)) {
                MsgOut.println("remove() failed");
            }
            return false;
        }
        vector.addElement(string);
        return true;
    }

    public boolean toggleInElision(String string) {
        MsgOut.dprintln("toggle in " + string);
        return this.toggleElision(this.inElision, string);
    }

    public boolean toggleInElision(RelationClass relationClass) {
        return this.toggleInElision(relationClass.getId());
    }

    public boolean toggleOutElision(String string) {
        MsgOut.dprintln("toggle out " + string);
        return this.toggleElision(this.outElision, string);
    }

    public boolean toggleOutElision(RelationClass relationClass) {
        return this.toggleOutElision(relationClass.getId());
    }

    public boolean toggleClientElision(String string) {
        MsgOut.dprintln("toggle client " + string);
        return this.toggleElision(this.clientElision, string);
    }

    public boolean toggleClientElision(RelationClass relationClass) {
        return this.toggleClientElision(relationClass.getId());
    }

    public boolean toggleSupplierElision(String string) {
        MsgOut.dprintln("toggle supplier " + string);
        return this.toggleElision(this.supplierElision, string);
    }

    public boolean toggleSupplierElision(RelationClass relationClass) {
        return this.toggleSupplierElision(relationClass.getId());
    }

    public boolean toggleInternalElision(String string) {
        MsgOut.dprintln("toggle internal " + string);
        return this.toggleElision(this.internalElision, string);
    }

    public boolean toggleInternalElision(RelationClass relationClass) {
        return this.toggleInternalElision(relationClass.getId());
    }

    public void setTempOpenFlag(int n) {
        this.tmpOpen = n;
    }

    public boolean hasId(String string) {
        return this.id.equals(string);
    }

    public boolean isInRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.inElision, relationClass.getId());
    }

    public boolean isInRelationElided(String string) {
        return this.isRelationElided(this.inElision, string);
    }

    public boolean isOutRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.outElision, relationClass.getId());
    }

    public boolean isOutRelationElided(String string) {
        return this.isRelationElided(this.outElision, string);
    }

    public boolean isClientRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.clientElision, relationClass.getId());
    }

    public boolean isClientRelationElided(String string) {
        return this.isRelationElided(this.clientElision, string);
    }

    public boolean isSupplierRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.supplierElision, relationClass.getId());
    }

    public boolean isSupplierRelationElided(String string) {
        return this.isRelationElided(this.supplierElision, string);
    }

    public boolean isInternalRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.internalElision, relationClass.getId());
    }

    public boolean isInternalRelationElided(String string) {
        return this.isRelationElided(this.internalElision, string);
    }

    public boolean isContainedBy(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = this.containedBy;
        while (entityInstance2 != null) {
            if (entityInstance2 == entityInstance) {
                return true;
            }
            entityInstance2 = entityInstance2.containedBy;
        }
        return false;
    }

    public boolean descendent(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = entityInstance;
        while (entityInstance2 != null) {
            if (entityInstance2 == this) {
                return true;
            }
            entityInstance2 = entityInstance2.containedBy;
        }
        return false;
    }

    public EntityInstance common(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = this.containedBy;
        if (entityInstance2 == null) {
            return entityInstance2;
        }
        while (entityInstance2 != null) {
            EntityInstance entityInstance3 = entityInstance;
            while (entityInstance3 != null) {
                if (entityInstance2 == entityInstance3) {
                    return entityInstance2;
                }
                entityInstance3 = entityInstance3.containedBy;
            }
            entityInstance2 = entityInstance2.containedBy;
        }
        MsgOut.println("EntityInstance.common: failed");
        return null;
    }

    public EntityInstance getVisibleEntity(EntityInstance entityInstance) {
        if (this == entityInstance) {
            return entityInstance;
        }
        if (this.visibleEntityCache == null) {
            EntityInstance entityInstance2;
            EntityInstance entityInstance3;
            EntityInstance entityInstance4 = entityInstance3 = this;
            if (entityInstance.descendent(entityInstance3)) {
                entityInstance2 = entityInstance;
            } else {
                entityInstance2 = this.dg.getClientOrSupplier(entityInstance3);
                if (entityInstance2 == null) {
                    return null;
                }
                entityInstance2 = entityInstance2.getParent();
            }
            do {
                if ((entityInstance4 = entityInstance4.containedBy) == null) {
                    return entityInstance3;
                }
                if (entityInstance4 == entityInstance2 || entityInstance4.isOpen()) continue;
                entityInstance3 = entityInstance4;
            } while (entityInstance4 != entityInstance2);
            this.visibleEntityCache = entityInstance3;
        }
        return this.visibleEntityCache;
    }

    public EntityInstance getVisibleEntity() {
        return this.getVisibleEntity(this.dg.getRoot());
    }

    public boolean isClientOf(EntityInstance entityInstance) {
        LandscapeObject landscapeObject;
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = ((RelationInstance)landscapeObject).getDst();
            if (entityInstance2 == entityInstance) {
                return true;
            }
            if (!entityInstance.isContainedBy(entityInstance2)) continue;
            return true;
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            if (!((EntityInstance)landscapeObject).isClientOf(entityInstance)) continue;
            return true;
        }
        return false;
    }

    public EntityInstance getMouseOver(int n, int n2) {
        if (this.isPointOver(n, n2)) {
            if (this.isOpen()) {
                Enumeration enumeration = this.getChildren();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                    EntityInstance entityInstance2 = entityInstance.getMouseOver(n, n2);
                    if (entityInstance2 == null) continue;
                    return entityInstance2;
                }
            }
            return this;
        }
        return null;
    }

    public Bend getMouseOverBend(int n, int n2) {
        Object object;
        Enumeration enumeration = this.bends.elements();
        while (enumeration.hasMoreElements()) {
            object = (Bend)enumeration.nextElement();
            if (!((Bend)object).isOver(n, n2)) continue;
            return object;
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            Bend bend;
            object = (EntityInstance)enumeration.nextElement();
            if (!((EntityInstance)object).isOpen() || (bend = ((EntityInstance)object).getMouseOverBend(n, n2)) == null) continue;
            return bend;
        }
        return null;
    }

    public RelationInstance getMouseOverEdge(int n, int n2, int n3) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance;
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Enumeration enumeration2 = entityInstance.dstRelationElements();
            while (enumeration2.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration2.nextElement();
                if (!relationInstance.isNearEdge(n, n2, 4, n3)) continue;
                return relationInstance;
            }
            enumeration2 = entityInstance.srcRelationElements();
            while (enumeration2.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration2.nextElement();
                if (!relationInstance.isNearEdge(n, n2, 4, n3)) continue;
                return relationInstance;
            }
            relationInstance = entityInstance.getMouseOverEdge(n, n2, n3);
            if (relationInstance == null) continue;
            return relationInstance;
        }
        return null;
    }

    public void getMouseOverAllEdges(int n, int n2, Vector vector) {
        RelationInstance relationInstance;
        Enumeration enumeration = this.dstRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (!relationInstance.isNearEdge(n, n2, 4, -1) || vector.contains(relationInstance)) continue;
            vector.addElement(relationInstance);
        }
        enumeration = this.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (!relationInstance.isNearEdge(n, n2, 4, -1) || vector.contains(relationInstance)) continue;
            vector.addElement(relationInstance);
        }
    }

    public EntityInstance intersects(Layout layout) {
        if (this.containsLayout(layout)) {
            if (!this.containsList.isEmpty()) {
                Enumeration enumeration = this.getChildren();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                    EntityInstance entityInstance2 = entityInstance.intersects(layout);
                    if (entityInstance2 == null) continue;
                    return entityInstance2;
                }
                return null;
            }
            return this;
        }
        if (this.intersectsLayout(layout)) {
            return this;
        }
        return null;
    }

    public EntityInstance containing(Layout layout) {
        if (this.containsLayout(layout)) {
            if (!this.containsList.isEmpty() && this.isOpen()) {
                Enumeration enumeration = this.getChildren();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                    EntityInstance entityInstance2 = entityInstance.containing(layout);
                    if (entityInstance2 == null) continue;
                    return entityInstance2;
                }
            }
            return this;
        }
        return null;
    }

    public Vector getCoverList(Layout layout) {
        Vector<EntityInstance> vector = new Vector<EntityInstance>();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Layout layout2 = entityInstance.getLayout();
            if (!(layout.x < layout2.x) || !(layout2.x + layout2.width < layout.x + this.width()) || !(layout.y < layout2.y) || !(layout2.y + layout2.height < layout.y + this.height())) continue;
            vector.addElement(entityInstance);
        }
        return vector;
    }

    public Enumeration srcRelationElements() {
        return this.srcRelList.elements();
    }

    public Enumeration dstRelationElements() {
        return this.dstRelList.elements();
    }

    protected void addSrcRels(Vector vector) {
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.addSrcRels(vector);
        }
    }

    public Enumeration srcRelationAbstractedElements() {
        Vector vector = new Vector();
        this.addSrcRels(vector);
        return vector.elements();
    }

    protected void addDstRels(Vector vector) {
        Enumeration enumeration = this.dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.addDstRels(vector);
        }
    }

    public Enumeration dstRelationAbstractedElements() {
        Vector vector = new Vector();
        this.addDstRels(vector);
        return vector.elements();
    }

    public Vector groupRegion(Layout layout) {
        if (this.containsList.isEmpty()) {
            return null;
        }
        Vector<EntityInstance> vector = new Vector<EntityInstance>();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (!entityInstance.intersectsLayout(layout)) continue;
            entityInstance.setGroupFlag();
            vector.addElement(entityInstance);
        }
        if (vector.isEmpty()) {
            return null;
        }
        return vector;
    }

    public void getGroup(Vector vector) {
        if (this.getGroupFlag()) {
            vector.addElement(this);
        }
        if (this.containsList.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.getGroup(vector);
        }
    }

    protected void setGroupFlag() {
        this.m_groupFlag = true;
    }

    protected void clearGroupFlag() {
        this.m_groupFlag = false;
    }

    public boolean getGroupFlag() {
        return this.m_groupFlag;
    }

    protected void setGroupKeyFlag() {
        this.m_groupKeyFlag = true;
    }

    protected void clearGroupKeyFlag() {
        this.m_groupKeyFlag = false;
    }

    public boolean getGroupKeyFlag() {
        return this.m_groupKeyFlag;
    }

    public void getHighlightGroup(Vector vector) {
        if (this.highlightFlag) {
            vector.addElement(this);
        }
        if (this.containsList.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.getHighlightGroup(vector);
        }
    }

    public void setHighlightFlag() {
        this.highlightFlag = true;
    }

    public boolean getHighlightFlag() {
        return this.highlightFlag;
    }

    public boolean clearHighlightFlag() {
        boolean bl = this.highlightFlag;
        if (bl) {
            this.highlightFlag = false;
        }
        return bl;
    }

    public boolean clearAllFlags() {
        LandscapeObject landscapeObject;
        this.clearGroupFlag();
        this.clearGroupKeyFlag();
        boolean bl = this.clearHighlightFlag();
        this.tmpOpen = -1;
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            bl |= ((RelationInstance)landscapeObject).clearHighlightFlag();
            ((RelationInstance)landscapeObject).clearGroupFlag();
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            bl |= ((EntityInstance)landscapeObject).clearAllFlags();
        }
        return bl;
    }

    public boolean clearHighlightFlags() {
        LandscapeObject landscapeObject;
        boolean bl = this.clearHighlightFlag();
        Enumeration enumeration = this.srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (RelationInstance)enumeration.nextElement();
            bl |= ((RelationInstance)landscapeObject).clearHighlightFlag();
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            bl |= ((EntityInstance)landscapeObject).clearHighlightFlags();
        }
        return bl;
    }

    public void clearGroupFlags() {
        this.clearGroupFlag();
        this.clearGroupKeyFlag();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearGroupFlags();
        }
    }

    public boolean isClippedLabel() {
        return !this.fullLabel;
    }

    public boolean isTransparent() {
        return false;
    }

    public boolean isCloseable() {
        return true;
    }

    public boolean isClickable() {
        return true;
    }

    public boolean isLabelDrawable() {
        return true;
    }

    public boolean isEnterable() {
        return true;
    }

    public void incDstCount() {
        ++this.dstCount;
    }

    public int getDstCount() {
        return this.dstCount;
    }

    public void setMark(int n) {
        this.mark = n;
    }

    public int getMark() {
        return this.mark;
    }

    public void clearMarks() {
        this.mark = 0;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearMarks();
        }
    }

    public static Font getSmallFont() {
        return smallFont;
    }

    public double x() {
        return this.m_x;
    }

    public double y() {
        return this.m_y;
    }

    public double width() {
        return this.m_width;
    }

    public double height() {
        return this.m_height;
    }

    protected void setX(double d) {
        this.m_x = d;
    }

    protected void setY(double d) {
        this.m_y = d;
    }

    protected void setWidth(double d) {
        this.m_width = d;
    }

    protected void setHeight(double d) {
        this.m_height = d;
    }

    boolean overlaps(EntityInstance entityInstance) {
        if (entityInstance.xLocal > this.xLocal + this.widthLocal) {
            return false;
        }
        if (this.xLocal > entityInstance.xLocal + entityInstance.widthLocal) {
            return false;
        }
        if (entityInstance.yLocal > this.yLocal + this.heightLocal) {
            return false;
        }
        return !(this.yLocal > entityInstance.yLocal + entityInstance.heightLocal);
    }

    void correctBadLayout() {
        EntityInstance entityInstance;
        boolean bl = false;
        Enumeration enumeration = this.getChildren();
        block0: while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2;
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.correctBadLayout();
            if (bl) continue;
            Enumeration enumeration2 = this.getChildren();
            while (enumeration2.hasMoreElements() && (entityInstance2 = (EntityInstance)enumeration2.nextElement()) != entityInstance) {
                if (!entityInstance2.overlaps(entityInstance)) continue;
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.setGroupFlag();
            }
            double d = this.m_x;
            double d2 = this.m_y;
            double d3 = this.m_width;
            double d4 = this.m_height;
            double d5 = this.dg.getScaleX();
            double d6 = this.dg.getScaleY();
            this.m_x = 0.0;
            this.m_y = 0.0;
            this.m_width = Double.MAX_VALUE;
            this.m_height = Double.MAX_VALUE;
            this.dg.setScaleX(1.0);
            this.dg.setScaleY(1.0);
            SugiyamaLayout sugiyamaLayout = new SugiyamaLayout();
            sugiyamaLayout.setDiagram(this.dg);
            sugiyamaLayout.doLayout();
            this.dg.setScaleX(d5);
            this.dg.setScaleY(d6);
            this.m_x = d;
            this.m_y = d2;
            this.m_width = d3;
            this.m_height = d4;
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.clearGroupFlag();
            }
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.xLocal < this.xLocal) {
                this.xLocal = entityInstance.xLocal;
            }
            if (entityInstance.yLocal < this.yLocal) {
                this.yLocal = entityInstance.yLocal;
            }
            if (entityInstance.xLocal + entityInstance.widthLocal > this.xLocal + this.widthLocal) {
                this.widthLocal = entityInstance.xLocal + entityInstance.widthLocal - this.xLocal;
            }
            if (!(entityInstance.yLocal + entityInstance.heightLocal > this.yLocal + this.heightLocal)) continue;
            this.heightLocal = entityInstance.yLocal + entityInstance.heightLocal - this.yLocal;
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            double d;
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.xLocal == this.xLocal) {
                d = this.widthLocal / 16.0;
                this.xLocal -= d;
                this.widthLocal += d;
            }
            if (entityInstance.yLocal == this.yLocal) {
                d = this.heightLocal / 16.0;
                this.yLocal -= d;
                this.heightLocal += d;
            }
            if (entityInstance.xLocal + entityInstance.widthLocal == this.xLocal + this.widthLocal) {
                this.widthLocal += this.widthLocal / 16.0;
            }
            if (entityInstance.yLocal + entityInstance.heightLocal != this.yLocal + this.heightLocal) continue;
            this.heightLocal += this.heightLocal / 16.0;
        }
    }

    public void ancilliary(Object object) {
        this.m_ancilliary = object;
    }

    public Object ancilliary() {
        return this.m_ancilliary;
    }

    public int getPrimaryAttributeCount() {
        return 12;
    }

    public String getAttributeNameAt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "id";
                break;
            }
            case 1: {
                string = LABEL_ID;
                break;
            }
            case 2: {
                string = TITLE_ID;
                break;
            }
            case 3: {
                string = DESC_ID;
                break;
            }
            case 4: {
                string = "color";
                break;
            }
            case 5: {
                string = "labelcolor";
                break;
            }
            case 6: {
                string = "opencolor";
                break;
            }
            case 7: {
                string = XPOSITION_ID;
                break;
            }
            case 8: {
                string = YPOSITION_ID;
                break;
            }
            case 9: {
                string = WIDTH_ID;
                break;
            }
            case 10: {
                string = HEIGHT_ID;
                break;
            }
            case 11: {
                string = FONTDELTA_ID;
                break;
            }
            default: {
                string = super.getAttributeNameAt(n);
            }
        }
        return string;
    }

    public Object getAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
            }
            case 1: {
                object = this.label;
                break;
            }
            case 2: {
                object = this.title;
                break;
            }
            case 3: {
                object = this.description;
                break;
            }
            case 4: {
                object = this.getObjectColor();
                break;
            }
            case 5: {
                object = this.getLabelColor();
                break;
            }
            case 6: {
                object = this.getObjectColorWhenOpen();
                break;
            }
            case 7: {
                object = new Double(this.xLocal);
                break;
            }
            case 8: {
                object = new Double(this.yLocal);
                break;
            }
            case 9: {
                object = new Double(this.widthLocal);
                break;
            }
            case 10: {
                object = new Double(this.heightLocal);
                break;
            }
            case 11: {
                object = new Integer(this.fontDelta);
                break;
            }
            default: {
                object = super.getAttributeValueAt(n);
            }
        }
        return object;
    }

    public void setAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.label = (String)object;
                break;
            }
            case 2: {
                this.title = (String)object;
                break;
            }
            case 3: {
                this.description = (String)object;
                break;
            }
            case 4: {
                this.setObjectColor((Color)object);
                break;
            }
            case 5: {
                this.setLabelColor((Color)object);
                break;
            }
            case 6: {
                this.setObjectColorWhenOpen((Color)object);
                break;
            }
            case 7: {
                this.xLocal = (Double)object;
                break;
            }
            case 8: {
                this.yLocal = (Double)object;
                break;
            }
            case 9: {
                this.widthLocal = (Double)object;
                break;
            }
            case 10: {
                this.heightLocal = (Double)object;
                break;
            }
            case 11: {
                this.fontDelta = (Integer)object;
                break;
            }
            default: {
                super.setAttributeValueAt(n, object);
            }
        }
    }

    public int getAttributeTypeAt(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 12;
                break;
            }
            case 4: 
            case 5: {
                n2 = 7;
                break;
            }
            case 6: {
                n2 = 8;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
            case 11: {
                n2 = 1;
                break;
            }
            default: {
                n2 = super.getAttributeTypeAt(n);
            }
        }
        return n2;
    }
}

