/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.Diagram;
import lsedit.LandscapeViewerCore;
import lsedit.MyComponent;
import lsedit.Util;

public class Feedback
extends MyComponent {
    protected static final Font feedbackFont = new Font("Helvetica", 0, 11);
    protected static final int GAP = 5;
    protected String feedbackStr = null;
    protected LandscapeViewerCore ls;

    protected void drawFeedback(Graphics graphics, Rectangle rectangle) {
        if (this.feedbackStr != null) {
            graphics.setColor(Color.black);
            graphics.setFont(feedbackFont);
            Util.drawStringClipped(graphics, this.feedbackStr, 5.0, 2.0, rectangle.width - 10, rectangle.height);
        }
    }

    public Feedback(LandscapeViewerCore landscapeViewerCore) {
        this.ls = landscapeViewerCore;
        this.setBackground(Diagram.boxColour);
        this.setFont(feedbackFont);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        Util.drawFrame(graphics, rectangle);
        if (this.feedbackStr != null) {
            this.drawFeedback(graphics, rectangle);
        }
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.paint(graphics2);
        graphics2.dispose();
    }

    public void repaint() {
        if (this.isVisible()) {
            Graphics graphics = this.ls.getGraphics();
            this.draw(graphics);
            graphics.dispose();
        }
    }

    public void set(String string) {
        this.feedbackStr = string;
        this.repaint();
    }

    public String get() {
        return this.feedbackStr;
    }
}

