/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Vertex;

class Graph {
    private Vector vertices;
    private int[] labelled;
    private int curLabel = 1;
    private int size = 0;
    private double maxRowWidth;
    private double maxTotalHeight;
    private int numLayers;
    private boolean debugMode;

    public Graph(int n, double d, double d2, boolean bl) {
        this.maxTotalHeight = d2;
        this.maxRowWidth = d;
        this.vertices = new Vector();
        this.labelled = new int[n];
        for (int i = 0; i < n; ++i) {
            this.labelled[i] = 0;
        }
        this.debugMode = bl;
    }

    public void addVertex(double d) {
        this.vertices.addElement(new Vertex(d));
        ++this.size;
    }

    public Vertex getVertex(int n) {
        return (Vertex)this.vertices.elementAt(n);
    }

    public void addEdge(int n, int n2) {
        this.getVertex(n).addChild(new Integer(n2));
        this.getVertex(n2).addParent(new Integer(n));
    }

    public void print() {
        int n = 0;
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            System.out.print(n + "  ");
            ++n;
            ((Vertex)enumeration.nextElement()).print();
        }
    }

    private void DeleteInEdges(int n) {
        Vector vector = this.getVertex(n).getParents();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.getVertex((Integer)enumeration.nextElement()).decOutDegree();
        }
    }

    private void DeleteOutEdges(int n, Vector vector) {
        Vector vector2 = this.getVertex(n).getChildren();
        Integer n2 = null;
        Vector<Integer> vector3 = new Vector<Integer>();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            n2 = (Integer)enumeration.nextElement();
            this.getVertex(n2).decInDegree();
            int n3 = vector.indexOf(n2);
            if (n3 == -1) continue;
            if (this.debugMode) {
                System.out.println("Reverse " + n + "->" + n2);
            }
            this.getVertex(n2).removeParent(new Integer(n));
            this.getVertex(n2).addChild(new Integer(n));
            vector3.addElement(n2);
            this.getVertex(n).addParent(n2);
        }
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            this.getVertex(n).removeChild((Integer)enumeration.nextElement());
        }
    }

    private int FindSink(int n, Vector vector) {
        int n2;
        block0: do {
            for (n2 = 0; n2 < this.size; ++n2) {
                if (this.getVertex(n2).getOutDegree() != 0 || this.getVertex(n2).isVisited()) continue;
                this.getVertex(n2).setVisited();
                --n;
                this.DeleteOutEdges(n2, vector);
                this.DeleteInEdges(n2);
                continue block0;
            }
        } while (n2 < this.size && n > 0);
        return n;
    }

    private int FindSource(int n, Vector vector) {
        int n2;
        block0: do {
            for (n2 = 0; n2 < this.size; ++n2) {
                if (this.getVertex(n2).getInDegree() != 0 || this.getVertex(n2).isVisited()) continue;
                this.getVertex(n2).setVisited();
                --n;
                this.DeleteOutEdges(n2, vector);
                this.DeleteInEdges(n2);
                continue block0;
            }
        } while (n2 < this.size && n > 0);
        return n;
    }

    private int FindNext(int n, Vector vector) {
        int n2 = 0;
        int n3 = -1000;
        int n4 = this.size;
        for (int i = 0; i < this.size; ++i) {
            if (this.getVertex(i).isVisited() || (n2 = this.getVertex(i).getOutDegree() - this.getVertex(i).getInDegree()) <= n3) continue;
            n3 = n2;
            n4 = i;
        }
        this.getVertex(n4).setVisited();
        this.DeleteOutEdges(n4, vector);
        this.DeleteInEdges(n4);
        vector.addElement(new Integer(n4));
        return --n;
    }

    private void RemoveCycles() {
        Vector vector = new Vector();
        int n = this.size;
        while ((n = this.FindSink(n, vector)) != 0 && (n = this.FindSource(n, vector)) != 0 && (n = this.FindNext(n, vector)) > 0) {
        }
    }

    private Vector getLabels(Vector vector) {
        Vector<Integer> vector2 = new Vector<Integer>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n = this.labelled[(Integer)enumeration.nextElement()];
            if (n == 0) {
                return null;
            }
            vector2.addElement(new Integer(n));
        }
        return vector2;
    }

    private Integer maxValue(Vector vector) {
        Integer n = (Integer)vector.firstElement();
        for (int i = 1; i < vector.size(); ++i) {
            if ((Integer)vector.elementAt(i) <= n) continue;
            n = (Integer)vector.elementAt(i);
        }
        return n;
    }

    private boolean lessThan(Vector vector, Vector vector2) {
        if (vector.isEmpty() && !vector2.isEmpty()) {
            return true;
        }
        if (!vector.isEmpty() && !vector2.isEmpty()) {
            Integer n = this.maxValue(vector);
            Integer n2 = this.maxValue(vector2);
            if (n < n2) {
                return true;
            }
            if (n == n2) {
                Vector vector3 = (Vector)vector.clone();
                vector3.removeElement(n);
                Vector vector4 = (Vector)vector2.clone();
                vector4.removeElement(n2);
                return this.lessThan(vector3, vector4);
            }
        }
        return false;
    }

    private void AssignLabel() {
        for (int i = 0; i < this.size; ++i) {
            int n = 0;
            Vector vector = new Vector();
            vector.addElement(new Integer(this.size));
            for (int j = 0; j < this.size; ++j) {
                Vector vector2;
                if (this.labelled[j] != 0 || (vector2 = this.getLabels(this.getVertex(j).getParents())) == null || !this.lessThan(vector2, vector)) continue;
                vector = vector2;
                n = j;
            }
            ++this.curLabel;
        }
    }

    private boolean childrenPlaced(int n) {
        Vector vector = this.getVertex(n).getChildren();
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (this.labelled[(Integer)enumeration.nextElement()] == -1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void AddDummies(int n, int n2, Vector vector) {
        Vector vector2 = this.getVertex(n).getChildren();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            int n4 = this.getVertex(n3).getLayer();
            if (n2 - n4 <= 1) continue;
            int n5 = this.vertices.size();
            int n6 = n3;
            this.getVertex(n6).replaceParent(new Integer(n), new Integer(n5));
            for (int i = n4 + 1; i < n2 - 1; ++i) {
                this.vertices.addElement(new Vertex(0.0));
                ((Vector)vector.elementAt(i)).addElement(new Integer(this.size));
                ++this.size;
                this.getVertex(n5).setDummy();
                this.getVertex(n5).setLayer(i);
                this.getVertex(n5).addChild(new Integer(n6));
                this.getVertex(n5).addParent(new Integer(n5 + 1));
                n6 = n5++;
            }
            this.vertices.addElement(new Vertex(0.0));
            ((Vector)vector.elementAt(n2 - 1)).addElement(new Integer(this.size));
            ++this.size;
            this.getVertex(n5).setDummy();
            this.getVertex(n5).setLayer(n2 - 1);
            this.getVertex(n5).addChild(new Integer(n6));
            this.getVertex(n5).addParent(new Integer(n));
            this.getVertex(n).replaceChild(n3, new Integer(n5));
        }
    }

    public Vector doCoffmanGrahamSugiyama() {
        this.RemoveCycles();
        if (this.debugMode) {
            System.out.println("finish removeCycle");
        }
        this.AssignLabel();
        if (this.debugMode) {
            System.out.println("finish assignLabel");
        }
        int n = 0;
        Vector<Integer> vector = new Vector<Integer>();
        double d = 0.0;
        Vector vector2 = new Vector();
        vector2.addElement(new Vector());
        int n2 = this.size;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = n2;
            for (int i = 0; i < n2; ++i) {
                if (this.labelled[i] <= n4 || !this.childrenPlaced(i)) continue;
                n4 = this.labelled[i];
                n5 = i;
            }
            if (n5 < n2) {
                d2 = d + this.getVertex(n5).getWidth();
            }
            if (n5 < n2 && d2 < this.maxRowWidth) {
                this.getVertex(n5).setLayer(n);
                vector.addElement(new Integer(n5));
                ((Vector)vector2.lastElement()).addElement(new Integer(n5));
                this.AddDummies(n5, n, vector2);
                this.labelled[n5] = 0;
                ++n3;
                d = d2;
            }
            if (n5 < n2 && !(d2 >= this.maxRowWidth)) continue;
            ++n;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.labelled[((Integer)enumeration.nextElement()).intValue()] = -1;
            }
            vector2.addElement(new Vector());
            d = 0.0;
        }
        this.numLayers = n;
        this.Sugiyama(vector2);
        if (this.debugMode) {
            System.out.println("Finish Sugiyama");
        }
        return vector2;
    }

    private void Sort(float[] fArray, Vector vector) {
        int n = 0;
        Integer n2 = null;
        for (int i = 1; i < vector.size(); ++i) {
            float f = fArray[i];
            n2 = (Integer)vector.elementAt(i);
            for (n = 0; n < i && !(fArray[i] < fArray[n]); ++n) {
            }
            for (int j = i; j > n; --j) {
                fArray[j] = fArray[j - 1];
            }
            vector.removeElementAt(i);
            vector.insertElementAt(n2, n);
            fArray[n] = f;
        }
    }

    public void BarycentreSort(Vector vector, Vector vector2, Vector vector3) {
        float[] fArray = new float[vector2.size()];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            n = 0;
            n2 = 0;
            Enumeration enumeration = ((Vector)vector3.elementAt(i)).elements();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                int n4 = vector.indexOf(n3);
                if (n4 == -1) {
                    System.exit(-1);
                    continue;
                }
                n += 1 + n4;
                ++n2;
            }
            fArray[i] = n2 == 0 ? 0.0f : (float)n / (float)n2;
        }
        this.Sort(fArray, vector2);
    }

    private void Sugiyama(Vector vector) {
        for (int i = vector.size() - 2; i >= 0; --i) {
            Vector<Vector> vector2 = new Vector<Vector>();
            Enumeration enumeration = ((Vector)vector.elementAt(i)).elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                vector2.addElement(this.getVertex(n).getParents());
            }
            this.BarycentreSort((Vector)vector.elementAt(i + 1), (Vector)vector.elementAt(i), vector2);
        }
    }
}

