/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Event;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.Layout;
import lsedit.ScreenLayout;
import lsedit.Util;

public class GroupModeHandler
extends LandscapeModeHandler {
    protected static final int NONE = 0;
    protected static final int GROUPING = 1;
    protected static final int GROUP_MOVE = 2;
    protected Layout curLayout;
    protected int curX;
    protected int curY;
    protected Vector groupList = null;
    protected Layout grpLayout;
    protected int groupMode = 0;
    protected double m_dx;
    protected double m_dy;
    protected LandscapeModeHandler parent = null;
    private boolean seen_motion;
    protected static final boolean allowOverlap = true;

    protected void drawBox(Layout layout) {
        ScreenLayout screenLayout = new ScreenLayout(layout);
        this.gc.drawRect(screenLayout.x, screenLayout.y, screenLayout.width, screenLayout.height);
    }

    protected void drawGroup(Graphics graphics, Layout layout) {
        double d = layout.x - this.grpLayout.x;
        double d2 = layout.y - this.grpLayout.y;
        Enumeration enumeration = this.groupList.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Layout layout2 = entityInstance.getLayout();
            layout2.x += d;
            layout2.y += d2;
            this.dg.drawEntityOutline(graphics, layout2, entityInstance);
        }
    }

    protected EntityInstance findOverlap(Layout layout) {
        double d = layout.x - this.grpLayout.x;
        double d2 = layout.y - this.grpLayout.y;
        EntityInstance entityInstance = this.dg.getKeyEntity();
        Layout layout2 = entityInstance.getLayout();
        layout2.x += d;
        layout2.y += d2;
        EntityInstance entityInstance2 = this.dg.intersects(layout);
        if (entityInstance2 != null && !this.groupList.contains(entityInstance2)) {
            return entityInstance2;
        }
        Enumeration enumeration = this.groupList.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            layout2 = entityInstance.getLayout();
            layout2.x += d;
            layout2.y += d2;
            entityInstance2 = this.dg.intersects(layout);
            if (entityInstance2 == null || this.groupList.contains(entityInstance2)) continue;
            return entityInstance2;
        }
        return null;
    }

    protected void moveGroup(EntityInstance entityInstance, double d, double d2) {
        Enumeration enumeration;
        EntityInstance entityInstance2 = (EntityInstance)this.groupList.firstElement();
        this.dg.saveForUndo();
        boolean bl = entityInstance2.getParent() != entityInstance;
        double d3 = 0.0;
        double d4 = 0.0;
        if (bl) {
            Layout layout;
            int n = entityInstance.numChildren();
            if (n == 0) {
                layout = entityInstance2.getParent().getLayout();
                Layout layout2 = entityInstance.getLayout();
                double d5 = layout2.width / layout.width;
                double d6 = layout2.height / layout.height;
                Layout layout3 = entityInstance2.getLayout();
                d3 = layout3.width * d5;
                d4 = layout3.height * d6;
            } else {
                enumeration = entityInstance.getChildren();
                while (enumeration.hasMoreElements()) {
                    entityInstance2 = (EntityInstance)enumeration.nextElement();
                    layout = entityInstance2.getLayout();
                    d3 += layout.width;
                    d4 += layout.height;
                }
                d3 /= (double)n;
                d4 /= (double)n;
                enumeration = this.groupList.elements();
            }
        }
        enumeration = this.groupList.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            Layout layout = entityInstance2.getLayout();
            layout.x += d;
            layout.y += d2;
            if (bl) {
                layout.width = d3;
                layout.height = d4;
            }
            entityInstance2.moveEntityContainment(entityInstance);
            entityInstance2.setLayout(layout);
        }
    }

    protected void moveGroup(EntityInstance entityInstance, Layout layout) {
        double d = layout.x - this.grpLayout.x;
        double d2 = layout.y - this.grpLayout.y;
        this.moveGroup(entityInstance, d, d2);
    }

    protected void setAsKeyEntity(EntityInstance entityInstance) {
        this.dg.setKeyEntity(entityInstance);
    }

    protected void selectEntity(EntityInstance entityInstance) {
        if (entityInstance.getGroupFlag()) {
            if (entityInstance != this.dg.getKeyEntity()) {
                this.setAsKeyEntity(entityInstance);
            }
        } else {
            EntityInstance entityInstance2 = this.dg.getKeyEntity();
            if (entityInstance2 != null) {
                boolean bl = this.dg.clearFlags();
                this.dg.setKeyEntity(entityInstance);
                if (bl) {
                    this.ls.repaintDg();
                }
            } else {
                this.setAsKeyEntity(entityInstance);
            }
        }
        this.showGroupList(false);
    }

    protected void toggleMembership(EntityInstance entityInstance) {
        if (entityInstance.getGroupFlag()) {
            if (entityInstance == this.dg.getKeyEntity()) {
                Vector vector = this.dg.getGroup();
                if (vector.size() == 1) {
                    this.dg.clearFlags();
                    this.ls.repaintEntity(entityInstance);
                } else {
                    entityInstance.clearGroupFlag();
                    vector = this.dg.getGroup();
                    EntityInstance entityInstance2 = (EntityInstance)vector.firstElement();
                    this.setAsKeyEntity(entityInstance2);
                }
            } else {
                entityInstance.clearGroupFlag();
                this.ls.repaintEntity(entityInstance);
            }
        } else {
            EntityInstance entityInstance3;
            Vector vector = this.dg.getGroup();
            if (vector != null && (entityInstance3 = (EntityInstance)vector.firstElement()).getParent() != entityInstance.getParent()) {
                this.selectEntity(entityInstance);
                return;
            }
            this.setAsKeyEntity(entityInstance);
        }
        this.showGroupList(false);
    }

    protected boolean groupingStart(Event event, int n, int n2) {
        this.gc.setXORMode(this.e.getBackground());
        this.curX = n;
        this.curY = n2;
        this.curLayout = null;
        return true;
    }

    protected void groupingMotion(Event event, int n, int n2) {
        if (this.curLayout == null) {
            this.curLayout = new Layout(0.0, 0.0, 0.0, 0.0);
        } else {
            this.drawBox(this.curLayout);
        }
        double d = n;
        double d2 = n2;
        Layout layout = this.e.getLayout();
        if (d < layout.x + 4.0) {
            d = layout.x + 4.0;
        } else if (d > layout.x + layout.width - 4.0) {
            d = layout.x + layout.width - 4.0;
        }
        if (d2 < layout.y + 4.0) {
            d2 = layout.y + 4.0;
        } else if (d2 > layout.y + layout.height - 4.0) {
            d2 = layout.y + layout.height - 4.0;
        }
        if (d > (double)this.curX) {
            this.curLayout.x = this.curX;
            this.curLayout.width = d - (double)this.curX;
        } else {
            this.curLayout.x = d;
            this.curLayout.width = (double)this.curX - d;
        }
        if (d2 > (double)this.curY) {
            this.curLayout.y = this.curY;
            this.curLayout.height = n2 - this.curY;
        } else {
            this.curLayout.y = n2;
            this.curLayout.height = this.curY - n2;
        }
        this.drawBox(this.curLayout);
    }

    protected void groupingEnd(Event event, int n, int n2) {
        Vector vector = this.dg.setGroupRegion(this.curLayout);
        if (vector != null) {
            this.showGroupList(false);
            this.dg.setKeyEntity((EntityInstance)vector.firstElement());
        } else {
            this.drawBox(this.curLayout);
        }
    }

    protected boolean moveGroupStart(Event event, int n, int n2) {
        this.groupList = this.dg.getGroup();
        this.seen_motion = false;
        if (this.groupList == null) {
            return false;
        }
        EntityInstance entityInstance = ((EntityInstance)this.groupList.firstElement()).getParent();
        if (entityInstance == null) {
            return false;
        }
        this.grpLayout = this.dg.getGroupBoundingBox();
        this.curLayout = (Layout)this.grpLayout.clone();
        this.m_dx = (double)n - this.curLayout.x;
        this.m_dy = (double)n2 - this.curLayout.y;
        if (this.groupList.size() == 1) {
            this.ls.doFeedback("Moving entity: (" + Math.round(this.curLayout.x) + ", " + Math.round(this.curLayout.y) + ")");
        } else {
            this.ls.doFeedback("Moving group (key): (" + Math.round(this.curLayout.x) + ", " + Math.round(this.curLayout.y) + ")");
        }
        return true;
    }

    protected void moveGroupMotion(Event event, int n, int n2) {
        Object object;
        if (!this.seen_motion) {
            object = ((EntityInstance)this.groupList.firstElement()).getParent();
            this.gc.setXORMode(((EntityInstance)object).getBackground());
            this.drawGroup(this.gc, this.curLayout);
            this.seen_motion = true;
        }
        object = this.dg.getRoot().getLayout();
        int n3 = this.dg.getGrid();
        double d = Math.round((double)n - this.m_dx) / (long)n3 * (long)n3;
        double d2 = Math.round((double)n2 - this.m_dy) / (long)n3 * (long)n3;
        if (d < ((Layout)object).x + 4.0) {
            d = ((Layout)object).x + 4.0;
        }
        if (d2 < ((Layout)object).y + 4.0) {
            d2 = ((Layout)object).y + 4.0;
        }
        if (d + this.curLayout.width > ((Layout)object).x + ((Layout)object).width - 4.0) {
            d = ((Layout)object).x + ((Layout)object).width - this.curLayout.width - 4.0;
        }
        if (d2 + this.curLayout.height > ((Layout)object).y + ((Layout)object).height - 4.0) {
            d2 = ((Layout)object).y + ((Layout)object).height - this.curLayout.height - 4.0;
        }
        this.drawGroup(this.gc, this.curLayout);
        this.curLayout.x = d;
        this.curLayout.y = d2;
        this.drawGroup(this.gc, this.curLayout);
        if (this.groupList.size() == 1) {
            this.ls.doFeedback("Moving entity: (" + Math.round(d) + ", " + Math.round(d2) + ")");
        } else {
            this.ls.doFeedback("Moving group (key): (" + Math.round(d) + ", " + Math.round(d2) + ")");
        }
    }

    protected void moveGroupEnd(Event event, int n, int n2) {
        this.ls.clearFeedback();
        if (!this.seen_motion) {
            return;
        }
        EntityInstance entityInstance = this.dg.getKeyEntity();
        double d = this.curLayout.x - this.grpLayout.x;
        double d2 = this.curLayout.y - this.grpLayout.y;
        Layout layout = entityInstance.getLayout();
        layout.x += d;
        layout.y += d2;
        EntityInstance entityInstance2 = this.dg.containing(layout);
        if (entityInstance2 == null) {
            this.ls.error("Failed to find container");
            this.ls.redrawDg();
            return;
        }
        if (this.groupList.contains(entityInstance2)) {
            entityInstance2 = entityInstance2.getParent();
        }
        boolean bl = entityInstance2 != entityInstance.getParent();
        this.dg.saveForUndo();
        this.moveGroup(entityInstance2, this.curLayout);
        if (bl) {
            this.dg.setContainElision(entityInstance2, true);
            this.ls.doFeedback("Group move into: " + entityInstance2.getLabel());
        }
        this.curLayout = null;
        this.ls.redrawDg();
    }

    public GroupModeHandler(LandscapeModeHandler landscapeModeHandler) {
        this.parent = landscapeModeHandler;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        boolean bl = (event.modifiers & 8) != 0;
        boolean bl2 = (event.modifiers & 4) != 0;
        boolean bl3 = (event.modifiers & 1) != 0;
        this.e = this.dg.mouseOverEx(n, n2);
        if (this.e == null) {
            return false;
        }
        if (bl3) {
            if (bl) {
                this.groupMode = 1;
                return this.groupingStart(event, n, n2);
            }
            if (bl2) {
                if (this.e != this.dg.getRoot()) {
                    this.setAsKeyEntity(this.e);
                }
            } else if (this.e != this.dg.getRoot()) {
                this.toggleMembership(this.e);
            }
        } else {
            if (this.e != this.dg.getRoot() && !this.dg.isClientOrSupplier(this.e)) {
                this.selectEntity(this.e);
                this.ls.setCursor(13);
                this.groupMode = 2;
                return this.moveGroupStart(event, n, n2);
            }
            this.selectEntity(this.e);
            this.groupMode = 0;
            return true;
        }
        this.groupMode = 0;
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        switch (this.groupMode) {
            case 1: {
                this.groupingMotion(event, n, n2);
                break;
            }
            case 2: {
                this.moveGroupMotion(event, n, n2);
            }
        }
        return true;
    }

    public void mouseUp(Event event, int n, int n2) {
        switch (this.groupMode) {
            case 1: {
                this.groupingEnd(event, n, n2);
                break;
            }
            case 2: {
                this.moveGroupEnd(event, n, n2);
                break;
            }
            default: {
                return;
            }
        }
        this.ls.setCursor(0);
        this.groupMode = 0;
    }

    public void halt() {
        this.groupMode = 0;
    }

    public void showGroupList(boolean bl) {
        Vector vector = this.dg.getGroup();
        if (vector != null) {
            Util.sortVector(vector);
            this.ls.showList("GROUP:", vector, bl);
        } else {
            this.ls.error("No entities selected");
        }
    }

    public void groupAll() {
        Object object;
        EntityInstance entityInstance;
        EntityInstance entityInstance2 = entityInstance = this.dg.getKeyEntity();
        if (entityInstance == null) {
            entityInstance2 = entityInstance = this.dg.getRoot();
        }
        boolean bl = this.dg.clearFlags();
        if (!entityInstance2.isOpen()) {
            entityInstance2 = entityInstance2.getParent();
        }
        Enumeration enumeration = entityInstance2.getChildren();
        while (enumeration.hasMoreElements()) {
            object = (EntityInstance)enumeration.nextElement();
            ((EntityInstance)object).setGroupFlag();
        }
        object = this.dg.getGroup();
        if (object != null) {
            if (!((Vector)object).contains(entityInstance)) {
                entityInstance = (EntityInstance)((Vector)object).firstElement();
            }
            this.dg.setKeyEntity(entityInstance);
            if (bl) {
                this.ls.redrawDg();
            }
            this.showGroupList(false);
        } else {
            this.ls.error("No entities selected");
        }
    }

    public void moveGroup(int n) {
        this.groupList = this.dg.getGroup();
        if (this.groupList == null) {
            return;
        }
        EntityInstance entityInstance = this.dg.getKeyEntity().getParent();
        double d = 0.0;
        double d2 = 0.0;
        switch (n) {
            case 1004: {
                d = 0.0;
                d2 = -1.0;
                break;
            }
            case 1005: {
                d = 0.0;
                d2 = 1.0;
                break;
            }
            case 1007: {
                d = 1.0;
                d2 = 0.0;
                break;
            }
            case 1006: {
                d = -1.0;
                d2 = 0.0;
            }
        }
        this.moveGroup(entityInstance, d, d2);
    }
}

