/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.StringLinizer;
import lsedit.Util;

public class HelpBox
extends Canvas {
    protected static final int GAP = 5;
    protected static final int HELP_WIDTH = 250;
    protected static final Color BACKGROUND_COLOUR = new Color(1.0f, 1.0f, 0.85f);
    protected static final Font textFont = new Font("Helvetica", 0, 11);
    protected String text;
    protected boolean horizFit = false;

    protected void drawText(Graphics graphics, Rectangle rectangle) {
        int n = 5;
        int n2 = 5;
        String string = this.text;
        graphics.setColor(Color.black);
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = Util.fontHeight(textFont) - 2;
        n2 += n3;
        StringLinizer stringLinizer = new StringLinizer(string, fontMetrics, rectangle.width - 10);
        while (stringLinizer.hasMoreLines()) {
            String string2 = stringLinizer.nextLine();
            graphics.drawString(string2, n, n2);
            n2 += n3 + 2;
        }
    }

    protected int countLines(Graphics graphics, int n) {
        int n2 = 5;
        int n3 = 5;
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.text;
        StringLinizer stringLinizer = new StringLinizer(string, fontMetrics, n);
        int n4 = 0;
        while (stringLinizer.hasMoreLines()) {
            String string2 = stringLinizer.nextLine();
            ++n4;
        }
        return n4;
    }

    protected void setSize(Graphics graphics) {
        if (this.text != null) {
            graphics.setFont(textFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = this.horizFit ? fontMetrics.stringWidth(this.text) + 10 : 250;
            int n2 = Util.fontHeight(textFont);
            int n3 = this.countLines(graphics, n - 10);
            this.resize(n, n2 * n3 + 10);
        }
    }

    public HelpBox() {
        this.setBackground(BACKGROUND_COLOUR);
        this.resize(250, 5);
        this.hide();
    }

    public void paint(Graphics graphics) {
        this.setSize(graphics);
        Rectangle rectangle = this.bounds();
        graphics.clearRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        if (this.text != null) {
            this.drawText(graphics, rectangle);
        }
    }

    public void set(String string, boolean bl) {
        this.text = string;
        this.repaint();
        this.horizFit = bl;
    }

    public void set(String string) {
        this.set(string, false);
    }
}

