/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.LandscapeObject;
import lsedit.Util;

public abstract class LandscapeClassObject
extends LandscapeObject {
    protected Vector inherits = new Vector();
    protected static final String CLASSLABEL_ID = "class_label";
    protected static final String CLASSSTYLE_ID = "class_style";
    protected static final String CLASSDESC_ID = "class_description";

    protected void makeInstanceOfUs(LandscapeObject landscapeObject) {
        Object object;
        Enumeration enumeration = this.getParentElements();
        while (enumeration.hasMoreElements()) {
            object = (LandscapeClassObject)enumeration.nextElement();
            if (object == null) {
                System.out.println("Internal error: Null inheritance");
                break;
            }
            ((LandscapeClassObject)object).makeInstanceOfUs(landscapeObject);
        }
        enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            object = (Attribute)enumeration.nextElement();
            if (((Attribute)object).id.startsWith("class")) continue;
            landscapeObject.addAttribute((Attribute)object);
        }
    }

    protected String addParentClass(LandscapeClassObject landscapeClassObject, String string) {
        if (landscapeClassObject == null) {
            return "Can't inherit from null class";
        }
        if (!this.inherits.contains(landscapeClassObject)) {
            this.inherits.addElement(landscapeClassObject);
            return null;
        }
        return "Already inherits from " + landscapeClassObject.id;
    }

    protected void saveForUndo(LandscapeClassObject landscapeClassObject) {
        landscapeClassObject.setNid(this.getNid());
        super.saveForUndo(landscapeClassObject);
    }

    protected void undo(LandscapeClassObject landscapeClassObject) {
        this.setNid(landscapeClassObject.getNid());
        super.undo(landscapeClassObject);
    }

    protected boolean processClassAttributes(Attribute attribute) {
        if (attribute.id.startsWith("class_")) {
            if (attribute.avi != null) {
                if (attribute.id.equals(CLASSLABEL_ID)) {
                    this.label = attribute.avi.value;
                } else if (attribute.id.equals(CLASSSTYLE_ID)) {
                    this.style = Util.parseInt(attribute.avi.value);
                } else if (attribute.id.equals(CLASSDESC_ID)) {
                    this.description = attribute.avi.value;
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void addAttribute(Attribute attribute) {
        if (this.processClassAttributes(attribute)) {
            return;
        }
        if (this.processFirstOrder(attribute)) {
            return;
        }
        Attribute attribute2 = (Attribute)this.attributes.get(attribute.id);
        if (attribute2 == null) {
            this.attributes.put(attribute.id, attribute);
            attribute.cloneOnAssign = true;
        } else if (attribute.avi != null) {
            attribute2.avi = attribute.avi;
        }
    }

    public boolean addRawAttribute(String string, int n) {
        if (string.equals(CLASSSTYLE_ID)) {
            this.style = n;
            return true;
        }
        return super.addRawAttribute(string, n);
    }

    public boolean addRawAttribute(String string, double d) {
        return false;
    }

    public boolean addRawAttribute(String string, String string2) {
        if (string.equals(CLASSLABEL_ID)) {
            this.label = string2;
            return true;
        }
        if (string.equals(CLASSDESC_ID)) {
            this.description = string2;
            return true;
        }
        return false;
    }

    public Attribute getAttribute(String string) {
        Attribute attribute = (Attribute)this.attributes.get(string);
        if (attribute != null) {
            return attribute;
        }
        Enumeration enumeration = this.getParentElements();
        while (enumeration.hasMoreElements()) {
            LandscapeClassObject landscapeClassObject = (LandscapeClassObject)enumeration.nextElement();
            attribute = landscapeClassObject.getAttribute(string);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        super.writeAttributes(printStream, true);
        if (!this.id.equals(this.label)) {
            printStream.print("\t class_label = " + this.qt(this.label) + "\n");
        }
        printStream.print("\t class_style = " + this.style + "\n");
        if (this.description != null) {
            printStream.print("\t class_description = \"" + this.description + "\"\n");
        }
    }

    public void getAttributesRaw(Vector vector, Hashtable hashtable) {
        Vector vector2 = new Vector();
        super.getAttributesRaw(vector2, hashtable, true);
        if (!this.id.equals(this.label)) {
            this.regRawAttribute(vector2, hashtable, CLASSLABEL_ID, this.label);
        }
        this.regRawAttribute(vector2, hashtable, CLASSSTYLE_ID, this.style);
        if (this.description != null) {
            this.regRawAttribute(vector2, hashtable, CLASSDESC_ID, this.description);
        }
        Object[] objectArray = new Object[]{hashtable.get(this.id), vector2};
        vector.addElement(objectArray);
    }

    public void setColor(Color color) {
        Attribute attribute = this.getAttribute("color");
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        attribute.avi.value = "" + d;
        attribute.avi.next.value = "" + d2;
        attribute.avi.next.next.value = "" + d3;
    }

    public boolean inheritsFrom(LandscapeClassObject landscapeClassObject) {
        return this.inherits.contains(landscapeClassObject);
    }

    public Enumeration getParentElements() {
        return this.inherits.elements();
    }
}

