/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.CheckboxMenuItem;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Rectangle;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeEditorFrame;
import lsedit.MsgOut;
import lsedit.OkNoCanBox;

public class LandscapeEditorApp
extends LandscapeEditorCore {
    protected static final String QUIT_LABEL = "Quit";
    protected Menu optionMenu;
    protected static int openFrames = 1;
    protected static String[] fileMenuEntries = new String[]{"Open landscape (^O)", "Save landscape (^S)", "Save landscape (raw)", "Save landscape as", "-", "Save LS as .eps file", "-", "Close editor (^W)", "Quit"};
    protected static int[] fileMenuKeys = new int[]{15, 19, 19996, 19997, 0, 19993, 0, 23, 0};
    protected static String[] editMenuEntries = new String[]{"Undo (^Z)", "Refresh (^R)", "-", "Cut group (^X)", "Paste group (^V)", "-", "Grid decrease (g)", "Grid increase (G)", "-", "Clear current query/group (ESC)", "Find entities (^F)"};
    protected static int[] editMenuKeys = new int[]{26, 18, 0, 24, 22, 0, 103, 71, 0, 27, 6, 0};
    protected static String[] optionMenuEntries = new String[]{"Viewer mode on/off (V)", "-", "Inflection point edge", "Top/Bottom edge", "Direct edge", "-", "Clients at top", "-", "Show clients", "Show suppliers", "Show edge cardinals", "-", "Show descriptions", "Show feedback", "Show right box", "Show animation"};
    protected static int[] optionMenuKeys = new int[]{86, 0, 1120, 1121, 1122, 0, 1107, 0, 1104, 1105, 1106, 0, 1100, 1101, 1102, 1108};
    protected static boolean[] optionMenuStates = new boolean[]{false, false, true, false, false, false, true, false, true, true, false, false, true, true, true, false};
    protected static String[] arrangeMenuEntries = new String[]{"Align (top/horiz.)", "Align (center/horiz.)", "Align (left/vertical)", "Align (right/vertical)", "Align (center/vertical)", "-", "Same size", "Same width", "Same height", "-", "Equal spacing (horiz.)", "Equal spacing (vertical)", "Fit to label", "-", "Fit children to parent", "Put group in container"};
    protected static int[] arrangeMenuKeys = new int[]{10000, 10001, 10002, 10003, 10004, 0, 10022, 10020, 10021, 0, 10030, 10031, 10014, 0, 10010, 10013, 0};
    protected static String[] helpMenuEntries = new String[]{"About Landscape Editor", "-", "Show legend (l)"};
    protected static int[] helpMenuKeys = new int[]{19999, 0, 108};

    protected Dimension getViewDimensions() {
        Rectangle rectangle = this.af.bounds();
        Rectangle rectangle2 = this.bounds();
        return new Dimension(rectangle.width - 8, rectangle.height - 12 - rectangle2.y);
    }

    protected void genMenuButtons() {
    }

    protected void genGUI() {
        MsgOut.dprintln("App: gen GUI");
        this.genModeHandlers();
        this.genDropDowns();
        this.genMainGUI();
        this.validate();
        this.setLayout(null);
        this.layoutGUI();
    }

    protected void layoutGUI() {
        super.layoutGUI();
    }

    protected void setMenuCheck(int n, boolean bl) {
        for (int i = 0; i < optionMenuKeys.length; ++i) {
            if (optionMenuKeys[i] != n) continue;
            CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)this.optionMenu.getItem(i);
            checkboxMenuItem.setState(bl);
            return;
        }
    }

    protected boolean testForClose() {
        if (!this.dg.getChangedFlag()) {
            return true;
        }
        System.out.print("\u0007");
        int n = OkNoCanBox.Create(this, "Landscape Changed", "Landscape has been changed.\nShould it be saved?");
        switch (n) {
            case 0: {
                this.saveLs();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public MenuBar genMenu() {
        MenuItem menuItem;
        int n;
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        for (n = 0; n < fileMenuEntries.length; ++n) {
            menuItem = new MenuItem(fileMenuEntries[n]);
            menu.add(menuItem);
        }
        menuBar.add(menu);
        menu = new Menu("Edit");
        for (n = 0; n < editMenuEntries.length; ++n) {
            menuItem = new MenuItem(editMenuEntries[n]);
            menu.add(menuItem);
        }
        menuBar.add(menu);
        menu = new Menu("Arrange");
        for (n = 0; n < arrangeMenuEntries.length; ++n) {
            menuItem = new MenuItem(arrangeMenuEntries[n]);
            menu.add(menuItem);
        }
        menuBar.add(menu);
        menu = new Menu("Layout");
        this.layoutManager.setMenu(menu);
        menuBar.add(menu);
        menu = new Menu("Options");
        for (n = 0; n < optionMenuEntries.length; ++n) {
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(optionMenuEntries[n]);
            if (optionMenuStates[n]) {
                checkboxMenuItem.setState(true);
            }
            menu.add(checkboxMenuItem);
        }
        menuBar.add(menu);
        this.optionMenu = menu;
        menu = new Menu("Help");
        for (n = 0; n < helpMenuEntries.length; ++n) {
            menuItem = new MenuItem(helpMenuEntries[n]);
            menu.add(menuItem);
        }
        menuBar.add(menu);
        return menuBar;
    }

    public boolean processKey(int n, int n2) {
        if (super.processKey(n, n2)) {
            return true;
        }
        switch (n) {
            case 23: {
                if (!this.testForClose()) {
                    return true;
                }
                if (openFrames == 1) {
                    System.exit(0);
                } else {
                    Container container = this;
                    while (!((container = container.getParent()) instanceof Frame)) {
                    }
                    Frame frame = (Frame)container;
                    frame.hide();
                    frame.dispose();
                    --openFrames;
                }
                return true;
            }
        }
        return false;
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof MenuItem) {
            int n;
            int n2;
            MenuItem menuItem = (MenuItem)event.target;
            String string = menuItem.getLabel();
            if (string.equals(QUIT_LABEL) && this.testForClose()) {
                System.exit(0);
            }
            for (n2 = 0; n2 < fileMenuEntries.length; ++n2) {
                if (!string.equals(fileMenuEntries[n2])) continue;
                return this.processKey(fileMenuKeys[n2], event.modifiers);
            }
            for (n2 = 0; n2 < editMenuEntries.length; ++n2) {
                if (!string.equals(editMenuEntries[n2])) continue;
                return this.processKey(editMenuKeys[n2], event.modifiers);
            }
            for (n2 = 0; n2 < arrangeMenuEntries.length; ++n2) {
                if (!string.equals(arrangeMenuEntries[n2])) continue;
                return this.processKey(arrangeMenuKeys[n2], event.modifiers);
            }
            n2 = this.layoutManager.getMenuIndex(string);
            if (n2 >= 0) {
                this.doLayout(n2);
                return true;
            }
            for (n = 0; n < optionMenuEntries.length; ++n) {
                if (!string.equals(optionMenuEntries[n])) continue;
                return this.processKey(optionMenuKeys[n], event.modifiers);
            }
            for (n = 0; n < helpMenuEntries.length; ++n) {
                if (!string.equals(helpMenuEntries[n])) continue;
                return this.processKey(helpMenuKeys[n], event.modifiers);
            }
        }
        return super.action(event, object);
    }

    public void followLink(String string, int n) {
        System.out.println("followLink: " + n);
        if (n == 1) {
            LandscapeEditorApp landscapeEditorApp = new LandscapeEditorApp();
            landscapeEditorApp.lsPath = string;
            landscapeEditorApp.tocOn = this.tocOn;
            LandscapeEditorFrame landscapeEditorFrame = LandscapeEditorFrame.create(landscapeEditorApp);
            ++openFrames;
        } else if (n == 5) {
            super.followLink(string, n);
        } else {
            this.attach(string);
        }
    }

    public String getParameter(String string) {
        return System.getProperty(string);
    }

    protected void doSetCursor(int n) {
        this.af.setCursor(n);
    }
}

