/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Choice;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.BaseEntity;
import lsedit.DagGridLayout;
import lsedit.DataInputStream;
import lsedit.EditModeHandler;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.InternalBufferStream;
import lsedit.LandscapeModeHandler;
import lsedit.LandscapeObject;
import lsedit.LandscapeViewerCore;
import lsedit.Layout;
import lsedit.LayoutManager;
import lsedit.MsgOut;
import lsedit.MyChoice;
import lsedit.OkMsgBox;
import lsedit.PSGr;
import lsedit.PrintPromptDialog;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ScrollableDiagram;
import lsedit.Util;
import lsedit.Version;
import lsedit.ViewModeHandler;

public abstract class LandscapeEditorCore
extends LandscapeViewerCore {
    protected static final int A_HORIZ_TOP = 10000;
    protected static final int A_HORIZ_CENTER = 10001;
    protected static final int A_VERTICAL_LEFT = 10002;
    protected static final int A_VERTICAL_RIGHT = 10003;
    protected static final int A_VERTICAL_CENTER = 10004;
    protected static final int A_FIT = 10010;
    protected static final int A_GROUP = 10013;
    protected static final int A_FIT_LABEL = 10014;
    protected static final int SZ_WIDTH = 10020;
    protected static final int SZ_HEIGHT = 10021;
    protected static final int SZ_WIDTH_HEIGHT = 10022;
    protected static final int SPC_HORIZ = 10030;
    protected static final int SPC_VERTICAL = 10031;
    protected static final int PRINT_LS = 19993;
    protected static final int PRINT_BOOK = 19994;
    protected static final int PRINT_ALL = 19995;
    protected static final int SAVE_RAW = 19996;
    protected static final int SAVE_AS = 19997;
    protected static final int SAVE_AS_RAW = 19998;
    protected static final int ABOUT_HELP = 19999;
    protected static final int GRID_MAX = 10;
    protected static final int NUM_TOOL_BUTTONS = 10;
    protected static final String TITLE = "Landscape Editor";
    protected static final int FA_SAVE = 1;
    protected static final int FA_PRINT = 2;
    protected static final int FA_PRINT_ALL = 3;
    protected static final int FA_PRINT_BOOK = 4;
    protected LayoutManager layoutManager = new LayoutManager();
    protected LandscapeModeHandler editModeHandler;
    protected LandscapeModeHandler viewModeHandler;
    protected Choice lsDropDown;
    protected Vector diagrams = new Vector();
    protected Vector diagramNames = new Vector();
    protected String lsSavePath;
    protected String lsSaveSuffix;
    protected String lsSaveCmd;
    protected static String aboutStr = "Landscape Editor " + Version.Details();
    protected Vector clipboard = null;
    protected ScrollableDiagram clipboardDg;
    protected boolean clipboardDump = false;
    private static boolean _printing = false;
    private static boolean _web = false;
    private static boolean _landscape = false;
    private static boolean _blackwhite = false;
    private FileOutputStream pos;

    protected String printPrompt(String string, String string2, String string3, int n) {
        Container container = this;
        while (!((container = container.getParent()) instanceof Frame)) {
        }
        Frame frame = (Frame)container;
        PrintPromptDialog.Create(this, frame, string, string2, string3, n);
        return null;
    }

    private static final int partition(Vector vector, int n, int n2, int n3) {
        Layout layout = ((EntityInstance)vector.elementAt(n)).getLayout();
        --n;
        ++n2;
        while (true) {
            boolean bl;
            Layout layout2 = ((EntityInstance)vector.elementAt(--n2)).getLayout();
            if (n3 == 10030) {
                bl = layout2.x > layout.x;
            } else {
                boolean bl2 = bl = layout2.y > layout.y;
            }
            if (bl) continue;
            do {
                layout2 = ((EntityInstance)vector.elementAt(++n)).getLayout();
                if (n3 == 10030) {
                    bl = layout2.x < layout.x;
                    continue;
                }
                boolean bl3 = bl = layout2.y < layout.y;
            } while (bl);
            if (n >= n2) break;
            layout2 = vector.elementAt(n);
            vector.setElementAt(vector.elementAt(n2), n);
            vector.setElementAt(layout2, n2);
        }
        return n2;
    }

    private static final void sort(Vector vector, int n, int n2, int n3) {
        if (n < n2) {
            int n4 = LandscapeEditorCore.partition(vector, n, n2, n3);
            LandscapeEditorCore.sort(vector, n, n4, n3);
            LandscapeEditorCore.sort(vector, n4 + 1, n2, n3);
        }
    }

    protected static void sortVectorByLayout(Vector vector, int n) {
        LandscapeEditorCore.sort(vector, 0, vector.size() - 1, n);
    }

    protected String getTitle() {
        return TITLE;
    }

    public void paintTopControls(Graphics graphics) {
        this.lsDropDown.paint(graphics);
        this.paintToolButtons(graphics);
    }

    protected void layoutTopControls() {
        Insets insets = this.af.getContentPane().getInsets();
        int n = insets.left + 4;
        int n2 = insets.top + 4;
        Dimension dimension = this.lsDropDown.size();
        this.lsDropDown.reshape(n, n2, 100, dimension.height);
        MsgOut.dprintln("lsDropDown width: " + dimension.width);
        this.layoutToolButtons(n += 104, n2);
    }

    protected void genDropDowns() {
        MyChoice myChoice = new MyChoice();
        this.add(myChoice);
        this.lsDropDown = myChoice;
        this.lsDropDown.disable();
    }

    protected void genModeHandlers() {
        this.editModeHandler = new EditModeHandler();
        this.editModeHandler.init(this);
        this.viewModeHandler = new ViewModeHandler();
        this.viewModeHandler.init(this);
        this.modeHandler = this.editModeHandler;
    }

    protected int getNumToolButtons() {
        return this.toolButton.length;
    }

    protected void registerLsName(String string) {
        this.lsDropDown.addItem(string);
        if (this.lsDropDown.countItems() > 1) {
            this.lsDropDown.enable();
        }
    }

    protected void setDiagram(ScrollableDiagram scrollableDiagram) {
        this.dg = scrollableDiagram;
        this.modeHandler.select(scrollableDiagram);
        scrollableDiagram.setDrawBends(!(this.modeHandler instanceof ViewModeHandler));
        this.lsDropDown.select(scrollableDiagram.getName());
        this.fillTOC();
        this.layoutGUI();
        this.repaint();
        this.doFeedback("Set to: " + scrollableDiagram.getName());
        this.setLeftBox();
    }

    protected void setDiagram(int n) {
        ScrollableDiagram scrollableDiagram = (ScrollableDiagram)this.diagrams.elementAt(n);
        if (scrollableDiagram == this.dg) {
            return;
        }
        this.setDiagram(scrollableDiagram);
    }

    protected void addDiagram(ScrollableDiagram scrollableDiagram, String string) {
        this.diagrams.addElement(scrollableDiagram);
        this.diagramNames.addElement(string);
        this.registerLsName(scrollableDiagram.getName());
        this.setDiagram(scrollableDiagram);
        scrollableDiagram.setToViewport();
    }

    public void attach(String string) {
        int n = this.diagramNames.indexOf(string);
        if (n < 0) {
            ScrollableDiagram scrollableDiagram = new ScrollableDiagram(this, this.dgScrollBarRight, this.dgScrollBarBottom);
            String string2 = scrollableDiagram.loadDiagram(string, null, null);
            if (string2 != null) {
                this.error("Attach failed: " + string2);
                return;
            }
            this.addDiagram(scrollableDiagram, string);
        } else {
            this.setDiagram(n);
        }
    }

    public void followLink(String string, int n) {
        if (n == 5) {
            this.attach(string);
        } else {
            this.showURL(string, n);
        }
    }

    protected void loadLs(String string) {
        if (string != null && string.length() > 0) {
            this.lsPath = string;
            this.doFeedback("Reading: " + this.lsPath);
            ScrollableDiagram scrollableDiagram = new ScrollableDiagram(this, this.dgScrollBarRight, this.dgScrollBarBottom);
            String string2 = scrollableDiagram.loadDiagram(this.lsPath, null, null);
            if (string2 != null) {
                this.error("Failed to load (" + string2 + ")");
            } else {
                this.addDiagram(scrollableDiagram, this.lsPath);
            }
        }
        this.requestFocus();
        this.repaint();
    }

    protected void fitChildren() {
        this.dg.saveForUndo();
        this.dg.fitTo(this.dg.getRoot());
        this.doFeedback("Children fitted to: " + this.dg.getRoot().getLabel());
        this.dg.rescale();
        this.repaintDg();
    }

    protected void fitToLabel() {
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        int n = 8;
        int n2 = 4;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Dimension dimension = entityInstance.getLabelDim(this.getGraphics(), 1);
            Layout layout = entityInstance.getLayout();
            layout.width = dimension.width + n * 2;
            layout.height = dimension.height + n2 * 2;
            this.dg.saveForUndo();
            entityInstance.setLayout(layout);
        }
        this.dg.rescale();
        this.redrawDg();
    }

    public void doLayout(int n) {
        this.dg.saveForUndo();
        String string = this.layoutManager.executeLayout(n, this.dg);
        this.doFeedback(string);
        this.dg.rescale();
        this.repaintDg();
    }

    protected Vector startGroupOp() {
        this.dg.saveForUndo();
        Vector vector = this.dg.getGroup();
        if (vector == null) {
            this.error("Group not selected");
            return null;
        }
        return vector;
    }

    protected void treeGroup() {
        Object object;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        Object object2 = null;
        Enumeration enumeration = this.dg.enumRelations();
        while (enumeration.hasMoreElements()) {
            object = (RelationClass)enumeration.nextElement();
            if (!((RelationClass)object).isActive() || this.dg.excludeReln((RelationClass)object)) continue;
            if (object2 != null) {
                this.error("Only one relation must be selected");
                return;
            }
            object2 = object;
        }
        System.out.println(((LandscapeObject)object2).getLabel());
        object = new DagGridLayout(vector, (RelationClass)object2);
        int n = ((DagGridLayout)object).numLevels();
        int n2 = ((DagGridLayout)object).maxBreadth();
        System.out.println(n + " " + n2);
        if (n == 0) {
            this.error("Group is not a DAG");
            return;
        }
        if (n == 1) {
            this.error("Only single level found");
            return;
        }
        Layout layout = ((EntityInstance)vector.elementAt(0)).getParent().getLayout();
        double d = layout.x + layout.width / 16.0;
        double d2 = (layout.width - layout.width / 8.0) / (double)(n2 + 1);
        double d3 = layout.y + layout.height / 16.0;
        double d4 = (layout.height - layout.height / 8.0) / (double)(n + 1);
        for (int i = 0; i < n; ++i) {
            double d5 = d;
            for (int j = 0; j < n2; ++j) {
                EntityInstance entityInstance = ((DagGridLayout)object).getGrid(i, j);
                if (entityInstance != null) {
                    Layout layout2 = entityInstance.getLayout();
                    layout2.x = d5;
                    layout2.y = d3;
                    entityInstance.setLayout(layout2);
                }
                d5 += d2;
            }
            d3 += d4;
        }
        this.doFeedback("Laid out group as tree");
        this.dg.rescale();
        this.repaintDg();
    }

    protected void align(int n) {
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance = this.dg.getKeyEntity();
        Layout layout = entityInstance.getLayout();
        double d = layout.x + layout.width / 2.0;
        double d2 = layout.y + layout.height / 2.0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (entityInstance2 == entityInstance) continue;
            Layout layout2 = (Layout)entityInstance2.getLayout().clone();
            switch (n) {
                case 10000: {
                    layout2.y = layout.y;
                    break;
                }
                case 10001: {
                    layout2.y = d2 - layout2.height / 2.0;
                    break;
                }
                case 10002: {
                    layout2.x = layout.x;
                    break;
                }
                case 10003: {
                    layout2.x += layout.x + layout.width - layout2.width;
                    break;
                }
                case 10004: {
                    layout2.x = d - layout2.width / 2.0;
                    break;
                }
                default: {
                    MsgOut.println("Illegal allignment option");
                }
            }
            entityInstance2.setLayout(layout2);
        }
        this.dg.rescale();
        this.repaintDg();
    }

    protected void sameSize(int n) {
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance = this.dg.getKeyEntity();
        Layout layout = entityInstance.getLayout();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (entityInstance2 == entityInstance) continue;
            Layout layout2 = (Layout)entityInstance2.getLayout().clone();
            switch (n) {
                case 10020: {
                    layout2.width = layout.width;
                    break;
                }
                case 10021: {
                    layout2.height = layout.height;
                    break;
                }
                case 10022: {
                    layout2.width = layout.width;
                    layout2.height = layout.height;
                }
            }
            entityInstance2.setLayout(layout2);
        }
        this.dg.rescale();
        this.repaintDg();
    }

    protected void equalSpacing(int n) {
        Layout layout;
        EntityInstance entityInstance;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        if (vector.size() < 3) {
            this.error("Minimum group of three required");
            return;
        }
        Layout layout2 = this.dg.getGroupBoundingBox();
        if (layout2 == null) {
            this.error("Group not selected");
            return;
        }
        LandscapeEditorCore.sortVectorByLayout(vector, n);
        double d = 0.0;
        Enumeration enumeration = vector.elements();
        double d2 = 0.0;
        double d3 = 0.0;
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            layout = entityInstance.getLayout();
            d3 += layout.width;
            d2 += layout.height;
        }
        d = n == 10030 ? (layout2.width - d3) / (double)(vector.size() - 1) : (layout2.height - d2) / (double)(vector.size() - 1);
        entityInstance = (EntityInstance)vector.elementAt(0);
        layout = entityInstance.getLayout();
        for (int i = 1; i < vector.size() - 1; ++i) {
            EntityInstance entityInstance2 = (EntityInstance)vector.elementAt(i);
            Layout layout3 = entityInstance2.getLayout();
            if (n == 10030) {
                layout3.x = layout.x + layout.width + d;
            } else {
                layout3.y = layout.y + layout.height + d;
            }
            layout = (Layout)layout3.clone();
            entityInstance2.setLayout(layout3);
        }
        this.dg.rescale();
        this.repaintDg();
    }

    protected void createContainedGroup() {
        String string;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance = ((EntityInstance)vector.firstElement()).getParent();
        Layout layout = this.dg.getGroupBoundingBox();
        layout.y -= 21.0;
        layout.x -= 5.0;
        layout.width += 10.0;
        layout.height += 26.0;
        int n = 0;
        do {
            string = "Container#" + n;
            ++n;
        } while (this.dg.entityExists(string));
        EntityInstance entityInstance2 = this.dg.addEntity(string, layout, entityInstance);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
            Layout layout2 = entityInstance3.getLayout();
            entityInstance3.moveEntityContainment(entityInstance2);
            entityInstance3.setLayout(layout2);
        }
        this.dg.rescale();
        this.repaintDg();
    }

    protected void cutGroup() {
        this.clipboard = this.dg.getGroup();
        if (this.clipboard == null) {
            this.error("Group not selected");
        } else {
            this.clipboardDg = this.dg;
            this.doFeedback("Group copied to clipboard");
        }
        Enumeration enumeration = this.clipboard.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            this.dg.removeEntity(entityInstance);
        }
        this.repaintDg();
    }

    protected void pasteGroup() {
        if (this.clipboard == null || this.clipboard.size() == 0) {
            this.error("Clipboard empty");
        } else {
            this.clipboardDump = true;
            this.setCursor(13);
            this.doFeedback("Select parent entity for clipboard group");
        }
    }

    protected void newClipboardEntities(EntityInstance entityInstance, int n, int n2) {
        Enumeration enumeration = this.clipboard.elements();
        Vector vector = new Vector();
        Layout layout = entityInstance.getLayout();
        int n3 = 0;
        int n4 = 4;
        int n5 = 8;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            Layout layout2 = new Layout(n + n4 + (n5 + n4) * n3, n2 + n4 * 2, n5, n5);
            EntityClass entityClass = entityInstance2.getEntityClass();
            this.dg.addEntity(entityInstance2.getId(), entityInstance2.getLabel(), entityInstance2.getDescription(), layout2, entityInstance, entityClass, vector);
            ++n3;
        }
    }

    protected void dumpClipboard(EntityInstance entityInstance, int n, int n2) {
        EntityInstance entityInstance2;
        Enumeration enumeration = this.clipboard.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (!this.dg.containsEntity(entityInstance2)) continue;
            this.error("Landscape already contains item in clipboard");
            return;
        }
        entityInstance2 = (EntityInstance)this.clipboard.firstElement();
        if (this.dg == entityInstance2.getDiagram()) {
            enumeration = this.clipboard.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                entityInstance.addContainment(entityInstance2);
            }
        } else {
            this.newClipboardEntities(entityInstance, n, n2);
        }
        this.redrawDg();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.dg == null) {
            return false;
        }
        if (this.clipboardDump) {
            int n3;
            int n4 = this.dg.adjustX(n);
            EntityInstance entityInstance = this.dg.mouseOverEx(n4, n3 = this.dg.adjustY(n2));
            if (entityInstance == null) {
                this.error("Can't put entities there");
                return true;
            }
            this.dumpClipboard(entityInstance, n4, n3);
            this.clipboardDump = false;
            this.setCursor(0);
            if (this.modeHandler != null) {
                this.modeHandler.mouseMotion(entityInstance, n4, n3);
            }
            return true;
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.dg == null) {
            return false;
        }
        int n3 = this.dg.adjustX(n);
        int n4 = this.dg.adjustY(n2);
        EntityInstance entityInstance = this.dg.mouseOverEx(n3, n4);
        RelationInstance relationInstance = this.dg.mouseOverEdge(entityInstance, n3, n4);
        if (this.clipboardDump) {
            this.showDescription(entityInstance, relationInstance, false);
        } else {
            super.mouseMove(event, n, n2);
        }
        return true;
    }

    protected void saveStatus(String string) {
        this.doFeedback("Save status: " + string);
    }

    protected String doSaveByURL(String string) {
        OutputStream outputStream;
        URLConnection uRLConnection;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return "Malformed URL on write";
        }
        try {
            uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(false);
            uRLConnection.setDoOutput(true);
            uRLConnection.setAllowUserInteraction(false);
        }
        catch (IOException iOException) {
            return "Couldn't open connection";
        }
        try {
            outputStream = uRLConnection.getOutputStream();
        }
        catch (IOException iOException) {
            return "Couldn't openStream";
        }
        try {
            this.dg.saveDiagram(outputStream, false);
        }
        catch (IOException iOException) {
            return "IOException on write";
        }
        return null;
    }

    public void saveByURL(String string) {
        InputStream inputStream;
        URL uRL;
        MsgOut.dprintln("Save by URL");
        String string2 = this.doSaveByURL(this.lsSavePath);
        if (string2 != null) {
            this.saveStatus(string2);
            return;
        }
        if (this.lsSaveCmd == null) {
            this.saveStatus("Success");
            return;
        }
        try {
            uRL = new URL(this.lsSaveCmd);
        }
        catch (MalformedURLException malformedURLException) {
            this.saveStatus("Malformed URL on write");
            return;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            this.saveStatus("Couldn't openStream for store");
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            string2 = dataInputStream.readLine();
            inputStream.close();
            this.saveStatus(string2);
        }
        catch (IOException iOException) {
            this.saveStatus("IOexception on store");
        }
    }

    protected String saveByFile(String string) {
        try {
            Object object;
            File file = (File)this.dg.getContext();
            if (string == null) {
                object = file.getPath();
                file.renameTo(new File((String)object + ".old"));
            } else {
                file = new File(string);
                this.dg.setContext(file);
            }
            object = new FileOutputStream(file);
            this.dg.saveDiagram((OutputStream)object, false);
            return null;
        }
        catch (IOException iOException) {
            return "IOException on file open";
        }
    }

    protected String saveByFileRaw(String string) {
        try {
            Object object;
            File file = (File)this.dg.getContext();
            if (string == null) {
                object = file.getPath();
                if (((String)object).endsWith(".raw")) {
                    file.renameTo(new File((String)object + ".old"));
                } else {
                    file = new File((String)object + ".raw");
                }
            } else {
                file = new File(string + ".raw");
                this.dg.setContext(file);
            }
            object = new FileOutputStream(file);
            this.dg.saveDiagramRaw((OutputStream)object);
            return null;
        }
        catch (IOException iOException) {
            return "IOException on file open";
        }
    }

    protected String saveWithCmd(String string, String string2) {
        String string3;
        Object object;
        File file = (File)this.dg.getContext();
        String string4 = file.getPath() + string;
        File file2 = new File(string4);
        try {
            object = new FileOutputStream(file2);
            this.dg.saveDiagram((OutputStream)object, true);
        }
        catch (IOException iOException) {
            return "IOException on file save";
        }
        object = Util.expand(string2, file.getName(), this);
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec((String)object);
            DataInputStream dataInputStream = new DataInputStream(process.getErrorStream());
            string3 = dataInputStream.readLine();
            if (string3.equals("Done")) {
                string3 = "Save succeeded";
            }
            process.destroy();
        }
        catch (Exception exception) {
            string3 = "Exec failed for: " + (String)object;
        }
        return string3;
    }

    protected void doSaveLs(String string) {
        this.doFeedback("Saving landscape...");
        if (this.dg.getContext() instanceof URL) {
            this.saveByURL(string);
        } else {
            String string2;
            if (string == null && this.lsSaveCmd != null) {
                MsgOut.dprintln("Save by app");
                string2 = this.saveWithCmd(this.lsSaveSuffix, this.lsSaveCmd);
            } else {
                MsgOut.dprintln("Save by file");
                string2 = this.saveByFile(string);
            }
            if (string2 == null) {
                string2 = "Success";
            }
            this.saveStatus(string2);
        }
    }

    protected void saveLs() {
        Object object = this.dg.getContext();
        String string = null;
        if (object == null && (string = this.filePrompt("Save Landscape", this.dg.getAbsolutePath(), 1)).length() == 0) {
            return;
        }
        this.doSaveLs(null);
    }

    protected void doSaveLsRaw(String string) {
        this.doFeedback("Saving landscape in raw format...");
        if (!(this.dg.getContext() instanceof URL)) {
            MsgOut.dprintln("Save by file");
            String string2 = this.saveByFileRaw(string);
            if (string2 == null) {
                string2 = "Success";
            }
            this.saveStatus(string2);
        }
    }

    protected void saveLsRaw() {
        Object object = this.dg.getContext();
        String string = null;
        if (object == null && (string = this.filePrompt("Save Landscape Raw", this.dg.getAbsolutePath(), 1)).length() == 0) {
            return;
        }
        this.doSaveLsRaw(null);
    }

    public static boolean isPrinting() {
        return _printing;
    }

    private PSGr getPaperGraphics(String string) throws IOException {
        float f;
        float f2;
        Rectangle rectangle = this.dg.bounds();
        float f3 = 552.0f;
        float f4 = 732.0f;
        if (_landscape) {
            f2 = f4 / (float)rectangle.width;
            f = f3 / (float)rectangle.height;
        } else {
            f2 = f3 / (float)rectangle.width;
            f = f4 / (float)rectangle.height;
        }
        float f5 = f;
        if (f2 < f) {
            f5 = f2;
        }
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        this.pos = new FileOutputStream(string);
        PSGr pSGr = new PSGr(this.pos, this.getGraphics());
        if (_landscape) {
            int n = (int)(f3 - (float)rectangle.height * f5) / 2;
            int n2 = (int)(f4 - (float)rectangle.width * f5) / 2;
            int n3 = (int)(-((float)rectangle.x * f5));
            int n4 = (int)(-((float)rectangle.y * f5));
            pSGr.translate(-71, 100);
            pSGr.setBoundingBox(new Rectangle(n, n2, (int)((float)rectangle.height * f5 + 3.0f), (int)((float)rectangle.width * f5 + 2.0f)));
        } else {
            int n = (int)(f3 - (float)rectangle.width * f5) / 2;
            int n5 = (int)(f4 - (float)rectangle.height * f5) / 2;
            int n6 = (int)(-((float)rectangle.x * f5)) + n;
            int n7 = (int)(-((float)rectangle.y * f5)) + n5;
            pSGr.translate(n6, n7);
            pSGr.setBoundingBox(new Rectangle(n, n5, (int)((float)rectangle.width * f5 + 2.0f), (int)((float)rectangle.height * f5 + 3.0f)));
        }
        pSGr.setModes(_landscape, _blackwhite, -1);
        pSGr.scale(f5, f5);
        return pSGr;
    }

    private PSGr getBrowserGraphics(String string) throws IOException {
        float f;
        Rectangle rectangle = this.dg.bounds();
        Rectangle rectangle2 = new Rectangle(0, 0, 612, 792);
        float f2 = (float)rectangle2.width / (float)rectangle.width;
        float f3 = f = (float)rectangle2.height / (float)rectangle.height;
        if (f2 < f) {
            f3 = f2;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        this.pos = new FileOutputStream(string);
        PSGr pSGr = new PSGr(this.pos, this.getGraphics(), 0, 612, 792);
        pSGr.setModes(_landscape, _blackwhite, (int)((float)rectangle.height * f3 - 4.0f));
        int n = (int)(-((float)rectangle.x * f3));
        int n2 = (int)(-((float)rectangle.y * f3));
        pSGr.translate(n, n2);
        pSGr.setBoundingBox(new Rectangle(0, 0, (int)((float)rectangle.width * f3 + 2.0f), (int)((float)rectangle.height * f3 + 3.0f)));
        pSGr.scale(f3, f3);
        return pSGr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doPrint(String string) {
        boolean bl = true;
        BaseEntity.set3Dlook(!_blackwhite);
        try {
            _printing = true;
            PSGr pSGr = _web ? this.getBrowserGraphics(string) : this.getPaperGraphics(string);
            this.dg.draw(pSGr);
            pSGr.showpage();
            pSGr.dispose();
            pSGr.writeTrailer();
        }
        catch (Exception exception) {
            System.err.println("Printing..oops: " + exception);
            exception.printStackTrace();
            bl = false;
        }
        finally {
            _printing = false;
        }
        try {
            this.pos.close();
        }
        catch (Exception exception) {
            System.err.println("Printing..oops: " + exception);
            bl = false;
        }
        BaseEntity.set3Dlook(true);
        return bl;
    }

    protected void printLs(String string) {
        this.doFeedback("Printing landscape to: " + string);
        boolean bl = this.doPrint(string);
        if (bl) {
            this.doFeedback("Done printing (success)");
        } else {
            this.error("Done printing (failed)");
        }
    }

    protected String getLsPath(EntityInstance entityInstance) {
        if (entityInstance == this.dg.getTopInstance()) {
            return Util.mungeName(entityInstance.getLabel());
        }
        Vector<String> vector = new Vector<String>();
        EntityInstance entityInstance2 = entityInstance;
        String string = "";
        do {
            vector.addElement(Util.mungeName(entityInstance2.getLabel()));
            while ((entityInstance2 = entityInstance2.getParent()) != null && !entityInstance2.isEnterable()) {
            }
        } while (entityInstance2 != null);
        for (int i = vector.size() - 2; i >= 0; --i) {
            String string2 = (String)vector.elementAt(i);
            string = string + string2;
            if (i <= 0) continue;
            string = string + "#";
        }
        return string;
    }

    protected EntityInstance printAllLs(String string, EntityInstance entityInstance, int n) {
        Object object;
        if (entityInstance.numChildren() < n) {
            return null;
        }
        if (entityInstance.isEnterable()) {
            this.dg.navigateTo(entityInstance);
            object = string + File.separatorChar + this.getLsPath(this.dg.getRoot()) + ".eps";
            this.doFeedback("Printing: " + entityInstance.getLabel());
            if (!this.doPrint((String)object)) {
                return entityInstance;
            }
        }
        object = entityInstance.getChildren();
        while (object.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)object.nextElement();
            EntityInstance entityInstance3 = this.printAllLs(string, entityInstance2, n);
            if (entityInstance3 == null) continue;
            return entityInstance3;
        }
        return null;
    }

    protected void printAllLs(String string) {
        EntityInstance entityInstance = this.dg.getRoot();
        EntityInstance entityInstance2 = this.dg.getTopInstance();
        EntityInstance entityInstance3 = this.printAllLs(string, entityInstance2, 2);
        if (entityInstance3 != null) {
            this.error("Print to landscape failed on: " + entityInstance3.getLabel());
        } else {
            this.doFeedback("Done printing (success)");
        }
        this.dg.navigateTo(entityInstance);
    }

    protected void printBook(String string) {
    }

    public void dialogAction(Object[] objectArray, int n) {
        String string = (String)objectArray[0];
        if (string.length() != 0) {
            switch (n) {
                case 1: {
                    this.doSaveLs(string);
                    break;
                }
                case 0: {
                    this.loadLs(string);
                    break;
                }
                case 2: {
                    _web = (Boolean)objectArray[1];
                    _landscape = (Boolean)objectArray[2];
                    _blackwhite = (Boolean)objectArray[3];
                    this.printLs(string);
                    break;
                }
                case 3: {
                    _web = (Boolean)objectArray[1];
                    _landscape = (Boolean)objectArray[2];
                    _blackwhite = (Boolean)objectArray[3];
                    this.printAllLs(string);
                }
            }
        }
    }

    protected void initialLoad() {
        super.initialLoad();
        if (this.lsPath != null) {
            this.diagrams.addElement(this.dg);
            this.diagramNames.addElement(this.lsPath);
            this.registerLsName(this.dg.getName());
        } else {
            this.diagrams.addElement(this.dg);
            this.diagramNames.addElement("");
            this.registerLsName("unnamed");
        }
    }

    public boolean action(Event event, Object object) {
        if (super.action(event, object)) {
            return true;
        }
        if (event.target == this.lsDropDown) {
            int n = this.lsDropDown.getSelectedIndex();
            this.setDiagram(n);
            this.requestFocus();
        }
        return false;
    }

    public boolean processKey(int n, int n2) {
        if (super.processKey(n, n2)) {
            return true;
        }
        switch (n) {
            case 19: {
                if (this.dg.isReadOnly()) {
                    this.error("Diagram is read-only");
                    return true;
                }
                this.saveLs();
                return true;
            }
            case 19996: {
                if (this.dg.isReadOnly()) {
                    this.error("Diagram is read-only");
                    return true;
                }
                this.saveLsRaw();
                return true;
            }
            case 19997: {
                Object object = this.dg.getContext();
                String string = object != null ? this.filePrompt("Save Landscape As", this.dg.getAbsolutePath(), 1) : this.filePrompt("Save Landscape As", "", 1);
                if (string == null || string.length() == 0) {
                    return true;
                }
                this.doSaveLs(string);
                return true;
            }
            case 19993: {
                Object object = this.dg.getContext();
                String string = "Print Landscape Page to PostScript .eps File";
                String string2 = object != null ? this.dg.getDir() + File.separatorChar + Util.mungeName(this.dg.getRoot().getLabel() + ".eps") : Util.mungeName(this.dg.getRoot().getLabel() + ".eps");
                String string3 = this.filePrompt("Save to eps file:", string2, 1);
                if (string3 == null || string3.length() == 0) {
                    return true;
                }
                this.printLs(string3);
                return true;
            }
            case 19994: {
                Object object = this.dg.getContext();
                String string = "Print Landscape Book to PostScript .eps File";
                String string4 = object != null ? this.dg.getDir() + File.separatorChar + Util.mungeName(this.dg.getTopInstance().getLabel() + ".eps") : Util.mungeName(this.dg.getTopInstance().getLabel() + ".eps");
                String string5 = this.printPrompt(string, "Print to file:", string4, 4);
                if (string5 == null || string5.length() == 0) {
                    return true;
                }
                this.printBook(string5);
                return true;
            }
            case 19995: {
                Object object = this.dg.getContext();
                String string = "Print All Landscapes to PostScript .eps Files";
                String string6 = object != null ? this.dg.getDir() : "";
                String string7 = this.printPrompt(string, "Print in dir:", string6, 3);
                if (string7 == null || string7.length() == 0) {
                    return true;
                }
                this.printAllLs(string7);
                return true;
            }
            case 86: {
                if (this.modeHandler == this.editModeHandler) {
                    this.doFeedback("Set to viewer mode");
                    this.modeHandler = this.viewModeHandler;
                    this.dg.setDrawBends(false);
                    this.setMenuCheck(86, true);
                } else {
                    this.doFeedback("Set to editor mode");
                    this.modeHandler = this.editModeHandler;
                    this.dg.setDrawBends(true);
                    this.setMenuCheck(86, false);
                }
                this.modeHandler.select(this.dg);
                this.repaintDg();
                return true;
            }
            case 10000: 
            case 10001: 
            case 10002: 
            case 10003: 
            case 10004: {
                this.align(n);
                return true;
            }
            case 10013: {
                this.createContainedGroup();
                return true;
            }
            case 10010: {
                this.fitChildren();
                return true;
            }
            case 10014: {
                this.fitToLabel();
                return true;
            }
            case 10020: 
            case 10021: 
            case 10022: {
                this.sameSize(n);
                return true;
            }
            case 10030: 
            case 10031: {
                this.equalSpacing(n);
                return true;
            }
            case 19999: {
                OkMsgBox.Create(this, "About Landscape Editor", aboutStr);
                return true;
            }
            case 24: {
                this.cutGroup();
                return true;
            }
            case 22: {
                this.pasteGroup();
                return true;
            }
            case 103: {
                int n3 = this.dg.getGrid();
                if (n3 == 1) {
                    this.error("Grid already set to minimum (1 pixel)");
                } else {
                    int n4 = n3 - 1;
                    this.dg.setGrid(n4);
                    this.doFeedback("Grid set to " + n4 + " pixel(s)");
                }
                return true;
            }
            case 71: {
                int n5 = this.dg.getGrid();
                if (n5 == 10) {
                    this.error("Grid already set to maximum (" + n5 + " pixels)");
                } else {
                    int n6 = n5 + 1;
                    this.dg.setGrid(n6);
                    this.doFeedback("Grid set to " + n6 + " pixels");
                }
                return true;
            }
            case 15: {
                Object object = this.dg.getContext();
                String string = object != null ? this.filePrompt("Load Landscape", this.dg.getAbsolutePath(), 0) : this.filePrompt("Load Landscape", "", 0);
                this.loadLs(string);
                return true;
            }
        }
        return false;
    }

    public boolean isreadWrite() {
        return true;
    }

    public InternalBufferStream getInternalBufferStream() {
        return null;
    }
}

