/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import lsedit.LandscapeEditorApp;
import lsedit.LandscapeTokenStream;
import lsedit.MsgOut;
import lsedit.Util;

class LandscapeEditorFrame
extends JFrame
implements WindowListener {
    protected static final String title = "Software Landscape Editor";
    protected static final int MAX_WIDTH = 1280;
    protected static final int MAX_HEIGHT = 1024;
    protected boolean appFrameInitialized = false;
    protected LandscapeEditorApp applet;
    protected static Dimension editorDim = null;
    protected static Dimension diagDim = null;
    protected static boolean landscapeGeo = false;
    protected static boolean startInViewerMode = false;
    protected static String version = System.getProperty("java.version");

    public LandscapeEditorFrame(LandscapeEditorApp landscapeEditorApp, int n, int n2) {
        super(title);
        this.addWindowListener(this);
        this.getContentPane().setLayout(null);
        MenuBar menuBar = landscapeEditorApp.genMenu();
        this.setMenuBar(menuBar);
        this.setBackground(Color.lightGray);
        this.getContentPane().add(landscapeEditorApp);
        this.resize(n, n2);
        this.show();
        this.applet = landscapeEditorApp;
        Rectangle rectangle = this.bounds();
        MsgOut.dprintln("App: " + rectangle);
        landscapeEditorApp.init_app(this, diagDim);
        landscapeEditorApp.start();
        this.appFrameInitialized = true;
    }

    public boolean handleEvent(Event event) {
        if (!this.appFrameInitialized) {
            return false;
        }
        return this.applet.handleEvent(event);
    }

    protected static Dimension parseDim(String string) {
        int n = string.indexOf(120);
        if (n > 0) {
            try {
                int n2 = Util.parseInt(string.substring(0, n));
                int n3 = Util.parseInt(string.substring(n + 1));
                return new Dimension(n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static void usage() {
        System.out.println("\nLandscape Editor 6.0.13\n");
        System.out.println("<executor> LandscapeEditorFrame [options] <HTTP or file path>\n");
        System.out.println("-h\t This message");
        System.out.println("-t\t Activate with TOC");
        System.out.println("-v\t Verbose parsing output");
        System.out.println("");
        System.out.println("-g<width>x<height> Geometry of editor");
        System.out.println("-G<width>x<height> Geometry of diagram");
        System.out.println("");
        System.out.println("-L\t Start with landscape geometry");
        System.out.println("-V\t Start in viewer mode");
        System.out.println("");
        System.out.println("-P <path>  Optional save path");
        System.out.println("-S <path>  Optional save suffix");
        System.out.println("-X <path>  Optional app to exec on save");
        System.out.println("");
    }

    public static LandscapeEditorFrame create(LandscapeEditorApp landscapeEditorApp) {
        int n;
        int n2;
        if (editorDim != null) {
            n2 = LandscapeEditorFrame.editorDim.width;
            n = LandscapeEditorFrame.editorDim.height;
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            double d = 0.75;
            if (landscapeGeo) {
                n2 = Math.min(1280, dimension.width);
                n = Math.min(1024, dimension.height);
            } else {
                n = dimension.height - 50;
                n2 = (int)((double)dimension.width / d);
                if (landscapeEditorApp.tocOn) {
                    n2 += 200;
                }
            }
            n2 = Math.min(n2, dimension.width);
            n = Math.min(n, dimension.height);
        }
        return new LandscapeEditorFrame(landscapeEditorApp, n2, n);
    }

    public static void main(String[] stringArray) {
        int n;
        LandscapeEditorApp landscapeEditorApp = new LandscapeEditorApp();
        MsgOut.setVerboseFlag(false);
        MsgOut.setDebugFlag(false);
        for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            int n2 = stringArray[n].length();
            block15: for (int i = 1; i < n2; ++i) {
                char c = stringArray[n].charAt(i);
                switch (c) {
                    case 'd': {
                        MsgOut.setDebugFlag(true);
                        MsgOut.dprintln("Start app: " + version);
                        if (i >= n2 - 1 || stringArray[n].charAt(i + 1) != 'd') continue block15;
                        LandscapeTokenStream.setDebugOn();
                        ++i;
                        continue block15;
                    }
                    case 'h': {
                        LandscapeEditorFrame.usage();
                        System.exit(0);
                        continue block15;
                    }
                    case 't': {
                        landscapeEditorApp.tocOn = true;
                        continue block15;
                    }
                    case 'v': {
                        MsgOut.setVerboseFlag(true);
                        continue block15;
                    }
                    case 'g': {
                        editorDim = LandscapeEditorFrame.parseDim(stringArray[n].substring(i + 1));
                        i = n2;
                        continue block15;
                    }
                    case 'G': {
                        diagDim = LandscapeEditorFrame.parseDim(stringArray[n].substring(i + 1));
                        i = n2;
                        continue block15;
                    }
                    case 'L': {
                        landscapeGeo = true;
                        continue block15;
                    }
                    case 'N': {
                        if (++n == stringArray.length) {
                            System.out.println("\nInvalid use of -N");
                            LandscapeEditorFrame.usage();
                            System.exit(0);
                        }
                        landscapeEditorApp.startEntity = stringArray[n];
                        i = n2;
                        continue block15;
                    }
                    case 'V': {
                        startInViewerMode = true;
                        continue block15;
                    }
                    case 'P': {
                        if (++n == stringArray.length) {
                            System.out.println("\nInvalid use of -P");
                            LandscapeEditorFrame.usage();
                            System.exit(0);
                        }
                        landscapeEditorApp.lsSavePath = stringArray[n];
                        i = n2;
                        continue block15;
                    }
                    case 'S': {
                        if (++n == stringArray.length) {
                            System.out.println("\nInvalid use of -S");
                            LandscapeEditorFrame.usage();
                            System.exit(0);
                        }
                        landscapeEditorApp.lsSaveSuffix = stringArray[n];
                        i = n2;
                        continue block15;
                    }
                    case 'X': {
                        if (++n == stringArray.length) {
                            System.out.println("\nInvalid use of -X");
                            LandscapeEditorFrame.usage();
                            System.exit(0);
                        }
                        landscapeEditorApp.lsSaveCmd = stringArray[n];
                        i = n2;
                    }
                }
            }
        }
        landscapeEditorApp.lsPath = n == stringArray.length ? null : stringArray[n++];
        while (n < stringArray.length) {
            landscapeEditorApp.lsPath_bg.addElement(stringArray[n++]);
        }
        LandscapeEditorFrame landscapeEditorFrame = LandscapeEditorFrame.create(landscapeEditorApp);
        MsgOut.dprintln("exit main");
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.removeWindowListener(this);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }
}

