/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Diagram;

public abstract class LandscapeObject {
    public static final String COLOUR_ID = "color";
    public static final String LABEL_COLOUR_ID = "labelcolor";
    public static final String OPEN_COLOUR_ID = "opencolor";
    protected static final int MAX_RGB = 255;
    protected String id;
    protected String label;
    protected String description;
    protected String title;
    protected int style = 0;
    protected Diagram dg;
    protected int m_nid = -1;
    protected static int edge_mode = 0;
    private Color colourWhenOpen = null;
    private Color colour;
    private Color labelColour;
    protected Hashtable attributes = new Hashtable(5);

    protected void saveForUndo(LandscapeObject landscapeObject) {
        landscapeObject.id = this.id;
        landscapeObject.label = this.label;
        landscapeObject.dg = this.dg;
        landscapeObject.setNid(this.getNid());
        landscapeObject.attributes = (Hashtable)this.attributes.clone();
    }

    protected void undo(LandscapeObject landscapeObject) {
        this.id = landscapeObject.id;
        this.label = landscapeObject.label;
        this.dg = landscapeObject.dg;
        this.setNid(landscapeObject.getNid());
        this.attributes = landscapeObject.attributes;
    }

    protected String qt(String string) {
        return AttributeValueItem.qt(string);
    }

    public abstract boolean hasId(String var1);

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{hashtable.get(string), object, object2};
        vector.addElement(objectArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, int n) {
        this.regRawAttribute(vector, hashtable, string, Attribute.INT, new Integer(n));
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, double d) {
        this.regRawAttribute(vector, hashtable, string, Attribute.DOUBLE, new Double(d));
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, String string2) {
        this.regRawAttribute(vector, hashtable, string, Attribute.STRING, string2);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, int[] nArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.INT_LIST, nArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, double[] dArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.DOUBLE_LIST, dArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, String[] stringArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.STRING_LIST, stringArray);
    }

    public void regAttributeRaw(Vector vector, Hashtable hashtable, Attribute attribute, boolean bl) {
        if (attribute.avi == null) {
            if (bl) {
                this.regRawAttribute(vector, hashtable, attribute.id, Attribute.NULL, null);
            }
        } else if (bl || !attribute.cloneOnAssign) {
            if (attribute.avi.next != null) {
                AttributeValueItem attributeValueItem = attribute.avi;
                int n = 0;
                while (attributeValueItem != null) {
                    attributeValueItem = attributeValueItem.next;
                    ++n;
                }
                String[] stringArray = new String[n];
                attributeValueItem = attribute.avi;
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = attributeValueItem.value;
                }
                this.regRawAttribute(vector, hashtable, attribute.id, stringArray);
            } else {
                this.regRawAttribute(vector, hashtable, attribute.id, attribute.avi.value);
            }
        }
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        double[] dArray = new double[]{(double)n / 255.0, (double)n2 / 255.0, (double)n3 / 255.0};
        this.regRawAttribute(vector, hashtable, string, dArray);
    }

    public boolean processFirstOrder(Attribute attribute) {
        if (attribute.id.equals(COLOUR_ID)) {
            this.colour = attribute.parseColour();
            return true;
        }
        if (attribute.id.equals(LABEL_COLOUR_ID)) {
            this.labelColour = attribute.parseColour();
            return true;
        }
        if (attribute.id.equals(OPEN_COLOUR_ID)) {
            this.colourWhenOpen = attribute.parseColour();
            return true;
        }
        return false;
    }

    public void addAttribute(Attribute attribute) {
        if (this.processFirstOrder(attribute)) {
            return;
        }
        Attribute attribute2 = (Attribute)this.attributes.get(attribute.id);
        if (attribute2 == null) {
            this.attributes.put(attribute.id, attribute);
        } else if (attribute.avi != null) {
            this.attributes.remove(attribute2);
            this.attributes.put(attribute.id, attribute);
        }
    }

    public boolean addRawAttribute(String string) {
        Attribute attribute = new Attribute(string, null);
        this.addAttribute(attribute);
        return true;
    }

    public boolean addRawAttribute(String string, String string2) {
        AttributeValueItem attributeValueItem = new AttributeValueItem(string2);
        Attribute attribute = new Attribute(string, attributeValueItem);
        this.addAttribute(attribute);
        return true;
    }

    public boolean addRawAttribute(String string, double d) {
        System.out.println("0");
        return false;
    }

    public boolean addRawAttribute(String string, int n) {
        System.out.println("1");
        return false;
    }

    public boolean addRawAttribute(String string, int[] nArray) {
        System.out.println("2");
        return false;
    }

    public boolean addRawAttribute(String string, double[] dArray) {
        if (string.equals(COLOUR_ID)) {
            this.colour = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
            return true;
        }
        if (string.equals(LABEL_COLOUR_ID)) {
            this.labelColour = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
            return true;
        }
        if (string.equals(OPEN_COLOUR_ID)) {
            this.colourWhenOpen = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String string, String[] stringArray) {
        AttributeValueItem attributeValueItem = null;
        AttributeValueItem attributeValueItem2 = null;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            AttributeValueItem attributeValueItem3 = new AttributeValueItem(stringArray[i]);
            if (attributeValueItem2 != null) {
                attributeValueItem2.next = attributeValueItem3;
            }
            if (attributeValueItem == null) {
                attributeValueItem = attributeValueItem3;
            }
            attributeValueItem2 = attributeValueItem3;
        }
        Attribute attribute = new Attribute(string, attributeValueItem);
        this.addAttribute(attribute);
        return true;
    }

    public Attribute getAttribute(String string) {
        return (Attribute)this.attributes.get(string);
    }

    public void replaceAttribute(Attribute attribute) {
        this.addAttribute(attribute);
    }

    public void writeAttributes(PrintStream printStream, boolean bl) throws IOException {
        if (bl) {
            int n;
            int n2;
            int n3;
            if (this.colour != null) {
                n3 = this.colour.getRed();
                n2 = this.colour.getGreen();
                n = this.colour.getBlue();
                printStream.print("\t color = (" + (double)n3 / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n / 255.0 + ")\n");
            }
            if (this.labelColour != null) {
                n3 = this.labelColour.getRed();
                n2 = this.labelColour.getGreen();
                n = this.labelColour.getBlue();
                printStream.print("\t labelcolor = (" + (double)n3 / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n / 255.0 + ")\n");
            }
            if (this.colourWhenOpen != null) {
                n3 = this.colourWhenOpen.getRed();
                n2 = this.colourWhenOpen.getGreen();
                n = this.colourWhenOpen.getBlue();
                printStream.print("\t opencolor = (" + (double)n3 / 255.0 + " " + (double)n2 / 255.0 + " " + (double)n / 255.0 + ")\n");
            }
        }
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            attribute.writeAttribute(printStream, bl);
        }
    }

    public void getAttributesRaw(Vector vector, Hashtable hashtable, boolean bl) {
        if (bl) {
            if (this.colour != null) {
                this.regRawAttribute(vector, hashtable, COLOUR_ID, this.colour);
            }
            if (this.labelColour != null) {
                this.regRawAttribute(vector, hashtable, LABEL_COLOUR_ID, this.labelColour);
            }
            if (this.colourWhenOpen != null) {
                this.regRawAttribute(vector, hashtable, OPEN_COLOUR_ID, this.labelColour);
            }
        }
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            this.regAttributeRaw(vector, hashtable, attribute, bl);
        }
    }

    public boolean hasAttributes(boolean bl) {
        if (bl) {
            return true;
        }
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.cloneOnAssign) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getNid() {
        return this.m_nid;
    }

    public void setNid(int n) {
        this.m_nid = n;
    }

    public int getStyle() {
        return this.style;
    }

    public Color getObjectColorWhenOpen() {
        return this.colourWhenOpen;
    }

    public Color getObjectColor() {
        return this.colour;
    }

    public void setObjectColor(Color color) {
        this.colour = color;
    }

    public void setObjectColorWhenOpen(Color color) {
        this.colourWhenOpen = color;
    }

    public Color getLabelColor() {
        return this.labelColour;
    }

    public void setLabelColor(Color color) {
        this.labelColour = color;
    }

    public static void setEdgeMode(int n) {
        edge_mode = n;
    }

    public static int getEdgeMode() {
        return edge_mode;
    }

    public Attribute getAttributeAt(int n) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (n == 0) {
                return attribute;
            }
            --n;
        }
        return null;
    }

    public int getPrimaryAttributeCount() {
        return 0;
    }

    public int getAttributeCount() {
        return this.getPrimaryAttributeCount() + this.attributes.size() + 1;
    }

    public boolean canEditName(int n) {
        int n2 = this.getPrimaryAttributeCount();
        return n >= n2;
    }

    public boolean canEditAttribute(int n) {
        if (n == 0) {
            return false;
        }
        int n2 = this.getPrimaryAttributeCount();
        if (n < n2) {
            return true;
        }
        return (n -= n2) < this.attributes.size();
    }

    public String getAttributeNameAt(int n) {
        if ((n -= this.getPrimaryAttributeCount()) == this.attributes.size()) {
            return "";
        }
        Attribute attribute = this.getAttributeAt(n);
        if (attribute == null) {
            return null;
        }
        return attribute.id;
    }

    public Object getAttributeValueAt(int n) {
        if ((n -= this.getPrimaryAttributeCount()) == this.attributes.size()) {
            return "";
        }
        Attribute attribute = this.getAttributeAt(n);
        if (attribute == null) {
            return null;
        }
        return attribute.avi;
    }

    private boolean unknownAttributeName(String string) {
        String string2;
        int n = 0;
        while ((string2 = this.getAttributeNameAt(n)) != null) {
            if (string.equals(string2)) {
                System.out.println("Can't rename generic attribute to '" + string + "': attribute already exists");
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean setAttributeNameAt(int n, Object object) {
        int n2 = this.getPrimaryAttributeCount();
        if (n < n2) {
            return false;
        }
        String string = (String)object;
        if ((n -= n2) == this.attributes.size()) {
            if (string.equals("")) {
                return false;
            }
            if (!this.unknownAttributeName(string)) {
                return false;
            }
            Attribute attribute = new Attribute(string, null);
            this.attributes.put(attribute.id, attribute);
            return true;
        }
        Attribute attribute = this.getAttributeAt(n);
        if (attribute == null) {
            return false;
        }
        if (string.equals("")) {
            this.attributes.remove(attribute.id);
            return true;
        }
        if (string.equals(attribute.id)) {
            return false;
        }
        if (!this.unknownAttributeName(string)) {
            return false;
        }
        this.attributes.remove(attribute.id);
        attribute.id = string;
        this.attributes.put(attribute.id, attribute);
        return true;
    }

    public void setAttributeValueAt(int n, Object object) {
        Attribute attribute = this.getAttributeAt(n -= this.getPrimaryAttributeCount());
        if (attribute == null) {
            return;
        }
        attribute.avi = (AttributeValueItem)object;
    }

    public int getAttributeTypeAt(int n) {
        if (n < this.getAttributeCount() - 1) {
            return 11;
        }
        return 0;
    }
}

