/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.IOException;
import java.io.InputStream;
import lsedit.Attribute;
import lsedit.AttributeRecord;
import lsedit.AttributeValueItem;
import lsedit.MsgOut;
import lsedit.TA_StreamTokenizer;
import lsedit.Tuple;

public class LandscapeTokenStream {
    public static final int SCHEME_TUPLE = 0;
    public static final int SCHEME_ATTRIBUTE = 1;
    public static final int FACT_TUPLE = 2;
    public static final int FACT_ATTRIBUTE = 3;
    public static final int INCLUDE_FILE = 4;
    public static final int ERROR = -1;
    public static final int NONE = -2;
    public static final int EOF = 99;
    protected static final String SCHEME_ID = "SCHEME";
    protected static final String FACT_ID = "FACT";
    protected static final String TUPLE_ID = "TUPLE";
    protected static final String ATTRIBUTE_ID = "ATTRIBUTE";
    protected static final String INCLUDE_ID = "INCLUDE";
    protected static boolean debug = false;
    protected boolean fatalError = false;
    protected String fileName;
    protected TA_StreamTokenizer ts;
    protected String token1;
    protected String token2;
    protected String includeFile;
    protected int ttype3;

    public static void setDebugOn() {
        debug = true;
    }

    protected void debugOut(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    protected int nextToken() throws IOException {
        int n = this.ts.nextToken();
        if (debug) {
            switch (n) {
                case -1: {
                    System.out.println("Token(EOF)");
                    break;
                }
                case -3: {
                    System.out.println("WordToken(\"" + this.ts.sval + '\"' + ")");
                    break;
                }
                case -2: {
                    System.out.println("NumberToken(#" + this.ts.nval + ")");
                    break;
                }
                default: {
                    System.out.println("CharToken('" + (char)n + "')");
                }
            }
        }
        return n;
    }

    protected void skipRecord() throws IOException {
        int n;
        while ((n = this.nextToken()) != -1 && n != 123) {
        }
        if (n != 123) {
            return;
        }
        while ((n = this.nextToken()) != -1 && n != 125) {
        }
    }

    protected void pushBack() {
        this.ts.pushBack();
    }

    protected AttributeValueItem parseList() throws IOException {
        this.debugOut("parseList:");
        AttributeValueItem attributeValueItem = null;
        AttributeValueItem attributeValueItem2 = null;
        block5: while (true) {
            switch (this.nextToken()) {
                case 41: {
                    return attributeValueItem;
                }
                case 40: {
                    AttributeValueItem attributeValueItem3 = this.parseList();
                    if (attributeValueItem == null) {
                        attributeValueItem = attributeValueItem3;
                    } else {
                        attributeValueItem2.nextList = attributeValueItem3;
                    }
                    attributeValueItem2 = attributeValueItem3;
                    continue block5;
                }
                case -3: {
                    AttributeValueItem attributeValueItem3 = new AttributeValueItem(this.ts.sval);
                    if (attributeValueItem == null) {
                        attributeValueItem = attributeValueItem3;
                    } else {
                        attributeValueItem2.next = attributeValueItem3;
                    }
                    attributeValueItem2 = attributeValueItem3;
                    continue block5;
                }
            }
            break;
        }
        this.error("Expecting list, value, or ')'");
        this.pushBack();
        return null;
    }

    protected AttributeValueItem parseNested(String string) throws IOException {
        this.debugOut("parseNested:");
        AttributeRecord attributeRecord = new AttributeRecord(string);
        attributeRecord.attributes = this.parseAttributes();
        return new AttributeValueItem(attributeRecord);
    }

    protected AttributeValueItem parseAVI(String string) throws IOException {
        AttributeValueItem attributeValueItem;
        int n = this.nextToken();
        switch (n) {
            case 40: {
                attributeValueItem = this.parseList();
                break;
            }
            case 123: {
                attributeValueItem = this.parseNested(string);
                break;
            }
            case -3: {
                attributeValueItem = new AttributeValueItem(this.ts.sval);
                break;
            }
            default: {
                this.error("Expecting attribute value");
                attributeValueItem = null;
            }
        }
        return attributeValueItem;
    }

    protected Attribute parseAttributes() throws IOException {
        this.debugOut("parseAttributes:");
        Attribute attribute = null;
        Attribute attribute2 = null;
        int n;
        while ((n = this.nextToken()) != 125) {
            AttributeValueItem attributeValueItem;
            if (n != -3) {
                this.error("Expecting attribute id");
                return null;
            }
            String string = this.ts.sval;
            if (this.nextToken() != 61) {
                this.pushBack();
                attributeValueItem = null;
            } else {
                attributeValueItem = this.parseAVI(string);
                if (attributeValueItem == null) {
                    return null;
                }
            }
            Attribute attribute3 = new Attribute(string, attributeValueItem);
            if (attribute == null) {
                attribute = attribute3;
            } else {
                attribute2.next = attribute3;
            }
            attribute2 = attribute3;
        }
        return attribute;
    }

    public LandscapeTokenStream(InputStream inputStream, String string) {
        this.fileName = string;
        this.ts = new TA_StreamTokenizer(inputStream);
    }

    protected AttributeValueItem parseAttributeValueItem() throws IOException {
        AttributeValueItem attributeValueItem = this.parseAVI("");
        int n = this.nextToken();
        if (n != -1) {
            attributeValueItem = null;
        }
        return attributeValueItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextSection() throws IOException {
        String string;
        String string2;
        this.debugOut("nextSection: ");
        if (this.fatalError) {
            return 99;
        }
        if (this.token1 != null) {
            if (this.ttype3 != 58) {
                this.error("Expecting section header ':'");
                return -1;
            }
            string2 = this.token1;
            string = this.token2;
            this.token1 = null;
            this.token2 = null;
        } else {
            int n = this.nextToken();
            if (n == -1) {
                return 99;
            }
            if (n != -3) {
                this.error("Expecting graph id");
                return -1;
            }
            string2 = this.ts.sval;
            if (this.nextToken() != -3) {
                this.error("Expecting section type id");
                return -1;
            }
            string = this.ts.sval;
            if (this.nextToken() != 58) {
                this.error("Expecting ':'");
                return -1;
            }
        }
        if (string2.equals(SCHEME_ID)) {
            if (string.equals(TUPLE_ID)) {
                return 0;
            }
            if (string.equals(ATTRIBUTE_ID)) {
                return 1;
            }
            this.error("Bad section type");
            return -1;
        }
        if (string2.equals(FACT_ID)) {
            if (string.equals(TUPLE_ID)) {
                return 2;
            }
            if (string.equals(ATTRIBUTE_ID)) {
                return 3;
            }
            this.error("Bad section type");
            return -1;
        }
        if (string2.equals(INCLUDE_ID)) {
            this.includeFile = string;
            return 4;
        }
        this.error("Bad section id");
        return -1;
    }

    public String getIncludeFile() {
        return this.includeFile;
    }

    public void setForTuples() {
    }

    public Tuple nextTuple() throws IOException {
        this.debugOut("nextTuple:");
        if (this.fatalError) {
            return null;
        }
        int n = this.nextToken();
        if (n == -1) {
            return null;
        }
        if (n != -3) {
            this.error("Expecting word token");
            this.fatalError = true;
            return null;
        }
        String string = this.ts.sval;
        if (this.nextToken() != -3) {
            this.error("Expecting word token");
            this.fatalError = true;
            return null;
        }
        String string2 = this.ts.sval;
        n = this.nextToken();
        if (n == 58) {
            this.token1 = string;
            this.token2 = string2;
            this.ttype3 = n;
            return null;
        }
        if (n != -3) {
            this.error("Error in tuple parse");
            this.fatalError = true;
            return null;
        }
        String string3 = this.ts.sval;
        return new Tuple(string, string2, string3);
    }

    public void setForRecords() {
    }

    public AttributeRecord nextRecord() throws IOException {
        String string;
        Attribute attribute;
        this.debugOut("nextRecord: ");
        if (this.fatalError) {
            return null;
        }
        do {
            int n;
            if ((n = this.nextToken()) == -1) {
                return null;
            }
            if (n == 40) {
                string = "(";
                boolean bl = true;
                while ((n = this.nextToken()) != 41) {
                    if (n == -1) {
                        this.error("Expected ')'");
                        return null;
                    }
                    if (n != -3) {
                        this.errorNS("Unexpected char '" + (char)this.ts.ttype + "' in relation id - Partial id: " + string);
                        this.skipRecord();
                        return this.nextRecord();
                    }
                    if (bl) {
                        string = string + this.ts.sval;
                        bl = false;
                        continue;
                    }
                    string = string + " " + this.ts.sval;
                }
                string = string + ")";
            } else {
                if (n != -3) {
                    this.error("Expecting object id");
                    this.skipRecord();
                    return this.nextRecord();
                }
                string = this.ts.sval;
            }
            this.debugOut("Processing record for: " + string);
            if (this.nextToken() == 123) continue;
            this.token1 = string;
            this.token2 = this.ts.sval;
            if (this.nextToken() != 58) {
                this.token1 = null;
                this.token2 = null;
                this.error("Expecting section header");
                this.skipRecord();
                return this.nextRecord();
            }
            this.ttype3 = 58;
            return null;
        } while ((attribute = this.parseAttributes()) == null);
        AttributeRecord attributeRecord = new AttributeRecord(string);
        attributeRecord.attributes = attribute;
        return attributeRecord;
    }

    public void errorNS(String string) {
        MsgOut.println("*** Error (" + this.fileName + ":" + this.ts.lineno() + "): " + string);
    }

    public void error(String string) {
        MsgOut.println("*** Error (" + this.fileName + ":" + this.ts.lineno() + "): " + string + ". Found " + this.ts.sval);
    }

    public void warning(String string) {
        MsgOut.println(">>> Warning (" + this.fileName + ":" + this.ts.lineno() + "): " + string);
    }
}

