/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Elision_CS_Button;
import lsedit.Elision_CU_Button;
import lsedit.Elision_I_Button;
import lsedit.Elision_c_Button;
import lsedit.Elision_s_Button;
import lsedit.Elision_u_Button;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.Feedback;
import lsedit.Find;
import lsedit.FindBox;
import lsedit.Find_Button;
import lsedit.FontBiggerButton;
import lsedit.FontSmallerButton;
import lsedit.HelpBox;
import lsedit.InternalBufferStream;
import lsedit.LandscapeBoxDrawer;
import lsedit.LandscapeModeHandler;
import lsedit.LandscapeObject;
import lsedit.Layout;
import lsedit.LegendBox;
import lsedit.LsLink;
import lsedit.MapBox;
import lsedit.MaxMinWindowButton;
import lsedit.MenuButton;
import lsedit.MsgOut;
import lsedit.MyComponent;
import lsedit.PopupHelp;
import lsedit.QueryBox;
import lsedit.Query_C_Button;
import lsedit.Query_Clear_Button;
import lsedit.Query_b_Button;
import lsedit.Query_f_Button;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.ScrollableDiagram;
import lsedit.SearchCookie;
import lsedit.TabbedBox;
import lsedit.TextBox;
import lsedit.TitleBox;
import lsedit.ToolBarButton;
import lsedit.ToolBarEventHandler;
import lsedit.Util;
import lsedit.ViewModeHandler;

public abstract class LandscapeViewerCore
extends Applet
implements ToolBarEventHandler {
    protected static final String TITLE = "Landscape Viewer";
    protected static final Font menuFont = new Font("Helvetica", 0, 12);
    protected static final int TOC_WIDTH = 175;
    protected static final int LB_WIDTH = 200;
    protected static final int NB_WIDTH = 200;
    protected static final int DESC_HEIGHT = 110;
    protected static final int NAV_DIM = 16;
    protected static final int SGAP = 2;
    protected static final int GAP = 4;
    protected static final int FB_GAP = 5;
    protected static final double DESC_HEIGHT_FACTOR = 0.12;
    protected static final int DROPDOWN_WIDTH = 150;
    protected static final int DROPDOWN_HEIGHT = 25;
    protected static final int TOP_CTRL_DELTA = 50;
    protected static final String LANDSCAPE_ITEM = "tool";
    protected static final String BOOKSHELF_ITEM = "bshelf";
    public static final int SHOW_DESC = 1100;
    public static final int SHOW_FB = 1101;
    public static final int SHOW_RIGHT = 1102;
    public static final int SHOW_TOC = 1103;
    public static final int SHOW_CLIENTS = 1104;
    public static final int SHOW_SUPPLIERS = 1105;
    public static final int SHOW_CARDINALS = 1106;
    public static final int TOP_CLIENTS = 1107;
    public static final int SHOW_ANIMATE = 1108;
    public static final int STUMP_BASE = 1110;
    public static final int EDGE_BASE = 1120;
    public static final int QUERY_PERSIST = 1140;
    public static final int FA_LOAD = 0;
    protected String editURL;
    protected String lsPath;
    protected Vector lsPath_bg = new Vector();
    protected String aboutURL;
    protected String helpURL;
    protected String prefURL;
    protected String prefInvokeURL;
    protected String user;
    protected String startEntity = null;
    protected LandscapeModeHandler modeHandler;
    protected static final int RELN_ALL = 10;
    protected AppletContext ac = null;
    protected JFrame af = null;
    protected ScrollableDiagram dg = null;
    protected static final String resultBoxHelp = "Displays the results of visual queries.";
    protected static final String leftTextBoxHelp = "Displays the 'description' for the current landscape.";
    protected static final String rightTextBoxHelp = "Displays the 'description' for the closed (not a container) entity currently under the mouse cursor.";
    protected static final String feedbackHelp = "Displays feedback from the program. Examples include errors, warnings, and confirmations of action.";
    protected static final String nameBoxHelp = "Displays the landscape entity, edge, or application button/box currently under the mouse cursor.";
    protected MenuButton editMenuButton = null;
    protected Scrollbar dgScrollBarRight;
    protected Scrollbar dgScrollBarBottom;
    protected TextBox leftTextBox;
    protected TextBox rightTextBox;
    protected TextBox tocBox;
    protected LegendBox legendBox;
    protected MapBox mapBox;
    protected QueryBox queryBox;
    protected ResultBox resultBox;
    protected Feedback feedback;
    protected Feedback nameBox;
    protected HelpBox helpBox;
    protected PopupHelp popupHelp;
    protected TitleBox titleBox;
    protected EntityInstance currentDescEntity = null;
    protected EntityInstance currentNameEntity = null;
    protected RelationInstance currentEdge = null;
    protected boolean appInitialized = false;
    protected Dimension viewportDim;
    protected Point lastMousePos = new Point(0, 0);
    protected TextBox boxDrawer;
    protected int mode = 0;
    protected boolean tocOn = false;
    protected boolean showClients = true;
    protected boolean showSuppliers = true;
    protected boolean showCardinals = false;
    protected boolean topClients = true;
    protected Dimension diagDim = null;
    private TabbedBox optionBox;
    protected int topWidth;
    private boolean show_animation = false;
    protected ToolBarButton[] toolButton = new ToolBarButton[]{new Find_Button(this), new Query_f_Button(this), new Query_b_Button(this), new Query_C_Button(this), new Query_Clear_Button(this), new Elision_c_Button(this), new Elision_I_Button(this), new Elision_u_Button(this), new Elision_CU_Button(this), new Elision_s_Button(this), new Elision_CS_Button(this), new FontSmallerButton(this), new FontBiggerButton(this)};
    protected MaxMinWindowButton maxMin;
    protected static final String indAdd = "  ";
    protected Find findResults = null;
    protected boolean modeHandlingActive = false;
    protected boolean mouseClickActive = false;
    protected long lastUp = 0L;
    protected static int EC_CNT = 40;
    private int curCursor = 0;
    protected boolean waitActive = false;

    protected abstract Dimension getViewDimensions();

    protected void repaintTabs(Graphics graphics) {
        if (this.optionBox != this.legendBox) {
            this.legendBox.draw(graphics);
        }
        if (this.optionBox != this.mapBox) {
            this.mapBox.draw(graphics);
        }
        if (this.optionBox != this.queryBox) {
            this.queryBox.draw(graphics);
        }
        if (this.optionBox != this.resultBox) {
            this.resultBox.draw(graphics);
        }
        if (this.optionBox == this.legendBox) {
            this.legendBox.draw(graphics);
        } else if (this.optionBox == this.mapBox) {
            this.mapBox.draw(graphics);
        } else if (this.optionBox == this.queryBox) {
            this.queryBox.draw(graphics);
        } else if (this.optionBox == this.resultBox) {
            this.resultBox.draw(graphics);
        }
    }

    protected void repaintTabs() {
        this.repaintTabs(this.getGraphics());
    }

    protected void hideTabs() {
        this.resultBox.hide();
        this.legendBox.hide();
        this.queryBox.hide();
        this.mapBox.hide();
    }

    protected void showTabs() {
        this.legendBox.show();
        this.mapBox.show();
        this.queryBox.show();
        this.resultBox.show();
        if (this.optionBox != null) {
            this.optionBox.activate();
        }
    }

    public void activateTabBox(TabbedBox tabbedBox) {
        if (this.optionBox == tabbedBox) {
            return;
        }
        if (this.optionBox != null) {
            this.optionBox.inactivate();
        }
        this.optionBox = tabbedBox;
        tabbedBox.activate();
        this.repaintTabs();
    }

    protected void setMenuCheck(int n, boolean bl) {
    }

    protected String getTitle() {
        return TITLE;
    }

    protected void undo() {
        if (this.dg.isUndoAvailable()) {
            this.dg.undo();
            this.repaintDg();
        } else {
            this.doFeedback("Require action before undo");
        }
    }

    protected int getNumToolButtons() {
        return 6;
    }

    protected void genToolBar() {
        for (int i = 0; i < this.getNumToolButtons(); ++i) {
            this.add(this.toolButton[i]);
        }
        this.maxMin = null;
    }

    protected void genMainGUI() {
        this.helpBox = new HelpBox();
        this.add(this.helpBox);
        this.popupHelp = new PopupHelp(this.helpBox, this.getViewDimensions());
        this.titleBox = new TitleBox(this);
        this.add(this.titleBox);
        this.add(this.dgScrollBarRight);
        this.add(this.dgScrollBarBottom);
        this.leftTextBox = new TextBox(this, true);
        this.rightTextBox = new TextBox(this, true);
        this.tocBox = new TextBox(this, false);
        if (!this.tocOn) {
            this.tocBox.hide();
        }
        this.legendBox = new LegendBox(this);
        this.mapBox = new MapBox(this);
        this.queryBox = new QueryBox(this);
        this.resultBox = new ResultBox(this);
        this.feedback = new Feedback(this);
        this.nameBox = new Feedback(this);
        this.genToolBar();
    }

    protected abstract void genMenuButtons();

    protected void genDropDowns() {
    }

    protected void genModeHandlers() {
        this.modeHandler = new ViewModeHandler();
        this.modeHandler.init(this);
    }

    protected void genGUI() {
        this.genModeHandlers();
        this.genMenuButtons();
        this.genDropDowns();
        this.genMainGUI();
        this.validate();
        this.setLayout(null);
    }

    protected void paintToolButtons(Graphics graphics) {
    }

    protected void layoutToolButtons(int n, int n2) {
        for (int i = 0; i < this.getNumToolButtons(); ++i) {
            this.toolButton[i].move(n, n2);
            Dimension dimension = this.toolButton[i].size();
            n += dimension.width + 2;
        }
        if (this.maxMin != null) {
            Dimension dimension = this.maxMin.size();
            this.maxMin.move(this.topWidth + 4 - dimension.width, n2);
        }
    }

    public void paintTopControls(Graphics graphics) {
    }

    protected void layoutTopControls() {
        int n = 4;
        int n2 = 4;
        if (this.editMenuButton != null) {
            this.editMenuButton.resizeButton();
            this.editMenuButton.move(n, n2);
            this.add(this.editMenuButton);
            Rectangle rectangle = this.editMenuButton.bounds();
            n += rectangle.x + rectangle.width + 4;
        }
        this.layoutToolButtons(n, n2);
    }

    protected void setLeftBox() {
        EntityInstance entityInstance = this.dg.getRoot();
        String string = entityInstance.getLabel();
        String string2 = entityInstance.getDescription();
        String string3 = entityInstance.getTitle();
        if (string2.length() == 0) {
            string2 = entityInstance.getParent() == null ? "The " + string + " landscape." : "The " + string + " " + entityInstance.getEntityClass().getLabel();
        }
        String string4 = string3 != null ? string3 + " (" + string + ")" : string;
        this.leftTextBox.set(string4, string2);
    }

    protected void layoutGUI() {
        int n;
        int n2;
        int n3;
        MsgOut.dprintln("Layout");
        this.viewportDim = this.getViewDimensions();
        int n4 = (int)((double)this.viewportDim.width * 0.2);
        int n5 = this.legendBox.isVisible() ? Math.max(200, n4) + 4 : 0;
        int n6 = this.tocBox.isVisible() ? 179 : 0;
        int n7 = (int)((double)this.viewportDim.height * 0.12);
        int n8 = !this.leftTextBox.isVisible() ? 0 : Math.min(110, n7) + 4;
        int n9 = this.feedback.isVisible() ? Util.fontHeight(this.feedback.getFont()) + 10 : 0;
        int n10 = this.viewportDim.width - n5 - n6 - 8;
        int n11 = this.viewportDim.height - 8;
        this.topWidth = n10;
        this.move(0, 0);
        this.resize(this.viewportDim.width, this.viewportDim.height);
        if (this.editMenuButton != null) {
            n3 = 4;
            n2 = 45;
        } else {
            Insets insets = this.af.getContentPane().getInsets();
            n3 = insets.left + 4;
            n2 = insets.top + 25 + 8;
        }
        if (n6 > 0) {
            this.tocBox.reshape(n3, n2, n6 - 4, n11 - n2);
        }
        if (n5 > 0) {
            int n12 = n11 - n2;
            this.legendBox.reshape(n3 + n6 + n10 + 4, n2, n5 - 4, n12);
            this.queryBox.reshape(n3 + n6 + n10 + 4, n2, n5 - 4, n12);
            this.mapBox.reshape(n3 + n6 + n10 + 4, n2, n5 - 4, n12);
            this.resultBox.reshape(n3 + n6 + n10 + 4, n2, n5 - 4, n12);
        }
        int n13 = (n10 - 4) / 2;
        if (n8 > 0) {
            n = Math.max(n8 - 4, this.leftTextBox.bounds().height);
            this.leftTextBox.reshape(n3 + n6, n2, n13, n);
            n = Math.max(n8 - 4, this.rightTextBox.bounds().height);
            this.rightTextBox.reshape(n3 + n6 + n13 + 4, n2, n10 - n13 - 4, n);
            n2 += n8;
        }
        if (n9 > 0) {
            this.feedback.reshape(n3 + n6, n2, n13, n9);
            this.nameBox.reshape(n3 + n6 + n13 + 4, n2, n10 - n13 - 4, n9);
            n2 += n9 + 4;
        }
        n = this.viewportDim.width - n5 - n6 - 8;
        int n14 = n11 - n2;
        if (this.dg != null) {
            this.dg.reshape(n3 + n6, n2, n, n14);
        }
        this.layoutTopControls();
    }

    protected void editLandscape() {
        MsgOut.dprintln("Edit: " + this.editURL);
        this.showURL(this.editURL, 1);
    }

    protected void about() {
        if (this.aboutURL != null) {
            this.showURL(this.aboutURL, 2);
        }
    }

    protected void help() {
        if (this.helpURL != null) {
            this.showURL(this.helpURL, 1);
        }
    }

    protected void toggleVisibility(LandscapeBoxDrawer landscapeBoxDrawer) {
        if (landscapeBoxDrawer.isVisible()) {
            landscapeBoxDrawer.hide();
        } else {
            landscapeBoxDrawer.show();
        }
    }

    protected void toggleVisibility(MyComponent myComponent) {
        if (myComponent.isVisible()) {
            myComponent.hide();
        } else {
            myComponent.show();
        }
        this.repaint();
    }

    protected void readyMsg() {
        this.doFeedback(this.getTitle() + " " + 6 + "." + 0 + " (build " + 13 + ") Started.");
    }

    protected void fillTOC(EntityInstance entityInstance, StringBuffer stringBuffer, String string) {
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (entityInstance2.hasChildren()) {
                stringBuffer.append(string + entityInstance2.getLabel() + " {\n");
                this.fillTOC(entityInstance2, stringBuffer, string + indAdd);
                stringBuffer.append(string + "}\n");
                continue;
            }
            stringBuffer.append(string + entityInstance2.getLabel() + "\n");
        }
    }

    protected void fillTOC() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string = Util.prefixOf(this.dg.getName());
        EntityInstance entityInstance = this.dg.getRoot();
        EntityInstance entityInstance2 = null;
        Enumeration enumeration = entityInstance.getChildren();
        boolean bl = true;
        while (bl && enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            object = Util.prefixOf(entityInstance2.getLabel());
            if (!string.equals(object)) continue;
            bl = false;
        }
        if (entityInstance2 != null) {
            EntityInstance entityInstance3;
            stringBuffer.append(entityInstance2.getLabel() + " {\n");
            this.fillTOC(entityInstance2, stringBuffer, indAdd);
            stringBuffer.append("}\n\n");
            object = new Vector();
            Vector<EntityInstance> vector = new Vector<EntityInstance>();
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance3 = (EntityInstance)enumeration.nextElement();
                if (entityInstance3 == entityInstance2) continue;
                if (entityInstance3.isClientOf(entityInstance2)) {
                    ((Vector)object).addElement(entityInstance3);
                    continue;
                }
                vector.addElement(entityInstance3);
            }
            if (((Vector)object).size() > 0) {
                stringBuffer.append("\nClients:\n\n");
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    entityInstance3 = (EntityInstance)enumeration.nextElement();
                    stringBuffer.append(entityInstance3.getLabel() + " {\n");
                    this.fillTOC(entityInstance3, stringBuffer, indAdd);
                    stringBuffer.append("}\n");
                }
            } else {
                stringBuffer.append("\nClients: NONE\n");
            }
            if (vector.size() > 0) {
                stringBuffer.append("\nServices:\n\n");
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    entityInstance3 = (EntityInstance)enumeration.nextElement();
                    stringBuffer.append(entityInstance3.getLabel() + " {\n");
                    this.fillTOC(entityInstance3, stringBuffer, indAdd);
                    stringBuffer.append("}\n");
                }
            } else {
                stringBuffer.append("\nServices: NONE");
            }
        } else {
            stringBuffer.append(string + " {\n");
            this.fillTOC(entityInstance, stringBuffer, indAdd);
            stringBuffer.append("}\n");
        }
        this.tocBox.set("Table of contents:", new String(stringBuffer), null, true);
    }

    protected void init_core(boolean bl) {
        this.setBackground(Color.lightGray);
        if (bl) {
            this.ac = this.getAppletContext();
        }
        this.dgScrollBarRight = new Scrollbar(1);
        this.dgScrollBarBottom = new Scrollbar(0);
        this.dgScrollBarRight.hide();
        this.dgScrollBarBottom.hide();
        EntityInstance.generateFonts();
        this.genGUI();
        this.showInfo("");
    }

    protected void initialLoad() {
        if (this.lsPath == null) {
            this.layoutGUI();
            MsgOut.dprintln("Empty landscape");
            this.leftTextBox.set("Empty Landscape", "Select 'Open landscape' from 'File' menu to load a new landscape.");
            this.readyMsg();
        } else {
            MsgOut.dprintln("Load: " + this.lsPath);
            String string = this.dg.loadDiagram(this.lsPath, this.lsPath_bg, null);
            this.layoutGUI();
            this.fillTOC();
            if (string != null) {
                this.error("Load failed (" + string + ") for: " + this.lsPath);
                System.out.println("Load failed (" + string + ") for: " + this.lsPath);
            } else {
                this.dg.setToViewport();
                this.setLeftBox();
                this.readyMsg();
                if (this.startEntity != null && !this.dg.navigateTo(this.startEntity)) {
                    this.error("Entity not found: '" + this.startEntity + "'");
                }
            }
        }
        this.layoutTopControls();
        if (this.legendBox.isVisible()) {
            this.activateTabBox(this.legendBox);
        }
        this.requestFocus();
        this.setEdgeModeMenu(this.dg.getEdgeMode());
    }

    protected void goTo(Vector vector) {
        this.doFeedback("");
        EntityInstance entityInstance = (EntityInstance)vector.elementAt(0);
        EntityInstance entityInstance2 = entityInstance.getParent();
        if (entityInstance2 != this.dg.getRoot()) {
            this.dg.navigateTo(entityInstance2);
        }
        this.dg.clearFlags();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.setHighlightFlag();
        }
        Util.sortVector(vector);
        this.showList("FIND RESULTS:", vector);
        this.setLeftBox();
        this.rightTextBox.set("", "");
        this.redrawDg();
    }

    protected void find() {
        SearchCookie searchCookie = FindBox.Create(this, "Find Landscape Entities");
        if (searchCookie.subPatterns.size() > 0) {
            this.findResults = new Find(searchCookie, this.dg.getTopInstance());
            if (this.findResults.foundCount() > 0) {
                this.goTo(this.findResults.firstResult());
            } else {
                this.error("No entities found which match search pattern.");
            }
        }
    }

    protected void findNext() {
        if (this.findResults == null) {
            this.error("No search has occured.");
            return;
        }
        if (this.findResults.foundCount() == 0) {
            this.error("No search results.");
            return;
        }
        if (!this.findResults.haveNextResult()) {
            this.error("No more results available.");
            return;
        }
        this.goTo(this.findResults.nextResult());
    }

    protected void findPrev() {
        if (this.findResults == null) {
            this.error("No search has occured.");
            return;
        }
        if (this.findResults.foundCount() == 0) {
            this.error("No search results.");
            return;
        }
        if (!this.findResults.havePrevResult()) {
            this.error("At first result.");
            return;
        }
        this.goTo(this.findResults.prevResult());
    }

    public void init() {
        MsgOut.dprintln("Applet initialization starts");
        this.init_core(true);
        MsgOut.dprintln("Applet initialization ends");
    }

    public void init_app(JFrame jFrame, Dimension dimension) {
        MsgOut.dprintln("App initialization starts");
        this.af = jFrame;
        this.diagDim = dimension;
        this.init_core(false);
        MsgOut.dprintln("App initialization ends");
    }

    public void start() {
        this.waitCursorOn();
        this.dg = new ScrollableDiagram(this, this.dgScrollBarRight, this.dgScrollBarBottom);
        if (this.modeHandler != null) {
            this.modeHandler.select(this.dg);
        }
        this.initialLoad();
        this.waitCursorOff();
        this.appInitialized = true;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (!this.appInitialized) {
            return;
        }
        Dimension dimension = this.getViewDimensions();
        if (dimension.width != this.viewportDim.width || dimension.height != this.viewportDim.height) {
            this.layoutGUI();
        }
        Rectangle rectangle = graphics.getClipRect();
        this.paintTopControls(graphics);
        Rectangle rectangle2 = this.dg.bounds();
        if (rectangle.intersects(rectangle2)) {
            this.dg.draw(graphics);
        }
        if (this.editMenuButton != null) {
            this.editMenuButton.repaint();
        }
        if (this.tocBox.isVisible()) {
            this.tocBox.draw(graphics);
        }
        if (this.feedback.isVisible()) {
            this.feedback.draw(graphics);
        }
        if (this.nameBox.isVisible()) {
            this.nameBox.draw(graphics);
        }
        if (this.legendBox.isVisible()) {
            this.repaintTabs(graphics);
        }
        if (this.leftTextBox.isVisible()) {
            this.leftTextBox.draw(graphics);
        }
        if (this.rightTextBox.isVisible()) {
            this.rightTextBox.draw(graphics);
        }
    }

    public void repaintDg() {
        this.waitCursorOn();
        Graphics graphics = this.getGraphics();
        this.dg.draw(graphics);
        if (this.leftTextBox.isVisible()) {
            this.leftTextBox.draw(graphics);
        }
        if (this.rightTextBox.isVisible()) {
            this.rightTextBox.draw(graphics);
        }
        if (this.mapBox.isVisible() && this.optionBox == this.mapBox) {
            this.mapBox.draw(graphics);
        }
        graphics.dispose();
        this.waitCursorOff();
    }

    public void repaintEntity(EntityInstance entityInstance) {
        Graphics graphics = this.getGraphics();
        this.dg.draw(graphics, entityInstance);
        graphics.dispose();
    }

    public void redrawDg() {
        this.waitCursorOn();
        this.dg.rescale();
        this.repaintDg();
    }

    public void repaintFull() {
        MsgOut.dprintln("Landscape ViewerCore repaintFull");
        Dimension dimension = this.size();
        Graphics graphics = this.getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.dispose();
        if (this.editMenuButton != null) {
            this.editMenuButton.repaint();
        }
        this.dg.rescale();
        this.repaint();
    }

    public void saveForUndo() {
        this.dg.saveForUndo();
    }

    public ResultBox getListBox() {
        return this.resultBox;
    }

    public Point getMousePos() {
        return this.lastMousePos;
    }

    protected boolean isReadWrite() {
        return false;
    }

    public void showURL(String string, int n) {
        MsgOut.vprintln("URL: " + string + " - target: " + n);
        try {
            URL uRL = new URL(this.getDocumentBase(), string);
            switch (n) {
                case 0: {
                    this.ac.showDocument(uRL, "_top");
                    break;
                }
                case 1: {
                    this.ac.showDocument(uRL, "_blank");
                    break;
                }
                case 2: {
                    this.ac.showDocument(uRL, "Map");
                    break;
                }
                case 4: {
                    this.ac.showDocument(uRL, "List");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            MsgOut.println("Malformed URL: " + string);
        }
        catch (IOException iOException) {
            MsgOut.println("Couldn't access URL: " + string);
        }
    }

    public void maxMinLandscape() {
        String string = this.dg.getName();
        String string2 = "$LSPATH$/$IDPREFIX$.$LSSUFFIX_ALT$";
        String string3 = Util.expand(string2, string, this);
        System.out.println(string3);
        this.showURL(string3, 0);
    }

    public void showList(String string, Vector vector, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                stringBuffer.append(string2 + "\n");
            }
        } else {
            stringBuffer.append("No entities");
        }
        this.resultBox.set(string, new String(stringBuffer), null, bl);
    }

    public void showList(String string, Vector vector) {
        this.showList(string, vector, true);
    }

    public void doFeedback(String string) {
        this.feedback.set(string);
    }

    public void showInfo(String string) {
        if (!this.rightTextBox.isVisible() || !this.rightTextBox.isOpen()) {
            this.nameBox.set(string);
        }
    }

    public void setHelpPopup(String string, int n, int n2) {
        this.popupHelp.set(string, n, n2);
    }

    public void clearHelpPopup() {
        this.popupHelp.clear();
    }

    public void error(String string) {
        this.doFeedback(string);
        System.out.print("\u0007");
        System.out.flush();
    }

    public void clearFeedback() {
        this.feedback.set("");
    }

    protected String filePrompt(String string, String string2, int n) {
        Container container = this;
        while (!((container = container.getParent()) instanceof Frame)) {
        }
        Frame frame = (Frame)container;
        int n2 = n == 0 ? 0 : 1;
        FileDialog fileDialog = new FileDialog(frame, string, n2);
        if (string2 != null) {
            fileDialog.setFile(string2);
        }
        fileDialog.show();
        String string3 = fileDialog.getFile();
        if (string3 != null) {
            string3 = fileDialog.getDirectory() + string3;
        }
        return string3;
    }

    protected void checkForPopupHelp(int n, int n2) {
        String string = null;
        if (this.leftTextBox.isMouseOver(n, n2)) {
            string = leftTextBoxHelp;
        } else if (this.rightTextBox.isMouseOver(n, n2)) {
            string = rightTextBoxHelp;
        } else if (this.feedback.isMouseOver(n, n2)) {
            string = feedbackHelp;
            String string2 = this.feedback.get();
            if (string2 != null) {
                string = string + "\n\n" + string2;
            }
        } else if (this.nameBox.isMouseOver(n, n2)) {
            string = nameBoxHelp;
        }
        if (string == null) {
            this.popupHelp.clear();
        } else {
            this.popupHelp.set(string, n, n2);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        boolean bl = (event.modifiers & 4) != 0;
        int n3 = this.dg.adjustX(n);
        int n4 = this.dg.adjustY(n2);
        if (this.optionBox.mouseDown(event, n, n2)) {
            return true;
        }
        EntityInstance entityInstance = this.dg.mouseOverEx(n3, n4);
        if (entityInstance != null) {
            RelationInstance relationInstance = this.dg.mouseOverEdge(entityInstance, n3, n4);
            this.showDescription(entityInstance, relationInstance, true);
            this.modeHandlingActive = true;
            this.mouseClickActive = true;
            this.modeHandler.start();
            if (!this.modeHandler.mouseDown(event, n3, n4)) {
                this.modeHandler.cleanup();
                this.modeHandlingActive = false;
            }
        } else if (this.legendBox.isOverTab(n, n2)) {
            this.activateTabBox(this.legendBox);
        } else if (this.mapBox.isOverTab(n, n2)) {
            this.activateTabBox(this.mapBox);
        } else if (this.queryBox.isOverTab(n, n2)) {
            this.activateTabBox(this.queryBox);
        } else if (this.resultBox.isOverTab(n, n2)) {
            this.activateTabBox(this.resultBox);
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        int n3;
        int n4;
        if (this.modeHandlingActive && this.modeHandler.mouseDrag(event, n4 = this.dg.adjustX(n), n3 = this.dg.adjustY(n2))) {
            return true;
        }
        if (this.optionBox.mouseDrag(event, n, n2)) {
            return true;
        }
        return this.mouseMove(event, n, n2);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        int n3 = this.dg.adjustX(n);
        int n4 = this.dg.adjustY(n2);
        if (this.optionBox.mouseUp(event, n, n2)) {
            return true;
        }
        if (this.mouseClickActive) {
            if (event.when - this.lastUp < 300L) {
                this.setCursor(0);
                this.modeHandler.mouseDoubleClick(event, n3, n4);
                this.lastUp = 0L;
                this.modeHandler.cleanup();
                this.modeHandlingActive = false;
            } else {
                this.lastUp = event.when;
            }
            this.mouseClickActive = false;
        }
        if (this.modeHandlingActive) {
            this.modeHandler.mouseUp(event, n3, n4);
            this.modeHandler.cleanup();
            this.modeHandlingActive = false;
        } else {
            this.optionBox.mouseUp(event, n, n2);
        }
        if (this.dg.adjustY(n2) > 0) {
            this.toolButton[0].requestFocus();
            this.requestFocus();
        }
        return true;
    }

    protected void showDescription(EntityInstance entityInstance, RelationInstance relationInstance, boolean bl) {
        if (relationInstance != null) {
            if (relationInstance != this.currentEdge) {
                this.currentEdge = relationInstance;
                this.currentNameEntity = null;
                EntityInstance entityInstance2 = this.dg.getRoot();
                EntityInstance entityInstance3 = relationInstance.getSrc().getVisibleEntity();
                EntityInstance entityInstance4 = relationInstance.getDst().getVisibleEntity();
                this.showInfo(Util.quoted(entityInstance3.getLabel()) + " " + relationInstance.getRelationClass().getLabel() + " " + Util.quoted(entityInstance4.getLabel()));
            }
        } else {
            String string;
            Object object;
            if (entityInstance != this.currentNameEntity) {
                this.currentNameEntity = entityInstance;
                this.currentEdge = null;
                string = entityInstance == null ? "" : ((object = entityInstance.getEnterableParent()) != null ? ((LandscapeObject)object).getLabel() + " . " + entityInstance.getLabel() : entityInstance.getLabel());
                this.showInfo(string);
            }
            if (entityInstance == null) {
                return;
            }
            if (this.currentDescEntity != entityInstance && (!entityInstance.isOpen() || bl) && entityInstance.getEntityClass() != null) {
                string = entityInstance.getLabel();
                object = entityInstance.getTitle();
                String string2 = entityInstance.getDescription();
                if (string2.length() == 0) {
                    string2 = "The " + entityInstance.getLabel() + " " + entityInstance.getEntityClass().getLabel() + ".";
                }
                String string3 = " (" + entityInstance.getEntityClass().getLabel() + (entityInstance.hasChildren() ? " - " + entityInstance.numChildren() + " items)" : ")");
                string3 = object != null ? (String)object + string3 : string + string3;
                this.rightTextBox.set(string3, string2);
                this.currentDescEntity = entityInstance;
            }
        }
    }

    public boolean mouseMove(Event event, int n, int n2) {
        int n3 = this.dg.adjustX(n);
        int n4 = this.dg.adjustY(n2);
        this.lastMousePos.x = n3;
        this.lastMousePos.y = n4;
        if (this.optionBox.isMouseOver(n, n2)) {
            this.optionBox.mouseMotion(event, n, n2);
            return true;
        }
        this.checkForPopupHelp(n, n2);
        if (this.leftTextBox.mouseMotion(event, n, n2)) {
            return true;
        }
        if (this.rightTextBox.mouseMotion(event, n, n2)) {
            return true;
        }
        EntityInstance entityInstance = this.dg.mouseOverEx(n3, n4);
        RelationInstance relationInstance = this.dg.mouseOverEdge(entityInstance, n3, n4);
        this.showDescription(entityInstance, relationInstance, false);
        if (entityInstance != null) {
            this.modeHandler.mouseMotion(entityInstance, n3, n4);
            if (!entityInstance.isOpen()) {
                if (entityInstance.isClippedLabel()) {
                    this.titleBox.set(entityInstance, this.dg);
                }
            } else {
                this.titleBox.hide();
            }
        } else {
            this.titleBox.hide();
            this.setCursor(0);
        }
        return true;
    }

    protected void toggleOption(int n) {
        switch (n) {
            case 1100: {
                this.toggleVisibility(this.leftTextBox);
                this.toggleVisibility(this.rightTextBox);
                this.setMenuCheck(1100, this.leftTextBox.isVisible());
                break;
            }
            case 1101: {
                this.toggleVisibility(this.feedback);
                this.toggleVisibility(this.nameBox);
                this.setMenuCheck(1101, this.feedback.isVisible());
                break;
            }
            case 1102: {
                if (this.legendBox.isVisible()) {
                    this.hideTabs();
                    this.setMenuCheck(1102, false);
                    break;
                }
                this.showTabs();
                this.setMenuCheck(1102, true);
                break;
            }
            case 1108: {
                this.show_animation = !this.show_animation;
                this.setMenuCheck(1108, this.show_animation);
                break;
            }
            case 1103: {
                this.toggleVisibility(this.tocBox);
                this.setMenuCheck(1103, this.tocBox.isVisible());
                break;
            }
            case 1104: {
                this.showClients = !this.showClients;
                this.setMenuCheck(1104, this.showClients);
                break;
            }
            case 1105: {
                this.showSuppliers = !this.showSuppliers;
                this.setMenuCheck(1105, this.showSuppliers);
                break;
            }
            case 1106: {
                this.showCardinals = !this.showCardinals;
                this.setMenuCheck(1106, this.showCardinals);
                break;
            }
            case 1107: {
                this.setGlobalOption(1107, !this.topClients);
            }
        }
    }

    protected void setEdgeModeMenu(int n) {
        for (int i = 0; i <= 2; ++i) {
            this.setMenuCheck(1120 + i, false);
        }
        this.setMenuCheck(1120 + n, true);
    }

    protected boolean processAltKey(int n) {
        switch (n) {
            case 108: {
                this.activateTabBox(this.legendBox);
                return true;
            }
            case 109: {
                this.activateTabBox(this.mapBox);
                return true;
            }
            case 113: {
                this.activateTabBox(this.queryBox);
                return true;
            }
            case 114: {
                this.activateTabBox(this.resultBox);
                return true;
            }
        }
        return false;
    }

    public boolean processKey(int n, int n2) {
        boolean bl = (n2 & 2) != 0;
        boolean bl2 = (n2 & 1) != 0;
        switch (n) {
            case 1002: 
            case 1003: {
                this.rightTextBox.keyProcess(n);
                return true;
            }
            case 81: {
                this.queryBox.toggleGroupingFlag();
                return true;
            }
            case 21: 
            case 26: {
                this.undo();
                return true;
            }
            case 117: {
                if (bl) {
                    return this.processKey(21, n2);
                }
                return false;
            }
            case 18: {
                this.layoutGUI();
                this.repaint();
                return true;
            }
            case 114: {
                if (bl) {
                    return this.processKey(18, n2);
                }
                return false;
            }
            case 47: {
                boolean bl3 = Util.adjustFontToggle();
                this.doFeedback("Font adjustment set to " + (bl3 ? "on" : "off") + ".");
                if (this.editMenuButton != null) {
                    this.editMenuButton.resizeButton();
                }
                this.setMenuCheck(47, bl3);
                this.repaintFull();
                return true;
            }
            case 27: {
                this.dg.clearFlags();
                this.doFeedback("Query/selection cleared");
                this.redrawDg();
                this.resultBox.clear();
                this.modeHandler.reset();
                return true;
            }
            case 1100: 
            case 1101: 
            case 1102: 
            case 1103: 
            case 1108: {
                this.toggleOption(n);
                this.layoutGUI();
                this.repaintFull();
                return true;
            }
            case 1104: 
            case 1105: 
            case 1107: {
                this.toggleOption(n);
                this.navigateTo(this.dg.getRoot());
                this.repaintDg();
                return true;
            }
            case 1106: {
                this.toggleOption(n);
                this.repaintDg();
                return true;
            }
            case 1120: 
            case 1121: 
            case 1122: {
                String string;
                int n3 = n - 1120;
                switch (n3) {
                    case 0: {
                        string = "best edge";
                        break;
                    }
                    case 1: {
                        string = "top/bottom";
                        break;
                    }
                    case 2: {
                        string = "direct";
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                this.dg.setEdgeMode(n3);
                this.setEdgeModeMenu(n3);
                this.navigateTo(this.dg.getRoot());
                this.doFeedback("Edge mode set to: " + string + ".");
                this.repaintDg();
                return true;
            }
            case 33: {
                return this.processKey(49, 1);
            }
            case 64: {
                return this.processKey(50, 1);
            }
            case 35: {
                return this.processKey(51, 1);
            }
            case 36: {
                return this.processKey(52, 1);
            }
            case 37: {
                return this.processKey(53, 1);
            }
            case 94: {
                return this.processKey(54, 1);
            }
            case 38: {
                return this.processKey(55, 1);
            }
            case 42: {
                return this.processKey(56, 1);
            }
            case 40: {
                return this.processKey(57, 1);
            }
            case 41: {
                return this.processKey(48, 1);
            }
            case 1008: {
                return true;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (bl2) {
                    this.activateTabBox(this.queryBox);
                    this.queryBox.toggleRelationActivity(this.dg, n == 48 ? 10 : n - 49);
                } else {
                    this.activateTabBox(this.legendBox);
                    this.legendBox.toggleRelationVisibility(this.dg, n == 48 ? 10 : n - 49);
                }
                this.repaintDg();
                this.requestFocus();
                return true;
            }
            case 83: {
                this.dg.setToViewport();
                this.repaintDg();
                this.doFeedback("Landscape adjusted to viewport");
                return true;
            }
            case 6: {
                this.find();
                return true;
            }
            case 1010: {
                this.findNext();
                return true;
            }
            case 1009: {
                this.findPrev();
                return true;
            }
            case 1140: {
                boolean bl4 = this.dg.toggleQueryPersistence();
                this.doFeedback("Query persistence set to: " + (bl4 ? "On" : "Off"));
                this.setMenuCheck(1140, bl4);
                return true;
            }
            case -1: {
                this.about();
                return true;
            }
            case -2: {
                this.help();
                return true;
            }
            case 256: {
                this.maxMinLandscape();
                return true;
            }
        }
        return false;
    }

    public boolean keyDown(Event event, int n) {
        if ((event.modifiers & 8) != 0) {
            return this.processAltKey(n);
        }
        if (this.modeHandler.processKey(n, event.modifiers)) {
            return true;
        }
        return this.processKey(n, event.modifiers);
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public boolean doHandleEvent(Event event, Graphics graphics) {
        if (this.leftTextBox.handleEvent(this.dg, graphics, event)) {
            return true;
        }
        if (this.rightTextBox.handleEvent(this.dg, graphics, event)) {
            return true;
        }
        if (this.tocBox.handleEvent(this.dg, graphics, event)) {
            return true;
        }
        if (this.optionBox.handleEvent(this.dg, graphics, event)) {
            return true;
        }
        if (event.target == this.dgScrollBarRight || event.target == this.dgScrollBarBottom) {
            this.dg.scroll(graphics, event);
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean handleEvent(Event event) {
        if (!this.appInitialized) {
            return false;
        }
        Graphics graphics = this.getGraphics();
        boolean bl = this.doHandleEvent(event, graphics);
        graphics.dispose();
        return bl;
    }

    public void dialogAction(Object[] objectArray, int n) {
    }

    public void processMenuSelection(MenuButton menuButton, int n) {
        this.processKey(n, 0);
    }

    public ScrollableDiagram getDiagram() {
        return this.dg;
    }

    protected void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Graphics getDiagramContext() {
        return this.dg.getContext(this.getGraphics());
    }

    protected void expandAnimate(EntityInstance entityInstance) {
        if (!this.show_animation) {
            return;
        }
        Graphics graphics = this.getDiagramContext();
        graphics.setXORMode(entityInstance.getBackground());
        Layout layout = entityInstance.getLayout();
        Rectangle rectangle = this.dg.bounds();
        double d = layout.x / (double)EC_CNT;
        double d2 = ((double)rectangle.width - (layout.x + layout.width)) / (double)EC_CNT;
        double d3 = layout.y / (double)EC_CNT;
        double d4 = ((double)rectangle.height - (layout.y + layout.height)) / (double)EC_CNT;
        this.dg.drawEntityOutline(graphics, layout, entityInstance);
        for (int i = 1; i < EC_CNT; ++i) {
            this.dg.drawEntityOutline(graphics, layout, entityInstance);
            layout.x -= d;
            layout.y -= d3;
            layout.width += d + d2;
            layout.height += d3 + d4;
            this.dg.drawEntityOutline(graphics, layout, entityInstance);
            this.sleep(5);
        }
    }

    protected void contractAnimate(EntityInstance entityInstance) {
        if (!this.show_animation) {
            return;
        }
        Graphics graphics = this.getDiagramContext();
        graphics.setXORMode(entityInstance.getBackground());
        Layout layout = entityInstance.getLayout();
        Rectangle rectangle = this.dg.bounds();
        double d = layout.x / (double)EC_CNT;
        double d2 = ((double)rectangle.width - (layout.x + layout.width)) / (double)EC_CNT;
        double d3 = layout.y / (double)EC_CNT;
        double d4 = ((double)rectangle.height - (layout.y + layout.height)) / (double)EC_CNT;
        Layout layout2 = new Layout(0.0, 0.0, rectangle.width, rectangle.height);
        this.dg.drawEntityOutline(graphics, layout2, entityInstance);
        for (int i = 1; i < EC_CNT; ++i) {
            this.dg.drawEntityOutline(graphics, layout2, entityInstance);
            layout2.x += d;
            layout2.y += d3;
            layout2.width -= d + d2;
            layout2.height -= d3 + d4;
            this.dg.drawEntityOutline(graphics, layout2, entityInstance);
            this.sleep(5);
        }
    }

    protected void navigateTo(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = this.dg.getRoot();
        if (entityInstance == this.dg.getRoot().getParent()) {
            this.dg.navigateTo(entityInstance);
            this.contractAnimate(entityInstance2);
        } else {
            this.expandAnimate(entityInstance);
            this.dg.navigateTo(entityInstance);
        }
        this.setLeftBox();
        this.dg.clearFlags();
        this.rightTextBox.set("", "");
        this.resultBox.clear();
        this.activateTabBox(this.mapBox);
        this.doFeedback("Now showing: " + entityInstance.getLabel());
        this.repaint();
    }

    public void followLink(String string, int n) {
        this.showURL(string, n);
    }

    public void followLink(EntityInstance entityInstance, boolean bl) {
        Attribute attribute = entityInstance.getAttribute("navlink");
        if (attribute == null) {
            this.navigateTo(entityInstance);
            return;
        }
        AttributeValueItem attributeValueItem = attribute.avi;
        if (attributeValueItem == null) {
            this.navigateTo(entityInstance);
            return;
        }
        while (attributeValueItem != null) {
            String string = LsLink.expand(attributeValueItem.value, entityInstance, this);
            if (string != null) {
                if (bl) {
                    this.followLink(string, 1);
                } else if (attribute.avi.next != null) {
                    String string2 = Util.expand(attributeValueItem.next.value, this);
                    int n = LsLink.convertTarget(string2);
                    if (n == 5) {
                        this.navigateTo(entityInstance);
                    } else {
                        this.followLink(string, n);
                    }
                } else {
                    this.error("No target: " + attribute.avi.value);
                }
            }
            attributeValueItem = attributeValueItem.nextList;
        }
    }

    public void enter(EntityInstance entityInstance) {
        this.dg.enter(entityInstance);
        this.dg.setToViewport();
        this.repaintDg();
    }

    abstract void doSetCursor(int var1);

    public void setCursor(int n) {
        if (this.curCursor != n) {
            this.curCursor = n;
            if (!this.waitActive) {
                this.doSetCursor(n);
            }
        }
    }

    public void waitCursorOn() {
        if (!this.waitActive) {
            this.waitActive = true;
            this.doSetCursor(3);
        }
    }

    public void waitCursorOff() {
        if (this.waitActive) {
            this.waitActive = false;
            this.doSetCursor(this.curCursor);
        }
    }

    public void processKeyEvent(int n, int n2) {
        if (this.modeHandler.processKey(n, n2)) {
            return;
        }
        this.processKey(n, n2);
    }

    public boolean isViewer() {
        return true;
    }

    public void toggleRightBoxes() {
    }

    public boolean getGroupQueryFlag() {
        return this.queryBox.getGroupingFlag();
    }

    public void setGlobalOption(int n, boolean bl) {
        switch (n) {
            case 1107: {
                this.topClients = bl;
                break;
            }
            case 1104: {
                this.showClients = bl;
                break;
            }
            case 1105: {
                this.showSuppliers = bl;
                break;
            }
            case 1106: {
                this.showCardinals = bl;
            }
        }
        this.setMenuCheck(n, bl);
    }

    public boolean getOption(int n) {
        switch (n) {
            case 1107: {
                return this.topClients;
            }
            case 1104: {
                return this.showClients;
            }
            case 1105: {
                return this.showSuppliers;
            }
            case 1106: {
                return this.showCardinals;
            }
        }
        return false;
    }

    public abstract InternalBufferStream getInternalBufferStream();

    public void setEntitiesColorWhenOpen(EntityClass entityClass, Color color) {
        this.dg.setEntitiesColorWhenOpen(entityClass, color);
    }

    public void setEntitiesColor(EntityClass entityClass, Color color) {
        this.dg.setEntitiesColor(entityClass, color);
    }

    public void setEntitiesLabelColor(EntityClass entityClass, Color color) {
        this.dg.setEntitiesLabelColor(entityClass, color);
    }

    public void setEntitiesStyle(EntityClass entityClass, int n) {
        this.dg.setEntitiesStyle(entityClass, n);
    }

    public void setRelationColor(RelationClass relationClass, Color color) {
        this.dg.setRelationColor(relationClass, color);
    }

    public void setRelationStyle(RelationClass relationClass, int n) {
        this.dg.setRelationStyle(relationClass, n);
    }
}

