/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EditAttribute;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeViewerCore;
import lsedit.Layout;
import lsedit.LegendObject;
import lsedit.RealPoint;
import lsedit.RelationClass;
import lsedit.TabbedBox;
import lsedit.Util;

public class LegendBox
extends TabbedBox {
    protected static final int CB_WD = 15;
    protected static final int CB_HT = 15;
    protected static final int WIDTH = 25;
    protected static final int HEIGHT = 20;
    protected static final Font textFont = new Font("Helvetica", 0, 11);
    protected static final String endEntMsg = "Pass cursor over entity for description.";
    protected static final String endRelMsg1 = "Checkboxes select visible relations.";
    protected static final String endRelMsg2 = "Click relation arrow for description.";
    protected static final String helpStr = "This box shows the types of entities and relations that are present in the current landscape.";
    protected static final int MAX_NUM_CHECKS = 20;
    protected Checkbox[] relnChk = new Checkbox[20];
    protected RelationClass[] relnClass = new RelationClass[20];
    protected Vector objects;
    protected PopupMenu m_popup = null;

    protected void drawContents(Diagram diagram, Graphics graphics, boolean bl) {
        int n;
        Object object;
        String string;
        String string2;
        LandscapeClassObject landscapeClassObject;
        Enumeration enumeration;
        int n2;
        Rectangle rectangle = this.bounds();
        int n3 = 10;
        int n4 = n2 = -this.scrollBar.getValue();
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = Util.fontHeight(textFont);
        int n6 = n5 * 2;
        int n7 = n6 * 4 / 3;
        int n8 = rectangle.width - n7 - 15;
        graphics.setColor(Color.black);
        if (bl) {
            graphics.drawString("Entities", n3, n2 += n5);
            graphics.drawLine(n3, n2 + 3, n3 + fontMetrics.stringWidth("Entities"), n2 + 3);
            n2 += n5 - 2;
        } else {
            n2 += 5;
        }
        int n9 = 0;
        int n10 = 0;
        if (bl) {
            enumeration = diagram.enumEntityClasses();
            this.objects = new Vector();
            while (enumeration.hasMoreElements()) {
                landscapeClassObject = (EntityClass)enumeration.nextElement();
                string2 = landscapeClassObject.getId();
                string = landscapeClassObject.getLabel();
                if (string2.equals("$ENTITY")) continue;
                object = ((EntityClass)landscapeClassObject).newEntity("A", diagram);
                Layout layout = new Layout(n3, n2 + 2, n7, n6);
                ((EntityInstance)object).setAbsoluteLayout(layout);
                ((EntityInstance)object).draw(graphics);
                Rectangle rectangle2 = new Rectangle(rectangle.x + n3, rectangle.y + n2 + 2, n7, n6);
                this.objects.addElement(new LegendObject(rectangle2, landscapeClassObject));
                graphics.setColor(Color.black);
                graphics.setFont(textFont);
                Util.drawStringClipped(graphics, string, n3 + n7 + 5, n2, n8, n5);
                n2 += n6 + 10;
                ++n9;
                ++n10;
            }
            if (n10 == 0) {
                graphics.setColor(Color.blue);
                graphics.draw3DRect(n3, n2, n7, n5, true);
                graphics.fill3DRect(n3 + 1, n2 + 1, n7 - 1, n5 - 1, true);
                graphics.setColor(Color.black);
                Util.drawStringClipped(graphics, "Entity", n3 + n7 + 5, n2, n8, n5);
                n2 += n5 + 5;
                ++n9;
            }
            Util.drawStringClipped(graphics, endEntMsg, n3, n2 += (n6 + n5) / 2, n8, n5);
            n2 += 2 * n5;
        }
        graphics.setColor(Color.black);
        graphics.drawString("Relations", n3, n2 + n5);
        graphics.drawLine(n3, n2 += n5 + 3, n3 + fontMetrics.stringWidth("Relations"), n2);
        n2 += n5 / 2;
        enumeration = diagram.enumRelations();
        n10 = 0;
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            string2 = landscapeClassObject.getId();
            string = landscapeClassObject.getLabel();
            if (diagram.excludeReln((RelationClass)landscapeClassObject)) continue;
            object = string + " (" + (n10 + 1) + ")";
            graphics.setColor(landscapeClassObject.getObjectColor());
            int n11 = n3 + 15 + 5;
            int n12 = n2 + 10;
            int n13 = n11 + 25;
            Rectangle rectangle3 = new Rectangle(rectangle.x + n11, rectangle.y + n2, 25, 20);
            this.relnClass[n10] = landscapeClassObject;
            this.relnChk[n10].resize(15, 15);
            this.relnChk[n10].move(rectangle.x + 5, rectangle.y + this.tabDim.height + n2 + 5 + 3);
            this.relnChk[n10].show();
            this.relnChk[n10].setState(((RelationClass)landscapeClassObject).isVisible());
            this.objects.addElement(new LegendObject(rectangle3, landscapeClassObject));
            RealPoint realPoint = new RealPoint(n11, n12);
            RealPoint realPoint2 = new RealPoint(n13, n12);
            Util.drawArrow(graphics, realPoint, realPoint2);
            graphics.setColor(landscapeClassObject.getLabelColor());
            Util.drawStringClipped(graphics, (String)object, n11 + 25 + 5, n2, n8, n5);
            graphics.setColor(Color.black);
            n2 += n5 + 5;
            ++n9;
            ++n10;
        }
        for (n = n10; n < 20; ++n) {
            this.relnChk[n].hide();
            this.relnClass[n] = null;
        }
        if (n10 == 0) {
            graphics.setColor(Color.black);
            n = n3;
            int n14 = n2 + 10;
            int n15 = n3 + 25;
            int n16 = n2 + 10;
            RealPoint realPoint = new RealPoint(n, n14);
            RealPoint realPoint3 = new RealPoint(n15, n16);
            Util.drawArrow(graphics, realPoint, realPoint3);
            graphics.setColor(Color.black);
            Util.drawStringClipped(graphics, "Relation", n3 + 25 + 5, n2, n8, n5);
            n2 += n5 + 5;
            ++n9;
        }
        if (bl) {
            Util.drawStringClipped(graphics, endRelMsg1, n3, n2 += n5 / 2, n8, n5);
            Util.drawStringClipped(graphics, endRelMsg2, n3, n2 += n5, n8, n5);
        }
        this.setupScrolling(n2 - n4);
    }

    protected void genChecks() {
        for (int i = 0; i < 20; ++i) {
            this.relnChk[i] = new Checkbox();
            this.relnChk[i].hide();
            this.ls.add(this.relnChk[i]);
        }
    }

    public LegendBox(LandscapeViewerCore landscapeViewerCore) {
        super(landscapeViewerCore, "Legend", 5);
        this.genChecks();
    }

    protected LegendObject mouseOverLegendObject(int n, int n2) {
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            LegendObject legendObject = (LegendObject)enumeration.nextElement();
            Rectangle rectangle = legendObject.getRectangle();
            int n3 = rectangle.x;
            int n4 = rectangle.y + 20;
            if (n < n3 || n > n3 + rectangle.width || n2 < n4 || n2 > n4 + rectangle.height) continue;
            return legendObject;
        }
        return null;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        LandscapeClassObject landscapeClassObject;
        LegendObject legendObject;
        boolean bl;
        boolean bl2 = bl = (event.modifiers & 4) != 0;
        if (this.m_popup != null) {
            this.ls.remove(this.m_popup);
            this.m_popup = null;
            this.repaint();
        }
        if (bl && (legendObject = this.mouseOverLegendObject(n, n2)) != null && (landscapeClassObject = legendObject.getLandscapeClass()) != null) {
            if (landscapeClassObject instanceof EntityClass) {
                this.m_popup = new PopupMenu("Class menu");
                MenuItem menuItem = new MenuItem("Display hierarchy");
                menuItem.addActionListener(new DisplayClassHierarchy(menuItem, this.ls, landscapeClassObject, n, n2));
                this.m_popup.add(menuItem);
                menuItem = new MenuItem("Edit attributes");
                menuItem.addActionListener(new EditClassAttributes(this.ls, (EntityClass)landscapeClassObject));
                this.m_popup.add(menuItem);
            } else if (landscapeClassObject instanceof RelationClass) {
                this.m_popup = new PopupMenu("Relation menu");
                MenuItem menuItem = new MenuItem("Display hierarchy");
                menuItem.addActionListener(new DisplayClassHierarchy(menuItem, this.ls, landscapeClassObject, n, n2));
                this.m_popup.add(menuItem);
                menuItem = new MenuItem("Edit attributes");
                menuItem.addActionListener(new EditRelationAttributes(this.ls, (RelationClass)landscapeClassObject));
                this.m_popup.add(menuItem);
            }
            if (this.m_popup != null) {
                this.ls.add(this.m_popup);
                this.m_popup.show(this.ls, n, n2);
                return true;
            }
        }
        return false;
    }

    public boolean mouseMotion(Event event, int n, int n2) {
        String string;
        LegendObject legendObject = this.mouseOverLegendObject(n, n2);
        if (legendObject != null && (string = legendObject.getDescription()) != null) {
            this.ls.setHelpPopup(string, n, n2);
            return true;
        }
        this.ls.setHelpPopup(helpStr, n, n2);
        return true;
    }

    public boolean handleEvent(Diagram diagram, Graphics graphics, Event event) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.handleEvent(diagram, graphics, event)) {
            return true;
        }
        for (int i = 0; i < 20; ++i) {
            if (event.target != this.relnChk[i]) continue;
            if (event.id == 1001) {
                this.ls.processKey(49 + i, 0);
            }
            return true;
        }
        return false;
    }

    public void toggleRelationVisibility(Diagram diagram, int n) {
        if (n == 10) {
            boolean bl = !this.relnClass[0].isVisible();
            int n2 = 0;
            while (this.relnClass[n2] != null) {
                diagram.setEdgeVisibilityState(this.relnClass[n2], bl);
                ++n2;
            }
        } else {
            RelationClass relationClass = this.relnClass[n];
            if (relationClass != null) {
                boolean bl = !relationClass.isVisible();
                diagram.setEdgeVisibilityState(relationClass, bl);
                this.ls.doFeedback("Relation " + relationClass.getLabel() + " set to " + (bl ? "visible" : "hidden"));
            }
        }
        this.repaint();
    }

    public void activate() {
        super.activate();
    }

    public void inactivate() {
        super.inactivate();
        for (int i = 0; i < 20; ++i) {
            this.relnChk[i].hide();
        }
    }

    private class EditRelationAttributes
    implements ActionListener {
        private LandscapeViewerCore m_ls;
        private RelationClass m_relation;

        public EditRelationAttributes(LandscapeViewerCore landscapeViewerCore, RelationClass relationClass) {
            this.m_ls = landscapeViewerCore;
            this.m_relation = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditAttribute.Create(this.m_ls, this.m_relation);
        }
    }

    private class EditClassAttributes
    implements ActionListener {
        private LandscapeViewerCore m_ls;
        private EntityClass m_entity;

        public EditClassAttributes(LandscapeViewerCore landscapeViewerCore, EntityClass entityClass) {
            this.m_ls = landscapeViewerCore;
            this.m_entity = entityClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditAttribute.Create(this.m_ls, this.m_entity);
        }
    }

    private class DisplayClassHierarchy
    implements ActionListener {
        private LandscapeViewerCore m_ls;
        private LandscapeClassObject m_landscapeClass;
        int m_x;
        int m_y;

        public DisplayClassHierarchy(MenuItem menuItem, LandscapeViewerCore landscapeViewerCore, LandscapeClassObject landscapeClassObject, int n, int n2) {
            Enumeration enumeration = landscapeClassObject.getParentElements();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                menuItem.setEnabled(false);
            }
            this.m_ls = landscapeViewerCore;
            this.m_landscapeClass = landscapeClassObject;
            this.m_x = n;
            this.m_y = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Enumeration enumeration = this.m_landscapeClass.getParentElements();
            if (enumeration != null && enumeration.hasMoreElements()) {
                String string = this.m_landscapeClass.getLabel();
                PopupMenu popupMenu = new PopupMenu(string);
                while (enumeration.hasMoreElements()) {
                    LandscapeClassObject landscapeClassObject = (LandscapeClassObject)enumeration.nextElement();
                    MenuItem menuItem = new MenuItem(landscapeClassObject.getLabel());
                    menuItem.addActionListener(new DisplayClassHierarchy(menuItem, this.m_ls, landscapeClassObject, this.m_x, this.m_y));
                    popupMenu.add(menuItem);
                }
                this.m_ls.add(popupMenu);
                popupMenu.show(LegendBox.this.ls, this.m_x, this.m_y);
            }
        }
    }
}

