/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.LsPopupMenuItem;

public abstract class LsPopupMenu
extends Canvas {
    public static final int MARGIN = 4;
    public static final Color backGroundColor = Color.lightGray;
    public static final Color textColor = Color.black;
    public static final Color textGrayedColor = Color.gray;
    protected static final String FONT_NAME = "Dialog";
    protected static final int FONT_SIZE = 10;
    public static final Font font = new Font("Dialog", 0, 10);
    protected static final int X_OFFSET = 10;
    protected static final int Y_OFFSET = 5;
    protected static final int NONE = -1;
    protected Applet applet;
    protected int entries;
    protected int fontHeight;
    protected LsPopupMenuItem currentItem = null;
    protected LsPopupMenuItem firstItem;
    protected int maxWidthLeft = 0;
    protected int maxWidthRight = 0;

    protected void setupMaxWidthCalc() {
        this.maxWidthLeft = 0;
        this.maxWidthRight = 0;
    }

    protected void calcMaxWidth(String string, FontMetrics fontMetrics) {
        int n = string.indexOf("\t");
        if (n >= 0) {
            this.maxWidthLeft = Math.max(fontMetrics.stringWidth(string.substring(0, n)), this.maxWidthLeft);
            this.maxWidthRight = Math.max(fontMetrics.stringWidth(string.substring(n)), this.maxWidthRight);
        } else {
            this.maxWidthLeft = Math.max(fontMetrics.stringWidth(string), this.maxWidthLeft);
        }
    }

    protected int getMaxWidth() {
        if (this.maxWidthRight > 0) {
            return this.maxWidthLeft + this.maxWidthRight + 5 + 16;
        }
        return this.maxWidthLeft + 16;
    }

    protected LsPopupMenuItem overItem(int n, int n2) {
        Rectangle rectangle = this.bounds();
        if (n < rectangle.x || n > rectangle.x + rectangle.width || n2 < rectangle.y || n2 > rectangle.y + rectangle.height) {
            return null;
        }
        LsPopupMenuItem lsPopupMenuItem = this.firstItem;
        while (lsPopupMenuItem != null && !lsPopupMenuItem.isOver(n - rectangle.x, n2 - rectangle.y)) {
            lsPopupMenuItem = lsPopupMenuItem.next;
        }
        return lsPopupMenuItem;
    }

    protected void popup(int n, int n2, int n3, int n4) {
        this.resize(n, n2);
        this.move(n3, n4);
        this.show();
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        graphics.setColor(backGroundColor);
        graphics.fill3DRect(1, 1, rectangle.width - 2, rectangle.height - 2, true);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        LsPopupMenuItem lsPopupMenuItem = this.firstItem;
        while (lsPopupMenuItem != null) {
            lsPopupMenuItem.drawNormal(graphics, 0, 0);
            lsPopupMenuItem = lsPopupMenuItem.next;
        }
    }

    public void trackMotion(int n, int n2) {
        Rectangle rectangle = this.bounds();
        LsPopupMenuItem lsPopupMenuItem = this.overItem(n, n2);
        if (this.currentItem == lsPopupMenuItem) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (this.currentItem != null && this.currentItem.isHighlightable()) {
            this.currentItem.drawNormal(graphics, 0, 0);
        }
        this.currentItem = lsPopupMenuItem;
        if (lsPopupMenuItem != null && lsPopupMenuItem.isHighlightable()) {
            lsPopupMenuItem.drawHighlighted(graphics, 0, 0);
        }
        graphics.dispose();
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.trackMotion(n, n2);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.currentItem = null;
        return false;
    }
}

