/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;
import lsedit.Layout;
import lsedit.ScreenPoint;
import lsedit.ScreenRect;
import lsedit.TabbedBox;
import lsedit.Util;

public class MapBox
extends TabbedBox {
    protected static final double DIV = 2.0;
    protected static final double HALF_VGAP = 7.5;
    protected static final Font textFont = new Font("Helvetica", 0, 10);
    protected static final String helpStr = "This box shows stylized versions of landscapes representing the path from the top of the containment heirarchy to the current landscape, with green boxes highlighting steps in the path.";
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    protected int over = -1;
    protected int mouseDown = -1;
    protected Vector maps;
    protected Vector entities;
    protected boolean drawing = false;

    protected int getIndex(int n, int n2) {
        Enumeration enumeration = this.maps.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            Rectangle rectangle = (Rectangle)enumeration.nextElement();
            if (n >= rectangle.x && n <= rectangle.x + rectangle.width && n2 >= rectangle.y && n2 <= rectangle.y + rectangle.height) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void drawOutline(int n, int n2) {
        Rectangle rectangle = (Rectangle)this.maps.elementAt(n);
        Graphics graphics = this.ls.getGraphics();
        graphics.setColor(Diagram.boxColour);
        if (n2 != 0) {
            graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2 == 1);
        } else {
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void drawEntity(Graphics graphics, EntityInstance entityInstance, Layout layout, double d, double d2, double d3, boolean bl, boolean bl2) {
        Layout layout2 = entityInstance.getLayout();
        layout2.x = (layout2.x - layout.x) * d3 + d;
        layout2.y = (layout2.y - layout.y) * d3 + d2;
        layout2.width *= d3;
        layout2.height *= d3;
        ScreenRect screenRect = new ScreenRect(layout2.x, layout2.y, layout2.width, layout2.height);
        if (bl) {
            graphics.setColor(Color.green);
        } else if (!bl2 && !entityInstance.isOpen()) {
            graphics.setColor(entityInstance.getObjectColor());
        } else if (entityInstance.isEnterable()) {
            float f = 0.7f;
            Color color = new Color(f, f, f);
            graphics.setColor(color);
        } else {
            graphics.setColor(Diagram.boxColour);
        }
        graphics.fillRect(screenRect.x, screenRect.y, screenRect.width, screenRect.height);
        graphics.setColor(Color.black);
        graphics.drawRect(screenRect.x, screenRect.y, screenRect.width, screenRect.height);
    }

    protected void doDrawLevel(Graphics graphics, EntityInstance entityInstance, EntityInstance entityInstance2, EntityInstance entityInstance3, Layout layout, double d, double d2, double d3) {
        if (entityInstance.getParent() != null) {
            this.drawEntity(graphics, entityInstance, layout, d2, d3, d, entityInstance == entityInstance3, entityInstance == entityInstance2);
        }
        if (entityInstance != entityInstance3 && (entityInstance == entityInstance2 || entityInstance.isOpen())) {
            Enumeration enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance4 = (EntityInstance)enumeration.nextElement();
                this.doDrawLevel(graphics, entityInstance4, entityInstance2, entityInstance3, layout, d, d2, d3);
            }
        }
    }

    protected double drawLevel(Graphics graphics, EntityInstance entityInstance, EntityInstance entityInstance2, double d) {
        Layout layout = entityInstance.getLayout();
        double d2 = this.width;
        double d3 = (d2 - d2 / 2.0) / layout.width;
        double d4 = layout.width * d3;
        double d5 = layout.height * d3;
        double d6 = ((double)this.width - d4) / 2.0;
        this.doDrawLevel(graphics, entityInstance, entityInstance, entityInstance2, layout, d3, d6, d);
        return d5;
    }

    protected void drawContents(Diagram diagram, Graphics graphics, boolean bl) {
        int n;
        double d;
        EntityInstance entityInstance;
        this.maps = new Vector();
        this.entities = new Vector();
        diagram.saveLayout();
        diagram.rescale();
        Vector<EntityInstance> vector = new Vector<EntityInstance>();
        for (entityInstance = diagram.getRoot(); entityInstance != null; entityInstance = entityInstance.getParent()) {
            if (!entityInstance.isEnterable()) continue;
            vector.addElement(entityInstance);
        }
        Rectangle rectangle = this.bounds();
        int n2 = vector.size();
        double d2 = d = (double)this.scrollBar.getValue();
        double d3 = Util.fontHeight(textFont);
        graphics.setFont(textFont);
        for (n = n2 - 1; n >= 0; --n) {
            int n3 = (int)(d + 0.5);
            entityInstance = (EntityInstance)vector.elementAt(n);
            EntityInstance entityInstance2 = n == 0 ? null : (EntityInstance)vector.elementAt(n - 1);
            graphics.setColor(Color.black);
            Util.drawStringClipped(graphics, entityInstance.getLabel(), 0.0, d, rectangle.width, d3, true, false);
            double d4 = this.drawLevel(graphics, entityInstance, entityInstance2, d += 7.5 + d3);
            this.maps.addElement(new Rectangle(rectangle.x + 20, rectangle.y + this.tabDim.height + n3 + 5, rectangle.width - 40, (int)(d4 + d3 + 15.0 - 4.0 + 0.5)));
            this.entities.addElement(entityInstance);
            d += d4 + 7.5;
            if (n > 0) {
                ScreenPoint screenPoint = new ScreenPoint(10.0, d);
                ScreenPoint screenPoint2 = new ScreenPoint(rectangle.width - 10, d);
                Util.drawLine(graphics, screenPoint, screenPoint2, 3);
            }
            d += 7.5;
        }
        n = (int)(d - d2);
        diagram.restoreLayout();
        this.setupScrolling(n);
        this.over = -1;
    }

    public MapBox(LandscapeViewerCore landscapeViewerCore) {
        super(landscapeViewerCore, "Map", 54);
    }

    public boolean handleEvent(Diagram diagram, Graphics graphics, Event event) {
        return super.handleEvent(diagram, graphics, event);
    }

    public void activate() {
        super.activate();
    }

    public void inactivate() {
        super.inactivate();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.over >= 0) {
            this.mouseDown = this.over;
            this.drawOutline(this.over, 0);
            this.drawOutline(this.over, 2);
            return true;
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.mouseDown >= 0) {
            if (this.over == this.mouseDown) {
                EntityInstance entityInstance = (EntityInstance)this.entities.elementAt(this.over);
                this.drawOutline(this.over, 0);
                this.ls.followLink(entityInstance, false);
            }
            this.mouseDown = -1;
            return true;
        }
        return false;
    }

    public boolean mouseMotion(Event event, int n, int n2) {
        this.ls.setHelpPopup(helpStr, n, n2);
        int n3 = this.getIndex(n, n2);
        if (n3 == this.over) {
            return n3 >= 0;
        }
        if (this.over >= 0) {
            this.drawOutline(this.over, 0);
        }
        if (n3 >= 0) {
            this.drawOutline(n3, 1);
        }
        this.over = n3;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.mouseDown == -1) {
            return false;
        }
        int n3 = this.getIndex(n, n2);
        if (n3 == this.over) {
            return true;
        }
        if (this.over >= 0) {
            this.drawOutline(this.over, 0);
        }
        if (n3 == this.mouseDown) {
            this.drawOutline(n3, 2);
        }
        this.over = n3;
        return true;
    }
}

