/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import lsedit.LandscapeViewerCore;
import lsedit.LsButtonMenu;
import lsedit.Util;

public class MenuButton
extends Canvas {
    protected static final int MARGIN = 4;
    protected String label;
    protected LandscapeViewerCore ls;
    protected Font font;
    protected int fontHeight;
    protected LsButtonMenu menu;
    protected String[] menuEntries;
    protected int[] menuKeys;
    protected boolean[] grayStates;

    public MenuButton(String string, LandscapeViewerCore landscapeViewerCore, Font font, String[] stringArray, int[] nArray, boolean[] blArray) {
        this.label = string;
        this.ls = landscapeViewerCore;
        this.menuEntries = stringArray;
        this.menuKeys = nArray;
        this.grayStates = blArray;
        this.font = font;
        this.menu = new LsButtonMenu();
        this.menu.hide();
        landscapeViewerCore.add(this.menu);
        this.setFont(font);
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.stringWidth(string) + 16;
        this.fontHeight = Util.fontHeight(font);
        int n2 = this.fontHeight + 16;
        this.resize(n, n2);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        graphics.setColor(this.menu.isVisible() ? Color.gray : this.getBackground());
        graphics.fillRect(0, 0, dimension.width - 4, dimension.height - 4);
        graphics.draw3DRect(0, 0, dimension.width - 4, dimension.height - 4, true);
        graphics.draw3DRect(1, 1, dimension.width - 4 - 2, dimension.height - 4 - 2, true);
        graphics.setFont(this.font);
        graphics.setColor(this.getForeground());
        graphics.drawString(this.label, 6, 2 + this.fontHeight);
    }

    public int resizeButton() {
        Rectangle rectangle = this.bounds();
        this.fontHeight = Util.fontHeight(this.font);
        int n = this.fontHeight + 12;
        this.resize(rectangle.width, n);
        return rectangle.width;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.repaint();
        this.menu.set(this, this.ls, this.menuEntries, this.menuKeys, this.grayStates);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        Point point = this.location();
        return this.menu.mouseDrag(event, n + point.x, n2 + point.y);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        Point point = this.location();
        int n3 = this.menu.getKey(event, n + point.x, n2 + point.y);
        this.menu.hide();
        this.ls.processMenuSelection(this, n3);
        return true;
    }
}

