/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Event;
import lsedit.EdgePoint;
import lsedit.LandscapeModeHandler;
import lsedit.Layout;
import lsedit.MsgOut;
import lsedit.RealPoint;

public class MoveModeHandler
extends LandscapeModeHandler {
    protected double dx;
    protected double dy;
    protected Layout curLayout;
    protected EdgePoint ept;

    protected boolean moveBendStart(Event event, int n, int n2) {
        this.ls.doFeedback("Bend point at (" + n + ", " + n2 + ")");
        this.dg.setDrawEdges(false);
        this.ls.redrawDg();
        this.gc.setXORMode(this.bend.e.getBackground());
        this.dg.drawEdge(this.gc, this.ri);
        return true;
    }

    protected void moveBendMotion(Event event, int n, int n2) {
        this.ls.doFeedback("Bend point at (" + n + ", " + n2 + ")");
        this.dg.drawEdge(this.gc, this.ri);
        this.bend.x = n;
        this.bend.y = n2;
        this.dg.drawEdge(this.gc, this.ri);
    }

    protected void moveBendEnd(Event event, int n, int n2) {
        this.dg.setDrawEdges(true);
        this.dg.moveBend(this.bend, n, n2);
        this.ls.redrawDg();
    }

    protected RealPoint getFactors(int n, int n2) {
        double d;
        double d2;
        Layout layout = this.ept.getEntity().getLayout();
        double d3 = n;
        double d4 = n2;
        double d5 = Math.abs(d3 - layout.x);
        double d6 = Math.abs(d3 - (layout.x + layout.width));
        double d7 = Math.abs(d4 - layout.y);
        double d8 = Math.abs(d4 - (layout.y + layout.height));
        if (d5 < d6) {
            if (d7 < d8) {
                if (d7 < d5) {
                    d2 = (d3 - layout.x) / layout.width;
                    d = 0.0;
                } else {
                    d2 = 0.0;
                    d = (d4 - layout.y) / layout.height;
                }
            } else if (d8 < d5) {
                d2 = (d3 - layout.x) / layout.width;
                d = 1.0;
            } else {
                d2 = 0.0;
                d = (d4 - layout.y) / layout.height;
            }
        } else if (d7 < d8) {
            if (d7 < d6) {
                d2 = (d3 - layout.x) / layout.width;
                d = 0.0;
            } else {
                d2 = 1.0;
                d = (d4 - layout.y) / layout.height;
            }
        } else if (d8 < d6) {
            d2 = (d3 - layout.x) / layout.width;
            d = 1.0;
        } else {
            d2 = 1.0;
            d = (d4 - layout.y) / layout.height;
        }
        d2 = Math.max(0.0, Math.min(1.0, d2));
        d = Math.max(0.0, Math.min(1.0, d));
        return new RealPoint(d2, d);
    }

    protected boolean moveIOStart(Event event, int n, int n2) {
        this.dg.setDrawEdges(false);
        this.ls.redrawDg();
        this.gc.setXORMode(this.e.getBackground());
        this.dg.drawEdge(this.gc, this.ri);
        RealPoint realPoint = this.getFactors(n, n2);
        this.ls.doFeedback("I/O point at factors (" + realPoint.x + ", " + realPoint.y + ")");
        return true;
    }

    protected void moveIOMotion(Event event, int n, int n2) {
        this.dg.drawEdge(this.gc, this.ri);
        RealPoint realPoint = this.getFactors(n, n2);
        this.ept.wf = realPoint.x;
        this.ept.hf = realPoint.y;
        this.ls.doFeedback("I/O point at factors (" + realPoint.x + ", " + realPoint.y + ")");
        this.ept.rescale();
        this.dg.drawEdge(this.gc, this.ri);
    }

    protected void moveIOEnd(Event event, int n, int n2) {
        this.ept.isDefault = false;
        this.dg.setDrawEdges(true);
        this.ls.redrawDg();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.e = null;
        this.ri = null;
        this.bend = null;
        this.ept = null;
        this.e = this.dg.mouseOverEx(n, n2);
        if (this.e == null) {
            return false;
        }
        if (!this.ls.isViewer()) {
            this.ept = this.dg.mouseOverIO(this.e, n, n2);
            if (this.ept != null) {
                this.ri = this.dg.mouseOverAnyEdge(this.ept.getEntity(), n, n2);
                if (this.ri != null) {
                    this.moveIOStart(event, n, n2);
                    return true;
                }
                MsgOut.println("Missing relation");
                return false;
            }
            this.bend = this.dg.mouseOverBend(n, n2);
        }
        if (this.bend != null) {
            this.ri = this.bend.getFirstEdge();
        }
        if (this.bend != null) {
            this.moveBendStart(event, n, n2);
            return true;
        }
        if (this.ri != null) {
            this.dx = n;
            this.dy = n2;
            return true;
        }
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.ept != null) {
            this.moveIOMotion(event, n, n2);
        } else if (this.bend != null) {
            this.moveBendMotion(event, n, n2);
        }
        return true;
    }

    public void mouseUp(Event event, int n, int n2) {
        this.ls.clearFeedback();
        if (this.ept != null) {
            this.moveIOEnd(event, n, n2);
        } else if (this.bend != null) {
            this.moveBendEnd(event, n, n2);
        }
    }

    public void drawOutline() {
        this.dg.drawEntityOutline(this.gc, this.curLayout, this.e);
    }

    public void setLayout() {
        this.curLayout = (Layout)this.e.getLayout().clone();
    }
}

