/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.LandscapeViewerCore;
import lsedit.LegendObject;
import lsedit.RealPoint;
import lsedit.RelationClass;
import lsedit.TabbedBox;
import lsedit.Util;

public class QueryBox
extends TabbedBox {
    protected static final int CB_WD = 15;
    protected static final int CB_HT = 15;
    protected static final int WIDTH = 20;
    protected static final int HEIGHT = 20;
    protected static final Font textFont = new Font("Helvetica", 0, 11);
    protected static final String endRelMsg1 = "Checkboxes select active relations.";
    protected static final String endRelMsg2 = "Click relation arrow for description.";
    protected static final String helpStr = "This box shows the relations which are active during queries";
    protected static final int MAX_NUM_CHECKS = 20;
    protected Checkbox grpChk;
    protected Checkbox[] relnChk = new Checkbox[20];
    protected RelationClass[] relnClass = new RelationClass[20];
    protected Vector objects;

    protected void drawContents(Diagram diagram, Graphics graphics, boolean bl) {
        int n;
        Object object;
        int n2;
        Rectangle rectangle = this.bounds();
        int n3 = 5;
        int n4 = n2 = -this.scrollBar.getValue();
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = Util.fontHeight(textFont);
        int n6 = n5 * 3 / 2;
        int n7 = rectangle.width - n6 - 15;
        graphics.setColor(Color.black);
        graphics.drawString("Relations", n3, (n2 += n5 + 5) + n5);
        graphics.drawLine(n3, n2 += n5 + 3, n3 + fontMetrics.stringWidth("Relations"), n2);
        n2 += n5;
        Enumeration enumeration = diagram.enumRelations();
        int n8 = 0;
        int n9 = 0;
        this.objects = new Vector();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            String string = relationClass.getId();
            String string2 = relationClass.getLabel();
            if (diagram.excludeReln(relationClass)) continue;
            String string3 = string2 + " (" + (n8 + 1) + ")";
            object = relationClass.getAttribute("color");
            if (object != null) {
                graphics.setColor(((Attribute)object).parseColor());
            } else {
                graphics.setColor(Color.black);
            }
            int n10 = n3 + 15 + 5;
            int n11 = n2 + 10;
            int n12 = n10 + 20;
            int n13 = n11;
            Rectangle rectangle2 = new Rectangle(rectangle.x + n3 + 15 + 5, rectangle.y + n2, 20, 20);
            this.relnClass[n8] = relationClass;
            this.relnChk[n8].resize(15, 15);
            this.relnChk[n8].move(rectangle.x + n3 + 5, rectangle.y + n2 + this.tabDim.height + 5 + 3);
            this.relnChk[n8].show();
            this.relnChk[n8].setState(relationClass.isActive());
            this.objects.addElement(new LegendObject(rectangle2, relationClass));
            RealPoint realPoint = new RealPoint(n10, n11);
            RealPoint realPoint2 = new RealPoint(n12, n13);
            Util.drawArrow(graphics, realPoint, realPoint2);
            graphics.setColor(Color.black);
            Util.drawStringClipped(graphics, string3, n10 + 20 + 5, n2, n7, n5);
            n2 += n5 + 5;
            ++n9;
            ++n8;
        }
        for (n = n8; n < 20; ++n) {
            this.relnChk[n].hide();
            this.relnClass[n] = null;
        }
        if (n8 == 0) {
            graphics.setColor(Color.black);
            n = n3;
            int n14 = n2 + 10;
            int n15 = n3 + 20;
            int n16 = n2 + 10;
            object = new RealPoint(n, n14);
            RealPoint realPoint = new RealPoint(n15, n16);
            Util.drawArrow(graphics, (RealPoint)object, realPoint);
            graphics.setColor(Color.black);
            Util.drawStringClipped(graphics, "Relation", n3 + 20 + 5, n2, n7, n5);
            n2 += n5 + 5;
            ++n9;
        }
        if (bl) {
            Util.drawStringClipped(graphics, endRelMsg1, n3, n2 += n5 + n5 / 2, n7, n5);
            Util.drawStringClipped(graphics, endRelMsg2, n3, n2 += n5, n7, n5);
            this.grpChk.resize(15, 15);
            this.grpChk.move(rectangle.x + n3 + 5, rectangle.y + this.tabDim.height + (n2 += n5 * 2) + 5 + 3);
            this.grpChk.show();
            Util.drawStringClipped(graphics, "Group with queries", n3 + 20 + 5, n2, n7, n5);
        }
        this.setupScrolling(n2 - n4);
    }

    protected void genChecks() {
        for (int i = 0; i < 20; ++i) {
            this.relnChk[i] = new Checkbox();
            this.relnChk[i].hide();
            this.ls.add(this.relnChk[i]);
        }
        this.grpChk = new Checkbox();
        this.grpChk.hide();
        this.ls.add(this.grpChk);
    }

    protected void grpStateInfo() {
        this.ls.doFeedback("Entities " + (this.grpChk.getState() ? "are" : "aren't") + " grouped with queries");
    }

    public QueryBox(LandscapeViewerCore landscapeViewerCore) {
        super(landscapeViewerCore, "Queries", 88);
        this.genChecks();
    }

    public boolean mouseMotion(Event event, int n, int n2) {
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            LegendObject legendObject = (LegendObject)enumeration.nextElement();
            Rectangle rectangle = legendObject.getRectangle();
            if (n < rectangle.x || n > rectangle.x + rectangle.width || n2 < rectangle.y || n2 > rectangle.y + rectangle.height || (string = legendObject.getDescription()) == null) continue;
            this.ls.setHelpPopup(legendObject.getDescription(), n, n2);
            return true;
        }
        this.ls.setHelpPopup(helpStr, n, n2);
        return true;
    }

    public boolean handleEvent(Diagram diagram, Graphics graphics, Event event) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.handleEvent(diagram, graphics, event)) {
            return true;
        }
        if (event.target == this.grpChk) {
            if (event.id == 1001) {
                this.grpStateInfo();
                this.ls.requestFocus();
            }
            return true;
        }
        for (int i = 0; i < 20; ++i) {
            if (event.target != this.relnChk[i]) continue;
            if (event.id == 1001) {
                this.ls.processKey(49 + i, 1);
            }
            return true;
        }
        return false;
    }

    public void toggleRelationActivity(Diagram diagram, int n) {
        if (n == 10) {
            boolean bl = !this.relnClass[0].isActive();
            int n2 = 0;
            while (this.relnClass[n2] != null) {
                diagram.setEdgeActiveState(this.relnClass[n2], bl);
                ++n2;
            }
        } else {
            RelationClass relationClass = this.relnClass[n];
            if (relationClass != null) {
                boolean bl = !relationClass.isActive();
                diagram.setEdgeActiveState(relationClass, bl);
                this.ls.doFeedback("Relation " + relationClass.getLabel() + " set to " + (bl ? "active" : "inactive"));
            }
        }
        this.repaint();
    }

    public void activate() {
        super.activate();
    }

    public void inactivate() {
        super.inactivate();
        for (int i = 0; i < 20; ++i) {
            this.relnChk[i].hide();
        }
        this.grpChk.hide();
    }

    public void toggleGroupingFlag() {
        this.grpChk.setState(!this.grpChk.getState());
        this.grpStateInfo();
    }

    public boolean getGroupingFlag() {
        return this.grpChk.getState();
    }
}

