/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.RelationInstance;
import lsedit.Util;

public class RelationClass
extends LandscapeClassObject {
    protected static final String FACTOR_ID = "class_iofactor";
    protected static final String RELATION_BASE_CLASS_ID = "$RELATION";
    protected boolean active = true;
    protected boolean visible = true;
    protected Vector relationList = new Vector();
    protected int ordinal;

    public RelationClass(String string, int n, RelationClass relationClass, Diagram diagram) {
        this.id = string;
        this.setNid(n);
        this.label = string;
        this.dg = diagram;
        this.style = 0;
        this.addParentClass(relationClass);
        this.setObjectColor(Color.black);
    }

    public void addRelation(EntityClass entityClass, EntityClass entityClass2) {
        EntityClassPair entityClassPair = new EntityClassPair(entityClass, entityClass2);
        this.relationList.addElement(entityClassPair);
    }

    public boolean isValidRelation(EntityClass entityClass, EntityClass entityClass2) {
        return true;
    }

    public boolean isValidRelation(EntityInstance entityInstance, EntityInstance entityInstance2) {
        return this.isValidRelation(entityInstance.getEntityClass(), entityInstance2.getEntityClass());
    }

    public boolean isValidSrc(EntityClass entityClass) {
        Enumeration enumeration = this.relationList.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            if (entityClassPair.entityClass1 != entityClass) continue;
            return true;
        }
        return false;
    }

    public boolean isValidDst(EntityClass entityClass) {
        Enumeration enumeration = this.relationList.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            if (entityClassPair.entityClass2 != entityClass) continue;
            return true;
        }
        return false;
    }

    public boolean hasId(String string) {
        return this.id.equals(string);
    }

    public RelationInstance newRelation(EntityInstance entityInstance, EntityInstance entityInstance2, Diagram diagram) {
        RelationInstance relationInstance = new RelationInstance(this, entityInstance, entityInstance2, diagram);
        this.makeInstanceOfUs(relationInstance);
        return relationInstance;
    }

    public void writeRelations(PrintStream printStream) throws IOException {
        Enumeration enumeration = this.relationList.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            printStream.print(this.qt(this.id) + " " + this.qt(entityClassPair.entityClass1.id) + " " + this.qt(entityClassPair.entityClass2.id) + "\n");
        }
    }

    public void getRelationsRaw(Vector vector, Hashtable hashtable) {
        Enumeration enumeration = this.relationList.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            Integer[] integerArray = new Integer[]{(Integer)hashtable.get(this.id), (Integer)hashtable.get(entityClassPair.entityClass1.id), (Integer)hashtable.get(entityClassPair.entityClass2.id)};
            vector.addElement(integerArray);
        }
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        if (this.getNid() >= 2) {
            printStream.print("(" + this.qt(this.id) + ") {\n");
            super.writeAttributes(printStream);
            printStream.print("}\n\n");
        }
    }

    public String toString() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisibleState(boolean bl) {
        this.visible = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActiveState(boolean bl) {
        this.active = bl;
    }

    public String addParentClass(RelationClass relationClass) {
        return this.addParentClass(relationClass, RELATION_BASE_CLASS_ID);
    }

    public void setOrdinal(int n) {
        this.ordinal = n;
    }

    public double getIOfactor() {
        Attribute attribute = this.getAttribute(FACTOR_ID);
        if (attribute != null) {
            return Util.parseReal(attribute.avi.value);
        }
        if (this.dg.allowElision()) {
            double d = this.dg.numVisibleRelationClasses();
            return (double)(this.ordinal + 1) / (d + 1.0);
        }
        double d = this.dg.numRelationClasses();
        return d > 2.0 ? (double)(this.getNid() - 1) / (d - 1.0) : 0.5;
    }

    public int getPrimaryAttributeCount() {
        return 6;
    }

    public String getAttributeNameAt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "id";
                break;
            }
            case 1: {
                string = "class_label";
                break;
            }
            case 2: {
                string = "class_description";
                break;
            }
            case 3: {
                string = "class_style";
                break;
            }
            case 4: {
                string = "color";
                break;
            }
            case 5: {
                string = "labelcolor";
                break;
            }
            default: {
                string = super.getAttributeNameAt(n);
            }
        }
        return string;
    }

    public Object getAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                object = this.label;
                break;
            }
            case 2: {
                object = this.description;
                break;
            }
            case 3: {
                object = new Integer(this.style);
                break;
            }
            case 4: {
                object = this.getObjectColor();
                break;
            }
            case 5: {
                object = this.getLabelColor();
                break;
            }
            default: {
                object = super.getAttributeValueAt(n);
            }
        }
        return object;
    }

    public void setAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.label = (String)object;
                break;
            }
            case 2: {
                this.description = (String)object;
                break;
            }
            case 3: {
                this.style = (Integer)object;
                break;
            }
            case 4: {
                this.setObjectColor((Color)object);
                break;
            }
            case 5: {
                this.setLabelColor((Color)object);
                break;
            }
            default: {
                super.setAttributeValueAt(n, object);
            }
        }
    }

    public int getAttributeTypeAt(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 14;
                break;
            }
            case 4: 
            case 5: {
                n2 = 7;
                break;
            }
            default: {
                n2 = super.getAttributeTypeAt(n);
            }
        }
        return n2;
    }
}

