/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Bend;
import lsedit.BendPoint;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.LandscapeObject;
import lsedit.Layout;
import lsedit.MsgOut;
import lsedit.RealPoint;
import lsedit.RelationClass;
import lsedit.ScreenPoint;
import lsedit.Util;

public class RelationInstance
extends LandscapeObject {
    public static final int CLIENT_SUPPLIER_EL_LEN = 16;
    protected static final double SEP_THRESHOLD = 10.0;
    protected static final Color HIGHLIGHT_COLOUR = Color.yellow;
    protected static final int HIGHLIGHT_DIM = 4;
    protected static final String STYLE_ID = "style";
    protected static final String BENDS_ID = "bends";
    protected RelationClass parentClass;
    protected EntityInstance src;
    protected EntityInstance dst;
    protected Vector bends = null;
    protected Vector bendContainer = null;
    protected int timeStamp = -1;
    protected boolean groupFlag = false;
    protected boolean highlightFlag = false;
    protected static int stump_mode = 1;

    public static void drawBend(Graphics graphics, double d, double d2, boolean bl) {
        if (bl) {
            graphics.setColor(Color.black);
        }
        ScreenPoint screenPoint = new ScreenPoint(d - 3.0, d2 - 3.0);
        graphics.fillRect(screenPoint.x, screenPoint.y, 6, 6);
    }

    protected boolean processFirstOrderAttributes(Attribute attribute, Hashtable hashtable) {
        boolean bl;
        boolean bl2 = bl = attribute.avi != null;
        if (attribute.id.equals("color")) {
            if (bl) {
                this.setObjectColor(attribute.parseColour());
            }
            return true;
        }
        if (attribute.id.equals(STYLE_ID)) {
            if (bl) {
                this.style = attribute.parseInt();
            }
            return true;
        }
        if (attribute.id.equals(BENDS_ID)) {
            if (bl) {
                if (this.bends == null) {
                    this.bends = new Vector();
                }
                AttributeValueItem attributeValueItem = attribute.avi;
                while (attributeValueItem != null) {
                    RealPoint realPoint = attributeValueItem.next.parsePoint();
                    EntityInstance entityInstance = (EntityInstance)hashtable.get(attributeValueItem.value);
                    if (entityInstance != null) {
                        Bend bend = this.dg.newBend(entityInstance, this, realPoint.x, realPoint.y, false);
                        this.bends.addElement(bend);
                        entityInstance.addBend(bend);
                        MsgOut.dprintln("Bend added: " + entityInstance.getId() + " " + realPoint.x + " " + realPoint.y);
                    } else {
                        MsgOut.println("Missing bend parent entity: " + entityInstance.getId());
                    }
                    attributeValueItem = attributeValueItem.nextList;
                }
            }
            return true;
        }
        return false;
    }

    protected EdgePoint getOutPoint(EntityInstance entityInstance, Layout layout, Layout layout2) {
        return entityInstance.getOutPoint(this, edge_mode, layout, layout2);
    }

    protected Bend nextBend(Enumeration enumeration) {
        if (enumeration.hasMoreElements()) {
            return (Bend)enumeration.nextElement();
        }
        return null;
    }

    protected Bend nextBendRev(int n) {
        if (n >= 0) {
            return (Bend)this.bends.elementAt(n);
        }
        return null;
    }

    protected Vector points(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        EntityInstance entityInstance;
        EntityInstance entityInstance2;
        boolean bl2;
        EntityInstance entityInstance3;
        EntityInstance entityInstance4 = this.dg.getRoot();
        EntityInstance entityInstance5 = this.src.getVisibleEntity(entityInstance4);
        if (entityInstance5 == (entityInstance3 = this.dst.getVisibleEntity(entityInstance4)) || entityInstance5 == null || entityInstance3 == null) {
            return null;
        }
        if (this.src.containedBy == this.dst.containedBy || edge_mode == 2 || !bl) {
            if (entityInstance4.descendent(this.src) && this.src.containedBy != this.dst.containedBy && bl) {
                while (entityInstance5 != entityInstance4 && entityInstance5.getParent().isSupplierRelationElided(this.parentClass)) {
                    entityInstance5 = entityInstance5.getParent();
                }
            }
            Layout layout = entityInstance5.getLayout();
            Layout layout2 = entityInstance3.getLayout();
            Vector<RealPoint> vector = new Vector<RealPoint>();
            if (this.bends == null) {
                EdgePoint edgePoint = this.getOutPoint(entityInstance5, layout, layout2);
                EdgePoint edgePoint2 = this.getOutPoint(entityInstance3, layout2, layout);
                edgePoint.active = true;
                edgePoint.elision = false;
                edgePoint2.active = true;
                edgePoint2.elision = false;
                vector.addElement(edgePoint);
                vector.addElement(edgePoint2);
            } else {
                Bend bend = (Bend)this.bends.firstElement();
                Bend bend2 = (Bend)this.bends.lastElement();
                Layout layout3 = new Layout(bend.x, bend.y, 0.0, 0.0);
                Layout layout4 = new Layout(bend2.x, bend2.y, 0.0, 0.0);
                vector.addElement(this.getOutPoint(entityInstance5, layout, layout3));
                Enumeration enumeration = this.bends.elements();
                while (enumeration.hasMoreElements()) {
                    Bend bend3 = (Bend)enumeration.nextElement();
                    BendPoint bendPoint = new BendPoint(bend3.x, bend3.y);
                    bendPoint.active = true;
                    bendPoint.elision = false;
                    vector.addElement(bendPoint);
                }
                vector.addElement(this.getOutPoint(entityInstance3, layout2, layout4));
            }
            return vector;
        }
        boolean bl3 = !entityInstance4.descendent(this.src);
        boolean bl4 = bl2 = !entityInstance4.descendent(this.dst);
        if (!bl3 && !bl2) {
            entityInstance = entityInstance2 = this.src.common(this.dst);
        } else if (bl3) {
            entityInstance2 = this.dg.getClient((EntityInstance)this.src).containedBy;
            entityInstance = entityInstance4.containedBy;
        } else {
            entityInstance2 = entityInstance4.containedBy;
            entityInstance = this.dg.getSupplier((EntityInstance)this.dst).containedBy;
        }
        if (entityInstance2 == null) {
            System.out.println("C Error: " + this.src + " " + this.dst + " " + bl3 + " " + bl2);
            return null;
        }
        if (entityInstance == null) {
            System.out.println("S Error: " + this.src + " " + this.dst + " " + bl3 + " " + bl2);
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        Vector<RealPoint> vector2 = new Vector<RealPoint>();
        Object object4 = entityInstance5;
        EntityInstance entityInstance6 = this.src;
        EntityInstance entityInstance7 = this.dst;
        while (entityInstance6.containedBy != entityInstance2) {
            entityInstance6 = entityInstance6.containedBy;
        }
        while (entityInstance7.containedBy != entityInstance) {
            entityInstance7 = entityInstance7.containedBy;
        }
        Object object5 = entityInstance6.getLayout();
        Layout layout = entityInstance7.getLayout();
        Enumeration enumeration = null;
        Bend bend = null;
        if (this.bends != null) {
            enumeration = this.bends.elements();
            bend = this.nextBend(enumeration);
        }
        Object object6 = null;
        while (object4 != entityInstance2) {
            if (object4 == null) {
                MsgOut.println("Error in points: (" + this.parentClass.getId() + " " + this.src.getId() + " " + this.dst.getId() + ")");
                return null;
            }
            object3 = ((EntityInstance)object4).containedBy;
            if (bend != null && object3 != entityInstance2 && object3 == bend.e) {
                object5 = ((EntityInstance)object4).getLayout();
                object2 = new Layout(bend.x, bend.y, 0.0, 0.0);
                vector.addElement(this.getOutPoint((EntityInstance)object4, (Layout)object5, (Layout)object2));
                object5 = object2;
                while (bend != null && object3 == bend.e) {
                    object = new BendPoint(bend.x, bend.y);
                    vector.addElement(object);
                    bend = this.nextBend(enumeration);
                }
            } else {
                object2 = this.getOutPoint((EntityInstance)object4, (Layout)object5, layout);
                ((EdgePoint)object2).active = true;
                ((EdgePoint)object2).elision = false;
                if (bl && object6 != null && ((EntityInstance)object4).isSupplierRelationElided(this.parentClass)) {
                    ((EdgePoint)object6).active = false;
                    ((EdgePoint)object6).elision = true;
                }
                vector.addElement(object2);
                object6 = object2;
            }
            object4 = object3;
        }
        while (bend != null && entityInstance2 == bend.e) {
            object3 = new BendPoint(bend.x, bend.y);
            vector.addElement(object3);
            bend = this.nextBend(enumeration);
        }
        int n = -1;
        if (bend != null) {
            n = this.bends.size() - 1;
            bend = this.nextBendRev(n--);
        }
        object4 = entityInstance3;
        object5 = entityInstance7.getLayout();
        layout = entityInstance6.getLayout();
        object6 = null;
        while (object4 != entityInstance) {
            object2 = ((EntityInstance)object4).containedBy;
            if (bend != null && object2 != entityInstance && object2 == bend.e) {
                object5 = ((EntityInstance)object4).getLayout();
                object = new Layout(bend.x, bend.y, 0.0, 0.0);
                vector2.addElement(this.getOutPoint((EntityInstance)object4, (Layout)object5, (Layout)object));
                object5 = object;
                if (object2 != entityInstance) {
                    while (bend != null && object2 == bend.e) {
                        BendPoint bendPoint = new BendPoint(bend.x, bend.y);
                        vector2.addElement(bendPoint);
                        bend = this.nextBendRev(n--);
                    }
                }
            } else {
                object = this.getOutPoint((EntityInstance)object4, (Layout)object5, layout);
                ((EdgePoint)object).elision = false;
                ((EdgePoint)object).active = true;
                if (bl && object6 != null && ((EntityInstance)object4).isClientRelationElided(this.parentClass)) {
                    ((EdgePoint)object).elision = true;
                    ((EdgePoint)object).active = false;
                }
                vector2.addElement((RealPoint)object);
                object6 = object;
            }
            object4 = object2;
        }
        for (int i = vector2.size() - 1; i >= 0; --i) {
            vector.addElement(vector2.elementAt(i));
        }
        return vector;
    }

    protected int findNearestSeg(int n, int n2, int n3, Vector vector) {
        Enumeration enumeration = vector.elements();
        int n4 = 0;
        RealPoint realPoint = (RealPoint)enumeration.nextElement();
        do {
            double d;
            double d2;
            double d3;
            double d4;
            int n5;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            RealPoint realPoint2 = realPoint;
            realPoint = (RealPoint)enumeration.nextElement();
            if (!realPoint2.elision && realPoint2.active && (d9 = (((d8 = (double)n) - realPoint2.x) * (d7 = realPoint.x - realPoint2.x) + ((d6 = (double)n2) - realPoint2.y) * (d5 = realPoint.y - realPoint2.y)) / (d7 * d7 + d5 * d5)) > 0.0 && d9 < 1.0 && (n5 = (int)Math.sqrt((d4 = d8 - (d3 = realPoint2.x + d9 * d7)) * d4 + (d2 = d6 - (d = realPoint2.y + d9 * d5)) * d2)) < n3) {
                return n4;
            }
            ++n4;
        } while (enumeration.hasMoreElements());
        return -1;
    }

    protected void drawEdge(Graphics graphics, boolean bl) {
        if (this.src == null || this.dst == null) {
            MsgOut.println("Landscape error: null src or dst");
            return;
        }
        ScreenPoint screenPoint = new ScreenPoint();
        ScreenPoint screenPoint2 = new ScreenPoint();
        if (this.src.containedBy == null) {
            MsgOut.println("drawEdge: containedBy error");
            return;
        }
        if (this.dst.containedBy == null) {
            MsgOut.println("drawEdge: containedBy error");
            return;
        }
        Vector vector = this.points(bl);
        if (vector != null) {
            Object object;
            EdgePoint edgePoint;
            EntityInstance entityInstance = this.dg.getRoot();
            int n = bl && (!entityInstance.descendent(this.src) || !entityInstance.descendent(this.dst)) ? 2 : 0;
            Enumeration enumeration = vector.elements();
            EdgePoint edgePoint2 = (EdgePoint)enumeration.nextElement();
            boolean bl2 = false;
            boolean bl3 = this.dg.isDrawBends();
            if (edgePoint2.active && edgePoint2.getEntity() == this.src) {
                Util.drawTailPoint(graphics, edgePoint2);
            }
            RealPoint realPoint = edgePoint2;
            do {
                edgePoint = realPoint;
                realPoint = (RealPoint)enumeration.nextElement();
                bl2 = false;
                if (!edgePoint.active) continue;
                if (bl3 && !realPoint.isBend()) {
                    edgePoint2 = (EdgePoint)realPoint;
                    if (edgePoint.active && realPoint.active && edgePoint2.getEntity().isOpen()) {
                        edgePoint2.getEntity().drawIOpoint(graphics, this.parentClass, edgePoint2, true);
                    }
                }
                screenPoint.set(edgePoint.x, edgePoint.y);
                screenPoint2.set(realPoint.x, realPoint.y);
                this.dg.drawCache.drawSegment(graphics, n, screenPoint, screenPoint2);
                bl2 = true;
                if (this.groupFlag) {
                    object = graphics.getColor();
                    graphics.setColor(HIGHLIGHT_COLOUR);
                    screenPoint.set((screenPoint.x + screenPoint2.x - 4) / 2, (screenPoint.y + screenPoint2.y - 4) / 2);
                    graphics.fillRect(screenPoint.x, screenPoint.y, 4, 4);
                    graphics.setColor((Color)object);
                }
                if (!edgePoint.elision) continue;
                object = (RealPoint)realPoint.clone();
                ((RealPoint)object).y = edgePoint.y + (realPoint.y - edgePoint.y) * 0.7;
                Util.drawArrowHead(graphics, edgePoint, (RealPoint)object);
                bl2 = false;
            } while (enumeration.hasMoreElements());
            if (bl2) {
                Util.drawArrowHead(graphics, edgePoint, realPoint);
            }
            if (this.bends != null && bl3) {
                enumeration = this.bends.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Bend)enumeration.nextElement();
                    RelationInstance.drawBend(graphics, ((Bend)object).x, ((Bend)object).y, true);
                }
            }
        }
    }

    protected void drawElided(Graphics graphics, EntityInstance entityInstance, EntityInstance entityInstance2, boolean bl, boolean bl2) {
        ScreenPoint screenPoint;
        ScreenPoint screenPoint2;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        RealPoint realPoint;
        EdgePoint edgePoint;
        Layout layout;
        Layout layout2;
        if (entityInstance.isOutRelationElided(this.parentClass) || bl) {
            layout2 = entityInstance.getLayout();
            layout = entityInstance2.getLayout();
            edgePoint = this.getOutPoint(entityInstance, layout2, layout);
            realPoint = bl ? this.getOutPoint(entityInstance.getParent(), layout2, layout) : new RealPoint(layout.x + layout.width / 2.0, layout.y + layout.height / 2.0);
            d5 = edgePoint.x - realPoint.x;
            d4 = edgePoint.y - realPoint.y;
            d3 = Math.sqrt(d5 * d5 + d4 * d4);
            d2 = edgePoint.x - d5 * 2.0 * 10.0 / d3;
            d = edgePoint.y - d4 * 2.0 * 10.0 / d3;
            screenPoint2 = new ScreenPoint(edgePoint.x, edgePoint.y);
            screenPoint = new ScreenPoint(d2, d);
            this.dg.drawCache.drawSegment(graphics, this.style, screenPoint2, screenPoint);
            RealPoint realPoint2 = new RealPoint(d2, d);
            Util.drawArrowHead(graphics, edgePoint, realPoint2);
        }
        if (entityInstance2.isInRelationElided(this.parentClass) || bl2) {
            layout2 = entityInstance.getLayout();
            layout = entityInstance2.getLayout();
            edgePoint = this.getOutPoint(entityInstance2, layout, layout2);
            realPoint = bl2 ? this.getOutPoint(entityInstance2.getParent(), layout, layout2) : new RealPoint(layout2.x + layout2.width / 2.0, layout2.y + layout2.height / 2.0);
            d5 = realPoint.x - edgePoint.x;
            d4 = realPoint.y - edgePoint.y;
            d3 = Math.sqrt(d5 * d5 + d4 * d4);
            d2 = edgePoint.x + d5 * 2.0 * 10.0 / d3;
            d = edgePoint.y + d4 * 2.0 * 10.0 / d3;
            screenPoint2 = new ScreenPoint(d2, d);
            screenPoint = new ScreenPoint(edgePoint.x, edgePoint.y);
            this.dg.drawCache.drawSegment(graphics, this.style, screenPoint2, screenPoint);
            Util.drawArrowHead(graphics, realPoint, edgePoint);
        }
    }

    protected void drawRecursiveLoop(Graphics graphics) {
        if (!this.src.containedBy.isOpen()) {
            return;
        }
        int n = 8;
        Layout layout = this.src.getLayout();
        ScreenPoint screenPoint = new ScreenPoint(layout.x + layout.width - (double)n, layout.y - (double)n);
        graphics.drawArc(screenPoint.x, screenPoint.y, n * 2, n * 2, 270, 270);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = screenPoint.x;
        nArray2[0] = screenPoint.y + n;
        nArray[1] = screenPoint.x - 1;
        nArray2[1] = screenPoint.y;
        nArray[2] = screenPoint.x + n - 1;
        nArray2[2] = screenPoint.y + n - 1;
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public RelationInstance(RelationClass relationClass, EntityInstance entityInstance, EntityInstance entityInstance2, Diagram diagram) {
        this.parentClass = relationClass;
        this.src = entityInstance;
        this.dst = entityInstance2;
        this.dg = diagram;
        this.setObjectColor(relationClass.getObjectColor());
    }

    public boolean draw(Graphics graphics, boolean bl) {
        if (this.parentClass.isVisible() || !bl) {
            EntityInstance entityInstance;
            EntityInstance entityInstance2;
            EntityInstance entityInstance3 = this.src.getVisibleEntity();
            EntityInstance entityInstance4 = this.dst.getVisibleEntity();
            if (entityInstance3 == null || entityInstance4 == null || this.dg.drawCache.haveDrawn(entityInstance3, entityInstance4, this.parentClass)) {
                return false;
            }
            if (bl && (entityInstance2 = entityInstance3.containedBy) == (entityInstance = entityInstance4.containedBy) && entityInstance2.isInternalRelationElided(this.parentClass)) {
                return false;
            }
            graphics.setColor(this.getObjectColor());
            if (entityInstance3 != this.src && entityInstance3 == entityInstance4) {
                return false;
            }
            entityInstance2 = this.dg.getRoot();
            if (this.src == this.dst) {
                this.drawRecursiveLoop(graphics);
            } else if (bl && entityInstance2.descendent(this.src) && entityInstance2.descendent(this.dst)) {
                if (entityInstance3.isOutRelationElided(this.parentClass) || entityInstance4.isInRelationElided(this.parentClass)) {
                    this.drawElided(graphics, entityInstance3, entityInstance4, false, false);
                } else {
                    this.drawEdge(graphics, bl);
                    this.timeStamp = this.dg.getTimeStamp();
                }
            } else {
                this.drawEdge(graphics, bl);
                this.timeStamp = this.dg.getTimeStamp();
            }
        }
        return true;
    }

    public boolean draw(Graphics graphics) {
        this.drawEdge(graphics, true);
        return true;
    }

    public boolean isNearEdge(int n, int n2, int n3, int n4) {
        if (n4 != -1 && n4 != this.timeStamp) {
            return false;
        }
        Vector vector = this.points(!this.highlightFlag && n4 != -1);
        if (vector == null || vector.size() < 2) {
            return false;
        }
        return this.findNearestSeg(n, n2, n3, vector) >= 0;
    }

    public boolean addBend(Bend bend) {
        if (this.bends == null) {
            this.bends = new Vector();
            this.bends.addElement(bend);
        } else {
            Vector vector = this.points(true);
            int n = this.findNearestSeg((int)bend.x, (int)bend.y, 4, vector);
            if (n == -1) {
                MsgOut.println("Couldn't find bend slot");
                return false;
            }
            if (n == 0) {
                this.bends.insertElementAt(bend, 0);
            } else if (n == vector.size() - 1) {
                this.bends.addElement(bend);
            } else {
                int n2;
                for (n2 = this.bends.size() - 1; n2 >= 0 && vector.indexOf(this.bends.elementAt(n2)) > n; --n2) {
                }
                if (++n2 == this.bends.size()) {
                    this.bends.addElement(bend);
                } else {
                    this.bends.insertElementAt(bend, n2);
                }
            }
        }
        return true;
    }

    public void deleteBend(Bend bend) {
        this.bends.removeElement(bend);
        if (this.bends.size() == 0) {
            this.bends = null;
        }
    }

    public void addAttribute(Attribute attribute) {
        if (this.processFirstOrderAttributes(attribute, null)) {
            return;
        }
    }

    public void assignAttributes(Attribute attribute, Hashtable hashtable) {
        while (attribute != null) {
            if (attribute.avi == null) {
                MsgOut.println("Null attribute assignment");
            } else if (!this.processFirstOrderAttributes(attribute, hashtable)) {
                Attribute attribute2 = this.getAttribute(attribute.id);
                if (attribute2 == null) {
                    MsgOut.println("Missing attribute '" + attribute.toString() + "'");
                } else {
                    if (attribute2.cloneOnAssign) {
                        Attribute attribute3 = (Attribute)attribute2.clone();
                        this.replaceAttribute(attribute3);
                    }
                    attribute2.avi = attribute.avi;
                }
            }
            attribute = attribute.next;
        }
    }

    public void writeRelation(PrintStream printStream) throws IOException {
        printStream.print(this.qt(this.parentClass.getId()) + " " + this.qt(this.src.getId()) + " " + this.qt(this.dst.getId()) + "\n");
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        if (this.hasAttributes(false) || this.bends != null) {
            printStream.print("(" + this.qt(this.parentClass.getId()) + " " + this.qt(this.src.getId()) + " " + this.qt(this.dst.getId()) + ") {\n");
            if (this.bends != null) {
                printStream.print(" bends = (");
                Enumeration enumeration = this.bends.elements();
                while (enumeration.hasMoreElements()) {
                    Bend bend = (Bend)enumeration.nextElement();
                    printStream.print("(" + bend.e.getId() + " " + bend.xLocal + " " + bend.yLocal + ") ");
                }
                printStream.print(")\n");
            }
            super.writeAttributes(printStream, false);
            printStream.print("}\n\n");
        }
    }

    public boolean hasId(String string) {
        return false;
    }

    public boolean isSameRelation(RelationClass relationClass, EntityInstance entityInstance, EntityInstance entityInstance2) {
        return relationClass == this.parentClass && this.src == entityInstance && this.dst == entityInstance2;
    }

    public EntityInstance getSrc() {
        return this.src;
    }

    public EntityInstance getDst() {
        return this.dst;
    }

    public RelationClass getRelationClass() {
        return this.parentClass;
    }

    public Enumeration getBends() {
        if (this.bends == null) {
            return null;
        }
        return this.bends.elements();
    }

    public void setHighlightFlag() {
        this.highlightFlag = true;
    }

    public boolean getHighlightFlag() {
        return this.highlightFlag;
    }

    public boolean clearHighlightFlag() {
        boolean bl = this.highlightFlag;
        if (bl) {
            this.highlightFlag = false;
        }
        return bl;
    }

    public static void setStumpMode(int n) {
        stump_mode = n;
    }

    public void setGroupFlag() {
        this.groupFlag = true;
        this.setHighlightFlag();
    }

    public void clearGroupFlag() {
        this.groupFlag = false;
    }

    public boolean getGroupFlag() {
        return this.groupFlag;
    }

    public String toString() {
        EntityInstance entityInstance = this.dg.getRoot();
        EntityInstance entityInstance2 = this.src.getVisibleEntity(entityInstance);
        EntityInstance entityInstance3 = this.dst.getVisibleEntity(entityInstance);
        return entityInstance2 + (entityInstance2 == this.src ? "" : "{" + this.src + "}") + "->" + entityInstance3 + (entityInstance3 == this.dst ? "" : "{" + this.dst + "}");
    }
}

