/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Event;
import java.awt.Rectangle;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.Layout;

public class ResizeModeHandler
extends LandscapeModeHandler {
    protected static final int RM_NONE = 0;
    protected static final int RM_LEFT = 1;
    protected static final int RM_RIGHT = 2;
    protected static final int RM_TOP = 4;
    protected static final int RM_BOTTOM = 8;
    protected static final int LR_MASK = 3;
    protected static final int TB_MASK = 12;
    protected static final int RZONE_SIZE = 5;
    protected static final double MIN_DIM = 10.0;
    protected Layout curLayout;
    protected Layout bb;
    private Rectangle m_plyt = null;
    protected int resizeMode = 0;
    protected int[] startMode = new int[]{5, 4, 6, 2, 10, 8, 9, 1};

    protected void addMode(int n) {
        int n2 = 0;
        switch (n) {
            case 4: {
                n2 = 8;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 1;
            }
        }
        if ((this.resizeMode & n2) == 0) {
            this.resizeMode |= n;
        }
    }

    private String resizeDescription() {
        String string;
        if (this.resizeMode == 0) {
            string = "NONE";
        } else {
            string = "";
            if ((this.resizeMode & 1) != 0) {
                string = string + "LEFT ";
            }
            if ((this.resizeMode & 2) != 0) {
                string = string + "RIGHT ";
            }
            if ((this.resizeMode & 4) != 0) {
                string = string + "TOP ";
            }
            if ((this.resizeMode & 8) != 0) {
                string = string + "BOTTOM";
            }
        }
        return string;
    }

    protected void doResizeAdjust(int n, int n2, int n3) {
        int n4 = 20;
        int n5 = (int)this.curLayout.x;
        int n6 = (int)this.curLayout.y;
        int n7 = (int)this.curLayout.width;
        int n8 = (int)this.curLayout.height;
        if (n2 - n5 < 4) {
            this.addMode(1);
        }
        if (n5 + n7 - n2 < 4) {
            this.addMode(2);
        }
        if (n3 - n6 < 4) {
            this.addMode(4);
        }
        if (n6 + n8 - n3 < 4) {
            this.addMode(8);
        }
        if ((n & 4) != 0) {
            if (n3 >= this.m_plyt.y + n4) {
                n8 += n6 - n3;
                n6 = n3;
            }
        } else if ((n & 8) != 0 && n3 <= this.m_plyt.y + this.m_plyt.height - n4) {
            n8 = n3 - n6;
        }
        if ((n & 1) != 0) {
            if (n2 >= this.m_plyt.x + n4) {
                n7 += n5 - n2;
                n5 = n2;
            }
        } else if ((n & 2) != 0 && n2 <= this.m_plyt.x + this.m_plyt.width - n4) {
            n7 = n2 - n5;
        }
        if ((double)n7 >= 10.0) {
            this.curLayout.x = n5;
            this.curLayout.width = n7;
        }
        if ((double)n8 >= 10.0) {
            this.curLayout.y = n6;
            this.curLayout.height = n8;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        EntityInstance entityInstance;
        if (this.dg == null) {
            return false;
        }
        this.e = this.dg.mouseOver(n, n2);
        if (this.e == null || !this.e.getGroupKeyFlag()) {
            return false;
        }
        int n3 = this.e.overResizeTab(n, n2);
        if (n3 < 0) {
            return false;
        }
        this.resizeMode = this.startMode[n3];
        this.curLayout = (Layout)this.e.getLayout().clone();
        if (this.m_plyt == null) {
            this.m_plyt = new Rectangle();
        }
        if ((entityInstance = this.e.getParent()) != null && entityInstance.getParent() != null) {
            Layout layout = entityInstance.getLayout();
            this.m_plyt.x = (int)layout.x;
            this.m_plyt.y = (int)layout.y;
            this.m_plyt.width = (int)layout.width;
            this.m_plyt.height = (int)layout.height;
        } else {
            this.m_plyt = this.dg.bounds();
            this.m_plyt.x = 0;
            this.m_plyt.y = 0;
        }
        this.gc.setXORMode(this.e.getParent().getBackground());
        this.dg.drawEntityOutline(this.gc, this.curLayout, this.e);
        this.ls.doFeedback("Size: " + Math.round(this.curLayout.width) + " x " + Math.round(this.curLayout.height));
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        double d = n;
        double d2 = n2;
        if (this.resizeMode == 0) {
            boolean bl;
            boolean bl2 = d <= this.curLayout.x;
            boolean bl3 = d >= this.curLayout.x + this.curLayout.width;
            boolean bl4 = d2 <= this.curLayout.y;
            boolean bl5 = bl = d2 >= this.curLayout.y + this.curLayout.height;
            if (this.e == this.dg.getRoot()) {
                bl2 = false;
                bl4 = false;
            }
            if (bl2) {
                this.resizeMode = bl4 || d2 - this.curLayout.y < 4.0 ? 5 : (bl || this.curLayout.y + this.curLayout.height - d2 < 4.0 ? 9 : 1);
            } else if (bl3) {
                this.resizeMode = bl4 || d2 - this.curLayout.y < 4.0 ? 6 : (bl || this.curLayout.y + this.curLayout.height - d2 < 4.0 ? 10 : 2);
            } else if (bl4) {
                this.resizeMode = d - this.curLayout.x < 4.0 ? 5 : (this.curLayout.x + this.curLayout.width - d < 4.0 ? 6 : 4);
            } else if (bl) {
                this.resizeMode = d - this.curLayout.x < 4.0 ? 9 : (this.curLayout.x + this.curLayout.width - d < 4.0 ? 10 : 8);
            }
        }
        if (this.resizeMode == 0) {
            return true;
        }
        this.dg.drawEntityOutline(this.gc, this.curLayout, this.e);
        this.doResizeAdjust(this.resizeMode, n, n2);
        this.dg.drawEntityOutline(this.gc, this.curLayout, this.e);
        this.ls.doFeedback("Size: " + Math.round(this.curLayout.width) + " x " + Math.round(this.curLayout.height));
        return true;
    }

    public void mouseUp(Event event, int n, int n2) {
        if (this.e != null) {
            this.dg.saveForUndo();
            this.e.setLayout(this.curLayout);
            this.dg.rescale();
            this.e.fitTo(false);
            this.ls.redrawDg();
        }
        this.ls.clearFeedback();
    }
}

