/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.ClickHandler;
import lsedit.Diagram;
import lsedit.LandscapeViewerCore;
import lsedit.StringLinizer;
import lsedit.TabbedBox;
import lsedit.Util;

public class ResultBox
extends TabbedBox {
    protected static final Font textFont = new Font("Helvetica", 0, 11);
    protected static final Font titleFont = new Font("Helvetica", 1, 14);
    protected static final String helpStr = "This box shows the results of queries, and groupings";
    protected String text;
    protected String title;
    protected ClickHandler ch = null;
    private String m_link;
    private String m_target;

    protected void processLine(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = Util.fontHeight(fontMetrics);
        int n6 = 0;
        while (n6 < string.length()) {
            int n7;
            int n8 = string.indexOf(60, n6);
            if (n8 != n6) {
                String string2 = n8 > n6 ? string.substring(n6, n8) : string.substring(n6);
                Util.drawStringClipped(graphics, string2, n, n2, n3, n4);
                int n9 = fontMetrics.stringWidth(string2);
                if (n9 == 0) {
                    n9 = fontMetrics.charWidth('_') * string2.length();
                }
                n += n9;
                if (n8 < n6) {
                    return;
                }
            }
            if ((n7 = string.indexOf(62, n8)) < 0) {
                return;
            }
            String string3 = string.substring(n8 + 1, n7);
            n6 = n7 + 1;
            if (string3.equals("/a")) {
                graphics.setColor(Color.black);
                this.m_link = null;
                this.m_target = null;
                continue;
            }
            if (!string3.startsWith("a href='")) continue;
            n8 = string3.indexOf(39, 8);
            this.m_link = string3.substring(8, n8);
            string3 = string3.substring(n8 + 1);
            n8 = string3.indexOf("target='");
            string3 = string3.substring(n8 + 8);
            n8 = string3.indexOf("'");
            this.m_target = string3.substring(0, n8);
            graphics.setColor(Color.blue);
        }
    }

    protected void drawContents(Diagram diagram, Graphics graphics, boolean bl) {
        Rectangle rectangle = this.bounds();
        graphics.setFont(titleFont);
        graphics.setColor(titleColor);
        int n = Util.fontHeight(titleFont);
        int n2 = 10;
        int n3 = 5;
        Util.drawStringClipped(graphics, this.title, n2, n3, rectangle.width - 10, n);
        n3 += n + 7;
        graphics.setColor(Color.black);
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n = Util.fontHeight(textFont) - 2;
        int n4 = rectangle.width - 10;
        if (this.scrollBar != null && this.scrollBar.isVisible()) {
            n4 -= 17;
        }
        StringLinizer stringLinizer = new StringLinizer(this.text, fontMetrics, n4);
        this.m_link = null;
        this.m_target = null;
        int n5 = rectangle.height - n - 5;
        while (stringLinizer.hasMoreLines() && n3 < n5) {
            String string = stringLinizer.nextLine();
            this.processLine(graphics, string, n2, n3, rectangle.width - 10, n);
            n3 += n + 2;
        }
    }

    public ResultBox(LandscapeViewerCore landscapeViewerCore) {
        super(landscapeViewerCore, "Results", 140);
    }

    public void set(String string, String string2, ClickHandler clickHandler, boolean bl) {
        this.ch = clickHandler;
        this.title = string;
        this.text = string2;
        if (bl) {
            this.ls.activateTabBox(this);
        }
        this.repaint();
    }

    public void set(String string, String string2, ClickHandler clickHandler) {
        this.set(string, string2, clickHandler, true);
    }

    public void set(String string, String string2) {
        this.set(string, string2, null, true);
    }

    public void clear() {
        this.ch = null;
        this.title = "";
        this.text = "";
        if (this.active) {
            this.repaint();
        }
    }

    public boolean mouseMotion(Event event, int n, int n2) {
        this.ls.setHelpPopup(helpStr, n, n2);
        return true;
    }

    public boolean handleEvent(Diagram diagram, Graphics graphics, Event event) {
        return super.handleEvent(diagram, graphics, event);
    }
}

