/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Event;
import java.awt.Graphics;
import java.awt.Scrollbar;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;
import lsedit.Layout;

public class ScrollableDiagram
extends Diagram {
    protected static final int SB_WIDTH = 12;
    protected static final int SB_HEIGHT = 12;
    protected Scrollbar rightScroll;
    protected Scrollbar bottomScroll;
    protected int diffx;
    protected int diffy;

    protected void posScroll() {
        this.rightScroll.move(this.x + this.width - 5 - 12, this.y + 5);
        this.rightScroll.resize(12, this.height - 10 - 13);
        this.bottomScroll.move(this.x + 5, this.y + this.height - 5 - 12);
        this.bottomScroll.resize(this.width - 10 - 13, 12);
    }

    public Layout calcRootLayout() {
        Layout layout;
        Layout layout2 = this.drawRoot.getChildBoundingBox();
        if (layout2 != null) {
            double d = layout2.x - (double)this.xoffset;
            double d2 = layout2.y - (double)this.yoffset;
            layout = new Layout(0.0, 0.0, Math.max((double)(this.width - 10), d + layout2.width), Math.max((double)(this.height - 10), d2 + layout2.height));
        } else {
            layout = new Layout(0.0, 0.0, this.width - 10, this.height - 10);
        }
        return layout;
    }

    protected void resetScroll() {
    }

    protected Graphics gContext(Graphics graphics) {
        int n = this.rightScroll.isVisible() ? this.width - 27 : this.width - 10;
        int n2 = this.bottomScroll.isVisible() ? this.height - 27 : this.height - 10;
        Graphics graphics2 = graphics.create(this.x + 5, this.y + 5, n, n2);
        return graphics2;
    }

    protected void scrollRightBar(Graphics graphics, Event event) {
        switch (event.id) {
            case 601: 
            case 603: {
                if (this.yoffset < 0) {
                    this.yoffset = Math.min(this.yoffset + this.diffy / 5, 0);
                    this.rescale();
                    this.draw(graphics);
                }
                return;
            }
            case 602: 
            case 604: {
                if (this.yoffset > -this.diffy) {
                    this.yoffset = Math.max(this.yoffset - this.diffy / 5, -this.diffy);
                    this.rescale();
                    this.draw(graphics);
                }
                return;
            }
            case 605: {
                this.yoffset = -((Integer)event.arg).intValue();
                this.rescale();
                this.draw(graphics);
                return;
            }
        }
    }

    protected void scrollBottomBar(Graphics graphics, Event event) {
        switch (event.id) {
            case 601: 
            case 603: {
                if (this.xoffset < 0) {
                    this.xoffset = Math.min(this.xoffset + this.diffx / 5, 0);
                    this.rescale();
                    this.draw(graphics);
                }
                return;
            }
            case 602: 
            case 604: {
                if (this.xoffset > -this.diffx) {
                    this.xoffset = Math.max(this.xoffset - this.diffx / 5, -this.diffx);
                    this.rescale();
                    this.draw(graphics);
                }
                return;
            }
            case 605: {
                this.xoffset = -((Integer)event.arg).intValue();
                this.rescale();
                this.draw(graphics);
                return;
            }
        }
    }

    public ScrollableDiagram(LandscapeViewerCore landscapeViewerCore, Scrollbar scrollbar, Scrollbar scrollbar2) {
        super(landscapeViewerCore, true);
        this.rightScroll = scrollbar;
        this.bottomScroll = scrollbar2;
        this.width = 10;
        this.height = 10;
        this.x = 0;
        this.y = 0;
        this.xoffset = 0;
        this.yoffset = 0;
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.posScroll();
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.posScroll();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.posScroll();
    }

    public Graphics getContext(Graphics graphics) {
        int n = this.rightScroll.isVisible() ? this.width - 27 : this.width - 10;
        int n2 = this.bottomScroll.isVisible() ? this.height - 27 : this.height - 10;
        return graphics.create(this.x + 5, this.y + 5, n, n2);
    }

    public void draw(Graphics graphics) {
        graphics.setColor(Diagram.boxColour);
        graphics.fillRect(this.x, this.y, this.width, this.height);
        graphics.draw3DRect(this.x, this.y, this.width, this.height, true);
        graphics.draw3DRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2, true);
        this.posScroll();
        Graphics graphics2 = this.getContext(graphics);
        this.doDraw(graphics2, this.drawRoot, this.drawRoot != this.rootInstance);
        graphics2.dispose();
    }

    public void draw(Graphics graphics, EntityInstance entityInstance) {
        Graphics graphics2 = this.getContext(graphics);
        super.draw(graphics2, entityInstance);
        graphics2.dispose();
    }

    public void rescale() {
        super.rescale();
        this.resetScroll();
    }

    public int adjustX(int n) {
        return n - (this.x + 5);
    }

    public int adjustY(int n) {
        return n - (this.y + 5);
    }

    public void scroll(Graphics graphics, Event event) {
        if (event.target == this.rightScroll) {
            this.scrollRightBar(graphics, event);
        } else {
            this.scrollBottomBar(graphics, event);
        }
    }

    public void navigateTo(EntityInstance entityInstance) {
        super.navigateTo(entityInstance);
        this.resetScroll();
    }
}

