/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import lsedit.Diagram;
import lsedit.LandscapeViewerCore;
import lsedit.MyComponent;
import lsedit.ScrollableDiagram;
import lsedit.Sizeable;
import lsedit.SizingButton;
import lsedit.Util;

public abstract class TabbedBox
extends MyComponent
implements Sizeable {
    protected static final Color titleColor = Color.red.darker();
    protected static final int SZ_DIM = 16;
    protected static final int SB_WIDTH = 12;
    protected static final int GAP = 5;
    protected Scrollbar scrollBar;
    protected int maxScrollPos;
    protected int nitem = 0;
    protected int vitem = 0;
    protected int itemNo = 0;
    protected LandscapeViewerCore ls;
    protected Dimension tabDim;
    protected boolean active = false;
    protected String title;
    protected int tabOffset;
    protected SizingButton sizingButton = null;

    protected void posControls() {
        Rectangle rectangle = this.bounds();
        this.sizingButton.show();
        this.sizingButton.move(rectangle.x + rectangle.width - 5 - 16 - 1, rectangle.y + this.tabDim.height + 5);
        if (this.scrollBar != null && this.scrollBar.isVisible()) {
            if (this.sizingButton == null) {
                this.scrollBar.move(rectangle.x + rectangle.width - 5 - 12, rectangle.y + this.tabDim.height + 5);
            } else {
                this.scrollBar.move(rectangle.x + rectangle.width - 5 - 12 - 1, rectangle.y + this.tabDim.height + 16 + 10);
            }
        }
    }

    protected void setupScrolling(int n) {
        if (this.scrollBar == null) {
            return;
        }
        Rectangle rectangle = this.bounds();
        int n2 = rectangle.height - this.tabDim.height - 10;
        if (n > n2) {
            if (!this.scrollBar.isVisible()) {
                if (this.sizingButton == null) {
                    this.scrollBar.resize(12, n2);
                } else {
                    this.scrollBar.resize(12, n2 - 16 - 5);
                }
                this.scrollBar.show();
                this.maxScrollPos = n - n2;
                this.posControls();
                this.repaint();
            }
            this.scrollBar.setValues(this.scrollBar.getValue(), n2, 0, n);
        } else if (this.scrollBar.isVisible()) {
            this.scrollBar.setValue(0);
            this.scrollBar.hide();
            this.repaint();
        }
    }

    protected void scroll(Diagram diagram, Graphics graphics, Event event) {
        Object object = event.arg;
        int n = this.scrollBar.getValue();
        switch (event.id) {
            case 601: 
            case 603: {
                if (n <= 0) break;
                n = Math.max(0, n - 10);
                this.repaint();
                break;
            }
            case 602: 
            case 604: {
                if (n >= this.maxScrollPos) break;
                n = Math.min(this.maxScrollPos, n + 10);
                this.repaint();
                break;
            }
            case 605: {
                this.repaint();
                return;
            }
            default: {
                return;
            }
        }
        this.scrollBar.setValue(n);
    }

    protected abstract void drawContents(Diagram var1, Graphics var2, boolean var3);

    public TabbedBox(LandscapeViewerCore landscapeViewerCore, String string, int n) {
        this.ls = landscapeViewerCore;
        this.scrollBar = new Scrollbar();
        landscapeViewerCore.add(this.scrollBar);
        this.scrollBar.hide();
        this.setBackground(Diagram.boxColour);
        this.tabDim = Util.getTabDim(landscapeViewerCore.getGraphics(), string);
        this.title = "&" + string;
        this.tabOffset = n;
        this.sizingButton = new SizingButton(this, 16, 1);
        landscapeViewerCore.add(this.sizingButton);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        ScrollableDiagram scrollableDiagram = this.ls.getDiagram();
        graphics.setColor(this.getBackground());
        if (this.active) {
            boolean bl = this.sizingButton.getKind() == 1;
            graphics.fillRect(0, this.tabDim.height, rectangle.width, rectangle.height - this.tabDim.height);
            Util.drawTabbedFrame(graphics, rectangle, this.title, titleColor, this.tabOffset);
            Graphics graphics2 = graphics.create(0, this.tabDim.height + 5, rectangle.width, rectangle.height - this.tabDim.height - 10);
            this.drawContents(scrollableDiagram, graphics2, bl);
            graphics2.dispose();
        } else {
            Util.drawTab(graphics, this.title, titleColor, this.tabOffset, false);
        }
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.paint(graphics2);
        graphics2.dispose();
    }

    public void repaint() {
        Graphics graphics = this.ls.getGraphics();
        this.draw(graphics);
        graphics.dispose();
    }

    public abstract boolean mouseMotion(Event var1, int var2, int var3);

    public boolean handleEvent(Diagram diagram, Graphics graphics, Event event) {
        if (this.isVisible() && event.target == this.scrollBar) {
            this.scroll(diagram, graphics, event);
            return true;
        }
        return false;
    }

    public void show() {
        super.show();
        this.posControls();
    }

    public void hide() {
        super.hide();
        this.inactivate();
    }

    public void activate() {
        this.active = true;
        this.posControls();
    }

    public void inactivate() {
        if (this.active) {
            this.active = false;
            this.sizingButton.hide();
        }
    }

    public boolean isactive() {
        return this.active;
    }

    public void move(int n, int n2) {
        super.move(n, n2 - this.tabDim.height);
        this.posControls();
    }

    public void resize(int n, int n2) {
        super.move(n, n2 + this.tabDim.height);
        this.posControls();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2 - this.tabDim.height, n3, n4 + this.tabDim.height);
        this.posControls();
    }

    public boolean isOverTab(int n, int n2) {
        Rectangle rectangle = this.bounds();
        return n > rectangle.x + this.tabOffset && n < rectangle.x + this.tabOffset + this.tabDim.width && n2 > rectangle.y && n2 < rectangle.y + this.tabDim.height;
    }

    public void handleSizing() {
        this.ls.toggleRightBoxes();
    }

    public void setButtonState(boolean bl) {
        this.sizingButton.setKind(bl ? 1 : 0);
    }
}

