/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import lsedit.ClickHandler;
import lsedit.Diagram;
import lsedit.LandscapeViewerCore;
import lsedit.MyComponent;
import lsedit.ScrollableDiagram;
import lsedit.StringLinizer;
import lsedit.Util;

public class TextBox
extends MyComponent {
    protected static final int GAP = 5;
    protected static final int SB_WIDTH = 12;
    protected static final int SZ_DIM = 16;
    protected static final int NO_LINK = -1;
    protected static final Color titleColor = Color.red.darker();
    protected static final Font titleFont = new Font("Helvetica", 1, 14);
    protected static final Font textFont = new Font("Helvetica", 0, 11);
    protected LandscapeViewerCore ls;
    protected ClickHandler ch = null;
    protected String text;
    protected String title;
    protected int lineNo = 0;
    protected int numLines;
    protected int maxDisplayable;
    protected int normHeight;
    protected Scrollbar scrollBar;
    protected boolean sizeable = false;
    protected boolean droppable = false;
    protected boolean isOpen = false;
    protected boolean suppress = false;
    protected boolean preformatted = false;
    protected boolean flagSetup = false;
    protected int activeLink = -1;
    protected boolean highlightLink = false;

    protected void posScroll() {
        Rectangle rectangle = this.bounds();
        this.scrollBar.move(rectangle.x + rectangle.width - 12 - 5, rectangle.y + 10 + 16);
        this.scrollBar.resize(12, rectangle.height - 15 - 16);
    }

    protected void doArrowPaint(Graphics graphics, Rectangle rectangle, boolean bl) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (bl) {
            nArray[0] = rectangle.x + 4;
            nArray2[0] = rectangle.y + 4;
            nArray[1] = rectangle.x + rectangle.width - 4;
            nArray2[1] = rectangle.y + 4;
            nArray[2] = rectangle.x + rectangle.width / 2;
            nArray2[2] = rectangle.y + rectangle.height - 4;
        } else {
            nArray[0] = rectangle.x + rectangle.width / 2;
            nArray2[0] = rectangle.y + 4;
            nArray[1] = rectangle.x + 4;
            nArray2[1] = rectangle.y + rectangle.height - 4;
            nArray[2] = rectangle.x + rectangle.width - 4;
            nArray2[2] = rectangle.y + rectangle.height - 4;
        }
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    protected void doDrawDrop(Graphics graphics) {
        if (this.droppable) {
            Rectangle rectangle = this.bounds();
            graphics.setColor(Color.black);
            rectangle.x = rectangle.width - 16 - 10;
            rectangle.y = 5;
            rectangle.width = 16;
            rectangle.height = 16;
            graphics.drawRoundRect(rectangle.x, rectangle.y, 16, 16, 4, 4);
            this.doArrowPaint(graphics, rectangle, !this.isOpen());
        }
    }

    protected void drawText(Graphics graphics, Rectangle rectangle) {
        graphics.setFont(titleFont);
        graphics.setColor(titleColor);
        int n = Util.fontHeight(titleFont);
        int n2 = 5;
        int n3 = 5;
        Util.drawStringClipped(graphics, this.title, n2, n3, rectangle.width - 10, n);
        n3 += n + 7;
        graphics.setColor(Color.black);
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n = Util.fontHeight(textFont) - 2;
        int n4 = rectangle.width - 10;
        if (this.scrollBar != null && this.scrollBar.isVisible()) {
            n4 -= 17;
        }
        StringLinizer stringLinizer = new StringLinizer(this.text, fontMetrics, n4);
        int n5 = 0;
        int n6 = rectangle.height - n - 5;
        while (stringLinizer.hasMoreLines() && n3 < n6) {
            String string = stringLinizer.nextLine();
            if (n5 >= this.lineNo) {
                Util.drawStringClipped(graphics, string, n2, n3, rectangle.width - 10, n);
                n3 += n + 2;
            }
            ++n5;
        }
    }

    protected int countMaxDisplayable(Graphics graphics, boolean bl) {
        graphics.setFont(titleFont);
        graphics.setColor(titleColor);
        int n = Util.fontHeight(titleFont);
        int n2 = 5 + n;
        graphics.setColor(Color.black);
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n = Util.fontHeight(textFont) - 2;
        n2 += n + 7;
        Rectangle rectangle = this.bounds();
        int n3 = rectangle.width - 10;
        if (bl) {
            n3 -= 17;
        }
        StringLinizer stringLinizer = new StringLinizer(this.text, fontMetrics, n3);
        int n4 = 0;
        int n5 = rectangle.height - n - 5;
        while (stringLinizer.hasMoreLines() && n2 < n5) {
            String string = stringLinizer.nextLine();
            n2 += n + 2;
            ++n4;
        }
        return n4;
    }

    protected int countLines(Graphics graphics, boolean bl) {
        Rectangle rectangle = this.bounds();
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = rectangle.width - 10;
        if (bl) {
            n -= 17;
        }
        StringLinizer stringLinizer = new StringLinizer(this.text, fontMetrics, n);
        int n2 = 0;
        while (stringLinizer.hasMoreLines()) {
            String string = stringLinizer.nextLine();
            ++n2;
        }
        return n2;
    }

    protected void scroll(Diagram diagram, Graphics graphics, Event event) {
        Object object = event.arg;
        switch (event.id) {
            case 601: 
            case 603: {
                if (this.lineNo > 0) {
                    --this.lineNo;
                    this.repaint();
                }
                return;
            }
            case 602: 
            case 604: {
                if (this.lineNo + 1 < this.numLines) {
                    ++this.lineNo;
                    this.repaint();
                }
                return;
            }
            case 605: {
                this.lineNo = (Integer)object;
                this.repaint();
                return;
            }
        }
    }

    protected void setupScrolling(Graphics graphics) {
        if (this.scrollBar == null) {
            return;
        }
        this.lineNo = 0;
        this.numLines = this.countLines(graphics, false);
        this.maxDisplayable = this.countMaxDisplayable(graphics, false);
        if (this.numLines > this.maxDisplayable) {
            if (this.flagSetup) {
                this.droppable = this.sizeable;
            }
            this.numLines = this.countLines(graphics, true);
            this.maxDisplayable = this.countMaxDisplayable(graphics, true);
            this.posScroll();
            this.scrollBar.setValues(0, this.maxDisplayable, 0, this.numLines);
            this.scrollBar.show();
        } else {
            if (this.flagSetup) {
                this.droppable = false;
            }
            this.scrollBar.hide();
        }
    }

    protected int overLink(int n, int n2) {
        int n3 = n2 % 20;
        return n3 > 5 && n3 < 9 ? 0 : -1;
    }

    protected void newText() {
        if (this.isOpen) {
            this.toggleSizing();
        } else {
            this.repaint();
        }
    }

    public TextBox(LandscapeViewerCore landscapeViewerCore, boolean bl) {
        this.ls = landscapeViewerCore;
        this.sizeable = bl;
        this.scrollBar = new Scrollbar();
        this.scrollBar.hide();
        this.setBackground(Diagram.boxColour);
        this.resize(5, 5);
        landscapeViewerCore.add(this.scrollBar);
    }

    public TextBox() {
        this.setBackground(Diagram.boxColour);
    }

    public void paint(Graphics graphics) {
        if (this.flagSetup) {
            if (this.title != null) {
                this.setupScrolling(graphics);
            }
            this.flagSetup = false;
            this.repaint();
            return;
        }
        Rectangle rectangle = this.bounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        Util.drawFrame(graphics, rectangle);
        if (this.title != null) {
            this.drawText(graphics, rectangle);
        }
        this.doDrawDrop(graphics);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.paint(graphics2);
        graphics2.dispose();
    }

    public void repaint() {
        if (this.isVisible()) {
            Graphics graphics = this.ls.getGraphics();
            this.draw(graphics);
            graphics.dispose();
        }
    }

    public void set(String string, String string2, ClickHandler clickHandler, boolean bl) {
        this.ch = clickHandler;
        this.title = string;
        this.text = string2;
        this.flagSetup = true;
        this.suppress = false;
        this.preformatted = bl;
        this.newText();
    }

    public void set(String string, String string2, ClickHandler clickHandler) {
        this.set(string, string2, clickHandler, false);
    }

    public void set(String string, String string2) {
        this.set(string, string2, null);
    }

    public boolean handleEvent(Diagram diagram, Graphics graphics, Event event) {
        if (event.target == this.scrollBar) {
            this.scroll(diagram, graphics, event);
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void toggleSizing() {
        this.isOpen = !this.isOpen;
        ScrollableDiagram scrollableDiagram = this.ls.getDiagram();
        Rectangle rectangle = scrollableDiagram.bounds();
        Rectangle rectangle2 = this.bounds();
        if (this.isOpen) {
            this.normHeight = rectangle2.height;
        }
        int n = this.isOpen ? rectangle.height : this.normHeight;
        this.resize(rectangle2.width, n);
        this.setupScrolling(this.ls.getGraphics());
        if (this.isOpen) {
            this.repaint();
        } else {
            this.ls.repaint();
        }
    }

    public void hide() {
        super.hide();
        this.scrollBar.hide();
    }

    public void show() {
        super.show();
        this.flagSetup = true;
        this.repaint();
    }

    public void move(int n, int n2) {
        super.move(n, n2);
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
    }

    public boolean mouseMotion(Event event, int n, int n2) {
        if (this.isMouseOver(n, n2)) {
            if (this.ch != null && this.overLink(n, n2) != -1) {
                this.ls.setCursor(12);
            } else {
                this.ls.setCursor(0);
            }
            return true;
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.isMouseOver(n, n2)) {
            int n3 = this.overLink(n, n2);
            if (this.ch != null && n3 != -1) {
                this.activeLink = n3;
                this.highlightLink = true;
                this.repaint();
            }
        }
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.activeLink != -1) {
            int n3 = this.overLink(n, n2);
            if (n3 == this.activeLink && !this.highlightLink) {
                this.highlightLink = true;
                this.repaint();
            } else if (n3 != this.activeLink && this.highlightLink) {
                this.highlightLink = false;
                this.repaint();
            }
            return true;
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.activeLink != -1) {
            if (this.overLink(n, n2) == this.activeLink) {
                this.ch.processClickedText(this, "test");
            }
            this.activeLink = -1;
            return true;
        }
        return false;
    }

    public void keyProcess(int n) {
        switch (n) {
            case 1003: {
                this.suppress = true;
                if (this.isOpen() || !this.droppable) break;
                this.toggleSizing();
                break;
            }
            case 1002: {
                this.suppress = false;
                if (!this.isOpen()) break;
                this.toggleSizing();
            }
        }
    }
}

