/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.ScreenLayout;
import lsedit.Util;

public class TitleBox
extends Canvas {
    protected static final int MARGIN = 5;
    protected static final Color BACKGROUND_COLOUR = new Color(1.0f, 1.0f, 0.85f);
    protected static final Font textFont = new Font("Helvetica", 0, 12);
    protected Applet ls;
    protected EntityInstance e;

    protected Dimension getLabelDim(Graphics graphics, String string) {
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = Util.fontHeight(fontMetrics);
        int n2 = fontMetrics.stringWidth(string);
        return new Dimension(n2, n);
    }

    public TitleBox(Applet applet) {
        this.ls = applet;
        this.hide();
    }

    public void set(EntityInstance entityInstance, Diagram diagram) {
        if (this.e != entityInstance) {
            this.e = entityInstance;
            Graphics graphics = this.getGraphics();
            Dimension dimension = this.getLabelDim(graphics, entityInstance.getLabel());
            Rectangle rectangle = diagram.bounds();
            this.setBackground(BACKGROUND_COLOUR);
            int n = dimension.width + 10 + 1;
            int n2 = dimension.height + 5;
            this.resize(n, n2);
            ScreenLayout screenLayout = new ScreenLayout(entityInstance.getLayout());
            this.move(rectangle.x + screenLayout.x + screenLayout.width / 2, rectangle.y + screenLayout.y + screenLayout.height + 10);
            this.show();
        }
    }

    public void hide() {
        if (this.e != null) {
            super.hide();
            this.e = null;
        }
    }

    public void paint(Graphics graphics) {
        if (this.e != null) {
            Rectangle rectangle = this.bounds();
            graphics.clearRect(0, 0, rectangle.width, rectangle.height);
            graphics.setColor(Color.black);
            graphics.setFont(textFont);
            this.e.doDrawLabel(graphics, 0.0, 0.0, rectangle.width, rectangle.height, false);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        }
    }
}

