/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import lsedit.HelpBox;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public abstract class ToolBarButton
extends Canvas {
    protected static final double ARROW_L = 5.0;
    protected static final double ARROW_TH = 0.4;
    protected static final Font font = new Font("Helvetica", 0, 12);
    protected static final Font font1 = new Font("Helvetica", 0, 8);
    protected static final int MARGIN = 2;
    protected static final int HEIGHT = 24;
    protected static final int WIDTH = 40;
    protected boolean momentary = false;
    protected boolean depressed = false;
    protected boolean mouseIn = false;
    protected boolean mouseDown = false;
    protected boolean buttonLook = false;
    protected int key = 0;
    protected ToolBarEventHandler teh;
    protected static HelpBox popup = null;

    protected abstract void paintIcon(Graphics var1);

    protected abstract String getDesc();

    protected void drawEdge(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
        double d = n - n3;
        double d2 = n2 - n4;
        double d3 = Math.atan2(d2, d);
        double d4 = Math.min(5.0, Math.sqrt(d * d + d2 * d2));
        double d5 = (double)n3 + d4 * Math.cos(d3 - 0.4);
        double d6 = (double)n4 + d4 * Math.sin(d3 - 0.4);
        double d7 = (double)n3 + d4 * Math.cos(d3 + 0.4);
        double d8 = (double)n4 + d4 * Math.sin(d3 + 0.4);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = Math.round(n3);
        nArray2[0] = Math.round(n4);
        nArray[1] = (int)Math.round(d5);
        nArray2[1] = (int)Math.round(d6);
        nArray[2] = (int)Math.round(d7);
        nArray2[2] = (int)Math.round(d8);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public ToolBarButton(ToolBarEventHandler toolBarEventHandler) {
        this.teh = toolBarEventHandler;
        this.resize(40, 24);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getBackground());
        if (this.depressed) {
            graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        } else if (this.mouseIn || this.buttonLook) {
            graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, !this.mouseDown);
        }
        graphics.setColor(Color.black);
        String string = null;
        int n = 0;
        if (this.key >= 32 && this.key < 256) {
            string = "" + (char)this.key;
            n = 0;
        } else if (this.key > 0 && this.key < 27) {
            string = "^" + (char)(this.key + 64);
            n = 2;
        }
        if (string != null) {
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = fontMetrics.stringWidth(string);
            int n3 = Util.fontHeight(font);
            graphics.drawString(string, dimension.width - n2 + n - 4, dimension.height - (dimension.height - n3) / 2 - 2);
        }
        this.paintIcon(graphics);
    }

    public void setState(boolean bl) {
        this.depressed = bl;
        this.repaint();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mouseDown = true;
        this.repaint();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.mouseDown) {
            this.teh.processKeyEvent(this.key, 0);
        }
        this.mouseDown = false;
        this.repaint();
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.teh.showInfo(this.getDesc());
        Point point = this.location();
        this.teh.setHelpPopup(this.getDesc(), point.x + n, point.y + n2);
        this.mouseIn = true;
        this.repaint();
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.teh.clearHelpPopup();
        this.mouseIn = false;
        this.repaint();
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return true;
    }
}

