/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.CompareFn;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;
import lsedit.LineWalker;
import lsedit.MsgOut;
import lsedit.RealPoint;
import lsedit.RelationClass;
import lsedit.ScreenLayout;
import lsedit.ScreenPoint;
import lsedit.StringCompareFn;

public class Util {
    public static final double ARROW_L = 10.0;
    public static final double ARROW_TH = 0.4;
    public static final int LINE_STYLE_NORMAL = 0;
    public static final int LINE_STYLE_DASHED = 1;
    public static final int LINE_STYLE_DOTTED = 2;
    public static final int LINE_STYLE_INSCRIBED = 3;
    public static final String[] lineStyleName = new String[]{"Normal", "Dashed", "Dotted", "Inscribed"};
    protected static final int DASH_LEN = 4;
    protected static final int DASH_GAP = 3;
    protected static final int DOT_LEN = 0;
    protected static final int DOT_GAP = 4;
    protected static boolean adjustFonts = false;
    protected static boolean reverseZflag = false;
    protected static final Font tabFont = new Font("Helvetica", 1, 10);
    protected static final int GAP = 5;
    protected static final int INSET = 12;
    protected static final int OUTSET = 5;
    protected static final StringCompareFn stringCompareFn = new StringCompareFn();

    private static final int partition(Vector vector, int n, int n2, CompareFn compareFn, boolean bl) {
        Object e = vector.elementAt(n);
        --n;
        ++n2;
        while (true) {
            boolean bl2;
            Object e2 = vector.elementAt(--n2);
            if (bl) {
                bl2 = compareFn.compare(e2, e) > 0;
            } else {
                boolean bl3 = bl2 = compareFn.compare(e2, e) < 0;
            }
            if (bl2) continue;
            do {
                e2 = vector.elementAt(++n);
                if (bl) {
                    bl2 = compareFn.compare(e2, e) < 0;
                    continue;
                }
                boolean bl4 = bl2 = compareFn.compare(e2, e) > 0;
            } while (bl2);
            if (n >= n2) break;
            if (compareFn.compare(vector.elementAt(n), vector.elementAt(n2)) == 0) continue;
            e2 = vector.elementAt(n);
            vector.setElementAt(vector.elementAt(n2), n);
            vector.setElementAt(e2, n2);
        }
        return n2;
    }

    private static final void qsort(Vector vector, int n, int n2, CompareFn compareFn, boolean bl) {
        if (n < n2) {
            int n3 = Util.partition(vector, n, n2, compareFn, bl);
            Util.qsort(vector, n, n3, compareFn, bl);
            Util.qsort(vector, n3 + 1, n2, compareFn, bl);
        }
    }

    private static final void sort(Vector vector, int n, int n2, CompareFn compareFn, boolean bl) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (compareFn.compare(vector.elementAt(0), vector.elementAt(1)) == 1) {
                    Object e = vector.elementAt(0);
                    vector.setElementAt(vector.elementAt(1), 0);
                    vector.setElementAt(e, 1);
                }
                return;
            }
        }
        Util.qsort(vector, n, n2, compareFn, bl);
    }

    public static void sortVector(Vector vector, CompareFn compareFn, boolean bl) {
        Util.sort(vector, 0, vector.size() - 1, compareFn, bl);
    }

    public static void sortVector(Vector vector, boolean bl) {
        Util.sort(vector, 0, vector.size() - 1, stringCompareFn, bl);
    }

    public static void sortVector(Vector vector) {
        Util.sort(vector, 0, vector.size() - 1, stringCompareFn, true);
    }

    public static boolean adjustFontToggle() {
        adjustFonts = !adjustFonts;
        return adjustFonts;
    }

    public static int fontHeight(FontMetrics fontMetrics) {
        return adjustFonts ? fontMetrics.getHeight() / 2 : fontMetrics.getHeight();
    }

    public static int fontHeight(Font font) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(font);
        return adjustFonts ? fontMetrics.getHeight() / 2 : fontMetrics.getHeight();
    }

    public static boolean drawStringClipped(Graphics graphics, String string, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        double d5;
        String string2;
        int n;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = string.length();
        if ((double)fontMetrics.stringWidth(string) > d3) {
            for (n = n2 - 1; n >= 0; --n) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!((double)fontMetrics.stringWidth(stringBuilder.append(string.substring(0, n)).append("...").toString()) > d3)) break;
            }
        }
        if (n < 0) {
            return false;
        }
        if (n == n2 - 1) {
            string2 = string;
            double d6 = fontMetrics.stringWidth(string);
            d5 = bl ? d + d3 / 2.0 - d6 / 2.0 : d;
        } else {
            string2 = string.substring(0, n) + "...";
            d5 = d;
        }
        ScreenPoint screenPoint = bl ? new ScreenPoint(d5, d2 + d4 / 2.0 + (double)(Util.fontHeight(fontMetrics) / 2)) : new ScreenPoint(d5, d2 + (double)Util.fontHeight(fontMetrics));
        graphics.drawString(string2, screenPoint.x, screenPoint.y);
        if (bl2) {
            int n3 = fontMetrics.stringWidth(string2);
            graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint.x + n3, screenPoint.y);
        }
        return n == n2 - 1;
    }

    public static boolean drawStringClipped(Graphics graphics, String string, double d, double d2, double d3, double d4) {
        return Util.drawStringClipped(graphics, string, d, d2, d3, d4, false, false);
    }

    public static boolean drawUnderlinedStringClipped(Graphics graphics, String string, double d, double d2, double d3, double d4) {
        return Util.drawStringClipped(graphics, string, d, d2, d3, d4, false, true);
    }

    protected static int longestSubStr(String string, FontMetrics fontMetrics, int n) {
        int n2 = string.indexOf(10);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if ((n2 = string.indexOf(32)) < 0 || fontMetrics.stringWidth(string) < n) {
            return string.length();
        }
        int n3 = -1;
        while (n2 >= 0) {
            if (fontMetrics.stringWidth(string.substring(0, n2)) > n) {
                return n3 < 0 ? n2 : n3;
            }
            n3 = n2;
            n2 = string.indexOf(n2 + 1, 32);
        }
        return n3;
    }

    public static boolean drawStringWrapped(Graphics graphics, String string, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        double d5;
        int n;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Vector<String> vector = new Vector<String>();
        if (string.indexOf(32) < 0 && string.indexOf(10) < 0) {
            return Util.drawStringClipped(graphics, string, d, d2, d3, d4, bl, bl2);
        }
        while (true) {
            n = Util.longestSubStr(string, fontMetrics, (int)d3);
            vector.addElement(string.substring(0, n));
            if (n == string.length()) break;
            string = string.substring(n + 1);
        }
        int n2 = Util.fontHeight(fontMetrics) * 3 / 4;
        int n3 = vector.size() * n2;
        Enumeration enumeration = vector.elements();
        double d6 = d5 = bl ? d2 + (d4 - (double)n3) / 2.0 + (double)n2 : d2 + (double)n2;
        while (enumeration.hasMoreElements()) {
            double d7;
            String string2;
            string = (String)enumeration.nextElement();
            int n4 = string.length();
            for (n = n4 - 1; n >= 0 && (double)fontMetrics.stringWidth(string.substring(0, n)) > d3; --n) {
            }
            if (n == n4 - 1) {
                string2 = string;
                double d8 = fontMetrics.stringWidth(string);
                d7 = bl ? d + d3 / 2.0 - d8 / 2.0 : d;
            } else {
                string2 = string.substring(0, n);
                d7 = d;
            }
            ScreenPoint screenPoint = new ScreenPoint(d7, d5);
            graphics.drawString(string2, screenPoint.x, screenPoint.y);
            if (bl2) {
                int n5 = fontMetrics.stringWidth(string2);
                graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint.x + n5, screenPoint.y);
            }
            d5 += (double)n2;
        }
        return true;
    }

    public static boolean isUnix() {
        try {
            if (System.getProperty("file.separator").equals("/")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isHTTP(String string) {
        return string.length() > 7 && (string.substring(0, 7).equals("http://") || string.substring(0, 7).equals("HTTP://"));
    }

    public static String prefixOf(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static void drawFrame(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Diagram.boxColour);
        graphics.draw3DRect(0, 0, rectangle.width - 1, rectangle.height - 1, true);
        graphics.draw3DRect(1, 1, rectangle.width - 3, rectangle.height - 3, true);
    }

    public static Dimension getTabDim(Graphics graphics, String string) {
        graphics.setFont(tabFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string) + 10;
        int n2 = Util.fontHeight(tabFont) + 5;
        return new Dimension(n, n2);
    }

    public static void drawTab(Graphics graphics, String string, Color color, int n, boolean bl) {
        boolean bl2 = string.charAt(0) == '&';
        String string2 = bl2 ? string.substring(1) : string;
        graphics.setFont(tabFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = Util.fontHeight(tabFont);
        int n3 = fontMetrics.stringWidth(string2) + 10;
        int n4 = n2 + 5;
        graphics.setColor(Diagram.boxColour);
        graphics.draw3DRect(n, 0, n3, n4, true);
        graphics.draw3DRect(n + 1, 1, n3 - 2, n4, true);
        if (bl) {
            graphics.fillRect(n + 2, 2, n3 - 3, n4 + 10);
        }
        graphics.setColor(color);
        graphics.drawString(string2, n + 5, n2);
        if (bl2) {
            int n5 = fontMetrics.stringWidth(string.substring(1, 2));
            graphics.drawLine(n + 5, n2 + 1, n + n5 + 5, n2 + 1);
        }
    }

    public static void drawTabbedFrame(Graphics graphics, Rectangle rectangle, String string, Color color, int n) {
        int n2 = Util.fontHeight(tabFont) + 5;
        graphics.setColor(Diagram.boxColour);
        graphics.draw3DRect(0, n2, rectangle.width - 1, rectangle.height - n2 - 1, true);
        graphics.draw3DRect(1, n2 + 1, rectangle.width - 3, rectangle.height - n2 - 3, true);
        Util.drawTab(graphics, string, color, n, true);
    }

    public static double parseReal(String string) {
        return new Double(string);
    }

    public static int parseInt(String string) {
        return new Integer(string);
    }

    public static boolean parseBoolean(String string) {
        return string.equals("true");
    }

    protected static String qt(String string) {
        if (string.indexOf(32) >= 0) {
            return "\"" + string + "\"";
        }
        return string;
    }

    protected static String doExpand(String string, String string2, LandscapeViewerCore landscapeViewerCore) {
        boolean bl;
        String string3 = "";
        int n = 0;
        int n2 = string.length();
        MsgOut.dprintln("Expand: " + string);
        do {
            String string4;
            int n3;
            boolean bl2 = bl = ((n3 = string.indexOf(36, n)) == 0 || n3 > 0 && string.charAt(n3 - 1) != '\\') && n3 + 1 < n2;
            if (!bl) continue;
            int n4 = string.indexOf(36, n3 + 1);
            if (n4 < n3) {
                MsgOut.println("Missing delimitting '$' in expansion variable");
                return null;
            }
            string3 = string3 + string.substring(n, n3);
            String string5 = string.substring(n3 + 1, n4);
            if (string5.equals("ID")) {
                string3 = string3 + Util.qt(string2);
            } else if (string5.equals("IDPREFIX")) {
                int n5 = string2.lastIndexOf(46);
                string3 = n5 >= 0 ? string3 + Util.qt(string2.substring(0, n5)) : string3 + Util.qt(string2);
            } else if (string5.equals("IDSUFFIX")) {
                int n6 = string2.lastIndexOf(46);
                if (n6 >= 0) {
                    string3 = string3 + string2.substring(n6 + 1);
                }
            } else if (string5.equals("DGDIR")) {
                String string6 = landscapeViewerCore.getDiagram().getAbsolutePath();
                string4 = Util.dirFromPath(string6);
                string3 = string3 + string4;
            } else if (string5.equals("DGSUFFIX")) {
                String string7 = landscapeViewerCore.getDiagram().getAbsolutePath();
                string4 = Util.nameFromPath(string7);
                int n7 = string4.indexOf(46);
                if (n7 >= 0) {
                    string3 = string3 + string4.substring(n7 + 1);
                }
            } else {
                String string8 = landscapeViewerCore.getParameter(string5);
                if (string8 != null) {
                    string3 = string3 + Util.qt(string8);
                } else {
                    MsgOut.println("Parameter not found: '" + string5 + "'");
                    return "";
                }
            }
            n = n4 + 1;
        } while (bl && n < n2);
        if (n < n2) {
            string3 = string3 + string.substring(n);
        }
        MsgOut.dprintln("Result: " + string3);
        return string3;
    }

    public static String expand(String string, String string2, LandscapeViewerCore landscapeViewerCore) {
        String string3;
        String string4 = Util.doExpand(string, string2, landscapeViewerCore);
        while (!(string3 = string4).equals(string4 = Util.doExpand(string3, string2, landscapeViewerCore))) {
        }
        return string3;
    }

    public static String expand(String string, LandscapeViewerCore landscapeViewerCore) {
        return Util.expand(string, "", landscapeViewerCore);
    }

    public static Frame getFrame(Component component) {
        if (component instanceof Frame) {
            return (Frame)component;
        }
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            return (Frame)component;
        }
        return null;
    }

    public static String dirFromPath(String string) {
        int n;
        int n2 = string.lastIndexOf(47);
        if (n2 > (n = string.lastIndexOf(92))) {
            return string.substring(0, n2);
        }
        if (n > n2) {
            return string.substring(0, n);
        }
        return "";
    }

    public static String nameFromPath(String string) {
        int n;
        int n2 = string.lastIndexOf(47);
        if (n2 > (n = string.lastIndexOf(92))) {
            return string.substring(n2 + 1);
        }
        if (n > n2) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static boolean isBlack(Color color) {
        if (color == Color.black) {
            return true;
        }
        if (color.getRed() != 0) {
            return false;
        }
        if (color.getGreen() != 0) {
            return false;
        }
        return color.getBlue() == 0;
    }

    public static String addNL(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string.length();
        while (n2 + n < n3) {
            int n4;
            for (n4 = n2 + n - 1; n4 > n2 && string.charAt(n4) != ' '; --n4) {
            }
            if (n4 == n2) {
                n4 = n;
            }
            stringBuffer.append(string.substring(n2, n4) + "\n");
            n2 = n4 + 1;
        }
        stringBuffer.append(string.substring(n2));
        return new String(stringBuffer);
    }

    public static String stripNL(String string) {
        return string.replace('\n', ' ');
    }

    public static String quoted(String string) {
        if (string.indexOf(32) >= 0) {
            return "\"" + string + "\"";
        }
        return string;
    }

    protected static void drawLine(Graphics graphics, LineWalker lineWalker) {
        ScreenPoint screenPoint = new ScreenPoint(0.0, 0.0);
        ScreenPoint screenPoint2 = new ScreenPoint(0.0, 0.0);
        while (lineWalker.morePoints()) {
            lineWalker.nextPoints(screenPoint, screenPoint2);
            graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint2.x, screenPoint2.y);
        }
    }

    protected static void drawInscribedLine(Graphics graphics, ScreenPoint screenPoint, ScreenPoint screenPoint2) {
        Color color = graphics.getColor();
        graphics.setColor(Color.gray);
        graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint2.x, screenPoint2.y);
        graphics.setColor(Color.white);
        if (screenPoint.x == screenPoint2.x) {
            graphics.drawLine(screenPoint.x + 1, screenPoint.y, screenPoint2.x + 1, screenPoint2.y);
        } else {
            graphics.drawLine(screenPoint.x, screenPoint.y + 1, screenPoint2.x, screenPoint2.y + 1);
        }
        graphics.setColor(color);
    }

    public static void drawLine(Graphics graphics, ScreenPoint screenPoint, ScreenPoint screenPoint2, int n) {
        switch (n) {
            case 0: {
                graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint2.x, screenPoint2.y);
                break;
            }
            case 2: {
                LineWalker lineWalker = new LineWalker(screenPoint, screenPoint2, 0, 4);
                Util.drawLine(graphics, lineWalker);
                break;
            }
            case 1: {
                LineWalker lineWalker = new LineWalker(screenPoint, screenPoint2, 4, 3);
                Util.drawLine(graphics, lineWalker);
                break;
            }
            case 3: {
                Util.drawInscribedLine(graphics, screenPoint, screenPoint2);
            }
        }
    }

    public static void drawTailPoint(Graphics graphics, RealPoint realPoint) {
        int n = 3;
        ScreenPoint screenPoint = new ScreenPoint(realPoint.x - (double)n, realPoint.y - (double)n);
        graphics.fillOval(screenPoint.x, screenPoint.y, n * 2, n * 2);
    }

    public static void drawArrowHead(Graphics graphics, RealPoint realPoint, RealPoint realPoint2) {
        double d = realPoint.x - realPoint2.x;
        double d2 = realPoint.y - realPoint2.y;
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        double d3 = Math.atan2(d2, d);
        double d4 = Math.min(10.0, Math.sqrt(d * d + d2 * d2));
        double d5 = realPoint2.x + d4 * Math.cos(d3 - 0.4);
        double d6 = realPoint2.y + d4 * Math.sin(d3 - 0.4);
        double d7 = realPoint2.x + d4 * Math.cos(d3 + 0.4);
        double d8 = realPoint2.y + d4 * Math.sin(d3 + 0.4);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = (int)Math.round(realPoint2.x);
        nArray2[0] = (int)Math.round(realPoint2.y);
        nArray[1] = (int)Math.round(d5);
        nArray2[1] = (int)Math.round(d6);
        nArray[2] = (int)Math.round(d7);
        nArray2[2] = (int)Math.round(d8);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public static void drawArrow(Graphics graphics, RealPoint realPoint, RealPoint realPoint2) {
        ScreenPoint screenPoint = new ScreenPoint(realPoint);
        ScreenPoint screenPoint2 = new ScreenPoint(realPoint2);
        graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint2.x, screenPoint2.y);
        Util.drawArrowHead(graphics, realPoint, realPoint2);
    }

    public static void drawOutlineBox(Graphics graphics, ScreenLayout screenLayout, boolean bl) {
        graphics.setColor(Color.gray);
        if (!bl) {
            graphics.drawRect(screenLayout.x, screenLayout.y, screenLayout.width, screenLayout.height);
            return;
        }
        int n = screenLayout.x;
        int n2 = screenLayout.y;
        int n3 = screenLayout.width;
        int n4 = screenLayout.height;
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
        graphics.drawLine(n, n2 + n4, n, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(n + 1, n2 + 1, n + n3, n2 + 1);
        graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2 + n4, n + 1, n2 + n4);
        graphics.drawLine(n + 1, n2 + n4, n + 1, n2 + 1);
    }

    public static void drawGroupBox(Graphics graphics, ScreenLayout screenLayout, String string, Color color, boolean bl) {
        int n = screenLayout.x;
        int n2 = screenLayout.y;
        int n3 = screenLayout.width;
        int n4 = screenLayout.height;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = Util.fontHeight(fontMetrics);
        int n7 = Math.min(12, n3 / 12);
        if (n3 < n7 + 5) {
            Util.drawOutlineBox(graphics, screenLayout, bl);
            return;
        }
        int n8 = n5 + 10 > n3 - n7 - 5 ? n + n3 - 5 : n + n7 + n5 + 10;
        graphics.setColor(Color.gray);
        if (bl) {
            graphics.drawLine(n, n2 + n4, n, n2);
            graphics.drawLine(n, n2, n + n7, n2);
            graphics.drawLine(n8, n2, n + n3, n2);
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n + 1, n2 + n4, n + 1, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + n7, n2 + 1);
            graphics.drawLine(n8, n2 + 1, n + n3, n2 + 1);
            graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + n4);
            graphics.drawLine(n + n3, n2 + n4, n + 1, n2 + n4);
        } else {
            graphics.drawLine(n, n2 + n4, n, n2);
            graphics.drawLine(n, n2, n + n7, n2);
            graphics.drawLine(n8, n2, n + n3, n2);
            graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
            graphics.drawLine(n + n3, n2 + n4, n, n2 + n4);
        }
        graphics.setColor(color);
        Util.drawStringClipped(graphics, string, n + n7 + 5, n2 - n6 * 2 / 3, n8 - n - 10, 100.0);
    }

    public static String mungeName(String string) {
        String string2 = string.replace(' ', '_');
        string2 = string2.replace('/', '-');
        string2 = string2.replace(',', '_');
        return string2.replace('\\', '-');
    }

    public static String hashEdge(RelationClass relationClass, EntityInstance entityInstance, EntityInstance entityInstance2) {
        return entityInstance.getId() + relationClass.getId() + entityInstance2.getId();
    }

    public static int round(double d) {
        return (int)(d + 0.5);
    }
}

