/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Event;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.CommandList;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.EntityInstancePair;
import lsedit.GroupModeHandler;
import lsedit.LandscapeModeHandler;
import lsedit.LandscapeObject;
import lsedit.LandscapeViewerCore;
import lsedit.LsLink;
import lsedit.LsViewMenu;
import lsedit.MoveModeHandler;
import lsedit.NavigateModeHandler;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResizeModeHandler;
import lsedit.ResultBox;
import lsedit.ScrollableDiagram;
import lsedit.TextBox;
import lsedit.Util;

public class ViewModeHandler
extends LandscapeModeHandler {
    protected static final int MENU_BASE = 2000;
    protected static final int EDGE_OPEN_LOW = 2000;
    protected static final int EDGE_OPEN_DST = 2001;
    protected static final int EDGE_OPEN_SRC = 2002;
    protected static final int EDGE_CLOSE_LOW = 2003;
    protected static final int EDGE_CLOSE_DST = 2004;
    protected static final int EDGE_CLOSE_SRC = 2005;
    protected static final int EDGE_NAVIGATE_SRC = 2006;
    protected static final int EDGE_NAVIGATE_DST = 2007;
    protected static final double SMALL_SCALE_UP = 1.1;
    protected static final double SMALL_SCALE_DOWN = 0.9;
    protected static final String SMALL_SCALE_STRING = "10%";
    protected MoveModeHandler moveHandler;
    protected ResizeModeHandler resizeHandler;
    protected NavigateModeHandler navHandler;
    protected GroupModeHandler groupingHandler;
    protected LandscapeModeHandler handler = null;
    protected LsViewMenu popup = null;
    protected EdgePoint ept;
    protected Vector edges = null;
    protected int[] resizeCursor = new int[]{6, 8, 7, 11, 5, 9, 4, 10};
    protected static final String[] entityMenu = new String[]{"Forward query (f)", "Backtrace query (b)", "Contents query (C)", "-", "Hide/show user edge (u)", "Hide/show user inside edges (U)", "Hide/show supplier edge (s)", "Hide/show supplier inside edges (S)", "Hide/show internal edges (I)", "Hide/show contents (c)", "-", "Select all entities (^A)", "-", "Scale smaller in X dim (x)", "Scale larger in X dim (X)", "Scale smaller in Y dim (y)", "Scale larger in Y dim (Y)", "Scale smaller (z)", "Scale larger (Z)"};
    protected static final int[] entityKeys = new int[]{102, 98, 67, 0, 117, 85, 115, 83, 73, 99, 0, 1, 0, 120, 88, 121, 89, 122, 90};
    protected static final String[] edgeMenu = new String[]{"Open to lowest level (l)", "Open edge destination (f)", "Open edge source (s)", "Close to top level (t)", "Close edge destination (F)", "Close edge source (B)", "Navigate to destination", "Navigate to source"};
    protected static final int[] edgeKeys = new int[]{2000, 2001, 2002, 2003, 2004, 2005, 2007, 2006};
    protected int curX;
    protected int curY;

    protected String genLink(EntityInstance entityInstance) {
        return "<a href='test' target='trg'>" + Util.quoted(entityInstance.getLabel()) + "</a>";
    }

    public void reset() {
        this.edges = null;
    }

    protected boolean addPair(Vector vector, EntityInstance entityInstance, EntityInstance entityInstance2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstancePair entityInstancePair = (EntityInstancePair)enumeration.nextElement();
            if (!entityInstancePair.equals(entityInstance, entityInstance2)) continue;
            return false;
        }
        vector.addElement(new EntityInstancePair(entityInstance, entityInstance2));
        return true;
    }

    public void processSelectList(boolean bl) {
        Object object;
        this.dg.clearCache();
        Enumeration enumeration = this.edges.elements();
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        EntityInstance entityInstance = this.dg.getRoot();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2;
            object = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = ((RelationInstance)object).getSrc().getVisibleEntity();
            if (!this.addPair(vector, entityInstance3, entityInstance2 = ((RelationInstance)object).getDst().getVisibleEntity())) continue;
            stringBuffer.append(this.genLink(entityInstance3) + "\t" + ((RelationInstance)object).getRelationClass().getLabel() + "  " + this.genLink(entityInstance2) + "\n");
        }
        object = this.ls.getListBox();
        ((ResultBox)object).set("SELECTED RELATIONS:", new String(stringBuffer), null, bl);
        this.dg.selectEdges(this.edges);
    }

    public void selectEdge(int n, int n2) {
        this.dg.clearFlags();
        this.edges = this.dg.mouseOverAllEdges(n, n2);
        this.processSelectList(false);
        this.ls.repaintDg();
    }

    protected void selectEntity(EntityInstance entityInstance) {
        if (entityInstance.getGroupFlag()) {
            if (entityInstance != this.dg.getKeyEntity()) {
                this.dg.setKeyEntity(entityInstance);
            }
        } else {
            EntityInstance entityInstance2 = this.dg.getKeyEntity();
            if (entityInstance2 != null) {
                this.dg.clearGroupFlags();
            }
            this.dg.setKeyEntity(entityInstance);
        }
    }

    protected void doHandleElision(int n) {
        Vector vector = this.dg.getGroup();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            switch (n) {
                case 99: {
                    this.dg.toggleContainElision(entityInstance);
                    break;
                }
                case 117: {
                    this.dg.toggleInElision(entityInstance);
                    break;
                }
                case 115: {
                    this.dg.toggleOutElision(entityInstance);
                    break;
                }
                case 85: {
                    if (!entityInstance.isOpen()) break;
                    this.dg.toggleClientElision(entityInstance);
                    break;
                }
                case 83: {
                    if (!entityInstance.isOpen()) break;
                    this.dg.toggleSupplierElision(entityInstance);
                    break;
                }
                case 73: {
                    if (!entityInstance.isOpen()) break;
                    this.dg.toggleInternalElision(entityInstance);
                }
            }
        }
    }

    protected void handleElision(int n) {
        Vector vector = this.dg.getGroup();
        if (vector == null) {
            this.e = this.dg.mouseOverEx(this.ls.getMousePos());
            if (this.e == null) {
                return;
            }
            this.selectEntity(this.e);
        }
        String string = "";
        switch (n) {
            case 99: {
                string = "Containment";
                this.doHandleElision(n);
                break;
            }
            case 117: {
                string = "Destination edges";
                this.doHandleElision(n);
                break;
            }
            case 115: {
                string = "Source edges";
                this.doHandleElision(n);
                break;
            }
            case 85: {
                string = "Use inside edges";
                this.doHandleElision(n);
                break;
            }
            case 83: {
                string = "Use outside edges";
                this.doHandleElision(n);
                break;
            }
            case 73: {
                string = "Internal edges";
                this.doHandleElision(n);
            }
        }
        this.ls.doFeedback(string + " elision toggled for group");
    }

    protected boolean edgeOpenSrc(Vector vector) {
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance;
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = relationInstance.getSrc();
            if (entityInstance2 == (entityInstance = entityInstance2.getVisibleEntity())) continue;
            entityInstance.setTempOpenFlag(1);
            bl = true;
        }
        return bl;
    }

    protected boolean edgeOpenDst(Vector vector) {
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance;
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = relationInstance.getDst();
            if (entityInstance2 == (entityInstance = entityInstance2.getVisibleEntity())) continue;
            entityInstance.setTempOpenFlag(1);
            bl = true;
        }
        return bl;
    }

    protected boolean edgeCloseSrc(Vector vector) {
        EntityInstance entityInstance = this.dg.getRoot();
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2;
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getSrc().getVisibleEntity().getParent();
            if (entityInstance3 == (entityInstance2 = relationInstance.getDst().common(entityInstance3))) continue;
            entityInstance3.setTempOpenFlag(0);
            bl = true;
        }
        return bl;
    }

    protected boolean edgeCloseDst(Vector vector) {
        EntityInstance entityInstance = this.dg.getRoot();
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2;
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getDst().getVisibleEntity().getParent();
            if (entityInstance3 == (entityInstance2 = relationInstance.getSrc().common(entityInstance3))) continue;
            entityInstance3.setTempOpenFlag(0);
            bl = true;
        }
        return bl;
    }

    protected void edgeNavigateSrc(Vector vector) {
    }

    protected void edgeNavigateDst(Vector vector) {
    }

    protected void handleEdgeExpansion(int n) {
        boolean bl;
        this.dg.clearCache();
        if (this.edges == null) {
            this.ls.error("An edge hasn't been selected");
            return;
        }
        boolean bl2 = false;
        String string = "";
        switch (n) {
            case 2000: 
            case 2001: 
            case 2002: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        boolean bl3 = false;
        switch (n) {
            case 2000: {
                boolean bl4;
                do {
                    this.dg.clearCache();
                    bl4 = this.edgeOpenSrc(this.edges);
                    bl3 |= bl4;
                } while (bl4);
                do {
                    this.dg.clearCache();
                    bl4 = this.edgeOpenDst(this.edges);
                    bl3 |= bl4;
                } while (bl4);
                string = "Opened to lowest level.";
                break;
            }
            case 2003: {
                boolean bl5;
                do {
                    this.dg.clearCache();
                    bl5 = this.edgeCloseSrc(this.edges);
                    bl3 |= bl5;
                } while (bl5);
                do {
                    this.dg.clearCache();
                    bl5 = this.edgeCloseDst(this.edges);
                    bl3 |= bl5;
                } while (bl5);
                string = "Closed to top level.";
                break;
            }
            case 2002: {
                bl3 = this.edgeOpenSrc(this.edges);
                string = "Opened source edge.";
                break;
            }
            case 2001: {
                bl3 = this.edgeOpenDst(this.edges);
                string = "Opened destination edge.";
                break;
            }
            case 2005: {
                bl3 = this.edgeCloseSrc(this.edges);
                string = "Closed source edge.";
                break;
            }
            case 2004: {
                bl3 = this.edgeCloseDst(this.edges);
                string = "Closed destination edge.";
                break;
            }
            case 2006: {
                this.edgeNavigateSrc(this.edges);
                return;
            }
            case 2007: {
                this.edgeNavigateDst(this.edges);
                return;
            }
        }
        if (bl3) {
            this.processSelectList(true);
            this.ls.doFeedback(string);
        } else if (bl) {
            this.ls.error("No further expansion is possible");
        } else {
            this.ls.error("No further contraction is possible");
        }
    }

    protected boolean goodQueryEdge(EntityInstance entityInstance, EntityInstance entityInstance2, EntityInstance entityInstance3) {
        if (entityInstance.descendent(entityInstance2) || entityInstance2.descendent(entityInstance)) {
            return false;
        }
        if (this.dg.isClientOrSupplier(entityInstance)) {
            return entityInstance3.descendent(entityInstance2);
        }
        return true;
    }

    protected int addToForwardEntityList(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass, Vector vector) {
        LandscapeObject landscapeObject;
        Enumeration enumeration = entityInstance2.srcRelationElements();
        EntityInstance entityInstance3 = this.dg.getRoot();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4;
            EntityInstance entityInstance5;
            landscapeObject = (RelationInstance)enumeration.nextElement();
            if (((RelationInstance)landscapeObject).getRelationClass() != relationClass || (entityInstance5 = (entityInstance4 = ((RelationInstance)landscapeObject).getDst()).getVisibleEntity()) == null || !this.goodQueryEdge(entityInstance, entityInstance4, entityInstance3)) continue;
            String string = this.genLink(entityInstance5);
            int n2 = vector.indexOf(string);
            ((RelationInstance)landscapeObject).setHighlightFlag();
            entityInstance4.setHighlightFlag();
            if (n2 >= 0) continue;
            entityInstance5.setHighlightFlag();
            if (this.ls.getGroupQueryFlag()) {
                entityInstance5.setGroupFlag();
            }
            vector.addElement(string);
            ++n;
        }
        enumeration = entityInstance2.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            n += this.addToForwardEntityList(entityInstance, (EntityInstance)landscapeObject, relationClass, vector);
        }
        return n;
    }

    protected int addForwardRelation(EntityInstance entityInstance, RelationClass relationClass, StringBuffer stringBuffer, boolean bl) {
        Vector vector = new Vector();
        int n = this.addToForwardEntityList(entityInstance, entityInstance, relationClass, vector);
        if (n > 0 || bl) {
            stringBuffer.append(this.genLink(entityInstance) + "  " + relationClass.getLabel() + " ?\n");
        }
        if (n > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\t" + string + "\n");
            }
        }
        return n;
    }

    protected int showForwardEdges(EntityInstance entityInstance, StringBuffer stringBuffer) {
        if (this.dg.isSupplier(entityInstance)) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = this.dg.enumRelations();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (!relationClass.isActive()) continue;
            int n2 = this.addForwardRelation(entityInstance, relationClass, stringBuffer, false);
            n += n2;
            if (n2 <= 0) continue;
            stringBuffer.append("\n");
        }
        return n;
    }

    protected void getSrcRelationWithClosure(EntityInstance entityInstance, Vector vector) {
        Enumeration enumeration = entityInstance.srcRelationElements();
        EntityInstance entityInstance2 = this.dg.getRoot();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getDst();
            boolean bl = entityInstance3.getHighlightFlag();
            relationInstance.setHighlightFlag();
            if (vector.indexOf(relationInstance) < 0) {
                vector.addElement(relationInstance);
            }
            if (bl) continue;
            entityInstance3.setHighlightFlag();
            if (this.ls.getGroupQueryFlag()) {
                entityInstance3.setGroupFlag();
            }
            this.getSrcRelationWithClosure(entityInstance3, vector);
        }
    }

    protected int addRelations(EntityInstance entityInstance, RelationClass relationClass, Vector vector, StringBuffer stringBuffer, boolean bl) {
        int n = 0;
        if (vector.size() > 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
                if (relationInstance.getRelationClass() != relationClass) continue;
                relationInstance.setHighlightFlag();
                stringBuffer2.append("\t" + relationInstance.getSrc().getLabel() + " " + relationInstance.getDst().getLabel() + "\n");
                ++n;
            }
            if (n > 0) {
                if (bl) {
                    stringBuffer.append(entityInstance.getLabel() + " " + relationClass.getLabel() + " *\n");
                } else {
                    stringBuffer.append("\t* " + relationClass.getLabel() + " " + entityInstance.getLabel() + "\n");
                }
                stringBuffer.append(stringBuffer2);
            }
        }
        return n;
    }

    protected int showSrcEdgesWithClosure(EntityInstance entityInstance, StringBuffer stringBuffer) {
        Enumeration enumeration = entityInstance.srcRelationElements();
        Vector vector = new Vector();
        int n = 0;
        this.dg.clearQueryFlags();
        this.getSrcRelationWithClosure(entityInstance, vector);
        this.dg.clearQueryFlags();
        Enumeration enumeration2 = this.dg.enumRelations();
        while (enumeration2.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration2.nextElement();
            if (!relationClass.isActive()) continue;
            int n2 = this.addRelations(entityInstance, relationClass, vector, stringBuffer, true);
            n += n2;
            if (n2 <= 0) continue;
            stringBuffer.append("\n");
        }
        return n;
    }

    public int addToBackEntityList(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass, Vector vector) {
        LandscapeObject landscapeObject;
        Enumeration enumeration = entityInstance2.dstRelationElements();
        int n = 0;
        EntityInstance entityInstance3 = this.dg.getRoot();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4;
            EntityInstance entityInstance5;
            landscapeObject = (RelationInstance)enumeration.nextElement();
            if (((RelationInstance)landscapeObject).getRelationClass() != relationClass || (entityInstance5 = (entityInstance4 = ((RelationInstance)landscapeObject).getSrc()).getVisibleEntity()) == null || !this.goodQueryEdge(entityInstance4, entityInstance, entityInstance3)) continue;
            String string = this.genLink(entityInstance5);
            int n2 = vector.indexOf(string);
            ((RelationInstance)landscapeObject).setHighlightFlag();
            entityInstance4.setHighlightFlag();
            if (n2 >= 0) continue;
            entityInstance5.setHighlightFlag();
            if (this.ls.getGroupQueryFlag()) {
                entityInstance5.setGroupFlag();
            }
            vector.addElement(string);
            ++n;
        }
        enumeration = entityInstance2.getChildren();
        while (enumeration.hasMoreElements()) {
            landscapeObject = (EntityInstance)enumeration.nextElement();
            n += this.addToBackEntityList(entityInstance, (EntityInstance)landscapeObject, relationClass, vector);
        }
        return n;
    }

    public int addDstRelation(EntityInstance entityInstance, RelationClass relationClass, StringBuffer stringBuffer, boolean bl) {
        Vector vector = new Vector();
        int n = this.addToBackEntityList(entityInstance, entityInstance, relationClass, vector);
        if (n > 0 || bl) {
            stringBuffer.append("? " + relationClass.getLabel() + "\t" + this.genLink(entityInstance) + "\n");
        }
        if (n > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\t" + string + "\n");
            }
        }
        return n;
    }

    public int showDstEdges(EntityInstance entityInstance, StringBuffer stringBuffer) {
        int n = 0;
        if (!this.dg.isClient(entityInstance)) {
            Enumeration enumeration = this.dg.enumRelations();
            while (enumeration.hasMoreElements()) {
                RelationClass relationClass = (RelationClass)enumeration.nextElement();
                if (!relationClass.isActive()) continue;
                int n2 = this.addDstRelation(entityInstance, relationClass, stringBuffer, false);
                n += n2;
                if (n2 <= 0) continue;
                stringBuffer.append("\n");
            }
        }
        return n;
    }

    protected void getDstRelationWithClosure(EntityInstance entityInstance, Vector vector) {
        Enumeration enumeration = entityInstance.dstRelationElements();
        EntityInstance entityInstance2 = this.dg.getRoot();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getSrc();
            boolean bl = entityInstance3.getHighlightFlag();
            relationInstance.setHighlightFlag();
            if (vector.indexOf(relationInstance) < 0) {
                vector.addElement(relationInstance);
            }
            if (bl) continue;
            entityInstance3.setHighlightFlag();
            if (this.ls.getGroupQueryFlag()) {
                entityInstance3.setGroupFlag();
            }
            this.getDstRelationWithClosure(entityInstance3, vector);
        }
    }

    protected int showDstEdgesWithClosure(EntityInstance entityInstance, StringBuffer stringBuffer) {
        Enumeration enumeration = entityInstance.srcRelationElements();
        Vector vector = new Vector();
        int n = 0;
        this.dg.clearQueryFlags();
        this.getDstRelationWithClosure(entityInstance, vector);
        this.dg.clearQueryFlags();
        Enumeration enumeration2 = this.dg.enumRelations();
        while (enumeration2.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration2.nextElement();
            if (!relationClass.isActive()) continue;
            int n2 = this.addRelations(entityInstance, relationClass, vector, stringBuffer, false);
            n += n2;
            if (n2 <= 0) continue;
            stringBuffer.append("\n");
        }
        return n;
    }

    protected int showContents(EntityInstance entityInstance, StringBuffer stringBuffer) {
        Object object;
        Enumeration enumeration = entityInstance.getChildren();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (EntityInstance)enumeration.nextElement();
            vector.addElement(Util.quoted(((LandscapeObject)object).getLabel()) + " (" + ((EntityInstance)object).getEntityClass().getLabel() + ")");
            ++n;
        }
        stringBuffer.append(entityInstance.getLabel() + "\n contains (" + n + " items):\n\n");
        if (n > 0) {
            Util.sortVector(vector);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                stringBuffer.append((String)object + "\n");
            }
        }
        return n;
    }

    protected int doQueryEntity(EntityInstance entityInstance, int n, StringBuffer stringBuffer) {
        switch (n) {
            case 102: 
            case 113: {
                return this.showForwardEdges(entityInstance, stringBuffer);
            }
            case 70: {
                return this.showSrcEdgesWithClosure(entityInstance, stringBuffer);
            }
            case 98: {
                return this.showDstEdges(entityInstance, stringBuffer);
            }
            case 66: {
                return this.showDstEdgesWithClosure(entityInstance, stringBuffer);
            }
            case 67: {
                return this.showContents(entityInstance, stringBuffer);
            }
        }
        return 0;
    }

    protected void queryEntity(int n) {
        Object object;
        ResultBox resultBox = this.ls.getListBox();
        Vector vector = this.dg.getGroup();
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.dg.getQueryPersistance()) {
            this.dg.clearQueryFlags();
        }
        if (vector == null) {
            if (n == 67) {
                this.doQueryEntity(this.dg.getRoot(), n, stringBuffer);
                resultBox.set("CONTENTS", new String(stringBuffer));
                return;
            }
            this.e = this.dg.mouseOverEx(this.ls.getMousePos());
            if (this.e != null) {
                this.selectEntity(this.e);
                vector = this.dg.getGroup();
            } else {
                this.ls.error("No entity or group is selected");
                return;
            }
        }
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (EntityInstance)enumeration.nextElement();
            int n3 = this.doQueryEntity((EntityInstance)object, n, stringBuffer);
            if (n3 > 0) {
                stringBuffer.append("\n");
            }
            n2 += n3;
        }
        object = "";
        if (n2 == 0) {
            stringBuffer.append("NO ENTITIES");
        }
        switch (n) {
            case 102: 
            case 113: {
                object = "FORWARD QUERY";
                break;
            }
            case 70: {
                object = "FORWARD QUERY (closure)";
                break;
            }
            case 98: {
                object = "BACKTRACE QUERY";
                break;
            }
            case 66: {
                object = "BACKTRACE QUERY (closure)";
                break;
            }
            case 67: {
                object = "CONTENTS";
                resultBox.set((String)object, new String(stringBuffer));
                return;
            }
        }
        resultBox.set((String)object, new String(stringBuffer));
        this.dg.setForHighlightEdges();
    }

    protected void doScaleEntity(EntityInstance entityInstance, int n, boolean bl) {
        switch (n) {
            case 120: {
                entityInstance.scaleX(0.9, bl);
                break;
            }
            case 88: {
                entityInstance.scaleX(1.1, bl);
                break;
            }
            case 121: {
                entityInstance.scaleY(0.9, bl);
                break;
            }
            case 89: {
                entityInstance.scaleY(1.1, bl);
                break;
            }
            case 122: {
                entityInstance.scale(0.9, bl);
                break;
            }
            case 90: {
                entityInstance.scale(1.1, bl);
            }
        }
    }

    protected void scaleEntity(int n, boolean bl) {
        Vector vector = this.dg.getGroup();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                this.doScaleEntity(entityInstance, n, bl);
            }
        } else {
            switch (n) {
                case 90: {
                    if (this.dg.zoomIn(1.1)) {
                        this.ls.doFeedback("Zoomed in (10%)");
                    }
                    return;
                }
                case 122: {
                    if (this.dg.zoomOut(0.9)) {
                        this.ls.doFeedback("Zoomed out (10%)");
                    }
                    return;
                }
                case 88: {
                    if (this.dg.scaleX(1.1)) {
                        this.ls.doFeedback("Scaled X direction (10%)");
                    }
                    return;
                }
                case 120: {
                    if (this.dg.scaleX(0.9)) {
                        this.ls.doFeedback("Scaled X direction (-10%)");
                    }
                    return;
                }
                case 89: {
                    if (this.dg.scaleY(1.1)) {
                        this.ls.doFeedback("Scaled Y direction (10%)");
                    }
                    return;
                }
                case 121: {
                    if (this.dg.scaleY(0.9)) {
                        this.ls.doFeedback("Scaled Y direction (-10%)");
                    }
                    return;
                }
            }
        }
    }

    protected boolean handleRelnCommands(int n, int n2) {
        switch (n) {
            case 97: {
                break;
            }
            case 70: {
                return this.handleRelnCommands(2004, 0);
            }
            case 102: {
                return this.handleRelnCommands(2001, 0);
            }
            case 66: {
                return this.handleRelnCommands(2005, 0);
            }
            case 98: {
                return this.handleRelnCommands(2002, 0);
            }
            case 108: {
                return this.handleRelnCommands(2000, 0);
            }
            case 76: 
            case 116: {
                return this.handleRelnCommands(2003, 0);
            }
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: {
                this.handleEdgeExpansion(n);
                this.ls.redrawDg();
                return true;
            }
            default: {
                return false;
            }
        }
        this.e = null;
        this.ri = null;
        this.bend = null;
        this.dg.setDrawEdges(true);
        this.ls.redrawDg();
        return true;
    }

    protected boolean exclusiveEntityCommand(int n) {
        switch (n) {
            case 10: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: {
                return true;
            }
        }
        return false;
    }

    protected void navigateTo(EntityInstance entityInstance) {
        this.ls.followLink(entityInstance, false);
    }

    protected boolean handleEntityCommands(int n, int n2) {
        boolean bl;
        boolean bl2 = !this.mouseIsDown;
        boolean bl3 = (n2 & 1) != 0;
        boolean bl4 = bl = (n2 & 8) != 0;
        if (this.e == null) {
            this.e = this.dg.getKeyEntity();
            if (this.e == null) {
                this.e = this.dg.getRoot();
            }
        }
        switch (n) {
            case 66: 
            case 67: 
            case 70: 
            case 98: 
            case 102: 
            case 113: {
                this.queryEntity(n);
                break;
            }
            case 73: 
            case 83: 
            case 85: 
            case 99: 
            case 115: 
            case 117: {
                this.handleElision(n);
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 120: 
            case 121: 
            case 122: {
                this.scaleEntity(n, bl2);
                break;
            }
            case 1: {
                this.groupingHandler.groupAll();
                this.e = null;
                break;
            }
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: {
                this.groupingHandler.moveGroup(n);
                break;
            }
            case 108: {
                this.edges = this.dg.getHighlightedEdges();
                if (this.edges != null) {
                    return this.handleRelnCommands(2000, 0);
                }
                this.ls.error("No edges highlighted");
                return true;
            }
            case 10: {
                if (bl3) {
                    this.e = this.dg.getRoot().getEnterableParent();
                    if (this.e == null) {
                        this.ls.error("At topmost landscape");
                    } else {
                        this.navigateTo(this.e);
                    }
                } else {
                    this.e = this.dg.mouseOverEx(this.ls.getMousePos());
                    if (this.e != null) {
                        EntityInstance entityInstance = this.dg.getRoot();
                        if (this.e == entityInstance) {
                            this.ls.error("Already in: " + this.e.getLabel());
                        } else if (this.e == entityInstance.getParent()) {
                            this.navigateTo(this.e);
                        } else if (this.dg.isClientOrSupplier(this.e)) {
                            if (this.e.hasChildren()) {
                                this.navigateTo(this.e);
                            } else {
                                this.navigateTo(this.e.getEnterableParent());
                            }
                        } else {
                            while (this.e.getParent() != entityInstance && this.e.getParent().isEnterable()) {
                                this.e = this.e.getParent();
                            }
                            if (this.e.isEnterable()) {
                                this.navigateTo(this.e);
                            } else {
                                this.ls.error("Can't navigate into: " + this.e.getLabel());
                            }
                        }
                    }
                }
                this.e = null;
                break;
            }
            default: {
                this.e = null;
                this.ri = null;
                this.bend = null;
                return false;
            }
        }
        this.ri = null;
        this.bend = null;
        if (this.e != null) {
            this.ls.redrawDg();
        }
        this.e = null;
        return true;
    }

    protected void handleMenuCommand(Event event, int n, int n2) {
        LsLink lsLink = this.popup.getLink(event, event.x, event.y);
        if (lsLink != null && lsLink.url != null) {
            if (this.ri == null) {
                this.selectEntity(this.e);
            }
            if (lsLink.target == 5) {
                this.processKey(Util.parseInt(lsLink.url), 0);
            } else {
                String string = this.ri == null ? LsLink.expand(lsLink.url, this.e, this.ls) : LsLink.expand(lsLink.url, this.ri, this.ls);
                if (string != null) {
                    this.ls.followLink(string, lsLink.target);
                }
            }
        }
    }

    protected void popupMenu(Event event, int n, int n2) {
        this.e = this.dg.mouseOverEx(n, n2);
        this.ri = this.dg.mouseOverEdge(this.e, n, n2);
        if (this.ri != null) {
            this.popup.set("Entity options", new CommandList(edgeMenu, edgeKeys), null, this.dg.getRoot(), this.ls, event.x, event.y);
        } else {
            this.popup.set("Entity options", new CommandList(entityMenu, entityKeys), null, this.dg.getRoot(), this.ls, event.x, event.y);
        }
    }

    public ViewModeHandler() {
        this.moveHandler = new MoveModeHandler();
        this.resizeHandler = new ResizeModeHandler();
        this.navHandler = new NavigateModeHandler();
        this.groupingHandler = new GroupModeHandler(this);
    }

    public void init(LandscapeViewerCore landscapeViewerCore) {
        super.init(landscapeViewerCore);
        this.moveHandler.init(landscapeViewerCore);
        this.resizeHandler.init(landscapeViewerCore);
        this.navHandler.init(landscapeViewerCore);
        this.groupingHandler.init(landscapeViewerCore);
    }

    public void select(ScrollableDiagram scrollableDiagram) {
        super.select(scrollableDiagram);
        this.moveHandler.select(scrollableDiagram);
        this.resizeHandler.select(scrollableDiagram);
        this.navHandler.select(scrollableDiagram);
        this.groupingHandler.select(scrollableDiagram);
    }

    public void start() {
        super.start();
        this.moveHandler.start();
        this.resizeHandler.start();
        this.navHandler.start();
        this.groupingHandler.start();
    }

    public void cleanup() {
        super.cleanup();
        this.moveHandler.cleanup();
        this.resizeHandler.cleanup();
        this.navHandler.cleanup();
        this.groupingHandler.cleanup();
    }

    public void mouseDoubleClick(Event event, int n, int n2) {
        this.handleEntityCommands(10, 0);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        boolean bl;
        this.mouseIsDown = true;
        this.e = this.dg.mouseOverEx(n, n2);
        if (this.e == null) {
            return false;
        }
        if (this.dg.mouseOverEnterExit(this.e, n, n2)) {
            this.handler = null;
            return true;
        }
        this.ri = this.dg.mouseOverEdge(this.e, n, n2);
        if (this.ri != null) {
            this.selectEdge(n, n2);
            return true;
        }
        if (this.edges != null) {
            this.edges = null;
            this.dg.clearFlags();
        }
        this.curX = n;
        this.curY = n2;
        boolean bl2 = this.e == this.dg.getRoot();
        boolean bl3 = (event.modifiers & 1) != 0;
        boolean bl4 = (event.modifiers & 2) != 0;
        boolean bl5 = (event.modifiers & 8) != 0;
        boolean bl6 = bl = (event.modifiers & 4) != 0;
        if (bl2 && !bl) {
            this.dg.clearFlags();
        }
        LandscapeModeHandler landscapeModeHandler = null;
        if (bl4) {
            if (this.navHandler.mouseDown(event, n, n2)) {
                landscapeModeHandler = this.navHandler;
            }
        } else if (bl3) {
            if (this.groupingHandler.mouseDown(event, n, n2)) {
                landscapeModeHandler = this.groupingHandler;
            }
        } else {
            if (bl) {
                if (this.popup != null) {
                    this.popup.hide();
                    this.ls.remove(this.popup);
                    this.popup = null;
                }
                this.ls.setCursor(0);
                this.popup = new LsViewMenu();
                this.ls.add(this.popup);
                this.popupMenu(event, n, n2);
                return true;
            }
            if (this.moveHandler.mouseDown(event, n, n2)) {
                landscapeModeHandler = this.moveHandler;
            } else if (this.resizeHandler.mouseDown(event, n, n2)) {
                landscapeModeHandler = this.resizeHandler;
            } else if (this.groupingHandler.mouseDown(event, n, n2)) {
                landscapeModeHandler = this.groupingHandler;
            }
        }
        if (landscapeModeHandler != null) {
            this.handler = landscapeModeHandler;
        }
        return true;
    }

    public void mouseMotion(EntityInstance entityInstance, int n, int n2) {
        int n3;
        if (this.dg.mouseOverEnterExit(entityInstance, n, n2) || this.dg.mouseOverEdge(entityInstance, n, n2) != null) {
            this.ls.setCursor(12);
            return;
        }
        if (entityInstance != null && entityInstance != this.dg.getRoot() && entityInstance.getGroupKeyFlag() && (n3 = entityInstance.overResizeTab(n, n2)) != -1) {
            this.ls.setCursor(this.resizeCursor[n3]);
            return;
        }
        this.ls.setCursor(0);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.popup != null) {
            this.popup.mouseDrag(event, event.x, event.y);
            return true;
        }
        if (this.handler != null) {
            return this.handler.mouseDrag(event, n, n2);
        }
        return false;
    }

    public void mouseUp(Event event, int n, int n2) {
        if (this.popup != null) {
            this.popup.hide();
            this.handleMenuCommand(event, n, n2);
            this.ls.remove(this.popup);
            this.popup = null;
        } else if (this.handler != null) {
            this.handler.mouseUp(event, n, n2);
        } else if (this.dg.mouseOverEnterExit(this.e, n, n2)) {
            int n3 = this.e == this.dg.getRoot().getParent() ? 1 : 0;
            this.handleEntityCommands(10, n3);
        }
        this.mouseIsDown = false;
    }

    public boolean processKey(int n, int n2) {
        if (!this.exclusiveEntityCommand(n) && this.edges != null) {
            return this.handleRelnCommands(n, n2);
        }
        return this.handleEntityCommands(n, n2);
    }

    public void setHelp(TextBox textBox) {
    }

    public void processClickedText(TextBox textBox, String string) {
        this.ls.doFeedback("Clicked: " + string);
    }
}

