package lsedit;
import java.applet.*;
import java.awt.*;
import java.util.*;

abstract public class ArrowButton extends Canvas 
{

	static public final int BTN_DOWN		= 0;
	static public final int BTN_UP		    = 1;
	static public final int BTN_LEFT		= 2;
	static public final int BTN_RIGHT		= 3;

	protected TextBox tb;
	protected boolean enabled = true;
	protected boolean upState = true;
	protected int btnKind;
	protected int dim;

	abstract protected void handleClick();

	public ArrowButton(int dim, int kind) 
	{
		this.dim = dim;
		this.btnKind = kind;
		resize(dim, dim);
	}

	public void paint(Graphics g) 
	{
		g.setColor(Diagram.boxColour);
		g.fillRect(0, 0, dim, dim);
		g.draw3DRect(0, 0, dim, dim, upState);
		g.draw3DRect(1, 1, dim-2, dim-2, upState);
		g.setColor(enabled ? Color.black : Color.gray);

		int os = upState ? 0 : 1;

		int xp[] = new int[3];
		int yp[] = new int[3];

		switch(btnKind) 
		{
		case BTN_DOWN:
			xp[0] = 4 + os;
			yp[0] = 4 + os;
			xp[1] = dim-4 + os;
			yp[1] = 4 + os; 
			xp[2] = dim/2 + os;
			yp[2] = dim-4 + os;
			break;

		case BTN_UP:
			xp[0] = dim/2 + os;
			yp[0] = 4 + os;
			xp[1] = 4 + os;
			yp[1] = dim-4 + os;
			xp[2] = dim-4 + os;
			yp[2] = dim-4 + os;
			break;

		case BTN_LEFT: 
			xp[0] = dim-4 + os;
			yp[0] = 4 + os;
			xp[1] = dim-4 + os;
			yp[1] = dim-4 + os;
			xp[2] = 4 + os;
			yp[2] = dim/2 + os;
			break;

		case BTN_RIGHT:
			xp[0] = 4 + os;
			yp[0] = 4 + os;
			xp[1] = dim-4 + os;

			yp[1] = dim/2 + os;

			xp[2] = 4 + os;

			yp[2] = dim-4 + os;

			break;

		}
		g.fillPolygon(xp, yp, 3);
	}

	public boolean mouseDown(Event ev, int x, int y) {

		if (enabled) {

			upState = false;

			repaint();

		}

		return true;

	}



	public boolean mouseDrag(Event ev, int x, int y) {

		if (enabled) {

			Rectangle r = bounds();



			boolean in	= x >= 0 && x < r.width && y >= 0 && y <= r.height;



			if (upState == in) {

				upState = !in;

				repaint(); 

			}

		}

		return true;

	}



	public boolean mouseUp(Event ev, int x, int y) {

		if (enabled && !upState) {

			upState = true;

			repaint(0); 

			handleClick();

		}

		return true; 

	}



	// AWT has a nasty tendency to give keyboard focus to components

	public boolean keyDown(Event ev, int key) {

		return getParent().keyDown(ev, key);

	}



	public void setKind(int kind) {

		btnKind = kind;

		repaint();

	}



	public int getKind() {

		return btnKind;

	}



	public void enable() {

		enabled = true;

		repaint();

	}



	public void disable() {

		enabled = false;

		repaint();

	}

}

