package lsedit;

import java.util.*;
import java.io.*;

public class AttributeValueItem extends Object {

	// Attribute values can be single nodes, a linked list of nodes, or they can be nested lists.
	// 

	public String				value;
	public AttributeRecord		nestedAttributeRecord;
	public AttributeValueItem	next;
	public AttributeValueItem	nextList;

	// If any of these characters appear in an id or an attribute 
	// value, this string should be output quoted. 
	//

	protected static final String specialChars = " /,:\\\"(){}^<>"; 

	public static String qt(String str) 
	{
		if (str.length() == 0) {
			return "\"\"";
		}
		for (int i = 0; i < specialChars.length(); i++) {
			if (str.indexOf(specialChars.charAt(i)) >= 0)
				return "\"" + str + "\"";
		}
		return str;
	}


	// ----------------- 
	// Protected methods
	// -----------------

	protected void printList(PrintStream ps) throws IOException
	{
		AttributeValueItem avi = this;	 

		while(avi != null) {
			if (avi.next != null) {
				ps.print(qt(avi.value) + " ");
			} else {
				ps.print(qt(avi.value)); 
			}
			avi = avi.next; 
		}
	}



	// -------------- 
	// Public methods
	// -------------- 

	public AttributeValueItem(String value) 
	{
		this.value = value;
	}

	public AttributeValueItem(AttributeRecord ar) 
	{
		nestedAttributeRecord = ar;
	}

	public Object clone() 
	{
		AttributeValueItem av;

		if (nestedAttributeRecord != null) {
			av = new AttributeValueItem((AttributeRecord) nestedAttributeRecord.clone()); 
		} else {
			av = new AttributeValueItem(value);
		}

		if (next != null) {
			av.next = (AttributeValueItem) next.clone();
		}

		if (nextList != null) {
			av.nextList = (AttributeValueItem) nextList.clone();
		}
		return av; 
	}

	public String toString() {

		AttributeValueItem avi;
		String			   ret;	  

		if (next != null) {
			ret = "(";
		} else {
			ret = "";
		}
		for (avi = this; avi != null; avi = avi.next) {
			if (avi != this) {
				ret += " ";
			}
			ret += qt(avi.value);
		}
		if (next != null) {
			ret += ")";
		}
		return(ret);
	}

	public void writeAttribute(PrintStream ps) throws IOException {

		if (next != null) {
			ps.print("(");
			printList(ps);
			ps.print(")\n"); 
		} else if (nestedAttributeRecord != null) {
			// Nested case must be handled!
			ps.print("{\n"); 
			ps.print("}\n"); 
		} else {
			// Single string value is output
			ps.print(qt(value) + "\n"); 
		}
	}

	public RealPoint parsePoint() {

		if (value == null || next == null || next.value == null) {
			return new RealPoint(0.0, 0.0);
		}
		double v1 = (new Double(value)).doubleValue();
		double v2 = (new Double(next.value)).doubleValue();
		return new RealPoint(v1, v2);
	}
}

