package lsedit;

import java.awt.*;

import java.util.*;

import java.io.*;

// Entities in a landscape 



public class BaseEntity extends EntityInstance {

	protected static boolean has3Dlook = true;
	protected BaseEntity undoEntity; 


	public static void set3Dlook(boolean state) 
	{
		has3Dlook = state;
	}

	protected BaseEntity() 
	{
	}

	public BaseEntity(EntityClass parentClass, String id, Diagram dg) 
	{
		super(parentClass, id, dg);
		undoEntity = new BaseEntity();
	}

	public void saveForUndo() 
	{
		super.saveForUndo(undoEntity);
	}

	public void undo() 
	{
		BaseEntity undoEntity = this.undoEntity;

		this.undoEntity = new BaseEntity(); 
		doSaveForUndo(this.undoEntity); 
		super.undo(undoEntity); 
	}

	protected void setGraphicsColor(Graphics g) 
	{
		if (highlightFlag && !isOpen()) {
			g.setColor(Color.red.darker());
		} else {
			g.setColor(getBackground());
		}
	}

	protected void clearFlagAttributes() 
	{
		ScreenLayout rect;
		Graphics	 g;
		Color		 color;

		int x1, y1, width1, height1, pdim, pdim1;

		x1		= (int) x();
		y1		= (int) y();
		width1	= (int) width();
		height1 = (int) height();

		// Draw resize points

		g		= dg.ls.getDiagramContext();
		color	= getBackground();

		g.setColor(color);

		pdim  = (height1 < 20) ? 4 : 6;
		pdim1 = pdim+1;

		g.fillRect(x1+1,			   y1+1,				pdim1, pdim1);
		g.fillRect(x1+width1/2-pdim/2, y1+1,				pdim1, pdim1);
		g.fillRect(x1+width1-pdim,	   y1+1,				pdim1, pdim1);
		g.fillRect(x1+1,			   y1+height1/2-pdim/2, pdim1, pdim1);
		g.fillRect(x1+width1-pdim,	   y1+height1/2-pdim/2, pdim1, pdim1);
		g.fillRect(x1+1,			   y1+height1-pdim,		pdim1, pdim1);
		g.fillRect(x1+width1/2-pdim/2, y1+height1-pdim,		pdim1, pdim1);
		g.fillRect(x1+width1-pdim,	   y1+height1-pdim,		pdim1, pdim1);

		g.dispose();
	}

	protected void fillFlagAttributes(Graphics g, ScreenLayout rect, Color color) 
	{
		int x1, y1, width1, height1;

		x1		= rect.x;
		y1		= rect.y;
		width1	= rect.width;
		height1 = rect.height;

		// Draw resize points

		g.setColor(color);

		int pdim = (height1 < 20) ? 4 : 6;

		g.fillRect(x1+1,			   y1+1,				pdim, pdim);
		g.fillRect(x1+width1/2-pdim/2, y1+1,				pdim, pdim);
		g.fillRect(x1+width1-pdim,	   y1+1,				pdim, pdim);
		g.fillRect(x1+1,			   y1+height1/2-pdim/2, pdim, pdim);
		g.fillRect(x1+width1-pdim,	   y1+height1/2-pdim/2, pdim, pdim);
		g.fillRect(x1+1,			   y1+height1-pdim,		pdim, pdim);
		g.fillRect(x1+width1/2-pdim/2, y1+height1-pdim,		pdim, pdim);
		g.fillRect(x1+width1-pdim,	   y1+height1-pdim,		pdim, pdim);
	}

	protected void outlineFlagAttributes(Graphics g, ScreenLayout rect, Color color) 
	{
		int x1, y1, width1, height1;

		x1		= rect.x;
		y1		= rect.y;
		width1	= rect.width;
		height1 = rect.height;

		// Draw resize points

		g.setColor(color);

		// Stupidity here.. An outline is one extra byte wide and high because the two
		// edges of a one pixel box occupy 2 pixels.

		int pdim = ((height1 < 20) ? 4 : 6) ;

		g.drawRect(x1+1,			   y1+1,				pdim, pdim);
		g.drawRect(x1+width1/2-pdim/2, y1+1,				pdim, pdim);
		g.drawRect(x1+width1-pdim-1,   y1+1,				pdim, pdim);
		g.drawRect(x1+1,			   y1+height1/2-pdim/2, pdim, pdim);
		g.drawRect(x1+width1-pdim-1,   y1+height1/2-pdim/2, pdim, pdim);
		g.drawRect(x1+1,			   y1+height1-pdim-1,	pdim, pdim);
		g.drawRect(x1+width1/2-pdim/2, y1+height1-pdim-1,	pdim, pdim);
		g.drawRect(x1+width1-pdim-1,   y1+height1-pdim-1,	pdim, pdim);
	}

	protected void clearGroupFlag() 
	{
		if (getGroupFlag()) {
			super.clearGroupFlag();
			clearFlagAttributes();
		}
	}

	// Put flags around the edges of the box

	protected void drawFlagAttributes(Graphics g, ScreenLayout rect) 
{
		if (getGroupFlag()) {

			if (getGroupKeyFlag()) {
				fillFlagAttributes(g, rect, getLabelColor());
			}  else {
				clearFlagAttributes();
				outlineFlagAttributes(g, rect, getLabelColor());
			}
		}
	}

	protected void setGroupFlag() 
	{

		Graphics		gc;
		ScreenLayout	rect;

		super.setGroupFlag();
		rect = new ScreenLayout(x(), y(), width(), height()); 
		gc	 = dg.ls.getDiagramContext();
		drawFlagAttributes(gc, rect);
		gc.dispose();
	}

	public void draw(Graphics g)
	{
	}



	// Assuming p1 is in this object and p2 is outside,
	// return the point that is the intersection between this object 
	// and the line segment p1->p2.

	public RealPoint calculateIntercept(RealPoint p1, RealPoint p2) 
	{
		double x = 0.0;
		double y = 0.0;

		double t, b, l, r;	// Top, bottom, left, and right

		t = this.y()-1;
		b = this.y() + this.height() + 1;
		l = this.x() - 1;
		r = this.x() + this.width() + 1;

		boolean found = true;

		if (p1.x < l || p1.x > r || p1.y < t || p1.y > b) {
			MsgOut.println("calculateIntercept: p1 is not in box");
			return new RealPoint(x, y);
		}

		if (p1.x == p2.x && p1.y == p2.y) {
			MsgOut.println("calculateIntercept: p1 == p2");
			return new RealPoint(x, y);
		}

		if (r <= p2.x) {
			x = r;
		} else if (p2.x < l) {
			x = l;
		} else {
			found = false;
		}

		if (found) {
			// y = mx + b
			y = p1.y + (x - p1.x) * ( (p2.y - p1.y) / (p2.x - p1.x) );
			found = ( t <= y && y <= b );
		}

		if (!found) {
			found = true;

			if (p2.y <= t) {
				y = t;
			} else if (p2.y >= b) {
				y = b;
			} else {
				found = false;
			}

			if (found) {
				x = p1.x + (y - p1.y) * ( (p2.x - p1.x) / (p2.y - p1.y) );
				found = (l <= x && x <= r);
			}

		}

		if (!found) {
			MsgOut.println("calculateIntercept failed: " + p1.x + " " + p1.y + " " + p2.x + " " + p2.y); 
		}
		return new RealPoint(x, y);
	}

	public boolean isPointOver(int x1, int y1) 
	{
		if (x1 < (int) x()) {
			return(false);
		}
		if (y1 < (int) y()) {
			return(false);
		}
		if (x1 > (int) (x() + width()) ) {
			return(false);
		}

		if (y1 > (int) (y() + height()) ) {
			return(false);
		}
		return(true);
	}


	public int overResizeTab(int x1, int y1) 
	{
		int xLeft, xMid, xRight;
		int	yTop,  yMid, yBottom;
		int	pos;

		xLeft  = (int) x();
		if (x1 < xLeft) {
			// Outside object
			return RSZ_NONE;
		}
		if (x1 <= xLeft + 6) {
			pos = 0;
		} else {
			xRight = (int) (x() + width());
			if (x1 > xRight) {
				// Outside object
				return RSZ_NONE;
			}
			if (x1 >= xRight - 6) {
				pos = 2;
			} else {
				xMid   = (xLeft + xRight)  / 2;
				if (x1 < xMid - 3 || x1 > xMid + 3) {
					return RSZ_NONE;
				}
				pos = 1;
		}	}

		yTop = (int) y();
		if (y1 < yTop) {
			// Outside object
			return RSZ_NONE;
		}
		if (y1 > yTop + 6) {
			yBottom = (int) (y() + height());
			if (y1 > yBottom) {
				// Outside object
				return RSZ_NONE;
			}
			if (y1 >= yBottom - 6) {
				pos += 6;
			} else {
				yMid = (yTop  + yBottom) / 2;
				if (y1 < yMid - 3 || y1 > yMid + 3) {
					return RSZ_NONE;
				}
				pos += 3;
		}	}

		switch (pos) {
		case 0:
			return RSZ_NW;
		case 1:
			return RSZ_N;
		case 2:
			return RSZ_NE;
		case 3:
			return RSZ_W;
		case 5:
			return RSZ_E;
		case 6:
			return RSZ_SW;
		case 7:
			return RSZ_S;
		case 8:
			return RSZ_SE;
		}
		return RSZ_NONE;
	}

	public boolean isPointOverIO(EdgePoint pt, int x, int y) 
	{
		int	x1, y1;

		x1 = (int) (pt.x + 0.5);	// round
		y1 = (int) (pt.y + 0.5);	// round	

		return ((x1 - Bend.SIZE/2) < x && x < (x1 + Bend.SIZE/2) && (y1 - Bend.SIZE/2) < y && y < (y1 + Bend.SIZE/2));
	}

 	public boolean containsLayout(Layout lyt) 
	{
		return (x() < lyt.x && lyt.x+lyt.width < x()+width() &&	y() < lyt.y && lyt.y+lyt.height < y()+height()); 
	}

	public boolean intersectsLayout(Layout lyt)
	{
		// Return true if the intersection of passed layout and 
		// entities layout is non-null

		// It overlaps if any corner of layout is contained in
		// entity, or vice versa.

		ScreenLayout rgn = new ScreenLayout(lyt); 
		ScreenLayout box = new ScreenLayout(this.x(), this.y(), width(), height());

		return rgn.intersects(box);
	}

	public void drawHighlight(Graphics g) 
	{
		g.setColor(Color.white);

		ScreenLayout rect = new ScreenLayout(x(), y(), width(), height());

		g.drawRect(rect.x, rect.y, rect.width, rect.height);
		g.drawRect(rect.x+1, rect.y+1, rect.width-1, rect.height-1);
	}

	public void undrawHighlight(Graphics g) 
	{
		setGraphicsColor(g);

		ScreenLayout rect = new ScreenLayout(x(), y(), width(), height());

		g.draw3DRect(rect.x, rect.y, rect.width, rect.height, true);
		g.draw3DRect(rect.x+1, rect.y+1, rect.width-1, rect.height-1, true);
	}

	public void drawOutline(Graphics g, Layout lyt)
	{
		ScreenLayout rect = new ScreenLayout(lyt); 

		g.drawRect(rect.x, rect.y, rect.width, rect.height);
		// g.drawRect(rect.x-1, rect.y-1, rect.width+1, rect.height+1);
	}

	private EdgePoint getPoint(EdgePoint[] pts, RelationClass rc, int side) 
	{
		int		  nid;
		EdgePoint cached;

		nid	   = rc.getNid();
		cached = pts[nid];

		// Cache calculated points

		if (cached == null || cached.getRc() != rc) {

			double f  = rc.getIOfactor();
			double wf = 0.0;
			double hf = 0.0;

			switch(side)
			{

			case EdgePoint.TOP:
				wf = f;					// Put at entity x + width * f 
				hf = 0.0;				// But at top
				break;
			case EdgePoint.BOTTOM:
				wf = f;
				hf = 1.0;				// But at bottom
				break;
			case EdgePoint.LEFT:
				wf = 0.0;				// But at left
				hf = f;
				break;
			default:
				wf = 1.0;				// Put at right
				hf = f;
				break;

			}
			if (cached == null) {
				pts[nid] = cached = new EdgePoint(this, rc, wf, hf);
			} else {
				cached.setRc(rc);
			}
			cached.rescale();			// Compute actual point given current position of e
			cached.isDefault = true;
			cached.side		 = side;
		}

		return cached;
	}

	public EdgePoint getPoint(RelationClass rc, int side) 
	{
		EdgePoint[] cache;

		switch(side) {
		case EdgePoint.TOP:
			cache = topPoints;
			if (cache == null) {
				topPoints = cache = new EdgePoint[dg.numRelationClasses()];
			}
			break;
		case EdgePoint.BOTTOM:
			cache = bottomPoints;
			if (cache == null) {
				bottomPoints = cache = new EdgePoint[dg.numRelationClasses()];
			}
			break;
		case EdgePoint.LEFT:
			cache = leftPoints;
			if (cache == null) {
				leftPoints = cache = new EdgePoint[dg.numRelationClasses()];
			}
			break;
		default:
			cache = rightPoints;
			if (cache == null) {
				rightPoints = cache = new EdgePoint[dg.numRelationClasses()];
		}	 }
		return getPoint(cache, rc, side);
	}


	// At what point does the ri relation hit this, given that it goes from the box specified by srcLyt to dstLyt
	// N.B. Most of the time anyway it appears that srcLyt is the srcLyt of this.

	public EdgePoint getOutPoint(RelationInstance ri, int edge_mode, Layout srcLyt, Layout dstLyt) 

	{

		RelationClass rc = ri.getRelationClass();
		int nid = rc.getNid();

		switch(edge_mode)
		{

		case Diagram.TB_EDGE:

			{

			BaseEntity src = (BaseEntity) ri.getSrc();



			if (this == src || src.isContainedBy(this)) {
				return getPoint(rc, EdgePoint.BOTTOM);
			}
			return getPoint(rc, EdgePoint.TOP);

			}



		default:

			if ((dstLyt.y - (srcLyt.y+srcLyt.height)) > SEP_THRESHOLD) {

				// dstLyt strictly below srcLyt
				return getPoint(rc, EdgePoint.BOTTOM);

			}

			if ((srcLyt.y - (dstLyt.y+dstLyt.height)) > SEP_THRESHOLD) {

				// srcLyt strictly below dstLyt
				return getPoint(rc, EdgePoint.TOP);

			}

			if ((dstLyt.x - (srcLyt.x+srcLyt.width)) > SEP_THRESHOLD) {
				return getPoint(rc, EdgePoint.RIGHT);
			}

			if ((srcLyt.x - (dstLyt.x+dstLyt.width)) > SEP_THRESHOLD) {
				return getPoint(rc, EdgePoint.LEFT);
			}

			if (dstLyt.y > (srcLyt.y+srcLyt.height)) {
				return getPoint(rc, EdgePoint.BOTTOM);
			}
			return getPoint(rc, EdgePoint.TOP);

		}

	}



	protected EdgePoint testMouseOverIO(EdgePoint[] pts, int x, int y) {

		if (pts == null) {
			return null;
		}

		for (int i = 0; i < pts.length; i++) {
			EdgePoint pt = pts[i];

			if (pt != null) {
				if (isPointOverIO(pt, x, y)) {
					return pt;
				}
			}
		}
		return null;
	}



	public EdgePoint getMouseOverIO(int x, int y) {

		EdgePoint pt = testMouseOverIO(topPoints, x, y);
		if (pt != null) {
			return pt;
		}


		pt = testMouseOverIO(bottomPoints, x, y);
		if (pt != null) {
			return pt;
		}


		pt = testMouseOverIO(leftPoints, x, y);
		if (pt != null) {
			return pt;
		}


		return testMouseOverIO(rightPoints, x, y);
	}



	protected void writePoints(PrintStream ps, EdgePoint[] pts, String name) 
	{
		if (pts == null) {
			return;
		}

		boolean isDefault = true;

		for (int i = 1; i < pts.length; i++) {
			if (pts[i] != null) {
				isDefault = isDefault && pts[i].isDefault;
		}	}

		if (isDefault) {
			return;
		}

		ps.print("	" + name + " = ( ");

		for (int i = 1; i < pts.length; i++) {
			if (pts[i] != null && !pts[i].isDefault) {
				ps.print("(" + pts[i].getRc().getId() + " " + pts[i].wf + " " + pts[i].hf + ") ");
			}
		}
		ps.print(")\n");
	}

	public void writeIOpoints(PrintStream ps) 
	{
		writePoints(ps, topPoints, INPOINT_ID);
		writePoints(ps, bottomPoints, OUTPOINT_ID);
		writePoints(ps, leftPoints, LEFTPOINT_ID);
		writePoints(ps, rightPoints, RIGHTPOINT_ID);
	}
}

