package lsedit;

import java.util.*;



public class Bend extends Object {



	public static final int SIZE = 6;

	public double x, y;					// Absolute location
	public double xLocal, yLocal;		// Location relative to parent
	public EntityInstance e;

	protected Vector edges = new Vector();

	public Bend(EntityInstance e, RelationInstance ri, double x, double y, boolean globalCoords)
	{
		this.e = e;
		edges.addElement(ri);

		if (globalCoords) {
			this.x = x;
			this.y = y;
		} else {
			this.xLocal = x;
			this.yLocal = y;
		}
	}



	public Bend(EntityInstance e, RelationInstance ri, double x, double y) 
	{
		this.e = e;
		edges.addElement(ri);

		this.x = x;
		this.y = y;
	}

	public Bend(EntityInstance e, RelationInstance ri, int x, int y) 
	{
		this.e = e;
		edges.addElement(ri);
		this.x = x;
		this.y = y;
	}

	private Bend(EntityInstance e, double x, double y) 
	{
		this.e = e;
		this.x = x;
		this.y = y;
	}

	public void delete() 
	{
		e.deleteBend(this);
		Enumeration en = edges.elements();

		while (en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			ri.deleteBend(this);
		}
	}

	public void addRelation(RelationInstance ri) 
	{
		edges.addElement(ri);
	}

	public boolean hasRelation(RelationInstance ri) 
	{
		return edges.contains(ri);
	}

	public RelationInstance getFirstEdge() 
	{
		return (RelationInstance) edges.firstElement();
	}

	public void move(double x, double y) 
	{
		this.x = x;
		this.y = y;
	}

	public void move(int x, int y) 
	{
		this.x = x;
		this.y = y;
	}

	public boolean isOver(double x, double y) 
	{
		return (x >= (this.x - SIZE/2) && x < (this.x + SIZE/2) &&
				y >= (this.y - SIZE/2) && y < (this.y + SIZE/2));
	}



	public boolean isOver(int x, int y) 
	{
		return isOver((double) x, (double) y);
	}

	public void translate(double dx, double dy) 
	{
		x += dx;
		y += dy;
	}

	public Object clone() 
	{
		Bend		nbend = new Bend(e, x, y);
		Enumeration en    = edges.elements();

		while(en.hasMoreElements()) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			nbend.addRelation(ri);
		}
		return nbend;
	}
}

