package lsedit;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.colorchooser.*;

/* This class augments JColorChooser to allow optionally the
 * inclusion of a null color and an alpha associated with a color
 */

public class ColorChooser extends JDialog {

	/* Pain that these must be static but seen in a static context */
	/* m_tcc is static so preserves chosen colours */

	private static JColorChooser m_tcc = null;
	private static JSlider m_slider = null;
	private Button m_okButton, m_canButton, m_nullButton;
	private static Color  m_color;

	private ColorChooser(Frame frame, String title, Color oldColor, boolean include_alpha, boolean allow_null) 
	{
		super(frame, title, true /* modal */);

		Container	contentPane;

		m_color = oldColor;
		contentPane = getContentPane();

		//Set up color chooser for setting text color
		if (m_tcc == null) {
			m_tcc	 = new JColorChooser();
			m_slider = new JSlider(1, 255, 255);
			m_slider.setMajorTickSpacing(50);
			m_slider.setPaintLabels(true);
			m_slider.setPaintTicks(true);
		}
		m_tcc.setColor(((oldColor == null) ? Color.gray : oldColor));

		contentPane.add("North", m_tcc);

		// Create an Okay button in a Panel; add the Panel to the window

		// Use a FlowLayout to center the button and give it margins.

		Panel p = new Panel();

		p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));

		if (include_alpha) {
			Panel p1 = new Panel();
		
			m_slider.setValue(255);
			p1.add("Top", m_slider);
			p1.add("Bottom", new Label("Alpha", Label.CENTER));

			contentPane.add("Center", p1);
		}
		m_okButton = new Button("OK");
		p.add(m_okButton);

		if (!allow_null) {
			m_nullButton = null;
		} else {
			m_nullButton = new Button("Null");
			p.add(m_nullButton);
		}

		m_canButton = new Button("Cancel");
		p.add(m_canButton);

		contentPane.add("South", p);

		addWindowListener(
			new WindowAdapter() {
				public void windowClosing(WindowEvent e) { dispose();}
			}
		);

		// Resize the window to the preferred size of its components
		
		pack();
	}

	// Pop down the window when the button is clicked.

	public boolean action(Event e, Object arg)
	{
		if (e.target != m_canButton) {
			if (e.target == m_okButton) {
				m_color = m_tcc.getColor();
				if (m_slider != null) {
					int alpha;

					alpha = m_slider.getValue();
					if (alpha != 255) {
						m_color = new Color(m_color.getRed(), m_color.getGreen(), m_color.getBlue(), alpha);
				}	}
			} else if (e.target != null && e.target == m_nullButton) {
				m_color = null; 
			} else {
				return(false);
		}	}
		dispose();
		return(true);
	}

	public static Color create(Frame frame, String title, Color oldColor, boolean include_alpha, boolean allow_null) 
	{

		Color	color;
		int		alpha;

		ColorChooser mb = new ColorChooser(frame, title, oldColor, include_alpha, allow_null);

		mb.move(20, 20);
		mb.show();
		return(m_color);
	}
}
