package lsedit;

import java.awt.*;

import java.util.*;

import java.io.*;



// Disk style entities in a landscape



public class DiskEntity extends BaseEntity {



	protected static final int ARC_DIM = 8;



	public DiskEntity() {

	}

	  

	public DiskEntity(EntityClass parentClass, String id, Diagram dg) {

		super(parentClass, id, dg);

	}



	public void draw(Graphics g) {

		setGraphicsColor(g);



		ScreenLayout rect = new ScreenLayout(x(), y(), width(), height()); 



		int ad = Math.min(Math.min(rect.width, rect.height)/2, ARC_DIM);



		// Draw a cylinder



		g.fillRect(rect.x, rect.y+ad/2, rect.width, rect.height-ad);



		g.fillOval(rect.x, rect.y, rect.width, ad);

		g.fillOval(rect.x, rect.y+rect.height-ad, rect.width, ad);



		g.setColor(Color.black);



		g.drawOval(rect.x, rect.y, rect.width, ad);

		g.drawArc(rect.x, rect.y+rect.height-ad, rect.width, ad, 180, 180);

		g.drawLine(rect.x, rect.y+ad/2, rect.x, rect.y+rect.height-ad/2);

		g.drawLine(rect.x+rect.width, rect.y+ad/2, 

						rect.x+rect.width, rect.y+rect.height-ad/2);



		drawFlagAttributes(g, rect);
	}

}

