package lsedit;

import java.awt.*;

import java.util.*;

/* This routine seems to exist for only two reasons.
 * 1) It serves as a utility class for printing dotted lines
 * 2) It keeps track of edges that have been drawn to avoid redrawing them
 */

public class DrawCache extends Object {

	protected static final int MAX_HANDLED_ENTITIES = 5000;

	protected static final int DASH_LEN			= 4;
	protected static final int DASH_GAP			= 3;

	protected static final int DOT_LEN_REG		= 0;
	protected static final int DOT_LEN_PRNT		= 1;
	protected static final int DOT_GAP			= 4;

	protected int edges = 0;
	protected int drawn = 0;

	protected Hashtable m_drawnCache;

	protected int getDotLen(Graphics g) 
	{
		if (g instanceof PSGr) {
			return DOT_LEN_PRNT;
		}
		return DOT_LEN_REG;
	}


	// Low level routine to draw dashed lines

	private void drawLine(Graphics g, LineWalker lw) 
	{
		ScreenPoint p1 = new ScreenPoint(0, 0);
		ScreenPoint p2 = new ScreenPoint(0, 0);

		while(lw.morePoints()) {
			 lw.nextPoints(p1, p2);
			 g.drawLine(p1.x, p1.y, p2.x, p2.y);
		}
	}



	protected void drawDashed(Graphics g, ScreenPoint p1, ScreenPoint p2) 
	{
		LineWalker lw = new LineWalker(p1, p2, DASH_LEN, DASH_GAP);
		drawLine(g, lw);
	}



	protected void drawDotted(Graphics g, ScreenPoint p1, ScreenPoint p2) 
	{
		LineWalker lw = new LineWalker(p1, p2, getDotLen(g), DOT_GAP);
		drawLine(g, lw);
	}

	protected void doDraw(Graphics g, int style, ScreenPoint p1, ScreenPoint p2)
	{
		switch(style) {
		case Util.LINE_STYLE_NORMAL:
			g.drawLine(p1.x, p1.y, p2.x, p2.y);
			break;

		case Util.LINE_STYLE_DOTTED:
			drawDotted(g, p1, p2);
			break;

		case Util.LINE_STYLE_DASHED:
			drawDashed(g, p1, p2);
			break;
		}
	}

	// --------------
	// Public methods
	// --------------

	public DrawCache(int numEntities, int numRelations) 
	{
		m_drawnCache = new Hashtable();
	}

	public boolean drawSegment(Graphics g, int style, ScreenPoint p1, ScreenPoint p2)
	{
		doDraw(g, style, p1, p2);
		return true;
	}

	public boolean haveDrawn(EntityInstance vsrc, EntityInstance vdst, RelationClass rc) 
	{
		edges++;

		String str = Util.hashEdge(rc, vsrc, vdst);

		if (m_drawnCache.contains(str)) {
			return true;
		}
		m_drawnCache.put(str, str);
		drawn++;
		return false;
	}



	public void printStats() 
	{
		System.out.println("Edges: " + edges + " drawn: " + drawn);
	}

}

