package lsedit;

import java.util.*;



public class EdgePoint extends RealPoint {



	public static final int TOP			= 0;
	public static final int BOTTOM		= 1;
	public static final int LEFT		= 2;
	public static final int RIGHT		= 3;

	private EntityInstance m_e;			// This is an edge point of this entity
	public RelationClass m_rc;			// The edge going here belongs to this relationclass
	public double wf;					// Width fraction of entity e width
	public double hf;					// Height fraction of entity e height 
	public boolean drawn = false;
	public boolean isDefault = true;
	public int side;					// Which of four sides is this on wrt entity e

	public EdgePoint(EntityInstance e, RelationClass rc, double wf, double hf) 
	{
		this.m_e = e;
		this.m_rc = rc;
		this.wf = wf;
		this.hf = hf;
	}

	public void rescale() 
	{
		x = m_e.x() + m_e.width()*wf;
		y = m_e.y() + m_e.height()*hf;
	}

	public Object clone() 
	{
		EdgePoint ne =	new EdgePoint(m_e, m_rc, wf, hf);

		ne.x = x;
		ne.y = y;
		ne.active = active;
		ne.elision = elision;

		return ne;
	}

	public boolean isBend() 
	{
		return false;
	}



	public boolean isOver(int x, int y) 
	{
		return m_e.isPointOverIO(this, x, y);
	}


	public String EdgeSide() 
	{
		switch (side) {
		case EdgePoint.TOP:
			return("TOP");
		case EdgePoint.BOTTOM:
			return("BOTTOM");
		case EdgePoint.LEFT:
			return("LEFT");
		case EdgePoint.RIGHT:
			return("RIGHT");
		}
		return("??");
	}

	public EntityInstance getEntity()
	{
		return(m_e);
	}

	public void clearRc()
	{
		m_rc = null;
	}

	public void setRc(RelationClass rc1) 
	{
		m_rc = rc1;
	}

	public RelationClass getRc()
	{
		return(m_rc);
	}


	public String toString() 
	{
		return EdgeSide() + " of " + m_e + "{" + m_rc + "}: (" + x + ", " + y + ")";
	}

}

