package lsedit;
import java.awt.*;
import java.util.*;

public class EditModeHandler extends ViewModeHandler {

	protected static final String[] rootMenu =
		{ "Add new entity (e)", 
		   "-",
		  "Edit attributes (a)", 
		  "Edit class attributes (A)", 
		  "-",
		  "Decrease label font size (t)", 
		  "Increase label font size (T)",
		  "-",
		  "Select all children (^A)", 
		  "Fit children to container (F)", 
		  "-",
		  "Scale smaller in X dim (x)", 
		  "Scale larger in X dim (X)",
		  "Scale smaller in Y dim (y)", 
		  "Scale larger in Y dim (Y)",
		  "Scale smaller (z)", 
		  "Scale larger (Z)"
		};

	protected static final int[] rootKeys =
		{ 'e', 0,
		  'a', 'A', 0, 
		  't', 'T', 0,
		  CTRL.A,
		  'F', 0,
		  'x', 'X',
		  'y', 'Y',
		  'z', 'Z'
		};

	protected static final String[] entityMenu =
		{ "Forward query (f)",					// "Forward query w/closure (F)",
		  "Backtrace query (b)",				// "Backtrace query w/closure (B)", 
		  "Contain query result (^C)",
		  "-",
		  "Hide/show user edge (u)",
		  "Hide/show user inside edges (U)",
		  "Hide/show supplier edge (s)",
		  "Hide/show supplier inside edge (S)",
		  "Hide/show internal edges (I)",
		  "Hide/show contents (c)",
		  "-",
		  "Draw new entity (e)",
		  "Draw new source edge (E)",
		  "Delete entity (DEL)", 
		  "Delete container (k)", 
		  "-",
		  "Edit attributes (a)", 
		  "Edit class attributes (A)", 
		  "-",
		  "Decrease label text size (t)", 
		  "Increase label text size (T)",
		  "-",
		  "Select all children (^A)",
		  "Fit children to container (F)", 
		  "-", 
		  "Scale smaller in X dim (x)", 
		  "Scale larger in X dim (X)",
		  "Scale smaller in Y dim (y)", 
		  "Scale larger in Y dim (Y)",
		  "Scale smaller (z)", 
		  "Scale larger (Z)"
		};

	protected static final int[] entityKeys =
		{ 'f', 'b', CTRL.C, 0,
		  'u', 'U', 's', 'S', 'I', 'c', 0,
		  'e', 'E', 127, 'k', 0,
		  'a', 'A', 0,
		  't', 'T', 0,
		  CTRL.A,
		  'F', 0, 
		  'x', 'X',
		  'y', 'Y',
		  'z', 'Z'
		};

	protected static final String[] edgeMenu = 
		{ "Open edge destination", 
		  "Open edge source",
		  "Close edge destination",
		  "Close edge source",
		  "Navigate to destination",
		  "Navigate to source",
		  "New bend point (b)",
		  "Delete edge (DEL)" };

	protected static final int[] edgeKeys = 
		{ EDGE_OPEN_DST, 
		  EDGE_OPEN_SRC,
		  EDGE_CLOSE_DST,
		  EDGE_CLOSE_SRC,
		  EDGE_NAVIGATE_DST,
		  EDGE_NAVIGATE_SRC,
		  'b', 127 };

	protected static final String[] bendMenu =
		{ "Delete bend (DEL)" };

	protected static final int[] bendKeys = 
		{ 127 };

	protected static final String[] edgePointMenu =
		{ "Reset edge point (DEL)" };

	protected static final int[] edgePointKeys =
		{ 127 };


	// -----------------
	// Protected methods
	// -----------------

	// Other commands

	protected void containQuery() {
		EntityInstance container = (EntityInstance) dg.getKeyEntity();

		if (!container.isOpen()) {
			ls.error("Key entity doesn't seem likely destination");
			return;
		}

		Vector grp = dg.getHighlightGroup();

		if (grp == null) {
			ls.error("No query result active.");
			return;
		}

		Enumeration en = grp.elements();

		while(en.hasMoreElements()) {
			EntityInstance e = (EntityInstance) en.nextElement();

			e.moveEntityContainment(container);
		}

		dg.rescale();

		dg.fitTo(container);
	}

	protected void deltaFont(int delta) {
		Vector grp = dg.getGroup();

		Enumeration en = grp.elements();

		while (en.hasMoreElements()) {
			EntityInstance ge = (EntityInstance) en.nextElement();

			ge.deltaFont(delta);
		}
	}

	protected boolean handleRelnCommands(int key, int modifiers) {
		if (super.handleRelnCommands(key, modifiers))
			return true;

		switch(key)
		{
		case 127:
			dg.saveForUndo();
			if (bend != null) {
				dg.deleteBend(bend);
			}
			else {
				dg.deleteEdge(ri);
			}
			break; 

		default:
			return false;
		}

		e = null;
		ri = null;
		bend = null;

		dg.setDrawEdges(true);
		ls.redrawDg();
		return true;
	}

	protected boolean isRootCommand(int key) {
		for (int i = 0; i < rootKeys.length; i++) {
			if (key == rootKeys[i]) {
				return true;
			}
		}
		return false;
	}

	protected boolean handleEntityCommands(int key, int modifiers) {
		if (super.handleEntityCommands(key, modifiers)) {
			return true;
		}

		if (e == null) {
			e = dg.getKeyEntity();

			if (e == null)
				e = dg.getRoot();
		}

		if (e == dg.getRoot()) {
			if (!isRootCommand(key))
				return false;
		}

		switch(key)
		{
		case 'e':
			// draw entity
			{
			Layout lyt = e.getLayout();
			Layout nlyt = new Layout(curX, curY, lyt.width/10, lyt.height/10);

			String ename;

			int n = 0;

			do {
				ename = "Entity#" + n;
				n++;
			} while (dg.entityExists(ename));

			e = dg.addEntity(ename, nlyt, e);
			}
			break;

		case 'a':
			// edit attributes
			EditAttribute.Create(ls, e);
			break;

		case 'A':
			// edit class attributes
			EditAttribute.Create(ls, e.getEntityClass());
			break;

		case CTRL.C:
			dg.saveForUndo();
			containQuery();
			break;

		case 'k':
			dg.saveForUndo();
			e.delete();

			ls.doFeedback("Entity " + e.getLabel() + " has been deleted.");
			break;

		case 127:
			dg.saveForUndo();
			e.deleteAll(true);
			ls.doFeedback("Entity " + e.getLabel() +
						" and its contents have been deleted.");
			break;

		case 'T':
			deltaFont(1);
			break;

		case 't': 
			deltaFont(-1);
			break;

		default:
			e = null;
			ri = null;
			bend = null;
			return false;
		}

		ri = null;
		bend = null;

		if (e != null)
			ls.redrawDg();

		return true;
	}

	protected void popupMenu(Event ev, int x, int y) {
		e	 = dg.mouseOverEx(x, y);
		ri	 = dg.mouseOverEdge(e, x, y);
		bend = dg.mouseOverBend(x, y);
		ept	 = dg.mouseOverIO(e, x, y);

		if (ri != null) {
			popup.set("Relation options", 
						new CommandList(edgeMenu, edgeKeys),
						null, dg.getRoot(), ls, ev.x, ev.y);
		} else if (bend != null) {
			popup.set("Bend options", 
						new CommandList(bendMenu, bendKeys),
						null, dg.getRoot(), ls, ev.x, ev.y);
		} else if (ept != null) {
			popup.set("Side point options", 
						new CommandList(edgePointMenu, edgePointKeys),
						null, dg.getRoot(), ls, ev.x, ev.y);
		} else if (e == dg.getRoot()) {
			popup.set("Root options", 
						new CommandList(rootMenu, rootKeys),
						null, dg.getRoot(), ls, ev.x, ev.y);
		} else {
			popup.set("Entity options", 
						new CommandList(entityMenu, entityKeys),
						null, dg.getRoot(), ls, ev.x, ev.y);
		}
	}


	// --------------
	// Public methods
	// --------------

	public EditModeHandler() {
		super();
	}

	public void select(ScrollableDiagram dg) {
		super.select(dg);

		dg.setDrawBends(true);
	}

	public boolean mouseDown(Event ev, int x, int y) {

//		System.out.println("EditModeHandler mousedown\n");
		e = dg.mouseOverEx(x, y);
		if (e == null)
			return false;

		bend = dg.mouseOverBend(x, y);
		if (bend != null)
			ri = bend.getFirstEdge();
		else
			ri = dg.mouseOverEdge(e, x, y);

		return super.mouseDown(ev, x, y);
	}


	public void mouseMotion(EntityInstance e, int x, int y) {
		EdgePoint liop = dg.mouseOverIO(e, x, y);
		Bend lbend = dg.mouseOverBend(x, y);

		if (liop != null || lbend != null) {
			ls.setCursor(Frame.CROSSHAIR_CURSOR);
		}
		else {
			super.mouseMotion(e, x, y);
		}
	}

	public void setHelp(TextBox tb) {
	}
}
