package lsedit;
import java.awt.*;
import java.util.*;
import java.io.*;

// File style entities in a landscape

public class FileEntity extends BaseEntity 
{
	protected static final int FLAP_DIM = 8;

	public FileEntity() 
	{
	}

	public FileEntity(EntityClass parentClass, String id, Diagram dg) 
	{
		super(parentClass, id, dg);
	}

	public void draw(Graphics g) 
	{
		ScreenLayout rect = new ScreenLayout(x(), y(), width(), height()); 

		int fd = Math.min(Math.min(rect.width, rect.height)/2, FLAP_DIM);
/*
		if (containedBy != null) {
			g.setColor(containedBy.getBackground());
			g.fillRect(rect.x + rect.width - fd, rect.y, fd + 1, fd + 1);
		}
*/
		int[] xp = new int[6];
		int[] yp = new int[6];

		xp[0] = rect.x;
		yp[0] = rect.y;
		xp[1] = rect.x + rect.width - fd;
		yp[1] = rect.y;
		xp[2] = rect.x + rect.width;
		yp[2] = rect.y + fd;
		xp[3] = xp[2];
		yp[3] = rect.y + rect.height;
		xp[4] = rect.x;
		yp[4] = yp[3];
		xp[5] = xp[0];
		yp[5] = yp[0];

		setGraphicsColor(g);

		g.fillPolygon(xp, yp, 6);
		g.setColor(Color.darkGray);
		g.drawPolygon(xp, yp, 6);

		xp[0] = xp[1];
		yp[0] = yp[2];
		xp[3] = xp[0];
		yp[3] = yp[0];

		g.drawPolygon(xp, yp, 4);

		drawFlagAttributes(g, rect);
	}
}

