package lsedit;

import java.util.*;



public class Find extends Object {



	protected Vector results = new Vector();

	protected int groups = 0;

	protected int grp	 = 0;

	protected int ind	 = 0;



	protected int substringMatch(String str, int offset, 

										String substr, boolean matchCase) {

		int spos = offset;

		int slen = str.length();



		int sspos = 0;

		int sslen = substr.length();



		int fpos  = -1;



		while (spos < slen) {

			if (substr.charAt(sspos) == '?' || 

				str.charAt(spos) == substr.charAt(sspos))

			{

				if (fpos < 0)

					fpos = spos;



				sspos++;

				if (sspos == sslen)

					return fpos;

			}

			else if (substr.charAt(0) == '?' ||

					 str.charAt(spos) == substr.charAt(0))

			{

				fpos = spos;

				sspos = 1;

			}

			else {

				fpos = -1;

				sspos = 0;

			}



			spos++;

		}



		return -1;

	}



	protected boolean patternMatch(String str, SearchCookie sc) {

		Enumeration en = sc.subPatterns.elements();



		int pos = 0;

		int len = str.length();



		boolean firstPattern = true;



		while (pos < len && en.hasMoreElements()) {

			String subpattern = (String) en.nextElement();



			pos = substringMatch(str, pos, subpattern, sc.matchCase);



			if (pos < 0)

				return false;



			if (firstPattern) {

				firstPattern = false;

				if (!sc.startAny && pos > 0)

					return false;

			}



			pos += subpattern.length();

		}



		boolean match = (!en.hasMoreElements() && (pos == len || sc.endAny));



		return match;

	}



	protected boolean matches(SearchCookie sc, EntityInstance e) {

		String label = 

				(sc.matchCase ? e.getLabel() : e.getLabel().toLowerCase());

		int	   len	 = label.length();



		if (sc.complexPattern)

			return patternMatch(label, sc);



		String str = (String) sc.subPatterns.firstElement();



		if (sc.matchCase) 

			return (label.equals(str));



		return label.equalsIgnoreCase(str);

	}

 

	protected void find(SearchCookie sc, EntityInstance e) {

		Enumeration en = e.getChildren();



		boolean firstMatch = true;



		while (en.hasMoreElements()) {

			EntityInstance ce = (EntityInstance) en.nextElement();



			if (matches(sc, ce)) {

				results.addElement(ce);

				if (firstMatch) {

					firstMatch = false;

					groups++;

				}

			}

		}



		en = e.getChildren();



		while (en.hasMoreElements()) {

			EntityInstance ce = (EntityInstance) en.nextElement();



			find(sc, ce);

		}

	}



	protected Vector getGroup() {

		if (ind == results.size())

			return null;



		Vector v = new Vector();



		EntityInstance pe = 

				((EntityInstance) results.elementAt(ind)).getParent();



		while (ind < results.size()) {

			EntityInstance e = (EntityInstance) results.elementAt(ind);



			if (e.getParent() != pe)

				break;



			v.addElement(e);

			ind++;

		} 



		return v;

	}



	protected boolean rewind() {

		if (ind == 0)

			return false;



		int orgInd = ind;



		ind--;



		EntityInstance pe = 

				((EntityInstance) results.elementAt(ind)).getParent();



		while (ind > 0) {

			EntityInstance e = (EntityInstance) results.elementAt(ind);



			if (e.getParent() != pe) {

				pe = e.getParent();

				break;

			}



			ind--;

		} 



		if (ind == 0) {

			ind = orgInd;

			return false;

		}



		while (ind > 0) {

			EntityInstance e = (EntityInstance) results.elementAt(ind);



			if (e.getParent() != pe) {

				ind++;

				break;

			}



			ind--;

		} 



		return true;

	}

		



	/*

	 * Public methods

	 */



	public Find(SearchCookie sc, EntityInstance root) {

		find(sc, root);

	}



	public int foundCount() {

		return groups;

	}



	public boolean havePrevResult() {

		return (grp > 1);

	}



	public Vector prevResult() {

		if (rewind()) {

			grp--;

			return getGroup();

		}



		return null;

	}



	public boolean haveNextResult() {

		return (grp < groups);

	}



	public Vector nextResult() {

		grp++;

		return getGroup();

	}



	public Vector firstResult() {

		ind = 0;

		grp = 0;

		return nextResult();

	}

}

