package lsedit;

import java.awt.*;

import java.util.*;

import java.io.*;



// Folder style entities in a landscape



public class FolderEntity extends BaseEntity {



	protected static final int MIN_FLAP_WD	= 75;

	protected static final int TINY_FLAP_WD = 10;

	protected static final int MIN_FLAP_HT	= 3;

	protected static final int MAX_FLAP_HT	= 8;



	protected static final int FLAP_MARGIN = 4;



	protected int fw, fh;		// Flap width and height



	public FolderEntity() {

	}

	  

	public FolderEntity(EntityClass parentClass, String id, Diagram dg) {

		super(parentClass, id, dg);

	}



	public void draw(Graphics g) {

		setGraphicsColor(g);

		ScreenLayout rect = new ScreenLayout(x(), y(), width(), height()); 


		// Compute flap size

		fw = ((int) (((double) rect.width) * .4));
		fh = Math.max(MIN_FLAP_HT, Math.min(MAX_FLAP_HT, ((int) (((double) rect.height) * .2))));



		int fm = FLAP_MARGIN;



		if (fw < MIN_FLAP_WD) {
		   fw += fw/2;
		}


		if (fw < TINY_FLAP_WD) {

			fw = Math.min(fw + FLAP_MARGIN, (int) Math.round(width() - width()/3));

			fm = 0;

		}

		int[] xp = new int[9];
		int[] yp = new int[9];



		xp[0] = rect.x;
		yp[0] = rect.y;
		xp[1] = rect.x+fm;
		yp[1] = rect.y;
		xp[2] = xp[1]+fh/2;
		yp[2] = rect.y-fh;
		xp[3] = rect.x + fw;
		yp[3] = yp[2];
		xp[4] = xp[3]+fh/2;
		yp[4] = yp[0];
		xp[5] = rect.x + rect.width;
		yp[5] = yp[0];
		xp[6] = xp[5];
		yp[6] = rect.y + rect.height;
		xp[7] = xp[0];
		yp[7] = yp[6];
		xp[8] = xp[0];
		yp[8] = yp[0];

		g.fillPolygon(xp, yp, 9);


		g.setColor((highlightFlag && isOpen()) ? Color.red : Color.black);
		g.drawPolygon(xp, yp, 9);

		if (!isOpen()) {
			g.drawLine(xp[1], yp[1], xp[4], yp[4]);
		}

		drawFlagAttributes(g, rect);
	}

	protected void drawTopLeftLabel(Graphics g) {

		g.setFont(smallFont);

		g.setColor(Color.black); 



		Util.drawStringClipped(g, label, x()+FLAP_MARGIN+fh/2+2, y() - fh, (double) fw, height()-MARGIN*2);

	}

}

