package lsedit;

import java.awt.*;
import java.util.*;

public class GroupModeHandler extends LandscapeModeHandler
{
	protected static final int NONE				= 0;
	protected static final int GROUPING			= 1;
	protected static final int GROUP_MOVE		= 2;

	protected Layout curLayout;
	protected int curX, curY;

	protected Vector groupList = null;			// List of entities

	protected Layout grpLayout;

	protected int groupMode = NONE;

	protected double m_dx, m_dy;

	protected LandscapeModeHandler parent = null;

	private	  boolean seen_motion;

	// Group entities

	protected void drawBox(Layout lyt) {
		ScreenLayout rect = new ScreenLayout(lyt);

		gc.drawRect(rect.x, rect.y, rect.width, rect.height);
	}

	protected void drawGroup(Graphics gc, Layout lyt) {
		// Draw the outlines of each entity in group

		double dx = lyt.x - grpLayout.x;
		double dy = lyt.y - grpLayout.y; 

		Enumeration en = groupList.elements();

		while (en.hasMoreElements()) {
			EntityInstance e = (EntityInstance) en.nextElement(); 

			Layout elyt = e.getLayout();

			elyt.x += dx;
			elyt.y += dy;

			dg.drawEntityOutline(gc, elyt, e);
		}
	}

	protected EntityInstance findOverlap(Layout lyt) {
		double dx = lyt.x - grpLayout.x;
		double dy = lyt.y - grpLayout.y;

		EntityInstance e = dg.getKeyEntity();

		Layout elyt = e.getLayout();

		elyt.x += dx;
		elyt.y += dy;

		EntityInstance oe = dg.intersects(lyt);

		if (oe != null && !groupList.contains(oe)) {
			return oe;
		}

		Enumeration en = groupList.elements();

		while (en.hasMoreElements()) {
			e = (EntityInstance) en.nextElement();

			elyt = e.getLayout();

			elyt.x += dx;
			elyt.y += dy;

			oe = dg.intersects(lyt);

			if (oe != null && !groupList.contains(oe)) {
				return oe;
			}
		}

		return null;
	}


	protected void moveGroup(EntityInstance container, double dx, double dy) {

		EntityInstance e = (EntityInstance) groupList.firstElement();

		dg.saveForUndo();

		boolean changeParent = (e.getParent() != container);

		double width  = 0.0;
		double height = 0.0;

		Enumeration en;

		if (changeParent) {
			int num = container.numChildren();

			if (num == 0) {
				Layout plyt = e.getParent().getLayout();
				Layout nplyt = container.getLayout();

				double xs = nplyt.width/plyt.width;
				double ys = nplyt.height/plyt.height;

				Layout lyt = e.getLayout();

				width = lyt.width * xs;
				height = lyt.height * ys;
			}
			else {
				en = container.getChildren();

				while (en.hasMoreElements()) {
					e = (EntityInstance) en.nextElement();

					Layout elyt = e.getLayout();

					width += elyt.width;
					height += elyt.height;
				} 

				width /= num;
				height /= num;

				en = groupList.elements();
			}
		}

		en = groupList.elements();

		while (en.hasMoreElements()) {
			e = (EntityInstance) en.nextElement();

			Layout elyt = e.getLayout();

			elyt.x += dx;
			elyt.y += dy;

			if (changeParent) {
				elyt.width = width;
				elyt.height = height;
			}

			e.moveEntityContainment(container);
			e.setLayout(elyt);
		}
	}

	protected void moveGroup(EntityInstance container, Layout lyt) {
		double dx = lyt.x - grpLayout.x;
		double dy = lyt.y - grpLayout.y;

		moveGroup(container, dx, dy);
	}

	protected void setAsKeyEntity(EntityInstance e) {
/*
		EntityInstance old_ke = dg.getKeyEntity();
 */
		dg.setKeyEntity(e);

/* Omit as of 6.0.2 
		if (old_ke != null) {
			ls.repaintEntity(old_ke);
		}		
		ls.repaintEntity(e);
 */		
	}

	protected void selectEntity(EntityInstance e) {

		if (e.getGroupFlag()) {
			// Already a member of a group

			if (e != dg.getKeyEntity()) {
				setAsKeyEntity(e);
			}
		}
		else {
			EntityInstance old_ke = dg.getKeyEntity();

			if (old_ke != null) {
				boolean ret;

				ret = dg.clearFlags();
				dg.setKeyEntity(e);
				if (ret) {
					ls.repaintDg();
				}
			}
			else {
				setAsKeyEntity(e);
			}
		}

		showGroupList(false);
	}

	protected void toggleMembership(EntityInstance e) {
		if (e.getGroupFlag()) {
			if (e == dg.getKeyEntity()) {
				Vector grp = dg.getGroup();

				if (grp.size() == 1) {
					dg.clearFlags();
					ls.repaintEntity(e);
				}
				else {
					e.clearGroupFlag();
					grp = dg.getGroup();

					EntityInstance nke = (EntityInstance) grp.firstElement();

					setAsKeyEntity(nke);
				}
			}
			else {
				e.clearGroupFlag();
				ls.repaintEntity(e);
			}
		}
		else {
			Vector grp = dg.getGroup();

			if (grp != null) {
				// See if this is in same container as others

				EntityInstance fe = (EntityInstance) grp.firstElement();

				if (fe.getParent() != e.getParent()) {
					selectEntity(e);
					return;
				}
			}

			setAsKeyEntity(e);
		}

		showGroupList(false);
	}

	protected boolean groupingStart(Event ev, int x, int y) {

		gc.setXORMode(e.getBackground());

		curX = x;
		curY = y;

		curLayout = null;

		return true;
	}

	protected void groupingMotion(Event ev, int x, int y) {
		if (curLayout == null)
			curLayout = new Layout(0, 0, 0, 0);
		else
			drawBox(curLayout);

		// Constrain it to container

		double nx = x;
		double ny = y;

		Layout lyt = e.getLayout();

		if (nx < lyt.x+LandscapeViewerCore.GAP)
			nx = lyt.x+LandscapeViewerCore.GAP;
		else if (nx > lyt.x+lyt.width-LandscapeViewerCore.GAP)
			nx = lyt.x+lyt.width-LandscapeViewerCore.GAP;

		if (ny < lyt.y+LandscapeViewerCore.GAP)
			ny = lyt.y+LandscapeViewerCore.GAP;
		else if (ny > lyt.y+lyt.height-LandscapeViewerCore.GAP)
			ny = lyt.y+lyt.height-LandscapeViewerCore.GAP;


		// Calculate new layout rectangle

		if (nx > curX) {
			curLayout.x = curX;
			curLayout.width = nx-curX;
		}
		else {
			curLayout.x = nx;
			curLayout.width = curX-nx;
		}

		if (ny > curY) {
			curLayout.y = curY;
			curLayout.height = y-curY;
		}
		else {
			curLayout.y = y;
			curLayout.height = curY-y;
		}

		// Draw a box
		drawBox(curLayout);
	}

	protected void groupingEnd(Event ev, int x, int y) {
		// Flag all entities intersecting group box as being part of a group

		Vector gl = dg.setGroupRegion(curLayout);

		if (gl != null) {
			showGroupList(false);
			dg.setKeyEntity((EntityInstance) gl.firstElement());
/* Omit as 6.0.2
			ls.redrawDg();
 */
		}
		else {
			drawBox(curLayout);
		}
	}

	protected boolean moveGroupStart(Event ev, int x, int y) {
		groupList = dg.getGroup();

		seen_motion = false;

		if (groupList == null)
			return false;

		EntityInstance pe = ((EntityInstance) groupList.firstElement()).getParent();

		if (pe == null) {
			return false;
		}


		grpLayout = dg.getGroupBoundingBox();
		curLayout = (Layout) grpLayout.clone();
		m_dx	  = x - curLayout.x;
		m_dy	  = y - curLayout.y;

		if (groupList.size() == 1) {
			ls.doFeedback("Moving entity: (" + 
						Math.round(curLayout.x) + ", " + 
						Math.round(curLayout.y) + ")");
		}
		else {
			ls.doFeedback("Moving group (key): (" + 
						Math.round(curLayout.x) + ", " + 
						Math.round(curLayout.y) + ")");
		}
		return true;
	}

	protected void moveGroupMotion(Event ev, int x, int y) {
		// Make sure we don't moved out of the root

		if (!seen_motion) {
			EntityInstance pe = ((EntityInstance) groupList.firstElement()).getParent();
			gc.setXORMode(pe.getBackground());
			drawGroup(gc, curLayout);
			seen_motion = true;
		}

		Layout lyt = dg.getRoot().getLayout();

		int grid = dg.getGrid();

		double nx = (Math.round(x-m_dx)/grid)*grid;
		double ny = (Math.round(y-m_dy)/grid)*grid;

		if (nx < lyt.x+LandscapeViewerCore.GAP)
			nx = lyt.x+LandscapeViewerCore.GAP;

		if (ny < lyt.y+LandscapeViewerCore.GAP)
			ny = lyt.y+LandscapeViewerCore.GAP;

		if (nx+curLayout.width > lyt.x+lyt.width-LandscapeViewerCore.GAP)
			nx = lyt.x+lyt.width-curLayout.width-LandscapeViewerCore.GAP;

		if (ny+curLayout.height > lyt.y+lyt.height-LandscapeViewerCore.GAP)
			ny = lyt.y+lyt.height-curLayout.height-LandscapeViewerCore.GAP;

/*
		EntityInstance oe = dg.intersects(curLayout);

		if (!groupList.contains(oe) && oe != dg.getRoot()) {
			dg.drawEntityHighlight(gc, oe);
		}
*/

		drawGroup(gc, curLayout);
		curLayout.x = nx;
		curLayout.y = ny;
		drawGroup(gc, curLayout);

		if (groupList.size() == 1) {
			ls.doFeedback("Moving entity: (" + Math.round(nx) + ", " + 
						Math.round(ny) + ")");
		}
		else {
			ls.doFeedback("Moving group (key): (" + Math.round(nx) + ", " + 
						Math.round(ny) + ")");
		}
	}

	protected static final boolean allowOverlap = true;

	protected void moveGroupEnd(Event ev, int x, int y) {

		ls.clearFeedback();

		if (!seen_motion) {
			return;
		}

		if (!allowOverlap) {
			EntityInstance oe = findOverlap(curLayout);

			if (oe != null) {
				ls.error("Can't overlap entities");
				curLayout = null;
				ls.redrawDg();
				return;
			}
		}

		EntityInstance ke = dg.getKeyEntity();
		

		double dx = curLayout.x - grpLayout.x;
		double dy = curLayout.y - grpLayout.y;

		Layout klyt = ke.getLayout();

		klyt.x += dx;
		klyt.y += dy;

		EntityInstance container = dg.containing(klyt);

		if (container == null) {
			ls.error("Failed to find container");
			ls.redrawDg();
			return;
		}

		if (groupList.contains(container)) {
			container = container.getParent();
		}

		boolean changeParent = (container != ke.getParent());

		dg.saveForUndo();

		moveGroup(container, curLayout);

		if (changeParent) {
			dg.setContainElision(container, true);
			ls.doFeedback("Group move into: " + container.getLabel());
		}

		curLayout = null;
		ls.redrawDg();
	}

	//
	// Public methods
	//

	public GroupModeHandler(LandscapeModeHandler parent) {
		this.parent = parent;
	}

	public boolean mouseDown(Event ev, int x, int y) 
	{

//		System.out.println("GroupModeHandler mousedown\n");

		boolean middleButton = ((ev.modifiers & Event.ALT_MASK) != 0);
		boolean rightButton = ((ev.modifiers & Event.META_MASK) != 0);
		boolean shift = ((ev.modifiers & Event.SHIFT_MASK) != 0);

		e = dg.mouseOverEx(x, y);

		if (e == null) {
			return false;
		} 

		if (shift) {
			if (middleButton) {
				groupMode = GROUPING;
				return groupingStart(ev, x, y);
			}
			else if (rightButton) {
				if (e != dg.getRoot())
					setAsKeyEntity(e);
			}
			else {
				if (e != dg.getRoot())
					toggleMembership(e);
			}
		}
		else { 
			if (e != dg.getRoot() && !dg.isClientOrSupplier(e)) {
				selectEntity(e);
				ls.setCursor(Frame.MOVE_CURSOR);
				groupMode = GROUP_MOVE;

				return moveGroupStart(ev, x, y);
			}

			// Otherwise it is a selection event

			selectEntity(e);
			groupMode = NONE;
			return true;
		}

		groupMode = NONE;
		return false;
	}

	public boolean mouseDrag(Event ev, int x, int y) {
		switch(groupMode)
		{
		case GROUPING:
			groupingMotion(ev, x, y);
			break;

		case GROUP_MOVE:
			moveGroupMotion(ev, x, y);
			break;
		}
		return true;
	}

	public void mouseUp(Event ev, int x, int y) {
		switch(groupMode)
		{
		case GROUPING:
			groupingEnd(ev, x, y);
			break;

		case GROUP_MOVE:
			moveGroupEnd(ev, x, y);
			break;

		default:
			return;
		}

		ls.setCursor(Frame.DEFAULT_CURSOR);
		groupMode = NONE;
	}

	public void halt() {
		groupMode = NONE;
	}

	public void showGroupList(boolean activateResults) {
		Vector grp = dg.getGroup();

		if (grp != null) {
			Util.sortVector(grp);
			ls.showList("GROUP:", grp, activateResults);
		}
		else {
			ls.error("No entities selected");
		}
	}

	public void groupAll() {

		boolean ret;

		EntityInstance ke = dg.getKeyEntity();
		EntityInstance ge = ke;

		if (ke == null) {
			ke = dg.getRoot();
			ge = ke;
		}

		ret = dg.clearFlags();

		if (!ge.isOpen())
			ge = ge.getParent();

		Enumeration en = ge.getChildren();

		while (en.hasMoreElements()) {
			EntityInstance ce = (EntityInstance) en.nextElement();

			ce.setGroupFlag();
		}

		Vector grp = dg.getGroup();

		if (grp != null) {
			if (!grp.contains(ke))
				ke = (EntityInstance) grp.firstElement();

			dg.setKeyEntity(ke);
			if (ret) {
				ls.redrawDg();
			}
			showGroupList(false);
		}
		else {
			ls.error("No entities selected");
		}
	}

		
	public void moveGroup(int key) {
		groupList = dg.getGroup();

		if (groupList == null)
			return;

		EntityInstance pe = dg.getKeyEntity().getParent();

		double dx = 0;
		double dy = 0;

		switch(key)
		{
		case CTRL.UP:
			dx = 0;
			dy = -1;
			break;

		case CTRL.DOWN:
			dx = 0;
			dy = 1;
			break;

		case CTRL.RIGHT:
			dx = 1;
			dy = 0;
			break;

		case CTRL.LEFT:
			dx = -1;
			dy = 0;
			break;
		}

		moveGroup(pe, dx, dy);
	}
}
