package lsedit;

import java.awt.*;

import java.util.*;

import java.io.*;



// Group style entities in a landscape.



public class LabelledGroupEntity extends BaseEntity {



	protected static final int GAP	  = 5;

	protected static final int INSET  = 12;

	protected static final int OUTSET = 5;



	public LabelledGroupEntity() {

	}

	  

	public LabelledGroupEntity(EntityClass parentClass, String id, Diagram dg) {

		super(parentClass, id, dg);

		setHeight(width());

	}



	public void draw(Graphics g) {

		g.setFont(smallFont);



		ScreenLayout rect = new ScreenLayout(x(), y(), width(), height()); 



		Util.drawGroupBox(g, rect, label, getLabelColour(), has3Dlook);



		drawFlagAttributes(g, rect);

	}



	public boolean isTransparent() {

		return true;

	}



	public boolean isCloseable() {

		return false;

	}



	public boolean isLabelDrawable() {

		return false;

	}



	public boolean isEnterable() {

		return false;

	}

}

