package lsedit;

import java.awt.*;

import java.util.*;



public abstract class LandscapeModeHandler extends Object implements ClickHandler
{
	protected LandscapeViewerCore ls;
	protected ScrollableDiagram dg; 

	protected Graphics gc; 

	protected EntityInstance e    = null;
	protected RelationInstance ri = null;
	protected Bend bend           = null;

	protected boolean mouseIsDown = false;

	public LandscapeModeHandler() 
	{
	}

	public void init(LandscapeViewerCore ls) 
	{
		this.ls = ls;
	}



	public void select(ScrollableDiagram dg) 
	{
		this.dg     = dg;
	}

	public void start() 
	{
		Graphics lsgc = ls.getGraphics();
		gc = dg.getContext(lsgc);
		lsgc.dispose();
	}

	public void cleanup() 
	{
		e    = null;
		ri   = null;
		bend = null;
		gc.dispose();
	}

	public void reset() 
	{
	}

	public boolean mouseDown(Event ev, int x, int y) 
	{
//		System.out.println("LandscapeModeHandler mousedown\n");
		mouseIsDown = true;
		return false;
	}

	public boolean mouseDrag(Event ev, int x, int y) 
	{
		return false;
	}

	public void mouseUp(Event ev, int x, int y) 
	{
		mouseIsDown = false;
	}

	public void mouseDoubleClick(Event ev, int x, int y) 
	{
	}

	public void mouseMotion(EntityInstance e, int x, int y) 
	{
	}

	public void halt() 
	{
	}

	public boolean processKey(int key, int modifiers) 
	{
		return false;
	}



	public EntityInstance getActiveEntity() 
	{
		return e;
	}

	public void setHelp(TextBox tb) 
	{
	}

	public void processClickedText(TextBox tb, String text) 
	{
	}
}

