package lsedit;

import java.applet.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class LandscapeViewer extends LandscapeViewerCore {
	/* Implements the browser version of the editor */

	protected static String editMenuEntries[] =
		{ "Undo\t^Z",
		  "Refresh\t^R",
		  "-",
		  // "Query persistence on/off",
		  "Clear current query/group\tESC",
		  "Find entity\t^F",
		  "-", 
		  "Best side edge",
		  "Top/Bottom edge",
		  "Direct edge",
		  "-",
		  "Hide/show descriptions",
		  "Hide/show feedback",
		  "Hide/show right box",
// -eks	  "Hide/show client/supplier edges",
		  "-",
		  "Font correction\t/"
		};

	protected static int editMenuKeys[] =
		{ CTRL.Z, CTRL.R, 0,
		 // QUERY_PERSIST, CTRL.ESC, 0,
		 CTRL.ESC, CTRL.F, 0,
		 Diagram.BEST_EDGE+EDGE_BASE, Diagram.TB_EDGE+EDGE_BASE,
		 Diagram.DIRECT_EDGE+EDGE_BASE, 0,
		 SHOW_DESC, SHOW_FB, SHOW_RIGHT, /*SHOW_CLIENT_SUPPLIER, -eks*/ 0, 
		 '/'
		};

	protected boolean editGrayStates[] =
		{ false, false, false,
		  false, false, false,
		  false, false, 
		  false, false, 
		  false, false, false, false, false,
		  false,
		}; 

	protected void genMenuButtons() {
		editMenuButton = new MenuButton("Menu", this, menuFont, editMenuEntries, editMenuKeys, editGrayStates);
	}

	protected Dimension getViewDimensions() {
		return size();
	}

	public void init() {
		/* Obtain the arguments (passed as applet tag params) */

		lsPath = getParameter("lsfile");

		System.out.println(lsPath);

		int num = 0;

		for (;;) {
			String f = getParameter("lsfile_bg" + num);

			if (f == null || f.length() == 0)
				break;

			System.out.println(f);

			lsPath_bg.addElement(f);
			num++;
		}
		
		editURL		= getParameter("editlink");
		aboutURL	= getParameter("toolabout");
		helpURL		= getParameter("toolhelp");

		startEntity = getParameter("startEntity");

		String vf	= getParameter("verbose");
		String df	= getParameter("debug");

		MsgOut.setVerboseFlag(vf != null && vf.equals("true"));
		MsgOut.setDebugFlag(df != null && df.equals("true"));

		MsgOut.dprintln("Startup Landscape Viewer");

		super.init();
		repaint();
	}

	protected void doSetCursor(int cursor) {
		Frame f = Util.getFrame(this);

		if (f != null)
			f.setCursor(cursor);
	}

/*
	protected HelpEngine getHelpEngine() {
		return null; // new ViewerHelpEngine(listTextBox);
	}
*/

	public InternalBufferStream getInternalBufferStream() {
/*
		return (new InternalBufferStream(TA_SRC.intTable, TA_SRC.doubleTable,
								TA_SRC.stringTable));
*/
		return null;
	}
}
