package lsedit;

import java.util.*;

import java.awt.*;



public class LayoutManager {

 

	protected LandscapeLayouter[] layouterList = {
		new FlipLayoutHorizontally(),
		new FlipLayoutVertically(),
		null,
		new GridGroupHorizontally(),
		new GridGroupVertically(),
		null,
		new SugiyamaLayout()
	};

	// 
	// Public methods
	//

	public LayoutManager() 
	{
	}

	

	public void setMenu(Menu m) {

		for (int i = 0; i<layouterList.length; i++) {

			MenuItem mi;

			if (layouterList[i] == null) {
				mi = new MenuItem("-");
			} else {
				mi = new MenuItem(layouterList[i].getMenuLabel());
			}
			m.add(mi);
		}
	}



	public int getMenuIndex(String label) {

		for (int i = 0; i<layouterList.length; i++) {

			if (layouterList[i] != null && label.equals(layouterList[i].getMenuLabel())) {
				return i;
			}
		}
		return -1;
	}



	public String executeLayout(int menuIndex, Diagram dg) {

		LandscapeLayouter ll = layouterList[menuIndex];

		ll.setDiagram(dg);
		return ll.doLayout();
	}

}

