package lsedit;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;



public class LegendBox extends TabbedBox {

	protected static final int CB_WD = 15;
	protected static final int CB_HT = 15;
	protected static final int WIDTH = 25;
	protected static final int HEIGHT = 20;


	protected static final Font textFont	 = new Font("Helvetica", Font.PLAIN, 11); 
	protected static final String endEntMsg	 = "Pass cursor over entity for description.";
	protected static final String endRelMsg1 = "Checkboxes select visible relations.";
	protected static final String endRelMsg2 = "Click relation arrow for description.";
	protected static final String helpStr	 = "This box shows the types of entities and relations that are present in the current landscape.";

	protected static final int MAX_NUM_CHECKS = 20;

	protected Checkbox[]	  relnChk	= new Checkbox[MAX_NUM_CHECKS];
	protected RelationClass[] relnClass = new RelationClass[MAX_NUM_CHECKS];
	protected Vector		  objects;			// The position of the things in the legend

	protected PopupMenu m_popup = null;

	protected void drawContents(Diagram dg, Graphics g, boolean fullInfo) {

		Rectangle r = bounds();

		int xpos = GAP*2;
		int ypos = -scrollBar.getValue();
		int iypos = ypos;

		g.setFont(textFont);

		FontMetrics fm = g.getFontMetrics();

		int h = Util.fontHeight(textFont); // Util.fontHeight(fm);

		int bh = h*2;
		int bw = (bh*4)/3;
		int tw = r.width-bw-GAP*3;

		g.setColor(Color.black);

		if (fullInfo) {
			ypos += h;
			g.drawString("Entities", xpos, ypos);
			g.drawLine(xpos, ypos+3, xpos+fm.stringWidth("Entities"), ypos+3);
			ypos += h-2;
		} else {
			ypos += 5;
		}

		// Draw legend for entities

		Enumeration en;

		int item = 0;
		int n	 = 0;


		if (fullInfo) {
			en = dg.enumEntityClasses();

			objects = new Vector();

			while(en.hasMoreElements()) {

				EntityClass ec = (EntityClass) en.nextElement();

				String id	 = ec.getId();
				String label = ec.getLabel();

				if (!id.equals(EntityClass.ENTITY_BASE_CLASS_ID)) {
					if (true /* item >= itemNo && item < vitem */ ) {

						EntityInstance e = ec.newEntity("A", dg);

						Layout lyt = new Layout(xpos, ypos + 2, bw, bh);

						e.setAbsoluteLayout(lyt);
						e.draw(g);

						Rectangle rect = new Rectangle(r.x + xpos, r.y+ypos+2, bw, bh);
						objects.addElement(new LegendObject(rect, ec));

						g.setColor(Color.black);
						g.setFont(textFont);

						Util.drawStringClipped(g, label, xpos+bw+GAP, ypos, tw, h); 
						ypos += bh+GAP*2;
					}
					item++;
					n++;
				}
			}

			if (n == 0) {
				g.setColor(Color.blue);
				g.draw3DRect(xpos, ypos, bw, h, true);
				g.fill3DRect(xpos+1, ypos+1, bw-1, h-1, true);
				g.setColor(Color.black);
				Util.drawStringClipped(g, "Entity", xpos+bw+GAP, ypos, tw, h);
				ypos += h+GAP;
				item++;
			}

			ypos += (bh + h)/2;

			Util.drawStringClipped(g, endEntMsg, xpos, ypos, tw, h);
			ypos += 2*h;
		} // if (fullInfo)

		g.setColor(Color.black);
		g.drawString("Relations", xpos, ypos+h);
		ypos += h+3;
		g.drawLine(xpos, ypos, xpos+fm.stringWidth("Relations"), ypos);
		ypos += h/2;

		// Draw legend for relations

		en = dg.enumRelations();

		n = 0;
		while(en.hasMoreElements()) {
			RelationClass rc = (RelationClass) en.nextElement();

			String id	 = rc.getId();
			String label = rc.getLabel();

			if (!dg.excludeReln(rc)) {
				String str = label + " (" + (n+1) + ")";

				g.setColor(rc.getObjectColor());
				int x1 = xpos + CB_WD + GAP;
				int y1 = ypos+HEIGHT/2;
				int x2 = x1+WIDTH;

				Rectangle rect = new Rectangle(r.x + x1, r.y + ypos, WIDTH, HEIGHT);

				relnClass[n] = rc; 
				relnChk[n].resize(CB_WD, CB_HT); 
				relnChk[n].move(r.x + GAP, r.y + tabDim.height + ypos + GAP + 3);
				relnChk[n].show();
				relnChk[n].setState(rc.isVisible());

				objects.addElement(new LegendObject(rect, rc));

				RealPoint p1 = new RealPoint(x1, y1); 
				RealPoint p2 = new RealPoint(x2, y1); 

				Util.drawArrow(g, p1, p2);
				g.setColor(rc.getLabelColor());
				Util.drawStringClipped(g, str, x1+WIDTH+GAP, ypos, tw, h);
				g.setColor(Color.black);
				ypos += h+GAP;
				item++;
				n++;
			}
		}

		for (int i=n; i<MAX_NUM_CHECKS; i++) {
			relnChk[i].hide();
			relnClass[i] = null;
		}

		if (n == 0) {
			g.setColor(Color.black);

			int x1 = xpos;
			int y1 = ypos+HEIGHT/2;
			int x2 = xpos+WIDTH;
			int y2 = ypos+HEIGHT/2;

			RealPoint p1 = new RealPoint(x1, y1);
			RealPoint p2 = new RealPoint(x2, y2);

			Util.drawArrow(g, p1, p2);
			g.setColor(Color.black);
			Util.drawStringClipped(g, "Relation", xpos+WIDTH+GAP, ypos, tw, h);
			ypos += h+GAP;
			item++;
		}

		if (fullInfo) {
			ypos += h/2;
			Util.drawStringClipped(g, endRelMsg1, xpos, ypos, tw, h);
			ypos += h;
			Util.drawStringClipped(g, endRelMsg2, xpos, ypos, tw, h);
		}

		setupScrolling(ypos-iypos);
	}


	protected void genChecks() {
		for (int i=0; i<MAX_NUM_CHECKS; i++) {
			relnChk[i] = new Checkbox();
			relnChk[i].hide();
			ls.add(relnChk[i]);
		}
	}


	// --------------

	// Public methods 

	// --------------



	public LegendBox(LandscapeViewerCore ls) {

		super(ls, "Legend", 5);

		genChecks();

	}

	protected LegendObject mouseOverLegendObject(int x, int y)
	{
		Enumeration en = objects.elements();
		Rectangle	r;
		int			x1, y1;

		while (en.hasMoreElements()) {

			LegendObject lo = (LegendObject) en.nextElement();
			// Don't know why need to add the height of the tab but seems to fix things

			r  = lo.getRectangle();
			x1 = r.x;
			y1 = r.y + HEIGHT;
			if (x >= x1 && x <= x1 + r.width && y >= y1 && y <= y1 + r.height) {
				return(lo);
		 }	 }
		 return(null);
	}

	private class DisplayClassHierarchy implements ActionListener
	{
		private LandscapeViewerCore		m_ls;
		private LandscapeClassObject	m_landscapeClass;
		int								m_x;
		int								m_y;
 
		public DisplayClassHierarchy(MenuItem menuitem, LandscapeViewerCore ls, LandscapeClassObject landscapeClass, int x, int y)
		{
			Enumeration parentElements;

			parentElements = landscapeClass.getParentElements();

			if (parentElements == null || !parentElements.hasMoreElements()) {
				menuitem.setEnabled(false);
			}
			m_ls			 = ls;
			m_landscapeClass = landscapeClass;
			m_x				 = x;
			m_y				 = y;
		}

		public void actionPerformed(ActionEvent e)
		{
			Enumeration					parentElements;
			LandscapeClassObject		parent;

			parentElements = m_landscapeClass.getParentElements();

			if (parentElements != null && parentElements.hasMoreElements()) {
				PopupMenu		popup;
				MenuItem		mi;
				String			label;

				label = m_landscapeClass.getLabel();
				popup = new PopupMenu(label);

				while (parentElements.hasMoreElements()) {
					parent = (LandscapeClassObject) parentElements.nextElement();

					mi = new MenuItem(parent.getLabel());
					mi.addActionListener(new DisplayClassHierarchy(mi, m_ls, parent, m_x, m_y)); 
					popup.add(mi);
				} 
				m_ls.add(popup);

				popup.show(ls, m_x, m_y);
			}
	}	}

	private class EditClassAttributes implements ActionListener
	{
		private LandscapeViewerCore		m_ls;
		private EntityClass				m_entity;
 
		public EditClassAttributes(LandscapeViewerCore ls, EntityClass entity)
		{

			m_ls	 = ls;
			m_entity = entity;
		}

		public void actionPerformed(ActionEvent e)
		{
			EditAttribute.Create(m_ls, m_entity);
	}	}

	private class EditRelationAttributes implements ActionListener
	{
		private LandscapeViewerCore		m_ls;
		private RelationClass			m_relation;
 
		public EditRelationAttributes(LandscapeViewerCore ls, RelationClass relation)
		{

			m_ls	   = ls;
			m_relation = relation;
		}

		public void actionPerformed(ActionEvent e)
		{
			EditAttribute.Create(m_ls, m_relation);
	}	}

	public boolean mouseDown(Event ev, int x, int y) 
	{
//		System.out.println("LegendBox mousedown\n");

		// boolean shift = ((ev.modifiers & Event.SHIFT_MASK) != 0);
		// boolean ctrl = ((ev.modifiers & Event.CTRL_MASK) != 0);
		// boolean middleButton = ((ev.modifiers & Event.ALT_MASK) != 0);

		boolean rightButton = ((ev.modifiers & Event.META_MASK) != 0);

		if (m_popup != null) {
			// Allow a legend box to have only one popup open at a time
			// Can see a right click to legend box while popup is open
			ls.remove(m_popup);
			m_popup = null;
			repaint();
		}

		if (rightButton) {

			LegendObject				lo;
			LandscapeClassObject		landscapeClass;
			int							dropdownMode;

			lo = mouseOverLegendObject(x, y);
			if (lo != null) {

				landscapeClass = lo.getLandscapeClass();
				if (landscapeClass != null) {

					MenuItem	mi;

					if (landscapeClass instanceof EntityClass) {
						m_popup = new PopupMenu("Class menu");

						mi = new MenuItem("Display hierarchy");
						mi.addActionListener(new DisplayClassHierarchy(mi, ls, landscapeClass, x, y)); 
						m_popup.add(mi);

						mi = new MenuItem("Edit attributes");
						mi.addActionListener(new EditClassAttributes(ls, (EntityClass) landscapeClass)); 
						m_popup.add(mi);

					} else if (landscapeClass instanceof RelationClass) {

						m_popup = new PopupMenu("Relation menu");

						mi = new MenuItem("Display hierarchy");
						mi.addActionListener(new DisplayClassHierarchy(mi, ls, landscapeClass, x, y)); 
						m_popup.add(mi);

						mi = new MenuItem("Edit attributes");
						mi.addActionListener(new EditRelationAttributes(ls, (RelationClass) landscapeClass)); 
						m_popup.add(mi);
					} 
				
					if (m_popup != null) {
/*
						int		i;

						Font	  font	= new Font("Dialog", Font.PLAIN, 10);
						m_popup.setFont(font);

						for (i = m_popup.getItemCount(); i > 0; ) {
							m_popup.getItem(--i).setFont(font);
						}
 */
						ls.add(m_popup);

						m_popup.show(ls, x, y);
						return(true);
		}	}	}	}
		return(false);
   }


	public boolean mouseMotion(Event ev, int x, int y) {

		LegendObject lo = mouseOverLegendObject(x, y);
		String		 description;

		if (lo != null) {
			description = lo.getDescription();
			if (description != null) {
				ls.setHelpPopup(description, x, y);
				return true;
		}	}
		// Otherwise, display the general help
		ls.setHelpPopup(helpStr, x, y);
		return true;
	}



	public boolean handleEvent(Diagram dg, Graphics gc, Event event) {

		if (!isVisible())
			return false;

		if (super.handleEvent(dg, gc, event)) {
			return true;
		}

		for(int i = 0; i<MAX_NUM_CHECKS; i++) {
			if (event.target == relnChk[i]) {
				if (event.id == Event.ACTION_EVENT) {
					ls.processKey('1' + i, 0);
				}
				return true;
			}
		}
		return false;
	}

	public void toggleRelationVisibility(Diagram dg, int key) {

		if (key == 10) {
			// Affect all relations

			boolean ns = !relnClass[0].isVisible();

			int i = 0;

			while(relnClass[i] != null) {
				dg.setEdgeVisibilityState(relnClass[i], ns);
				i++;
			}
		} else {
			RelationClass rc = relnClass[key];

			if (rc != null) {
				boolean ns = !rc.isVisible();

				dg.setEdgeVisibilityState(rc, ns);
				ls.doFeedback("Relation " + rc.getLabel() + " set to " + (ns ? "visible" : "hidden"));
			}
		}
		repaint();
	}

	public void activate() {
		super.activate();
	}



	public void inactivate() {

		super.inactivate();

		for (int i=0; i<MAX_NUM_CHECKS; i++) {
			relnChk[i].hide();
		}
	}

}





